/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.metadata;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.metadata.BMetadataJob;
import com.tridium.workbench.metadata.MetadataCommands;
import com.tridium.workbench.nav.NavMonitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIPropertySpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BMetadataBrowser
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$metadata$BMetadataBrowser == null ? (class$com$tridium$workbench$metadata$BMetadataBrowser = BMetadataBrowser.class$("com.tridium.workbench.metadata.BMetadataBrowser")) : class$com$tridium$workbench$metadata$BMetadataBrowser));
    static TypeInfo HISTORY_TYPE = null;
    static Context context = null;
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$metadata$BMetadataBrowser == null ? (class$com$tridium$workbench$metadata$BMetadataBrowser = BMetadataBrowser.class$("com.tridium.workbench.metadata.BMetadataBrowser")) : class$com$tridium$workbench$metadata$BMetadataBrowser));
    BTreeTable table;
    Model model;
    Array roots;
    MetadataCommands commands;
    HashMap textCache = new HashMap();
    BJobBar jobBar;
    boolean jobComplete;
    BJob job = null;
    static /* synthetic */ Class class$com$tridium$workbench$metadata$BMetadataBrowser;
    static /* synthetic */ Class class$com$tridium$workbench$metadata$BMetadataBrowser$Node;
    static /* synthetic */ Class class$com$tridium$workbench$metadata$BMetadataJob;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BMetadataBrowser() {
        this.autoRegisterForComponentEvents = false;
        this.roots = new Array(class$com$tridium$workbench$metadata$BMetadataBrowser$Node == null ? (class$com$tridium$workbench$metadata$BMetadataBrowser$Node = BMetadataBrowser.class$("com.tridium.workbench.metadata.BMetadataBrowser$Node")) : class$com$tridium$workbench$metadata$BMetadataBrowser$Node);
        this.table = new BTreeTable();
        this.model = new Model();
        this.table.setModel((TableModel)this.model);
        this.table.setSelection((TableSelection)new Selection());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setController((TableController)new Controller());
        this.commands = new MetadataCommands(this);
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add(null, (BValue)new BButton((Command)this.commands.slotAdd));
        bGridPane.add(null, (BValue)new BButton((Command)this.commands.slotEdit));
        bGridPane.add(null, (BValue)new BButton((Command)this.commands.slotRemove));
        BEdgePane bEdgePane = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        BBorderPane bBorderPane2 = new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        bEdgePane.setTop((BWidget)bBorderPane2);
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 5.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
        try {
            if (HISTORY_TYPE == null) {
                HISTORY_TYPE = BTypeSpec.make((String)"history", (String)"IHistory").getTypeInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this.model);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this.model);
    }

    public BMenu[] getViewMenus() {
        return new BMenu[]{this.commands.buildMenu()};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)this.commands.slotAdd);
        bToolBar.add(null, (Command)this.commands.slotEdit);
        bToolBar.add(null, (Command)this.commands.slotRemove);
        return bToolBar;
    }

    public void doLoadValue(BObject bObject, Context context) {
        Object object;
        BUser bUser;
        Object object2;
        if (context != null) {
            try {
                object2 = null;
                bUser = context.getUser();
                if (bUser != null) {
                    object2 = bUser.getUsername();
                } else {
                    object = context.getFacet("username");
                    if (object instanceof BString) {
                        object2 = ((BString)object).getString();
                    }
                }
                if (object2 != null) {
                    object = null;
                    object = this.findJobInProgress();
                    if (object != null) {
                        object.lease();
                        if (((String)object2).equals(object.getUsername())) {
                            this.job = object;
                            this.jobComplete = false;
                            this.jobBar.load(this.job);
                            this.registerForComponentEvents((BComponent)this.job);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BMetadataBrowser.context = context;
        object2 = (BComponent)bObject;
        this.registerForComponentEvents((BComponent)object2);
        bUser = (BFoxSession)object2.getSession();
        object = bUser.getNavChildren();
        for (int i = 0; i < ((BINavNode[])object).length; ++i) {
            if (!(object[i] instanceof BSpace) || !(object[i] instanceof BINavNode) || !(object[i] instanceof BIPropertySpace)) continue;
            if (object[i] instanceof BComponentSpace) {
                BComponent bComponent = ((BComponentSpace)object[i]).getRootComponent();
                this.registerForComponentEvents(bComponent);
                Node node = new Node(this.model, (BINavNode)bComponent);
                this.roots.add((Object)node);
                continue;
            }
            this.addRoot(((BSpace)object[i]).getOrdInSession());
        }
        this.commands.updateCommands();
        if (!this.model.needsInitialization()) {
            this.model.updateTreeTable(true);
        }
    }

    private void addRoot(BOrd bOrd) {
        try {
            BObject bObject = bOrd.get(this.getCurrentValue());
            if (!(bObject instanceof BINavNode)) {
                return;
            }
            this.addRoot((BINavNode)bObject);
        }
        catch (Exception exception) {
            System.out.println("Cannot add root: " + bOrd);
            exception.printStackTrace();
        }
    }

    private void addRoot(BINavNode bINavNode) {
        try {
            this.roots.add((Object)new Node(this.model, bINavNode));
        }
        catch (Exception exception) {
            System.out.println("Cannot add root: " + bINavNode.getNavOrd());
            System.out.println("  " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        BComponent bComponent = bComponentEvent.getSourceComponent();
        if (this.job == bComponent) {
            if (this.job.getJobState().isComplete() && !this.jobComplete) {
                this.jobComplete = true;
                this.jobComplete(this.job);
            }
        } else {
            switch (bComponentEvent.getId()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if ((bComponentEvent.getSlotFlags() & 0x4000) == 0) break;
                }
                case 4: {
                    Node node;
                    if (this.model != null && (node = this.model.eventToNode(bComponentEvent)) != null) {
                        HashMap hashMap = this.textCache;
                        synchronized (hashMap) {
                            this.textCache.remove((Object)node);
                        }
                    }
                    this.repaint();
                }
            }
        }
    }

    void setJob(BJob bJob) {
        BJob bJob2;
        BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get(this.getCurrentValue());
        BOrd bOrd = bJobService.submit(bJob, this.getCurrentContext());
        try {
            bJobService.getComponentSpace().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.job = bJob2 = (BJob)bOrd.get((BObject)bJobService);
        this.jobComplete = false;
        this.registerForComponentEvents((BComponent)bJob2);
        this.jobBar.load(bJob2);
        if (bJob2 != null && bJob2.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(bJob2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobComplete(BJob bJob) {
        this.commands.updateCommands();
        HashMap hashMap = this.textCache;
        synchronized (hashMap) {
            this.textCache.clear();
        }
        this.repaint();
    }

    BMetadataJob findJobInProgress() {
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"service:baja:JobService");
        BJobService bJobService = (BJobService)bOrd2.resolve().get();
        bJobService.lease();
        BMetadataJob[] bMetadataJobArray = (BMetadataJob[])bJobService.getChildren(class$com$tridium$workbench$metadata$BMetadataJob == null ? (class$com$tridium$workbench$metadata$BMetadataJob = BMetadataBrowser.class$("com.tridium.workbench.metadata.BMetadataJob")) : class$com$tridium$workbench$metadata$BMetadataJob);
        if (bMetadataJobArray != null) {
            for (int i = 0; i < bMetadataJobArray.length; ++i) {
                if (bMetadataJobArray[i] == null) continue;
                bMetadataJobArray[i].lease();
                if (!bMetadataJobArray[i].isAlive()) continue;
                return bMetadataJobArray[i];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nodeToString(Node node) {
        String string = null;
        HashMap hashMap = this.textCache;
        synchronized (hashMap) {
            string = (String)this.textCache.get((Object)node);
        }
        if (string != null) {
            return string;
        }
        if (node.nav instanceof BIPropertyContainer) {
            hashMap = this.checkHistory((BIPropertyContainer)node.nav);
            Property[] propertyArray = hashMap.getPropertiesArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 0; i < propertyArray.length; ++i) {
                if ((hashMap.getFlags((Slot)propertyArray[i]) & 0x4000) == 0) continue;
                if (!bl) {
                    stringBuffer.append(" | ");
                }
                bl = false;
                stringBuffer.append(hashMap.getDisplayName((Slot)propertyArray[i], context)).append(":");
                stringBuffer.append(hashMap.get(propertyArray[i]).toString(context));
            }
            string = stringBuffer.toString();
        } else {
            string = lex.getText("metadataBrowser.notApplicable");
        }
        hashMap = this.textCache;
        synchronized (hashMap) {
            this.textCache.put(node, string);
        }
        return string;
    }

    BIPropertyContainer checkHistory(BIPropertyContainer bIPropertyContainer) {
        if (HISTORY_TYPE != null && bIPropertyContainer.getType().is(HISTORY_TYPE)) {
            try {
                Class clazz = Sys.loadClass((String)"history", (String)"javax.baja.history.BIHistory");
                Method method = clazz.getMethod("getConfig", null);
                return (BIPropertyContainer)method.invoke((Object)bIPropertyContainer, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bIPropertyContainer;
    }

    BINavNode[] getSelectedNodes() {
        int[] nArray = this.table.getSelection().getRows();
        BINavNode[] bINavNodeArray = new BINavNode[nArray.length];
        for (int i = 0; i < bINavNodeArray.length; ++i) {
            Node node = (Node)this.model.rowToNode(nArray[i]);
            bINavNodeArray[i] = (BINavNode)node.getSubject();
        }
        return bINavNodeArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = BMetadataBrowser.this.commands.buildMenu();
            bMenu.open((BWidget)BMetadataBrowser.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            boolean bl = BMetadataBrowser.this.table.getSelection().getRows().length > 0;
            String[] stringArray = BMetadataBrowser.this.model.getAllColumns();
            if (!bl || stringArray == null || stringArray.length <= 0) {
                return;
            }
            BMetadataBrowser.this.commands.slotEdit.doInvoke();
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BMetadataBrowser.this.commands.updateCommands();
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        BBrush EXPANDER_BRUSH = BColor.black.toBrush();
        BBrush CONNECTING_BRUSH = BColor.make((int)192, (int)192, (int)192).toBrush();
        BBrush DISABLED = BColor.make((String)"#666").toBrush();

        Renderer() {
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            this.paintCellBackground(graphics, cell);
            BBrush bBrush = graphics.getBrush();
            if (cell.column == 0) {
                String string;
                BImage bImage;
                double d;
                TreeTableTheme treeTableTheme = Theme.treeTable();
                Node node = (Node)BMetadataBrowser.this.model.rowToNode(cell.row);
                int n = node.getDepth();
                double d2 = treeTableTheme.getIndent(n);
                if (BMetadataBrowser.this.model.isDepthExpandable(n)) {
                    if (node.hasChildren()) {
                        int n2 = node.isExpanded() ? 2 : 1;
                        d = (cell.height - treeTableTheme.getExpanderHeight()) / 2.0;
                        this.paintExpander(graphics, treeTableTheme, d2, d, n2);
                    }
                    d2 += treeTableTheme.getExpanderWidth() + 5.0;
                }
                if ((bImage = BMetadataBrowser.this.model.getRowIcon(cell.row)) != null) {
                    d = (cell.height - 16.0) / 2.0;
                    graphics.drawImage(bImage, d2, d);
                    d2 += 18.0;
                }
                if ((string = this.getCellText(cell)) != null && string.length() > 0) {
                    BFont bFont = Theme.table().getCellFont();
                    graphics.setBrush(bBrush);
                    graphics.setFont(bFont);
                    graphics.drawString(string, d2, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
                }
            } else {
                Node node = (Node)BMetadataBrowser.this.model.rowToNode(cell.row);
                String string = BMetadataBrowser.this.nodeToString(node);
                if (string != null && string.length() > 0) {
                    BFont bFont = Theme.table().getCellFont();
                    if (!node.configured() && !bBrush.equals((Object)this.getSelectionForeground(cell))) {
                        graphics.setBrush(this.DISABLED);
                    } else {
                        graphics.setBrush(bBrush);
                    }
                    graphics.setFont(bFont);
                    graphics.drawString(string, 4.0, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
                }
            }
            this.paintVerticalLine(graphics, cell);
        }

        private void paintExpander(Graphics graphics, TreeTableTheme treeTableTheme, double d, double d2, int n) {
            BBrush bBrush = graphics.getBrush();
            graphics.setBrush(this.CONNECTING_BRUSH);
            double d3 = treeTableTheme.getExpanderWidth();
            double d4 = treeTableTheme.getExpanderHeight();
            graphics.strokeLine(d, d2, d + d3 - 1.0, d2);
            graphics.strokeLine(d, d2, d, d2 + d3 - 1.0);
            graphics.strokeLine(d + d3 - 1.0, d2, d + d3 - 1.0, d2 + d4 - 1.0);
            graphics.strokeLine(d, d2 + d4 - 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
            graphics.setBrush(this.EXPANDER_BRUSH);
            if (n != 0) {
                graphics.strokeLine(d + 2.0, d2 + 4.0, d + 6.0, d2 + 4.0);
            }
            if (n == 1) {
                graphics.strokeLine(d + 4.0, d2 + 2.0, d + 4.0, d2 + 6.0);
            }
            graphics.setBrush(bBrush);
        }
    }

    class Node
    extends TreeTableNode {
        BINavNode nav;
        String navOrdRelStr;
        BObject object;
        Node[] kids;
        BImage icon;
        boolean performFullLoad = false;
        boolean buildChildren = false;

        Node(Model model, BINavNode bINavNode) {
            super((TreeTableModel)model);
            this.nav = bINavNode;
            this.init();
        }

        Node(Node node, BINavNode bINavNode) {
            super((TreeTableNode)node);
            this.nav = bINavNode;
            this.init();
        }

        void init() {
            BOrd bOrd = this.nav.getNavOrd();
            BOrd bOrd2 = bOrd.relativizeToSession();
            this.navOrdRelStr = bOrd2.toString();
            this.icon = BImage.make((BIcon)this.nav.getNavIcon());
        }

        public Object getSubject() {
            return this.nav;
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.nav.getNavDisplayName(null);
            }
            return "";
        }

        public BImage getIcon() {
            return this.icon;
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return this.nav.hasNavChildren();
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            this.build();
            return this.kids.length;
        }

        public TreeTableNode getChild(int n) {
            this.build();
            return this.kids[n];
        }

        boolean configured() {
            return this.nav instanceof BIPropertyContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build() {
            if (this.buildChildren || this.kids == null) {
                this.buildChildren = false;
                BMetadataBrowser.this.enterBusy();
                try {
                    BINavNode[] bINavNodeArray = this.nav.getNavChildren();
                    Array array = new Array(class$com$tridium$workbench$metadata$BMetadataBrowser$Node == null ? (class$com$tridium$workbench$metadata$BMetadataBrowser$Node = BMetadataBrowser.class$("com.tridium.workbench.metadata.BMetadataBrowser$Node")) : class$com$tridium$workbench$metadata$BMetadataBrowser$Node);
                    Array array2 = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BMetadataBrowser.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
                    for (int i = 0; i < bINavNodeArray.length; ++i) {
                        array.add((Object)new Node(this, bINavNodeArray[i]));
                        if (!(bINavNodeArray[i] instanceof BComponent)) continue;
                        array2.add((Object)((BComponent)bINavNodeArray[i]));
                    }
                    this.kids = (Node[])array.trim();
                    BComponent[] bComponentArray = (BComponent[])array2.trim();
                    if (bComponentArray != null && bComponentArray.length > 0) {
                        BMetadataBrowser.this.registerForComponentEvents(bComponentArray, 0);
                    }
                }
                finally {
                    BMetadataBrowser.this.exitBusy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expanded() {
            NavMonitor navMonitor;
            if (this.performFullLoad) {
                this.performFullLoad = false;
                this.buildChildren = true;
            }
            if ((navMonitor = NavMonitor.get()) != null) {
                NavMonitor navMonitor2 = navMonitor;
                synchronized (navMonitor2) {
                    navMonitor.notify();
                }
            }
        }
    }

    class Model
    extends TreeTableModel
    implements NavListener {
        Model() {
        }

        public int getRootCount() {
            return BMetadataBrowser.this.roots.size();
        }

        public TreeTableNode getRoot(int n) {
            return (Node)((Object)BMetadataBrowser.this.roots.get(n));
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            return lex.getText("metadataBrowser.metaColumn.label");
        }

        String[] getAllColumns() {
            return this.getAllColumns(true);
        }

        String[] getAllColumns(boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            BINavNode[] bINavNodeArray = BMetadataBrowser.this.getSelectedNodes();
            for (int i = 0; i < bINavNodeArray.length; ++i) {
                if (!(bINavNodeArray[i] instanceof BIPropertyContainer)) continue;
                BIPropertyContainer bIPropertyContainer = BMetadataBrowser.this.checkHistory((BIPropertyContainer)bINavNodeArray[i]);
                Property[] propertyArray = bl ? bIPropertyContainer.getPropertiesArray() : bIPropertyContainer.getDynamicPropertiesArray();
                for (int j = 0; j < propertyArray.length; ++j) {
                    String string = propertyArray[j].getName();
                    if (arrayList.contains(string) || (bIPropertyContainer.getFlags((Slot)propertyArray[j]) & 0x4000) == 0) continue;
                    arrayList.add(string);
                }
            }
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(objectArray);
            return objectArray;
        }

        Type getColumnType(String string) {
            BINavNode[] bINavNodeArray = BMetadataBrowser.this.getSelectedNodes();
            for (int i = 0; i < bINavNodeArray.length; ++i) {
                try {
                    BIPropertyContainer bIPropertyContainer;
                    Property property;
                    if (!(bINavNodeArray[i] instanceof BIPropertyContainer) || (property = (bIPropertyContainer = BMetadataBrowser.this.checkHistory((BIPropertyContainer)bINavNodeArray[i])).getProperty(string)) == null || (bIPropertyContainer.getFlags((Slot)property) & 0x4000) == 0) continue;
                    return bIPropertyContainer.get(property).getType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return BString.TYPE;
        }

        public BObject export(int n, int n2) {
            if (n2 == 0) {
                return super.export(n, n2);
            }
            Node node = (Node)BMetadataBrowser.this.model.rowToNode(n);
            return BString.make((String)BMetadataBrowser.this.nodeToString(node));
        }

        public void navEvent(NavEvent navEvent) {
            Node node;
            if (navEvent.getId() == 2 && (node = this.eventToNode(navEvent)) != null && node.nav instanceof BComponent) {
                BComponent bComponent = (BComponent)node.nav;
                if (bComponent instanceof BVirtualGateway) {
                    try {
                        bComponent = ((BVirtualGateway)bComponent).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                    node.performFullLoad = true;
                }
            }
        }

        Node eventToNode(NavEvent navEvent) {
            BOrd bOrd = navEvent.getParentOrd();
            if (bOrd == null) {
                return null;
            }
            String string = bOrd.relativizeToSession().toString();
            Node node = null;
            for (int i = 0; i < BMetadataBrowser.this.roots.size() && (node = this.findNodeByNavOrd(string, (Node)((Object)BMetadataBrowser.this.roots.get(i)))) == null; ++i) {
            }
            return node;
        }

        Node eventToNode(BComponentEvent bComponentEvent) {
            BComponent bComponent = bComponentEvent.getSourceComponent();
            if (bComponent == null) {
                return null;
            }
            BOrd bOrd = bComponent.getNavOrd();
            if (bOrd == null) {
                return null;
            }
            String string = bOrd.relativizeToSession().toString();
            Node node = null;
            for (int i = 0; i < BMetadataBrowser.this.roots.size() && (node = this.findNodeByNavOrd(string, (Node)((Object)BMetadataBrowser.this.roots.get(i)))) == null; ++i) {
            }
            return node;
        }

        Node findNodeByNavOrd(String string, Node node) {
            Node[] nodeArray;
            if (string.equals(node.navOrdRelStr)) {
                return node;
            }
            if (string.startsWith(node.navOrdRelStr) && (nodeArray = node.kids) != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = this.findNodeByNavOrd(string, nodeArray[i]);
                    if (node2 == null) continue;
                    return node2;
                }
            }
            return null;
        }
    }
}

