/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import java.awt.Color;
import java.util.ArrayList;
import javax.baja.gx.BColor;

public class ColorModel {
    private ArrayList agents = new ArrayList();
    private float[] array = new float[3];
    private float hue = 0.0f;
    private float sat = 0.0f;
    private float bri = 0.0f;
    private float alpha = 1.0f;
    private boolean isNull = false;

    public float getHue() {
        return this.isNull ? 0.0f : this.hue;
    }

    public float getSat() {
        return this.isNull ? 0.0f : this.sat;
    }

    public float getBri() {
        return this.isNull ? 0.0f : this.bri;
    }

    public float getAlpha() {
        return this.isNull ? 0.0f : this.alpha;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public BColor toRGB() {
        if (this.isNull) {
            return BColor.NULL;
        }
        Color color = Color.getHSBColor(this.hue, this.sat, this.bri);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.round(this.alpha * 255.0f);
        return BColor.make((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void set(BColor bColor) {
        this.array = Color.RGBtoHSB(bColor.getRed(), bColor.getGreen(), bColor.getBlue(), this.array);
        this.set(this.array[0], this.array[1], this.array[2]);
    }

    public void setWithAlpha(BColor bColor) {
        this.array = Color.RGBtoHSB(bColor.getRed(), bColor.getGreen(), bColor.getBlue(), this.array);
        this.isNull = false;
        this.hue = this.array[0];
        this.sat = this.array[1];
        this.bri = this.array[2];
        this.alpha = (float)bColor.getAlpha() / 255.0f;
        this.fireColorChanged();
    }

    public void set(float f, float f2, float f3) {
        this.isNull = false;
        this.hue = f;
        this.sat = f2;
        this.bri = f3;
        this.fireColorChanged();
    }

    public void setAlpha(float f) {
        this.isNull = false;
        this.alpha = f;
        this.fireColorChanged();
    }

    public void setNull(boolean bl) {
        this.isNull = bl;
        this.fireColorChanged();
    }

    public void addAgent(Agent agent) {
        this.agents.add(agent);
    }

    public void removeAgent(Agent agent) {
        this.agents.remove(agent);
    }

    public void fireColorChanged() {
        for (int i = 0; i < this.agents.size(); ++i) {
            Agent agent = (Agent)this.agents.get(i);
            agent.colorChanged();
        }
    }

    public static interface Agent {
        public void colorChanged();
    }
}

