/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushList;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BHueBar;
import com.tridium.workbench.colorchooser.BPaletteManager;
import com.tridium.workbench.colorchooser.BSatBrightBox;
import com.tridium.workbench.colorchooser.ColorModel;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSlider;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;

public class BColorChooser
extends BEdgePane
implements ColorModel.Agent {
    public static final Action rgbModified = BColorChooser.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action hsbModified = BColorChooser.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action xmlModified = BColorChooser.newAction((int)0, null, null);
    public static final Action nameModified = BColorChooser.newAction((int)0, null, null);
    public static final Action alphaModified = BColorChooser.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$colorchooser$BColorChooser == null ? (class$com$tridium$workbench$colorchooser$BColorChooser = BColorChooser.class$("com.tridium.workbench.colorchooser.BColorChooser")) : class$com$tridium$workbench$colorchooser$BColorChooser));
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$colorchooser$BColorChooser == null ? (class$com$tridium$workbench$colorchooser$BColorChooser = BColorChooser.class$("com.tridium.workbench.colorchooser.BColorChooser")) : class$com$tridium$workbench$colorchooser$BColorChooser));
    private static Lexicon lex = Lexicon.make((String)"wbutil");
    private ColorModel model;
    private boolean ignoreEvents = false;
    private boolean fromHsb = false;
    private boolean fromRgb = false;
    private boolean fromXml = false;
    private boolean fromName = false;
    private boolean fromAlpha = false;
    private BBrushSwatch swatch;
    private BTextField redField;
    private BTextField greField;
    private BTextField bluField;
    private BSlider redSlider;
    private BSlider greSlider;
    private BSlider bluSlider;
    private BTextField hueField;
    private BTextField satField;
    private BTextField briField;
    private BSlider hueSlider;
    private BSlider satSlider;
    private BSlider briSlider;
    private BTextField alphaField;
    private BSlider alphaSlider;
    private BCheckBox nullColor;
    private BTextField xmlField;
    private BTextDropDown nameField;
    private ArrayList customBrushes = new ArrayList();
    private BBrushList customBrushList;
    private Add addCommand;
    private BBrush[] defaultBrushList = new BBrush[]{BColor.make((int)-65536).toBrush(), BColor.make((int)-12582912).toBrush(), BColor.make((int)-8388608).toBrush(), BColor.make((int)-4194304).toBrush(), BColor.make((int)-49088).toBrush(), BColor.make((int)-32640).toBrush(), BColor.make((int)-16192).toBrush(), BColor.make((int)-16777216).toBrush(), BColor.make((int)Short.MIN_VALUE).toBrush(), BColor.make((int)-12574720).toBrush(), BColor.make((int)-8372224).toBrush(), BColor.make((int)-4235264).toBrush(), BColor.make((int)-24512).toBrush(), BColor.make((int)-16256).toBrush(), BColor.make((int)-8257).toBrush(), BColor.make((int)-14671840).toBrush(), BColor.make((int)-256).toBrush(), BColor.make((int)-12566528).toBrush(), BColor.make((int)-8355840).toBrush(), BColor.make((int)-4145152).toBrush(), BColor.make((int)-192).toBrush(), BColor.make((int)-128).toBrush(), BColor.make((int)-64).toBrush(), BColor.make((int)-12566464).toBrush(), BColor.make((int)-16711936).toBrush(), BColor.make((int)-16760832).toBrush(), BColor.make((int)-16744448).toBrush(), BColor.make((int)-16728064).toBrush(), BColor.make((int)-12517568).toBrush(), BColor.make((int)-8323200).toBrush(), BColor.make((int)-4128832).toBrush(), BColor.make((int)-10461088).toBrush(), BColor.make((int)-16711681).toBrush(), BColor.make((int)-16760768).toBrush(), BColor.make((int)-16744320).toBrush(), BColor.make((int)-16727872).toBrush(), BColor.make((int)-12517377).toBrush(), BColor.make((int)-8323073).toBrush(), BColor.make((int)-4128769).toBrush(), BColor.make((int)-8355712).toBrush(), BColor.make((int)-16776961).toBrush(), BColor.make((int)-16777152).toBrush(), BColor.make((int)-16777088).toBrush(), BColor.make((int)-16777024).toBrush(), BColor.make((int)-12566273).toBrush(), BColor.make((int)-8355585).toBrush(), BColor.make((int)-4144897).toBrush(), BColor.make((int)-4144960).toBrush(), BColor.make((int)-8388353).toBrush(), BColor.make((int)-14811072).toBrush(), BColor.make((int)-12844928).toBrush(), BColor.make((int)-10878784).toBrush(), BColor.make((int)-6667777).toBrush(), BColor.make((int)-4488961).toBrush(), BColor.make((int)-2244609).toBrush(), BColor.make((int)-2039584).toBrush(), BColor.make((int)-65281).toBrush(), BColor.make((int)-12582848).toBrush(), BColor.make((int)-8388480).toBrush(), BColor.make((int)-4194112).toBrush(), BColor.make((int)-48897).toBrush(), BColor.make((int)-32513).toBrush(), BColor.make((int)-16129).toBrush(), BColor.make((int)-1).toBrush()};
    static /* synthetic */ Class class$com$tridium$workbench$colorchooser$BColorChooser;
    static /* synthetic */ Class class$javax$baja$gx$BBrush;

    public void rgbModified(BWidgetEvent bWidgetEvent) {
        this.invoke(rgbModified, (BValue)bWidgetEvent, null);
    }

    public void hsbModified(BWidgetEvent bWidgetEvent) {
        this.invoke(hsbModified, (BValue)bWidgetEvent, null);
    }

    public void xmlModified() {
        this.invoke(xmlModified, null, null);
    }

    public void nameModified() {
        this.invoke(nameModified, null, null);
    }

    public void alphaModified(BWidgetEvent bWidgetEvent) {
        this.invoke(alphaModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BColor openInDialog(BWidget bWidget) {
        return BColorChooser.openInDialog(bWidget, BColor.NULL);
    }

    public static BColor openInDialog(BWidget bWidget, BColor bColor) {
        return BColorChooser.openInDialog(bWidget, BColorChooser.text("title"), bColor);
    }

    public static BColor openInDialog(BWidget bWidget, String string, BColor bColor) {
        BColorChooser bColorChooser = new BColorChooser(bColor);
        if (1 == BDialog.open((BWidget)bWidget, (String)string, (Object)new BBorderPane((BWidget)bColorChooser), (int)3)) {
            return bColorChooser.model.toRGB();
        }
        return null;
    }

    public BColorChooser() {
        this(BColor.NULL);
    }

    public BColorChooser(BColor bColor) {
        Object[] objectArray = this.getColors().getChildren(class$javax$baja$gx$BBrush == null ? (class$javax$baja$gx$BBrush = BColorChooser.class$("javax.baja.gx.BBrush")) : class$javax$baja$gx$BBrush);
        for (int i = 0; i < objectArray.length; ++i) {
            this.customBrushes.add((BBrush)objectArray[i]);
        }
        this.model = new ColorModel();
        BSatBrightBox bSatBrightBox = new BSatBrightBox(this.model);
        BHueBar bHueBar = new BHueBar(this.model);
        this.swatch = new BBrushSwatch();
        this.swatch.setPreferredSize(48.0, 48.0);
        this.redSlider = new BSlider();
        this.greSlider = new BSlider();
        this.bluSlider = new BSlider();
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("hue"), BHalign.right));
        this.hueField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.hueField);
        bGridPane.add(null, (BValue)new BLabel("\u00b0"));
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("saturation"), BHalign.right));
        this.satField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.satField);
        bGridPane.add(null, (BValue)new BLabel("%"));
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("brightness"), BHalign.right));
        this.briField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.briField);
        bGridPane.add(null, (BValue)new BLabel("%"));
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 4.0, 0.0, 0.0, 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("red"), BHalign.right));
        this.redField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.redField);
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("green"), BHalign.right));
        this.greField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.greField);
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("blue"), BHalign.right));
        this.bluField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.bluField);
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 4.0, 0.0, 0.0, 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BLabel(BColorChooser.text("alpha"), BHalign.right));
        this.alphaField = new BTextField("", 4);
        bGridPane.add(null, (BValue)this.alphaField);
        bGridPane.add(null, (BValue)new BLabel("%"));
        this.hueSlider = new BSlider();
        this.satSlider = new BSlider();
        this.briSlider = new BSlider();
        this.alphaSlider = new BSlider();
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add(null, (BValue)new BLabel(BColorChooser.text("hex")));
        this.xmlField = new BTextField("", 10);
        bGridPane2.add(null, (BValue)this.xmlField);
        bGridPane2.add(null, (BValue)new BLabel(BColorChooser.text("name")));
        this.nameField = new BTextDropDown("", 10, true);
        bGridPane2.add(null, (BValue)this.nameField);
        BList bList = this.nameField.getList();
        bList.setRenderer((ListRenderer)new ColorRenderer());
        BColor[] bColorArray = BColor.getConstants();
        for (int i = 0; i < bColorArray.length; ++i) {
            if (bColorArray[i].isNull()) continue;
            bList.addItem((Object)bColorArray[i].toString());
        }
        BToolBar bToolBar = new BToolBar();
        this.addCommand = new Add((BWidget)this);
        bToolBar.add(null, (Command)this.addCommand);
        bToolBar.add(null, (Command)new Manage((BWidget)this));
        this.customBrushList = new BBrushList(this.getCustomList());
        this.customBrushList.setController(new CustomBrushListController());
        BScrollPane bScrollPane = new BScrollPane((BWidget)this.customBrushList);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        BGridPane bGridPane3 = new BGridPane(1);
        bGridPane3.setStretchRow(2);
        bGridPane3.setRowAlign(BValign.fill);
        bGridPane3.add(null, (BValue)BBrushList.makeScroll(this.defaultBrushList, new DefaultBrushListController()));
        bGridPane3.add(null, (BValue)bToolBar);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)bGridPane3);
        bEdgePane.setCenter((BWidget)bBorderPane);
        BGridPane bGridPane4 = new BGridPane(1);
        bGridPane4.setValign(BValign.top);
        bGridPane4.setRowGap(10.0);
        bGridPane4.add(null, (BValue)new BBorderPane((BWidget)this.swatch, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bGridPane4.add(null, (BValue)bGridPane);
        bGridPane4.add(null, (BValue)bGridPane2);
        this.nullColor = new BCheckBox((ToggleCommand)new NullCommand());
        bGridPane4.add(null, (BValue)this.nullColor);
        BGridPane bGridPane5 = new BGridPane(4);
        bGridPane5.setColumnGap(20.0);
        bGridPane5.setRowAlign(BValign.fill);
        bGridPane5.add(null, (BValue)bEdgePane);
        bGridPane5.add(null, (BValue)bSatBrightBox);
        bGridPane5.add(null, (BValue)bHueBar);
        bGridPane5.add(null, (BValue)bGridPane4);
        this.setCenter((BWidget)bGridPane5);
        this.linkTo((BComponent)this.redField, (Slot)BTextField.textModified, (Slot)rgbModified);
        this.linkTo((BComponent)this.greField, (Slot)BTextField.textModified, (Slot)rgbModified);
        this.linkTo((BComponent)this.bluField, (Slot)BTextField.textModified, (Slot)rgbModified);
        this.linkTo((BComponent)this.hueField, (Slot)BTextField.textModified, (Slot)hsbModified);
        this.linkTo((BComponent)this.satField, (Slot)BTextField.textModified, (Slot)hsbModified);
        this.linkTo((BComponent)this.briField, (Slot)BTextField.textModified, (Slot)hsbModified);
        this.linkTo((BComponent)this.alphaField, (Slot)BTextField.textModified, (Slot)alphaModified);
        this.linkTo((BComponent)this.xmlField, (Slot)BTextField.textModified, (Slot)xmlModified);
        this.linkTo((BComponent)this.nameField.getEditor(), (Slot)BTextField.textModified, (Slot)nameModified);
        this.model.setWithAlpha(bColor);
        if (bColor.isNull()) {
            this.model.setAlpha(1.0f);
            this.model.setNull(true);
        }
        this.model.addAgent(this);
        this.colorChanged();
        if (this.customBrushes.size() >= 88) {
            this.addCommand.setEnabled(false);
        }
    }

    private BBrush[] getCustomList() {
        return this.customBrushes.toArray(new BBrush[this.customBrushes.size()]);
    }

    public void colorChanged() {
        String string;
        this.ignoreEvents = true;
        this.swatch.setBrush(this.model.toRGB().toBrush());
        int n = Math.round(this.model.getHue() * 360.0f);
        int n2 = Math.round(this.model.getSat() * 100.0f);
        int n3 = Math.round(this.model.getBri() * 100.0f);
        this.hueSlider.setValue((double)n);
        this.satSlider.setValue((double)n2);
        this.briSlider.setValue((double)n3);
        if (!this.fromHsb) {
            this.hueField.setText(Integer.toString(n));
            this.satField.setText(Integer.toString(n2));
            this.briField.setText(Integer.toString(n3));
        }
        BColor bColor = this.model.toRGB();
        int n4 = bColor.getRed();
        int n5 = bColor.getGreen();
        n3 = bColor.getBlue();
        this.redSlider.setValue((double)n4);
        this.greSlider.setValue((double)n5);
        this.bluSlider.setValue((double)n3);
        if (!this.fromRgb) {
            this.redField.setText(Integer.toString(n4));
            this.greField.setText(Integer.toString(n5));
            this.bluField.setText(Integer.toString(n3));
        }
        int n6 = Math.round(this.model.getAlpha() * 100.0f);
        this.alphaSlider.setValue((double)n6);
        if (!this.fromAlpha) {
            this.alphaField.setText(Integer.toString(n6));
        }
        this.nullColor.setSelected(this.model.isNull());
        if (!this.fromXml) {
            string = Integer.toHexString(bColor.getRGB());
            if (string.length() == 1) {
                string = "00000000";
            } else if (string.length() == 7) {
                string = "0" + string;
            } else if (string.length() == 6) {
                string = "00" + string;
            }
            this.xmlField.setText("#" + string);
        }
        if (!this.fromName) {
            string = bColor.toString();
            this.nameField.getEditor().getSelection().deselect();
            this.nameField.setText(bColor.isNull() ? "" : (BColor.getConstant((String)string) == null ? "" : string));
        }
        this.ignoreEvents = false;
        this.fromHsb = false;
        this.fromRgb = false;
        this.fromXml = false;
        this.fromName = false;
        this.fromAlpha = false;
        this.repaint();
    }

    public void doRgbModified(BWidgetEvent bWidgetEvent) {
        if (this.ignoreEvents) {
            return;
        }
        BWidget bWidget = bWidgetEvent.getWidget();
        BColor bColor = this.model.toRGB();
        int n = bColor.getRed();
        int n2 = bColor.getGreen();
        int n3 = bColor.getBlue();
        try {
            if (bWidget == this.redSlider) {
                n = (int)this.redSlider.getValue();
            } else if (bWidget == this.greSlider) {
                n2 = (int)this.greSlider.getValue();
            } else if (bWidget == this.bluSlider) {
                n3 = (int)this.bluSlider.getValue();
            } else if (bWidget == this.redField) {
                n = Integer.parseInt(this.redField.getText());
                this.fromRgb = true;
            } else if (bWidget == this.greField) {
                n2 = Integer.parseInt(this.greField.getText());
                this.fromRgb = true;
            } else if (bWidget == this.bluField) {
                n3 = Integer.parseInt(this.bluField.getText());
                this.fromRgb = true;
            }
            this.model.set(BColor.make((int)n, (int)n2, (int)n3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doHsbModified(BWidgetEvent bWidgetEvent) {
        if (this.ignoreEvents) {
            return;
        }
        BWidget bWidget = bWidgetEvent.getWidget();
        float f = this.model.getHue();
        float f2 = this.model.getSat();
        float f3 = this.model.getBri();
        try {
            if (bWidget == this.hueSlider) {
                f = (float)this.hueSlider.getValue() / 360.0f;
            } else if (bWidget == this.satSlider) {
                f2 = (float)this.satSlider.getValue() / 100.0f;
            } else if (bWidget == this.briSlider) {
                f3 = (float)this.briSlider.getValue() / 100.0f;
            } else if (bWidget == this.hueField) {
                f = (float)Integer.parseInt(this.hueField.getText()) / 360.0f;
                this.fromHsb = true;
            } else if (bWidget == this.satField) {
                f2 = (float)Integer.parseInt(this.satField.getText()) / 100.0f;
                this.fromHsb = true;
            } else if (bWidget == this.briField) {
                f3 = (float)Integer.parseInt(this.briField.getText()) / 100.0f;
                this.fromHsb = true;
            }
            this.model.set(f, f2, f3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doAlphaModified(BWidgetEvent bWidgetEvent) {
        if (this.ignoreEvents) {
            return;
        }
        BWidget bWidget = bWidgetEvent.getWidget();
        if (bWidget == this.alphaSlider) {
            float f = (float)this.alphaSlider.getValue() / 100.0f;
            this.model.setAlpha(f);
        } else if (bWidget == this.alphaField) {
            try {
                float f = (float)Integer.parseInt(this.alphaField.getText()) / 100.0f;
                this.model.setAlpha(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doXmlModified() {
        if (this.ignoreEvents) {
            return;
        }
        try {
            String string = this.xmlField.getText();
            if (!string.startsWith("#")) {
                string = "#" + string;
            }
            BColor bColor = BColor.make((String)string);
            this.fromXml = true;
            this.model.setWithAlpha(bColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doNameModified() {
        if (this.ignoreEvents) {
            return;
        }
        try {
            String string = this.nameField.getText();
            BColor bColor = BColor.getConstant((String)string);
            if (bColor != null) {
                this.fromName = true;
                this.model.setWithAlpha(bColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BOptions getColors() {
        return BOptions.load((String)"colors", (Type)BOptions.TYPE);
    }

    private static String text(String string) {
        return lex.getText("colorChooser." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Manage
    extends Command {
        public Manage(BWidget bWidget) {
            super(bWidget, module, "colorChooser.manage");
        }

        public CommandArtifact doInvoke() {
            BBrush[] bBrushArray = BPaletteManager.openInDialog(this.getOwner(), BColorChooser.this.getCustomList());
            if (bBrushArray != null) {
                BColorChooser.this.customBrushes.clear();
                BOptions bOptions = BColorChooser.this.getColors();
                bOptions.removeAll();
                for (int i = 0; i < bBrushArray.length; ++i) {
                    BColorChooser.this.customBrushes.add(bBrushArray[i]);
                    bOptions.add(null, (BValue)bBrushArray[i]);
                }
                bOptions.save();
                BColorChooser.this.customBrushList.setList(bBrushArray);
                BColorChooser.this.customBrushList.relayout();
                if (BColorChooser.this.customBrushes.size() < 88) {
                    BColorChooser.this.addCommand.setEnabled(true);
                }
            }
            return null;
        }
    }

    class Add
    extends Command {
        public Add(BWidget bWidget) {
            super(bWidget, module, "colorChooser.add");
        }

        public CommandArtifact doInvoke() {
            BBrush bBrush = BColorChooser.this.model.toRGB().toBrush();
            BColorChooser.this.getColors().add(null, (BValue)bBrush);
            BColorChooser.this.getColors().save();
            BColorChooser.this.customBrushes.add(bBrush);
            BColorChooser.this.customBrushList.setList(BColorChooser.this.getCustomList());
            if (BColorChooser.this.customBrushes.size() >= 88) {
                BColorChooser.this.addCommand.setEnabled(false);
            }
            return null;
        }
    }

    class CustomBrushListController
    extends BBrushList.Controller {
        CustomBrushListController() {
        }

        public void swatchPressed(BBrushSwatch bBrushSwatch) {
            BBrush bBrush = bBrushSwatch.getBrush();
            if (bBrush.getPaint() instanceof BBrush.Solid) {
                BColorChooser.this.model.setWithAlpha(((BBrush.Solid)bBrush.getPaint()).getColor());
            }
        }
    }

    class DefaultBrushListController
    extends BBrushList.Controller {
        DefaultBrushListController() {
        }

        public void swatchPressed(BBrushSwatch bBrushSwatch) {
            BBrush bBrush = bBrushSwatch.getBrush();
            if (bBrush.getPaint() instanceof BBrush.Solid) {
                BColorChooser.this.model.set(((BBrush.Solid)bBrush.getPaint()).getColor());
            }
        }
    }

    class NullCommand
    extends ToggleCommand {
        public NullCommand() {
            super((BWidget)BColorChooser.this, BColorChooser.text("useNullColor"));
        }

        public CommandArtifact doInvoke() {
            if (!BColorChooser.this.ignoreEvents) {
                BColorChooser.this.model.setNull(this.isSelected());
            }
            return null;
        }
    }

    class ColorRenderer
    extends ListRenderer {
        ColorRenderer() {
        }

        public void paintItem(Graphics graphics, ListRenderer.Item item) {
            double d;
            this.paintItemBackground(graphics, item);
            String string = (String)item.value;
            double d2 = d = this.getItemHeight();
            graphics.setBrush(BColor.getConstant((String)string).toBrush());
            graphics.fillRect(2.0, 2.0, d2 - 4.0, d - 4.0);
            graphics.setBrush(BColor.black);
            graphics.strokeRect(2.0, 2.0, d2 - 4.0, d - 4.0);
            BFont bFont = Theme.table().getCellFont();
            graphics.setFont(bFont);
            graphics.drawString(string, d2 + 3.0, bFont.getAscent() + 2.0);
        }

        public double getPreferredItemWidth(ListRenderer.Item item) {
            BFont bFont = Theme.table().getCellFont();
            return bFont.width(item.value.toString()) + this.getItemHeight() + 17.0;
        }
    }
}

