/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celleditors;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.colorchooser.BGradientEditor;
import com.tridium.workbench.colorchooser.BImageEditor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BBrushCE
extends BWbCellEditor
implements BMenu.MenuCloseListener {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$celleditors$BBrushCE == null ? (class$com$tridium$workbench$celleditors$BBrushCE = BBrushCE.class$("com.tridium.workbench.celleditors.BBrushCE")) : class$com$tridium$workbench$celleditors$BBrushCE));
    private BBrush brush;
    private BBrushSwatch swatch;
    private SwatchController controller;
    private BLabel label;
    private BMenu menu;
    private RectGeom button = new RectGeom();
    static /* synthetic */ Class class$com$tridium$workbench$celleditors$BBrushCE;

    public Type getType() {
        return TYPE;
    }

    public BBrushCE() {
        this.swatch = new BBrushSwatch();
        this.add("swatch", (BValue)this.swatch);
        this.label = new BLabel();
        this.add("label", (BValue)this.label);
        this.label.setHalign(BHalign.left);
        this.controller = new SwatchController();
        this.swatch.setController(this.controller);
        this.menu = new BMenu();
        this.menu.add(null, (Command)new SolidCommand((BWidget)this));
        this.menu.add(null, (Command)new GradientCommand((BWidget)this));
        this.menu.add(null, (Command)new ImageCommand((BWidget)this));
        this.menu.add(null, (Command)new NullCommand((BWidget)this));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        super.doLoadValue(bObject, context);
        this.brush = (BBrush)bObject;
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        return this.brush;
    }

    public void computePreferredSize() {
        this.setPreferredSize(120.0, 10.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        double d2 = this.getWidth();
        double d3 = d = this.getHeight();
        double d4 = d - 4.0;
        BBrush bBrush = this.brush;
        this.swatch.setBrush(bBrush);
        if (bBrush == null || bBrush.isNull()) {
            this.label.setText("(default)");
        } else {
            BBrush.Paint paint = bBrush.getPaint();
            if (paint instanceof BBrush.Solid) {
                this.label.setText(((BBrush.Solid)paint).getColor().toString());
            } else if (paint instanceof BBrush.Gradient) {
                this.label.setText("(gradient)");
            } else if (paint instanceof BBrush.Image) {
                this.label.setText("(image)");
            }
        }
        this.swatch.setBounds(2.0, 2.0, d3, d4);
        this.label.setBounds(d3 + 6.0, 3.0, d2 - d3 - d3 - 12.0, d4);
        this.button.set(d2 - d3 - 1.0, 3.0, d3 - 2.0, d4 - 2.0);
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintChild(graphics, (BWidget)this.label);
        this.paintChild(graphics, this.swatch);
        if (!this.isReadonly()) {
            Theme.dropDown().paintButton(graphics, (BWidget)this, this.button, this.menu.isOpen());
        }
    }

    public void menuClosed(BMenu bMenu) {
        this.repaint();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.cellSelected();
        if (this.isReadonly()) {
            return;
        }
        if (bMouseEvent.isButton1Down() && this.button.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            this.menu.computePreferredSize();
            double d = this.button.x + this.button.width - this.menu.getPreferredWidth() + 2.0;
            double d2 = this.button.y + this.button.height + 1.0;
            this.menu.open((BWidget)this, d, d2);
            this.repaint();
        } else {
            this.controller.mousePressed(bMouseEvent);
        }
    }

    void doSolid() {
        BColor bColor;
        BBrush bBrush = this.brush;
        BBrush.Paint paint = bBrush.getPaint();
        BColor bColor2 = bColor = !bBrush.isNull() && paint instanceof BBrush.Solid ? BColorChooser.openInDialog((BWidget)this, ((BBrush.Solid)paint).getColor()) : BColorChooser.openInDialog((BWidget)this);
        if (bColor != null) {
            this.brush = bColor.toBrush();
            this.setModified();
            this.relayout();
        }
    }

    void doGradient() {
        BBrush bBrush = this.brush;
        BBrush.Paint paint = bBrush.getPaint();
        BBrush bBrush2 = bBrush = paint instanceof BBrush.Gradient ? BGradientEditor.openInDialog((BWidget)this, bBrush) : BGradientEditor.openInDialog((BWidget)this, BBrush.NULL);
        if (bBrush != null) {
            this.brush = bBrush;
            this.setModified();
            this.relayout();
        }
    }

    void doImage() {
        BBrush bBrush = this.brush;
        BBrush.Paint paint = bBrush.getPaint();
        BBrush bBrush2 = bBrush = paint instanceof BBrush.Image ? BImageEditor.openInDialog((BWidget)this, bBrush) : BImageEditor.openInDialog((BWidget)this, BBrush.NULL);
        if (bBrush != null) {
            BBrush.Paint paint2 = bBrush.getPaint();
            if (paint2 instanceof BBrush.Image) {
                BImage bImage = ((BBrush.Image)paint2).getImage();
                bImage.sync();
                bImage.setBaseOrd(BWbShell.getWbShell((BWidget)this).getActiveOrd());
            }
            this.brush = bBrush;
            this.setModified();
            this.relayout();
        }
    }

    void doNull() {
        this.brush = BBrush.NULL;
        this.setModified();
        this.relayout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NullCommand
    extends Command {
        public NullCommand(BWidget bWidget) {
            super(bWidget, "Null/Default");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doNull();
            return null;
        }
    }

    class ImageCommand
    extends Command {
        public ImageCommand(BWidget bWidget) {
            super(bWidget, "Image");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doImage();
            return null;
        }
    }

    class GradientCommand
    extends Command {
        public GradientCommand(BWidget bWidget) {
            super(bWidget, "Gradient");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doGradient();
            return null;
        }
    }

    class SolidCommand
    extends Command {
        public SolidCommand(BWidget bWidget) {
            super(bWidget, "Solid");
        }

        public CommandArtifact doInvoke() {
            BBrushCE.this.doSolid();
            return null;
        }
    }

    class SwatchController
    extends BBrushSwatch.Controller {
        SwatchController() {
        }

        public void mousePressed(BMouseEvent bMouseEvent) {
            if (BBrushCE.this.isReadonly()) {
                return;
            }
            if (bMouseEvent.isButton1Down()) {
                BBrush bBrush = BBrushCE.this.brush;
                BBrush.Paint paint = bBrush.getPaint();
                if (paint instanceof BBrush.Solid) {
                    BBrushCE.this.doSolid();
                } else if (paint instanceof BBrush.Gradient) {
                    BBrushCE.this.doGradient();
                } else if (paint instanceof BBrush.Image) {
                    BBrushCE.this.doImage();
                }
            } else if (bMouseEvent.isButton3Down()) {
                BBrushCE.this.cellPopup(bMouseEvent);
            }
        }
    }
}

