/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.workbench.category.Category;
import com.tridium.workbench.nav.NavMonitor;
import java.util.HashMap;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.view.BWbComponentView;

public class BCategoryBrowser
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$category$BCategoryBrowser == null ? (class$com$tridium$workbench$category$BCategoryBrowser = BCategoryBrowser.class$("com.tridium.workbench.category.BCategoryBrowser")) : class$com$tridium$workbench$category$BCategoryBrowser));
    boolean[] visible;
    int visibleSize;
    int[] viewIdx;
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$category$BCategoryBrowser == null ? (class$com$tridium$workbench$category$BCategoryBrowser = BCategoryBrowser.class$("com.tridium.workbench.category.BCategoryBrowser")) : class$com$tridium$workbench$category$BCategoryBrowser));
    static Class rootHistoryFolderClass = null;
    static Class historyMirrorClass = null;
    BTreeTable table;
    Model model;
    Array roots = new Array(class$com$tridium$workbench$category$BCategoryBrowser$Node == null ? (class$com$tridium$workbench$category$BCategoryBrowser$Node = BCategoryBrowser.class$("com.tridium.workbench.category.BCategoryBrowser$Node")) : class$com$tridium$workbench$category$BCategoryBrowser$Node);
    BCategoryService service;
    Category[] categories;
    static /* synthetic */ Class class$com$tridium$workbench$category$BCategoryBrowser;
    static /* synthetic */ Class class$com$tridium$workbench$category$BCategoryBrowser$Node;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$javax$baja$category$BCategoryMask;
    static /* synthetic */ Class class$java$lang$Integer;

    public Type getType() {
        return TYPE;
    }

    public BCategoryBrowser() {
        this.table = new BTreeTable();
        this.table.setStyleClasses("category-browser");
        this.table.setMultipleSelection(false);
        this.model = new Model();
        this.table.setModel((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setController((TableController)new Controller());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this.model);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this.model);
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("CategoryBrowser");
        bMenu.add(null, (Command)new ShowConfigured());
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)new ShowConfigured());
        return bToolBar;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.service = (BCategoryService)bObject;
        BISession bISession = BOrd.toSession((BObject)this.service);
        BINavNode[] bINavNodeArray = bISession.getNavChildren();
        int n = 0;
        for (int i = 0; i < bINavNodeArray.length; ++i) {
            if (!(bINavNodeArray[i] instanceof BSpace) || !(bINavNodeArray[i] instanceof BINavNode) || !(bINavNodeArray[i] instanceof BICategorizable)) continue;
            if (bINavNodeArray[i] instanceof BComponentSpace) {
                BComponent bComponent = ((BComponentSpace)bINavNodeArray[i]).getRootComponent();
                Node node = new Node(this.model, (BINavNode)bComponent);
                this.roots.add((Object)node);
                Category.Result result = Category.load(this.getWbShell(), node.mask.size() + 1);
                n = result.categories.length - 1;
                this.categories = new Category[n];
                System.arraycopy(result.categories, 1, this.categories, 0, n);
                continue;
            }
            this.addRoot(((BSpace)bINavNodeArray[i]).getOrdInSession());
        }
        this.loadVisible(n);
        if (!this.model.needsInitialization()) {
            this.model.updateTreeTable(true);
        }
    }

    private void addRoot(BOrd bOrd) {
        try {
            BObject bObject = bOrd.get(this.getCurrentValue());
            if (!(bObject instanceof BINavNode)) {
                return;
            }
            this.addRoot((BINavNode)bObject);
        }
        catch (Exception exception) {
            System.out.println("Cannot add root: " + bOrd);
            exception.printStackTrace();
        }
    }

    private void addRoot(BINavNode bINavNode) {
        try {
            if (bINavNode instanceof BICategorizable) {
                this.roots.add((Object)new Node(this.model, bINavNode));
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot add root: " + bINavNode.getNavOrd());
            System.out.println("  " + exception);
        }
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        Transaction transaction;
        Object object;
        Node node;
        int n;
        BOrdToCategoryMap bOrdToCategoryMap = this.service.getOrdMap();
        int n2 = bOrdToCategoryMap.size();
        HashMap<BOrd, BCategoryMask> hashMap = new HashMap<BOrd, BCategoryMask>();
        for (n = 0; n < n2; ++n) {
            hashMap.put(bOrdToCategoryMap.getOrd(n), bOrdToCategoryMap.getCategoryMask(n));
        }
        for (n = 0; n < this.roots.size(); ++n) {
            node = (Node)((Object)this.roots.get(n));
            if (node.nav instanceof BComponent && !node.virtual) {
                object = ((BComponent)node.nav).getComponentSpace();
                transaction = object.newTransaction();
                this.saveComponentNodes(node, (Context)transaction, hashMap);
                transaction.commit();
                continue;
            }
            this.saveOrdMappedNodes(node, hashMap);
        }
        Array array = new Array(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BCategoryBrowser.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
        node = new Array(class$javax$baja$category$BCategoryMask == null ? (class$javax$baja$category$BCategoryMask = BCategoryBrowser.class$("javax.baja.category.BCategoryMask")) : class$javax$baja$category$BCategoryMask);
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            transaction = (BOrd)object.next();
            BCategoryMask bCategoryMask = (BCategoryMask)hashMap.get(transaction);
            if (bCategoryMask == null || bCategoryMask.isNull()) continue;
            array.add((Object)transaction);
            node.add(bCategoryMask);
        }
        this.service.setOrdMap(BOrdToCategoryMap.make((BOrd[])((BOrd[])array.trim()), (BCategoryMask[])((BCategoryMask[])node.trim())));
        this.service.update();
        return this.service;
    }

    private void saveComponentNodes(Node node, Context context, Map map) {
        if (node.dirty) {
            if (node.inherited()) {
                ((BComponent)node.nav).setCategoryMask(BCategoryMask.NULL, context);
            } else {
                ((BComponent)node.nav).setCategoryMask(node.mask, context);
            }
        }
        if (node.kids == null) {
            return;
        }
        for (int i = 0; i < node.kids.length; ++i) {
            if (node.kids[i].virtual) {
                this.saveOrdMappedNodes(node.kids[i], map);
                continue;
            }
            this.saveComponentNodes(node.kids[i], context, map);
        }
    }

    private void saveOrdMappedNodes(Node node, Map map) {
        if (node.dirty) {
            BOrd bOrd = node.categorizableOrd;
            if (node.inherited()) {
                map.remove(bOrd);
            } else {
                map.put(bOrd, node.mask);
            }
        }
        if (node.kids == null) {
            return;
        }
        for (int i = 0; i < node.kids.length; ++i) {
            this.saveOrdMappedNodes(node.kids[i], map);
        }
    }

    private void updateVisible() {
        this.visibleSize = 0;
        for (int i = 0; i < this.visible.length; ++i) {
            if (!this.visible[i]) continue;
            this.viewIdx[this.visibleSize++] = i;
        }
    }

    private void loadVisible(int n) {
        this.visible = new boolean[n];
        this.viewIdx = new int[n];
        this.visibleSize = n;
        for (int i = 0; i < n; ++i) {
            this.visible[i] = true;
            this.viewIdx[i] = i;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConfigureColumns
    extends Command {
        ConfigureColumns(boolean bl) {
            super((BWidget)BCategoryBrowser.this, lex.getText("category.show"));
        }

        public CommandArtifact doInvoke() {
            int n;
            BCheckList bCheckList = new BCheckList();
            for (n = 0; n < BCategoryBrowser.this.categories.length; ++n) {
                bCheckList.addItem((Object)BCategoryBrowser.this.categories[n].display);
            }
            bCheckList.getSelection().deselectAll();
            for (n = 0; n < BCategoryBrowser.this.categories.length; ++n) {
                if (!BCategoryBrowser.this.visible[n]) continue;
                bCheckList.getSelection().select(n);
            }
            BDialog.open((BWidget)BCategoryBrowser.this, (String)lex.getText("category.categories"), (Object)bCheckList, (int)1);
            for (n = 0; n < BCategoryBrowser.this.categories.length; ++n) {
                BCategoryBrowser.this.visible[n] = bCheckList.getSelection().isSelected(n);
            }
            BCategoryBrowser.this.updateVisible();
            BCategoryBrowser.this.table.relayout();
            return null;
        }
    }

    class ShowAllColumns
    extends Command {
        boolean show;

        ShowAllColumns(boolean bl) {
            super((BWidget)BCategoryBrowser.this, bl ? lex.getText("category.showAll") : lex.getText("category.hideAll"));
            this.show = bl;
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < BCategoryBrowser.this.visible.length; ++i) {
                BCategoryBrowser.this.visible[i] = this.show;
            }
            BCategoryBrowser.this.updateVisible();
            BCategoryBrowser.this.table.relayout();
            return null;
        }
    }

    class ClearConfiguredVisitor
    extends ConfiguredNodeVisitor {
        Node fromNode;

        ClearConfiguredVisitor(Node node) {
            this.fromNode = node;
        }

        void visitNode(Node node) {
            if (node.isRoot) {
                return;
            }
            if (!this.isAncestor(this.fromNode, node)) {
                return;
            }
            if (node.inherited()) {
                return;
            }
            node.mask = null;
            node.dirty = true;
            BCategoryBrowser.this.setModified();
        }

        boolean isAncestor(Node node, Node node2) {
            if (node2 == node) {
                return true;
            }
            if (node2.isRoot) {
                return false;
            }
            return this.isAncestor(node, (Node)node2.getParent());
        }
    }

    class ShowConfiguredVisitor
    extends ConfiguredNodeVisitor {
        ShowConfiguredVisitor() {
        }

        void visitNode(Node node) {
            if (!node.isRoot) {
                this.expandNode((Node)node.getParent());
            }
        }

        void expandNode(Node node) {
            node.setExpanded(true);
            if (!node.isRoot) {
                this.expandNode((Node)node.getParent());
            }
        }
    }

    abstract class ConfiguredNodeVisitor {
        ConfiguredNodeVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void visitAll() {
            BCategoryBrowser.this.enterBusy();
            try {
                int n;
                BOrd bOrd = BOrd.make((String)"station:|slot:/|bql:select navOrd from baja:Component where not categoryMask.isNull");
                BITable bITable = ((BICollection)bOrd.resolve((BObject)BCategoryBrowser.this.service).get()).toTable();
                Column column = bITable.getColumns().get(0);
                TableCursor tableCursor = (TableCursor)bITable.cursor();
                Array array = new Array(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BCategoryBrowser.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
                while (tableCursor.next()) {
                    array.add((Object)BOrd.make((String)tableCursor.get(column).toString(null)).relativizeToSession());
                }
                BOrd[] bOrdArray = (BOrd[])array.trim();
                new BatchResolve(bOrdArray).resolve((BObject)BCategoryBrowser.this.service);
                for (int i = 0; i < bOrdArray.length; ++i) {
                    String string = bOrdArray[i].toString();
                    for (n = 0; n < BCategoryBrowser.this.roots.size(); ++n) {
                        this.findNode(string, (Node)((Object)BCategoryBrowser.this.roots.get(n)));
                    }
                }
                BOrdToCategoryMap bOrdToCategoryMap = BCategoryBrowser.this.service.getOrdMap();
                int n2 = bOrdToCategoryMap.size();
                for (n = 0; n < n2; ++n) {
                    String string = bOrdToCategoryMap.getOrd(n).relativizeToSession().toString();
                    for (int i = 0; i < BCategoryBrowser.this.roots.size(); ++i) {
                        this.findNode(string, (Node)((Object)BCategoryBrowser.this.roots.get(i)));
                    }
                }
            }
            finally {
                BCategoryBrowser.this.exitBusy();
                BCategoryBrowser.this.repaint();
            }
        }

        void findNode(String string, Node node) {
            String string2 = node.categorizableOrdRelStr;
            if (string.equals(string2)) {
                this.visitNode(node);
            } else if (string.startsWith(string2) || string2.equals("history:///") && string.startsWith("history:/") && !string.startsWith("history://")) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.findNode(string, (Node)node.getChild(i));
                }
            }
        }

        abstract void visitNode(Node var1);
    }

    class ClearConfigured
    extends Command {
        Node fromNode;

        ClearConfigured(Node node) {
            super((BWidget)BCategoryBrowser.this, lex, "category.clearConfigured");
            this.fromNode = node;
        }

        public CommandArtifact doInvoke() throws Exception {
            new ClearConfiguredVisitor(this.fromNode).visitAll();
            return null;
        }
    }

    class ShowConfigured
    extends Command {
        ShowConfigured() {
            super((BWidget)BCategoryBrowser.this, lex, "category.showConfigured");
        }

        public CommandArtifact doInvoke() throws Exception {
            new ShowConfiguredVisitor().visitAll();
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.isButton1Down()) {
                this.leftClick(bMouseEvent, n, n2);
            } else if (bMouseEvent.isButton3Down()) {
                this.rightClick(bMouseEvent, n, n2);
            }
        }

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            Node node = (Node)BCategoryBrowser.this.model.rowToNode(n);
            String string = ((BINavNode)node.getSubject()).getNavDisplayName(null).toString();
            string = string + "/" + BCategoryBrowser.this.model.getColumnName(n2);
            BCategoryBrowser.this.getWbShell().showStatus(string);
        }

        private void leftClick(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 == 0) {
                super.cellPressed(bMouseEvent, n, n2);
            } else if (n2 == 1) {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(n);
                if (node.isRoot) {
                    return;
                }
                node.mask = node.inherited() ? node.applied() : null;
                node.dirty = true;
                BCategoryBrowser.this.setModified();
                BCategoryBrowser.this.repaint();
            } else {
                int n3;
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(n);
                BCategoryMask bCategoryMask = node.mask;
                if (bCategoryMask == null) {
                    bCategoryMask = BCategoryMask.NULL;
                }
                Array array = new Array(class$java$lang$Integer == null ? (class$java$lang$Integer = BCategoryBrowser.class$("java.lang.Integer")) : class$java$lang$Integer);
                for (int i = 0; i < BCategoryBrowser.this.visibleSize; ++i) {
                    n3 = BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[i]].index;
                    if (i == n2 - 2) {
                        if (bCategoryMask.get(n3)) continue;
                        array.add((Object)new Integer(n3));
                        continue;
                    }
                    if (!bCategoryMask.get(n3)) continue;
                    array.add((Object)new Integer(n3));
                }
                int[] nArray = new int[array.size()];
                for (n3 = 0; n3 < array.size(); ++n3) {
                    nArray[n3] = (Integer)array.get(n3);
                }
                BCategoryMask bCategoryMask2 = BCategoryMask.make((int[])nArray);
                if (!bCategoryMask2.isNull()) {
                    node.mask = bCategoryMask2;
                    node.dirty = true;
                    BCategoryBrowser.this.setModified();
                    BCategoryBrowser.this.repaint();
                }
            }
        }

        private void rightClick(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new ClearConfigured((Node)BCategoryBrowser.this.model.rowToNode(n)));
            bMenu.open((BWidget)BCategoryBrowser.this, bMouseEvent.getX(), bMouseEvent.getY());
        }

        protected BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)new ShowAllColumns(true));
            bMenu.add(null, (Command)new ShowAllColumns(false));
            bMenu.add(null, (Command)new ConfigureColumns(false));
            return bMenu;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        BBrush EXPANDER_BRUSH = BColor.black.toBrush();
        BBrush CONNECTING_BRUSH = BColor.make((int)192, (int)192, (int)192).toBrush();
        BImage DOT = BImage.make((String)"module://icons/x16/bullet.png");
        BImage INHERIT = BImage.make((String)"module://icons/x16/check.png");

        Renderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
            if (!node.inherited()) {
                return Theme.table().getBandBrush((IStylable)this.getTable());
            }
            return super.getBackground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            BTable bTable = this.getTable();
            TreeTableTheme treeTableTheme = Theme.treeTable();
            this.paintCellBackground(graphics, cell);
            BBrush bBrush = graphics.getBrush();
            if (cell.column == 0) {
                String string;
                BImage bImage;
                double d;
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
                int n = node.getDepth();
                double d2 = treeTableTheme.getIndent(n);
                if (BCategoryBrowser.this.model.isDepthExpandable(n)) {
                    if (node.hasChildren()) {
                        int n2 = node.isExpanded() ? 2 : 1;
                        d = (cell.height - treeTableTheme.getExpanderHeight()) / 2.0;
                        this.paintExpander(graphics, treeTableTheme, d2, d, n2);
                    }
                    d2 += treeTableTheme.getExpanderWidth() + 5.0;
                }
                if ((bImage = BCategoryBrowser.this.model.getRowIcon(cell.row)) != null) {
                    d = (cell.height - 16.0) / 2.0;
                    if (node.inherited()) {
                        graphics.drawImage(bImage.getDisabledImage(), d2, d);
                    } else {
                        graphics.drawImage(bImage, d2, d);
                    }
                    d2 += 18.0;
                }
                if ((string = this.getCellText(cell)) != null && string.length() > 0) {
                    BFont bFont = treeTableTheme.getCellFont((IStylable)bTable);
                    if (node.inherited()) {
                        graphics.setBrush(treeTableTheme.getTextDisabled());
                    } else {
                        graphics.setBrush(bBrush);
                    }
                    graphics.setFont(bFont);
                    graphics.drawString(string, d2, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
                }
            } else if (cell.column == 1) {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
                if (node.inherited()) {
                    graphics.drawImage(this.INHERIT, 4.0, (cell.height - this.INHERIT.getHeight()) / 2.0);
                } else if (node.isRoot) {
                    BFont bFont = treeTableTheme.getCellFont((IStylable)bTable);
                    graphics.setBrush(treeTableTheme.getTextDisabled());
                    graphics.setFont(bFont);
                    graphics.drawString(lex.getText("category.notApplicable"), 4.0, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
                }
            } else {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
                int n = BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[cell.column - 2]].index;
                if (node.inherited()) {
                    if (node.applied().get(n)) {
                        graphics.drawImage(this.DOT.getDisabledImage(), 4.0, (cell.height - this.DOT.getDisabledImage().getHeight()) / 2.0);
                    }
                } else if (node.mask.get(n)) {
                    graphics.drawImage(this.DOT, 4.0, (cell.height - this.DOT.getHeight()) / 2.0);
                }
            }
            this.paintVerticalLine(graphics, cell);
        }

        private void paintExpander(Graphics graphics, TreeTableTheme treeTableTheme, double d, double d2, int n) {
            BBrush bBrush = graphics.getBrush();
            graphics.setBrush(this.CONNECTING_BRUSH);
            double d3 = treeTableTheme.getExpanderWidth();
            double d4 = treeTableTheme.getExpanderHeight();
            graphics.strokeLine(d, d2, d + d3 - 1.0, d2);
            graphics.strokeLine(d, d2, d, d2 + d3 - 1.0);
            graphics.strokeLine(d + d3 - 1.0, d2, d + d3 - 1.0, d2 + d4 - 1.0);
            graphics.strokeLine(d, d2 + d4 - 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
            graphics.setBrush(this.EXPANDER_BRUSH);
            if (n != 0) {
                graphics.strokeLine(d + 2.0, d2 + 4.0, d + 6.0, d2 + 4.0);
            }
            if (n == 1) {
                graphics.strokeLine(d + 4.0, d2 + 2.0, d + 4.0, d2 + 6.0);
            }
            graphics.setBrush(bBrush);
        }
    }

    class Node
    extends TreeTableNode {
        BINavNode nav;
        BOrd categorizableOrd;
        String categorizableOrdRelStr;
        String navOrdRelStr;
        BObject object;
        boolean virtual;
        Node[] kids;
        BImage icon;
        BCategoryMask mask;
        boolean dirty = false;
        boolean isRoot;
        boolean performFullLoad = false;
        boolean buildChildren = false;

        Node(Model model, BINavNode bINavNode) {
            super((TreeTableModel)model);
            this.nav = bINavNode;
            this.isRoot = true;
            this.init();
            if (this.mask == null) {
                this.mask = BCategoryMask.make((String)"1");
                this.dirty = true;
            }
        }

        Node(Node node, BINavNode bINavNode) {
            super((TreeTableNode)node);
            this.nav = bINavNode;
            this.isRoot = false;
            this.init();
        }

        void init() {
            if (!(this.nav instanceof BICategorizable)) {
                throw new IllegalStateException(this.nav.getClass().getName() + " is not BICategorizable");
            }
            this.virtual = this.nav instanceof BVirtualComponent;
            BOrd bOrd = this.nav.getNavOrd();
            BOrd bOrd2 = bOrd.relativizeToSession();
            this.categorizableOrd = this.virtual ? ((BVirtualComponent)this.nav).getCategorizableOrd().relativizeToSession() : bOrd2;
            this.categorizableOrdRelStr = this.categorizableOrd.toString();
            this.navOrdRelStr = bOrd2.toString();
            this.object = bOrd.get((BObject)BCategoryBrowser.this.service);
            this.icon = BImage.make((BIcon)this.nav.getNavIcon());
            this.mask = this.nav instanceof BComponent && !this.virtual ? ((BICategorizable)this.nav).getCategoryMask() : BCategoryBrowser.this.service.getOrdMap().getCategoryMask(this.categorizableOrd);
        }

        public Object getSubject() {
            return this.nav;
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.nav.getNavDisplayName(null);
            }
            return "";
        }

        public BImage getIcon() {
            return this.icon;
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return this.nav.hasNavChildren();
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            this.build();
            return this.kids.length;
        }

        public TreeTableNode getChild(int n) {
            this.build();
            return this.kids[n];
        }

        boolean inherited() {
            return this.mask == null || this.mask.isNull();
        }

        BCategoryMask applied() {
            if (this.inherited()) {
                Node node = (Node)this.getParent();
                try {
                    if (rootHistoryFolderClass == null) {
                        rootHistoryFolderClass = Sys.loadClass((String)"history", (String)"com.tridium.history.BRootHistoryFolder");
                    }
                    if (rootHistoryFolderClass.isInstance(node.nav)) {
                        node = (Node)node.getParent();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return node.applied();
            }
            return this.mask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build() {
            block10: {
                if (this.buildChildren || this.kids == null) {
                    this.buildChildren = false;
                    BCategoryBrowser.this.enterBusy();
                    try {
                        if (this.object instanceof BStation && !this.isRoot) {
                            this.kids = new Node[0];
                            break block10;
                        }
                        BINavNode[] bINavNodeArray = this.nav.getNavChildren();
                        Array array = new Array(class$com$tridium$workbench$category$BCategoryBrowser$Node == null ? (class$com$tridium$workbench$category$BCategoryBrowser$Node = BCategoryBrowser.class$("com.tridium.workbench.category.BCategoryBrowser$Node")) : class$com$tridium$workbench$category$BCategoryBrowser$Node);
                        for (int i = 0; i < bINavNodeArray.length; ++i) {
                            if (!(bINavNodeArray[i] instanceof BICategorizable)) continue;
                            try {
                                if (historyMirrorClass == null) {
                                    historyMirrorClass = Sys.loadClass((String)"history", (String)"com.tridium.history.BHistoryMirror");
                                }
                                if (historyMirrorClass.isInstance(bINavNodeArray[i])) {
                                    continue;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            array.add((Object)new Node(this, bINavNodeArray[i]));
                        }
                        this.kids = (Node[])array.trim();
                    }
                    finally {
                        BCategoryBrowser.this.exitBusy();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expanded() {
            NavMonitor navMonitor;
            if (this.performFullLoad) {
                this.performFullLoad = false;
                this.buildChildren = true;
            }
            if ((navMonitor = NavMonitor.get()) != null) {
                NavMonitor navMonitor2 = navMonitor;
                synchronized (navMonitor2) {
                    navMonitor.notify();
                }
            }
        }
    }

    class Model
    extends TreeTableModel
    implements NavListener {
        Model() {
        }

        public int getRootCount() {
            return BCategoryBrowser.this.roots.size();
        }

        public TreeTableNode getRoot(int n) {
            return (Node)((Object)BCategoryBrowser.this.roots.get(n));
        }

        public int getColumnCount() {
            return BCategoryBrowser.this.visibleSize + 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                return lex.getText("category.inherit.label");
            }
            return BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[n - 2]].display;
        }

        public BObject export(int n, int n2) {
            if (n2 == 0) {
                return super.export(n, n2);
            }
            if (n2 == 1) {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(n);
                if (node.inherited()) {
                    return BString.make((String)lex.getText("category.marker"));
                }
                if (node.isRoot) {
                    return BString.make((String)lex.getText("category.notApplicable"));
                }
                return BString.DEFAULT;
            }
            Node node = (Node)BCategoryBrowser.this.model.rowToNode(n);
            int n3 = BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[n2 - 2]].index;
            if (node.inherited()) {
                return node.applied().get(n3) ? BString.make((String)lex.getText("category.marker")) : BString.DEFAULT;
            }
            return node.mask.get(n3) ? BString.make((String)lex.getText("category.marker")) : BString.DEFAULT;
        }

        public void navEvent(NavEvent navEvent) {
            Node node;
            if (navEvent.getId() == 2 && (node = this.eventToNode(navEvent)) != null && node.nav instanceof BComponent) {
                BComponent bComponent = (BComponent)node.nav;
                if (bComponent instanceof BVirtualGateway) {
                    try {
                        bComponent = ((BVirtualGateway)bComponent).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                    node.performFullLoad = true;
                }
            }
        }

        Node eventToNode(NavEvent navEvent) {
            BOrd bOrd = navEvent.getParentOrd();
            if (bOrd == null) {
                return null;
            }
            String string = bOrd.relativizeToSession().toString();
            Node node = null;
            for (int i = 0; i < BCategoryBrowser.this.roots.size() && (node = this.findNodeByNavOrd(string, (Node)((Object)BCategoryBrowser.this.roots.get(i)))) == null; ++i) {
            }
            return node;
        }

        Node findNodeByNavOrd(String string, Node node) {
            Node[] nodeArray;
            if (string.equals(node.navOrdRelStr)) {
                return node;
            }
            if (string.startsWith(node.navOrdRelStr) && (nodeArray = node.kids) != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = this.findNodeByNavOrd(string, nodeArray[i]);
                    if (node2 == null) continue;
                    return node2;
                }
            }
            return null;
        }
    }
}

