/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ports;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platform.BPlatformService;
import java.util.StringTokenizer;
import javax.baja.license.LicenseManager;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPort
extends BComponent {
    public static final Property portType = BPort.newProperty((int)1, (BValue)BPortTypeEnum.unknown, null);
    public static final Property status = BPort.newProperty((int)1, (BValue)BHwScanStatusEnum.available, null);
    public static final Property prefix = BPort.newProperty((int)5, (String)"Port", null);
    public static final Property requiredFeatures = BPort.newProperty((int)5, (String)"", null);
    public static final Property hasConnector = BPort.newProperty((int)5, (boolean)true, null);
    public static final Property owner = BPort.newProperty((int)1, (String)"none", null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platHwScan$ports$BPort;

    public BPortTypeEnum getPortType() {
        return (BPortTypeEnum)this.get(portType);
    }

    public void setPortType(BPortTypeEnum bPortTypeEnum) {
        this.set(portType, (BValue)bPortTypeEnum, null);
    }

    public BHwScanStatusEnum getStatus() {
        return (BHwScanStatusEnum)this.get(status);
    }

    public void setStatus(BHwScanStatusEnum bHwScanStatusEnum) {
        this.set(status, (BValue)bHwScanStatusEnum, null);
    }

    public String getPrefix() {
        return this.getString(prefix);
    }

    public void setPrefix(String string) {
        this.setString(prefix, string, null);
    }

    public String getRequiredFeatures() {
        return this.getString(requiredFeatures);
    }

    public void setRequiredFeatures(String string) {
        this.setString(requiredFeatures, string, null);
    }

    public boolean getHasConnector() {
        return this.getBoolean(hasConnector);
    }

    public void setHasConnector(boolean bl) {
        this.setBoolean(hasConnector, bl, null);
    }

    public String getOwner() {
        return this.getString(owner);
    }

    public void setOwner(String string) {
        this.setString(owner, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void checkLicense() {
        if (!this.isLicensed()) {
            this.setStatus(BHwScanStatusEnum.notLicensed);
        }
    }

    public boolean isAvailable() {
        return this.getStatus().equals((Object)BHwScanStatusEnum.available);
    }

    public boolean isLicensed() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getRequiredFeatures(), ",");
        if (stringTokenizer.countTokens() == 0) {
            return true;
        }
        LicenseManager licenseManager = Sys.getLicenseManager();
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            try {
                licenseManager.checkFeature(stringTokenizer2.nextToken().trim(), stringTokenizer2.nextToken().trim());
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void initOwnerAndStatus() {
        block7: {
            try {
                if (this.getPrefix().startsWith("COM")) {
                    BPlatformService bPlatformService = (BPlatformService)Sys.getService((Type)BHardwareScanService.serialPortSvcTypeSpec.getResolvedType());
                    bPlatformService.checkPropertiesLoaded();
                    bPlatformService.lease();
                    BComponent bComponent = (BComponent)bPlatformService.get(this.getName());
                    bComponent.lease();
                    this.updateOwnerAndStatus(((BString)bComponent.get("owner")).toString().trim());
                    break block7;
                }
                if (!this.getPrefix().startsWith("LON")) break block7;
                BComponent[] bComponentArray = Sys.getServices((Type)BHardwareScanService.lonTypeSpec.getResolvedType());
                int n = 0;
                while (n < bComponentArray.length) {
                    BComponent bComponent = bComponentArray[n];
                    bComponent.lease(2);
                    BStruct bStruct = (BStruct)bComponent.get("lonCommConfig");
                    String string = ((BString)bStruct.get("deviceName")).toString();
                    if (string.equals(this.getName()) && ((BStatus)bComponent.get("status")).isOk()) {
                        this.updateOwnerAndStatus(bComponent.getName());
                        break;
                    }
                    ++n;
                }
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                BHardwareScanService.log.error(BHardwareScanService.lex.getText("moduleNotFound", new Object[]{moduleNotFoundException.getMessage(), this.getName()}));
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void updateOwnerAndStatus(String string) {
        if (this.getStatus().equals((Object)BHwScanStatusEnum.available) || this.getStatus().equals((Object)BHwScanStatusEnum.unavailable) || this.getStatus().equals((Object)BHwScanStatusEnum.inUse)) {
            this.setOwner(string);
            if (string.equals("dbgjmpr")) {
                this.setStatus(BHwScanStatusEnum.serialShell);
            } else if (!string.equals("none")) {
                this.setStatus(BHwScanStatusEnum.inUse);
            } else {
                this.setStatus(BHwScanStatusEnum.available);
            }
        }
    }

    private final String verify(String string) {
        if (string == null || string.equalsIgnoreCase(BHardwareScanService.lex.getText("none"))) {
            return "";
        }
        return string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPort() {
    }

    public BPort(BPortTypeEnum bPortTypeEnum) {
        this.setPortType(bPortTypeEnum);
    }

    public BPort(BPortTypeEnum bPortTypeEnum, String string) {
        this.setPortType(bPortTypeEnum);
        this.setRequiredFeatures(this.verify(string));
    }

    public BPort(BPortTypeEnum bPortTypeEnum, String string, String string2) {
        this.setPortType(bPortTypeEnum);
        this.setRequiredFeatures(this.verify(string));
        this.setPrefix(this.verify(string2));
    }

    public BPort(BPortTypeEnum bPortTypeEnum, String string, String string2, BHwScanStatusEnum bHwScanStatusEnum) {
        this.setPortType(bPortTypeEnum);
        this.setRequiredFeatures(this.verify(string));
        this.setPrefix(this.verify(string2));
        this.setStatus(bHwScanStatusEnum);
    }

    static {
        Class clazz = class$com$tridium$platHwScan$ports$BPort;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScan$ports$BPort = BPort.class("[Lcom.tridium.platHwScan.ports.BPort;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

