/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.pciCards.BPciCard;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHardwareScanService
extends BPlatformService {
    public static final Property baseBoardType = BHardwareScanService.newProperty((int)3, (BValue)new BBaseBoard(), null);
    public static final Action scan = BHardwareScanService.newAction((int)4, null);
    public static final Action simulateQnxCodes = BHardwareScanService.newAction((int)4, (BValue)BString.make((String)"01 FF FF FF FF FF FF FF FF"), null);
    public static final Action simulateWindowsCode = BHardwareScanService.newAction((int)4, (BValue)BString.make((String)"JNXT"), null);
    public static final Type TYPE;
    private static final BIcon ICON;
    public static final Lexicon lex;
    public static final Log log;
    public static final BTypeSpec lonTypeSpec;
    public static final BTypeSpec serialPortSvcTypeSpec;
    public static final BTypeSpec tcpPlatformSvcTypeSpec;
    private Subscriber lonListener;
    private Subscriber lonNameChangeListener;
    private Subscriber serialPortServiceListener;
    private ServiceListener serviceListener;
    private String simulationString;
    private BOperatingSystemEnum operatingSystem;
    static /* synthetic */ Class class$com$tridium$platHwScan$BHardwareScanService;

    public BBaseBoard getBaseBoardType() {
        return (BBaseBoard)this.get(baseBoardType);
    }

    public void setBaseBoardType(BBaseBoard bBaseBoard) {
        this.set(baseBoardType, (BValue)bBaseBoard, null);
    }

    public void scan() {
        this.invoke(scan, null, null);
    }

    public void simulateQnxCodes(BString bString) {
        this.invoke(simulateQnxCodes, (BValue)bString, null);
    }

    public void simulateWindowsCode(BString bString) {
        this.invoke(simulateWindowsCode, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        BComponent[] bComponentArray;
        super.serviceStarted();
        this.doScan();
        Nre.serviceManager.addServiceListener(this.serviceListener);
        try {
            bComponentArray = (BComponent[])Sys.getService((Type)serialPortSvcTypeSpec.getResolvedType());
            bComponentArray.checkPropertiesLoaded();
            this.serialPortServiceListener.subscribe((BComponent)bComponentArray, 2);
        }
        catch (Exception exception) {
            log.error(lex.getText("HardwareScanService.serialPortPlatformServiceNotFound"));
        }
        try {
            bComponentArray = Sys.getServices((Type)lonTypeSpec.getResolvedType());
            int n = 0;
            while (n < bComponentArray.length) {
                this.lonListener.subscribe(bComponentArray[n]);
                this.lonNameChangeListener.subscribe((BComponent)bComponentArray[n].getParent());
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void doPoll(Context context) {
        super.doPoll(context);
        this.init();
    }

    public int getSlotFlags() {
        return 0;
    }

    public boolean isValidPlatform() {
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.windows)) {
            return Nre.getHostModel().toUpperCase().startsWith("JNX");
        }
        return BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx);
    }

    public void scanHardware(boolean bl) {
        this.removeAll();
        switch (this.operatingSystem.getOrdinal()) {
            case 1: {
                this.scanQnxPlatform(bl);
                break;
            }
            case 0: {
                this.scanWindowsPlatform(bl);
                break;
            }
            default: {
                log.warning(lex.getText("HardwareScanService.operatingSystemNotSupported", new Object[]{BOperatingSystemEnum.getOS().getTag().toUpperCase(), this.getName()}));
            }
        }
    }

    public void doScan() {
        this.init();
        this.scanHardware(false);
    }

    public void doSimulateQnxCodes(BString bString) {
        this.doSimulation(bString, BOperatingSystemEnum.qnx);
    }

    public void doSimulateWindowsCode(BString bString) {
        this.doSimulation(bString, BOperatingSystemEnum.windows);
    }

    private final void doSimulation(BString bString, BOperatingSystemEnum bOperatingSystemEnum) {
        this.simulationString = bString.getString();
        this.operatingSystem = bOperatingSystemEnum;
        this.scanHardware(true);
    }

    protected BPort filterPortsByName(BPort[] bPortArray, String string) {
        BPort bPort = null;
        int n = 0;
        while (n < bPortArray.length) {
            bPort = bPortArray[n];
            if (bPort.getName().equalsIgnoreCase(string) && !bPort.getStatus().equals((Object)BHwScanStatusEnum.unavailable)) break;
            ++n;
        }
        return bPort;
    }

    public BPort[] getAllPorts() {
        BOrd bOrd = BOrd.make((BOrd)this.getOrdInSession(), (String)"bql:select parent.ordInSession, name from platHwScan:Port");
        return this.getPorts(bOrd);
    }

    public BPort getPort(String string) {
        return this.filterPortsByName(this.getAllPorts(), string);
    }

    public BPort[] getPorts(BPortTypeEnum bPortTypeEnum) {
        BOrd bOrd = BOrd.make((BOrd)this.getOrdInSession(), (String)("bql:select parent.ordInSession, name from platHwScan:Port where portType like '" + (Object)((Object)bPortTypeEnum) + '\''));
        return this.getPorts(bOrd);
    }

    private final BPort[] getPorts(BOrd bOrd) {
        this.lease(5);
        BITable bITable = (BITable)bOrd.get((BObject)this);
        int n = bITable.size();
        if (n == 0) {
            return new BPort[0];
        }
        BPort[] bPortArray = new BPort[n];
        int n2 = 0;
        ColumnList columnList = bITable.getColumns();
        TableCursor tableCursor = (TableCursor)bITable.cursor();
        while (tableCursor.next()) {
            BComplex bComplex = (BComplex)BOrd.make((String)tableCursor.getString(columnList.get(0))).get((BObject)this);
            bPortArray[n2] = (BPort)bComplex.get(tableCursor.getString(columnList.get(1)));
            ++n2;
        }
        return bPortArray;
    }

    private final String readOptCardCodes(boolean bl) throws Exception {
        if (bl) {
            return this.simulationString;
        }
        BIFile bIFile = (BIFile)BOrd.make((String)"file:/dev/shmem/optcardcodes").get();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
        return bufferedReader.readLine();
    }

    private final void scanQnxPlatform(boolean bl) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.readOptCardCodes(bl));
            String string = stringTokenizer.nextToken();
            BBaseBoard bBaseBoard = BBaseBoard.lookup(string);
            if (bBaseBoard == null) {
                this.addBasicPlatform(string);
                return;
            }
            try {
                BBaseBoard bBaseBoard2 = (BBaseBoard)bBaseBoard.newCopy(true);
                this.setBaseBoardType(bBaseBoard2);
                Array array = new Array();
                while (stringTokenizer.hasMoreTokens()) {
                    array.add((Object)stringTokenizer.nextToken().trim());
                }
                log.trace(lex.getText("HardwareScanService.optCodeArray", new Object[]{array}));
                bBaseBoard2.autoConfig(array, bl);
            }
            catch (Exception exception) {
                log.trace(exception.getMessage());
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
    }

    private final void scanWindowsPlatform(boolean bl) {
        BBaseBoard bBaseBoard;
        String string = Nre.getHostModel();
        if (bl) {
            string = this.simulationString;
        }
        if ((bBaseBoard = BBaseBoard.lookup(string)) == null) {
            this.addBasicPlatform(string);
            return;
        }
        BBaseBoard bBaseBoard2 = (BBaseBoard)bBaseBoard.newCopy(true);
        this.setBaseBoardType(bBaseBoard2);
        bBaseBoard2.autoConfig(null, bl);
    }

    private final void addBasicPlatform(String string) {
        Object object;
        if (!this.getBaseBoardType().getType().equals(BBaseBoard.TYPE)) {
            this.setBaseBoardType(new BBaseBoard());
        }
        if ((object = BBaseBoard.lookupModelJar(string)) != null) {
            this.getBaseBoardType().setProductModel(lex.getText("HardwareScanService.jarRequired", new Object[]{(String)object}));
        } else {
            this.getBaseBoardType().setProductModel(lex.getText("HardwareScanService.baseboardNotRecognized", new Object[]{string, this.getName()}));
        }
        log.warning(this.getBaseBoardType().getProductModel());
    }

    private final void init() {
        BOptionCard.buildCardCatalog();
        BPciCard.buildCardCatalog();
        this.operatingSystem = BOperatingSystemEnum.getOS();
    }

    public BIcon getIcon() {
        return ICON;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lonListener = new Subscriber(){

            public final void event(BComponentEvent bComponentEvent) {
                BComponent bComponent;
                BStruct bStruct;
                String string;
                BPort bPort;
                String string2 = bComponentEvent.getSlotName();
                if (string2.equals("lonCommConfig") || string2.equals("deviceChange")) {
                    BComponent bComponent2 = bComponentEvent.getSourceComponent();
                    if (((BBoolean)bComponent2.get("enabled")).getBoolean() && !((BStatus)bComponent2.get("status")).isFault()) {
                        String string3 = bComponent2.getName();
                        BStruct bStruct2 = (BStruct)bComponent2.get("lonCommConfig");
                        String string4 = ((BString)bStruct2.get("deviceName")).toString();
                        BPort[] bPortArray = BHardwareScanService.this.getAllPorts();
                        int n = 0;
                        while (n < bPortArray.length) {
                            BPort bPort2 = bPortArray[n];
                            if (bPort2.getName().equals(string4)) {
                                bPort2.updateOwnerAndStatus(string3);
                            } else if (bPort2.getOwner().equals(string3)) {
                                bPort2.updateOwnerAndStatus("none");
                            }
                            ++n;
                        }
                    }
                } else if (string2.equals("enabled") && (bPort = BHardwareScanService.this.getPort(string = ((BString)(bStruct = (BStruct)(bComponent = bComponentEvent.getSourceComponent()).get("lonCommConfig")).get("deviceName")).toString())) != null) {
                    if (((BBoolean)bComponentEvent.getValue()).getBoolean() && !((BStatus)bComponent.get("status")).isFault()) {
                        bPort.updateOwnerAndStatus(bComponent.getName());
                    } else {
                        bPort.updateOwnerAndStatus("none");
                    }
                }
            }
        };
        this.lonNameChangeListener = new Subscriber(){

            public final void event(BComponentEvent bComponentEvent) {
                BComponent bComponent;
                if (bComponentEvent.getId() == 3 && bComponentEvent.getSlot().asProperty().getType().getTypeSpec().equals((Object)lonTypeSpec) && ((BBoolean)(bComponent = (BComponent)bComponentEvent.getSourceComponent().get(bComponentEvent.getSlotName())).get("enabled")).getBoolean() && !((BStatus)bComponent.get("status")).isFault()) {
                    bComponent.lease(2);
                    BStruct bStruct = (BStruct)bComponent.get("lonCommConfig");
                    BPort bPort = BHardwareScanService.this.getPort(((BString)bStruct.get("deviceName")).getString());
                    if (bPort != null) {
                        bPort.updateOwnerAndStatus(bComponent.getName());
                    }
                }
            }
        };
        this.serialPortServiceListener = new Subscriber(){

            public final void event(BComponentEvent bComponentEvent) {
                if (bComponentEvent.getId() == 1 && bComponentEvent.getSlotName().startsWith("COM")) {
                    this.subscribe((BComponent)bComponentEvent.getSourceComponent().get(bComponentEvent.getSlotName()));
                } else if (bComponentEvent.getId() == 0 && bComponentEvent.getSlotName().equals("owner")) {
                    BHardwareScanService.this.getPort(bComponentEvent.getSourceComponent().getName()).updateOwnerAndStatus(((BString)bComponentEvent.getValue()).getString());
                }
            }
        };
        this.serviceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void serviceEvent(BServiceEvent bServiceEvent) {
                block6: {
                    if (bServiceEvent.getServiceType().getTypeSpec().equals((Object)lonTypeSpec)) {
                        ServiceListener serviceListener = BHardwareScanService.this.serviceListener;
                        synchronized (serviceListener) {
                            BComponent bComponent;
                            block5: {
                                bComponent = (BComponent)bServiceEvent.getService();
                                if (bServiceEvent.getId() != 0) break block5;
                                BHardwareScanService.this.lonListener.subscribe(bComponent);
                                BHardwareScanService.this.lonNameChangeListener.subscribe((BComponent)bComponent.getParent());
                                break block6;
                            }
                            if (bServiceEvent.getId() == 1) {
                                BStruct bStruct = (BStruct)bComponent.get("lonCommConfig");
                                String string = ((BString)bStruct.get("deviceName")).toString();
                                BHardwareScanService.this.getPort(string).updateOwnerAndStatus("none");
                                BHardwareScanService.this.lonListener.unsubscribe(bComponent);
                            }
                        }
                    }
                }
            }
        };
    }

    public BHardwareScanService() {
        this.this();
        this.setPlatformServiceDescription(lex.getText("HardwareScanService.description"));
    }

    static {
        Class clazz = class$com$tridium$platHwScan$BHardwareScanService;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScan$BHardwareScanService = BHardwareScanService.class("[Lcom.tridium.platHwScan.BHardwareScanService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ICON = BIcon.std((String)"glasses.png");
        Class clazz2 = class$com$tridium$platHwScan$BHardwareScanService;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platHwScan$BHardwareScanService = BHardwareScanService.class("[Lcom.tridium.platHwScan.BHardwareScanService;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        log = Log.getLog((String)"platHwScan");
        lonTypeSpec = BTypeSpec.make((String)"lonworks:LonNetwork");
        serialPortSvcTypeSpec = BTypeSpec.make((String)"platSerial:SerialPortPlatformService");
        tcpPlatformSvcTypeSpec = BTypeSpec.make((String)"platform:TcpIpPlatformService");
    }
}

