/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.sys.Nre;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBaseBoard
extends BComponent {
    public static final Property productModel = BBaseBoard.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    private static Hashtable boardTypes;
    private static Hashtable platJars;
    private static String[] jarFiles;
    protected static final int FLAGS = 3;
    protected Array configParms;
    protected boolean simulation;
    protected int nextLanPort;
    protected int nextLonPort;
    protected int nextSerialPort;
    static /* synthetic */ Class class$com$tridium$platHwScan$BBaseBoard;

    public String getProductModel() {
        return this.getString(productModel);
    }

    public void setProductModel(String string) {
        this.setString(productModel, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array array, boolean bl) {
        this.simulation = bl;
        this.setProductModel(BHardwareScanService.lex.getText(Nre.getHostModel()));
    }

    public String getBoardCode() {
        return null;
    }

    public Vector getHardwareRefs() {
        return new Vector();
    }

    public String getView(BObject bObject) {
        return BHardwareScanService.lex.getText("pxView");
    }

    public String getImagesDirectory() {
        return null;
    }

    public static BBaseBoard lookup(String string) {
        Object v;
        if (boardTypes.isEmpty()) {
            BBaseBoard.queryRegistry();
        }
        if ((v = boardTypes.get(string.toUpperCase())) == null) {
            return null;
        }
        return (BBaseBoard)((Object)v);
    }

    private static final void queryRegistry() {
        boardTypes = new Hashtable();
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
        int n = 0;
        while (n < typeInfoArray.length) {
            BBaseBoard bBaseBoard = (BBaseBoard)typeInfoArray[n].getInstance();
            try {
                String string = bBaseBoard.getBoardCode();
                if (string != null) {
                    boardTypes.put(string.toUpperCase(), bBaseBoard);
                }
            }
            catch (Exception exception) {
                BHardwareScanService.log.error(BHardwareScanService.lex.getText("BaseBoard.registrationError", new Object[]{bBaseBoard}));
            }
            ++n;
        }
    }

    public static Object lookupModelJar(String string) {
        if (platJars.isEmpty()) {
            int n = 0;
            while (n < jarFiles.length) {
                try {
                    Hashtable hashtable = BBaseBoard.parsePlatformJarsFile(jarFiles[n]);
                    if (hashtable != null) {
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            String string2 = ((String)enumeration.nextElement()).toUpperCase();
                            if (platJars.get(string2) != null) {
                                BHardwareScanService.log.warning(BHardwareScanService.lex.getText("BaseBoard.duplicatePlatformCode", new Object[]{string2, jarFiles[n]}));
                            }
                            platJars.put(string2, hashtable.get(string2));
                        }
                    }
                }
                catch (Exception exception) {
                    BHardwareScanService.log.error(BHardwareScanService.lex.getText("parsingError", new Object[]{exception.getClass().getName(), jarFiles[n]}));
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        return platJars.get(string.toUpperCase());
    }

    private static final Hashtable parsePlatformJarsFile(String string) throws Exception {
        XElem xElem;
        XElem[] xElemArray;
        Object object;
        BHardwareScanService.log.trace(BHardwareScanService.lex.getText("parsingNotification", new Object[]{string}));
        try {
            object = BOrd.make((String)string);
            xElemArray = (XElem[])object.get();
            xElem = XParser.make((InputStream)xElemArray.getInputStream()).parse();
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedException) {
                BHardwareScanService.log.trace(BHardwareScanService.lex.getText("fileDoesNotExist", new Object[]{string}));
                return null;
            }
            if (exception instanceof EOFException) {
                BHardwareScanService.log.error(BHardwareScanService.lex.getText("unexpectedEof", new Object[]{string}));
                return null;
            }
            throw exception;
        }
        if (!xElem.name().equalsIgnoreCase("hwScanPlatformJars")) {
            BHardwareScanService.log.error(BHardwareScanService.lex.getText("fileFormatError", new Object[]{string, xElem.name(), "hwScanPlatformJars"}));
            return null;
        }
        object = new Hashtable();
        xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem2 = xElemArray[n];
            String string2 = xElem2.name();
            if (string2.equalsIgnoreCase("platform")) {
                try {
                    ((Hashtable)object).put(xElem2.get("code").toUpperCase(), xElem2.get("module"));
                }
                catch (Exception exception) {
                    BHardwareScanService.log.error(BHardwareScanService.lex.getText("parsingError", new Object[]{xElem2.toString()}));
                }
            }
            ++n;
        }
        return object;
    }

    protected String buildPortRefDescription(BPort bPort) {
        StringBuffer stringBuffer = new StringBuffer(bPort.getName());
        if (!bPort.getHasConnector()) {
            stringBuffer.append(" ").append(BHardwareScanService.lex.getText("HardwareRef.noConnector"));
        }
        return stringBuffer.toString();
    }

    protected String getBaseUnitText() {
        return BHardwareScanService.lex.getText("HardwareRef.baseUnit");
    }

    public boolean isSerialShellJumperPresent() {
        try {
            BComplex bComplex = this.getParent();
            while (!(bComplex instanceof BPlatformServiceContainer)) {
                bComplex = bComplex.getParent();
            }
            BPlatformServiceContainer bPlatformServiceContainer = (BPlatformServiceContainer)bComplex;
            bPlatformServiceContainer.lease();
            BPlatformService[] bPlatformServiceArray = (BPlatformService[])bPlatformServiceContainer.getChildren(BHardwareScanService.serialPortSvcTypeSpec.getResolvedType().getTypeClass());
            bPlatformServiceArray[0].checkPropertiesLoaded();
            bPlatformServiceArray[0].lease(2);
            BComponent bComponent = (BComponent)bPlatformServiceArray[0].get("COM1");
            return ((BString)bComponent.get("owner")).getString().trim().equalsIgnoreCase("dbgjmpr");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    protected BHardwareRef makeBaseboardCommRef(int n, BPort bPort) {
        return new BHardwareRef(n, this.getBaseUnitText(), this.buildPortRefDescription(bPort), bPort.getPortType(), bPort.getStatus());
    }

    protected BHardwareRef makeJumperRef(int n) {
        return new BHardwareRef(n, this.getBaseUnitText(), BHardwareScanService.lex.getText("HardwareRef.serialShellJumper"), BPortTypeEnum.noPort, this.isSerialShellJumperPresent() ? BHwScanStatusEnum.serialShell : BHwScanStatusEnum.normalOperation);
    }

    protected String makePortName(int n, String string) {
        int n2 = n;
        if (string.startsWith("COM")) {
            n2 = this.nextSerialPort++;
        } else if (string.startsWith("LON")) {
            n2 = this.nextLonPort++;
        } else if (string.startsWith("LAN")) {
            n2 = this.nextLanPort++;
        }
        return string + n2;
    }

    protected BHardwareRef makePortRef(int n, int n2, BPort bPort) {
        return this.makePortRef(String.valueOf(n), n2, bPort);
    }

    protected BHardwareRef makePortRef(String string, int n, BPort bPort) {
        String string2 = this.getBaseUnitText();
        BComplex bComplex = bPort.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BOptionSlot) {
                string2 = bComplex.getDisplayName(null);
                break;
            }
            bComplex = bComplex.getParent();
        }
        return new BHardwareRef(string + '-' + n, string2, this.buildPortRefDescription(bPort), bPort.getPortType(), bPort.getStatus());
    }

    protected BHardwareRef makeSlotRef(int n, BOptionSlot bOptionSlot) {
        BHardwareRef bHardwareRef = new BHardwareRef();
        bHardwareRef.setReference(String.valueOf(n));
        bHardwareRef.setLocation(bOptionSlot.getDisplayName(null));
        if (bOptionSlot.isEmpty()) {
            bHardwareRef.setDescription(BHardwareScanService.lex.getText(BHwScanStatusEnum.empty.getTag()));
        } else {
            bHardwareRef.setDescription(((BOptionCard)bOptionSlot.getContents()).getDescription());
        }
        return bHardwareRef;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.configParms = null;
        this.simulation = false;
    }

    public BBaseBoard() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platHwScan$BBaseBoard;
        if (clazz == null) {
            clazz = class$com$tridium$platHwScan$BBaseBoard = BBaseBoard.class("[Lcom.tridium.platHwScan.BBaseBoard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        boardTypes = new Hashtable();
        platJars = new Hashtable();
        jarFiles = new String[]{"module://platHwScan/rc/platHwScanPlatformJars.xml", "file:!lib/platHwScanPlatformJars.xml"};
    }
}

