/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.test;

import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.config.BDataRecoveryConfig;
import java.io.DataOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.DataRecoveryInvalidKeyException;
import javax.baja.io.BIEncodable;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDataRecoveryPerformanceAnalyzer
extends BAbstractService
implements BIDataRecoveryService {
    public static final Property persistentStorageSize = BDataRecoveryPerformanceAnalyzer.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String[])new String[]{"units", "min", "max"}, (BIDataValue[])new BIDataValue[]{BUnit.make((String)"kilobyte", (String)"KB", (BDimension)BDimension.NULL, (double)1024.0), BDouble.make((double)0.0), BDouble.POSITIVE_INFINITY}));
    public static final Property dataRecoveryConfiguration = BDataRecoveryPerformanceAnalyzer.newProperty((int)1, (BValue)new BDataRecoveryConfig(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final Log log;
    private final Object applicationMonitor;
    private HashMap knownApplications;
    private int externalApplicationsEncountered;
    private final Object bufferUtilMonitor;
    private final ByteBuffer bufferUtil;
    Object receivedMonitor;
    Object flushedMonitor;
    long totalBytesReceivedSinceStart;
    long totalBytesFlushedSinceStart;
    long serviceStartTimeMilliseconds;
    double averageBytesFlushedPerSecondSinceStart;
    double averageBytesReceivedPerSecondSinceStart;
    long numberOfRecordsReceivedSinceStart;
    double averageRecordSize;
    static /* synthetic */ Class class$com$tridium$platDataRecovery$test$BDataRecoveryPerformanceAnalyzer;

    public double getPersistentStorageSize() {
        return this.getDouble(persistentStorageSize);
    }

    public void setPersistentStorageSize(double d) {
        this.setDouble(persistentStorageSize, d, null);
    }

    public BDataRecoveryConfig getDataRecoveryConfiguration() {
        return (BDataRecoveryConfig)this.get(dataRecoveryConfiguration);
    }

    public void setDataRecoveryConfiguration(BDataRecoveryConfig bDataRecoveryConfig) {
        this.set(dataRecoveryConfiguration, (BValue)bDataRecoveryConfig, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isEnabled() {
        return true;
    }

    public final boolean append(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray) throws BajaRuntimeException {
        return this.append(bIDataRecoverySource, bIEncodable, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean append(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray, int n, int n2) throws BajaRuntimeException {
        Object object;
        byte[] byArray2;
        byte[] byArray3;
        block25: {
            byte by;
            BOrd bOrd;
            if (bIDataRecoverySource == null) {
                throw new NullPointerException("Provided source can not be null");
            }
            if (bIEncodable == null) {
                throw new DataRecoveryInvalidKeyException("Provided key can not be null");
            }
            if (byArray == null) {
                throw new NullPointerException("Provided data can not be null");
            }
            if (n < 0) {
                throw new DataRecoveryException("Invalid data offset, offset < 0");
            }
            if (n >= byArray.length && byArray.length != 0) {
                throw new DataRecoveryException("Invalid data offset, offset >= non-zero data.length");
            }
            if (n2 < 0) {
                throw new DataRecoveryException("Invalid data length, length < 0");
            }
            if (n2 > byArray.length - n) {
                n2 = byArray.length - n;
            }
            byArray3 = null;
            byArray2 = null;
            object = this.bufferUtilMonitor;
            synchronized (object) {
                try {
                    this.bufferUtil.reset();
                    bIEncodable.encode((DataOutput)this.bufferUtil);
                    byArray3 = this.bufferUtil.toByteArray();
                    this.bufferUtil.reset();
                    this.bufferUtil.write(byArray, n, n2);
                    byArray2 = this.bufferUtil.toByteArray();
                }
                catch (Exception exception) {
                    return false;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl32 : MonitorExitStatement: MONITOREXIT : var8_8
                bOrd = null;
                by = 0;
            }
            try {
                bOrd = bIDataRecoverySource.getOrdInSession();
            }
            catch (Exception exception) {
                log.error("Could not obtain source ord: ", (Throwable)exception);
                return false;
            }
            object = this.applicationMonitor;
            synchronized (object) {
                ApplicationEntry applicationEntry;
                block24: {
                    applicationEntry = (ApplicationEntry)this.knownApplications.get(bOrd);
                    if (applicationEntry != null) break block24;
                    if (log.isTraceOn()) {
                        log.trace("Encountered new data recovery source: " + bOrd);
                    }
                    ++this.externalApplicationsEncountered;
                    if (this.externalApplicationsEncountered != (byte)this.externalApplicationsEncountered) {
                        throw new DataRecoveryException("Data recovery Service can not respond to request from source: " + bOrd + ", byte overflow detected.");
                    }
                    by = (byte)this.externalApplicationsEncountered;
                    this.knownApplications.put(bOrd, new ApplicationEntry(bOrd.encodeToString(), by, byArray2.length + byArray3.length));
                    break block25;
                }
                applicationEntry.updateMetrics(byArray2.length + byArray3.length);
            }
        }
        object = this.receivedMonitor;
        synchronized (object) {
            ++this.numberOfRecordsReceivedSinceStart;
            this.totalBytesReceivedSinceStart += (long)(byArray2.length + byArray3.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize);
            this.averageBytesReceivedPerSecondSinceStart = (double)this.totalBytesReceivedSinceStart / (double)(System.currentTimeMillis() - this.serviceStartTimeMilliseconds) * 1000.0;
            this.averageRecordSize = (double)this.totalBytesReceivedSinceStart / (double)this.numberOfRecordsReceivedSinceStart;
            return true;
        }
    }

    public boolean update(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray) throws BajaRuntimeException {
        return this.update(bIDataRecoverySource, bIEncodable, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean update(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray, int n, int n2) throws BajaRuntimeException {
        Object object;
        byte[] byArray2;
        byte[] byArray3;
        block25: {
            byte by;
            BOrd bOrd;
            if (bIDataRecoverySource == null) {
                throw new NullPointerException("Provided source can not be null");
            }
            if (bIEncodable == null) {
                throw new DataRecoveryInvalidKeyException("Provided key can not be null");
            }
            if (byArray == null) {
                throw new NullPointerException("Provided data can not be null");
            }
            if (n < 0) {
                throw new DataRecoveryException("Invalid data offset, offset < 0");
            }
            if (n >= byArray.length && byArray.length != 0) {
                throw new DataRecoveryException("Invalid data offset, offset >= non-zero data.length");
            }
            if (n2 < 0) {
                throw new DataRecoveryException("Invalid data length, length < 0");
            }
            if (n2 > byArray.length - n) {
                n2 = byArray.length - n;
            }
            byArray3 = null;
            byArray2 = null;
            object = this.bufferUtilMonitor;
            synchronized (object) {
                try {
                    this.bufferUtil.reset();
                    bIEncodable.encode((DataOutput)this.bufferUtil);
                    byArray3 = this.bufferUtil.toByteArray();
                    this.bufferUtil.reset();
                    this.bufferUtil.write(byArray, n, n2);
                    byArray2 = this.bufferUtil.toByteArray();
                }
                catch (Exception exception) {
                    return false;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl32 : MonitorExitStatement: MONITOREXIT : var8_8
                bOrd = null;
                by = 0;
            }
            try {
                bOrd = bIDataRecoverySource.getOrdInSession();
            }
            catch (Exception exception) {
                log.error("Could not obtain source ord: ", (Throwable)exception);
                return false;
            }
            object = this.applicationMonitor;
            synchronized (object) {
                ApplicationEntry applicationEntry;
                block24: {
                    applicationEntry = (ApplicationEntry)this.knownApplications.get(bOrd);
                    if (applicationEntry != null) break block24;
                    if (log.isTraceOn()) {
                        log.trace("Encountered new data recovery source: " + bOrd);
                    }
                    ++this.externalApplicationsEncountered;
                    if (this.externalApplicationsEncountered != (byte)this.externalApplicationsEncountered) {
                        throw new DataRecoveryException("Data recovery Service can not respond to request from source: " + bOrd + ", byte overflow detected.");
                    }
                    by = (byte)this.externalApplicationsEncountered;
                    this.knownApplications.put(bOrd, new ApplicationEntry(bOrd.encodeToString(), by, byArray2.length + byArray3.length));
                    break block25;
                }
                applicationEntry.updateMetrics(byArray2.length + byArray3.length);
            }
        }
        object = this.receivedMonitor;
        synchronized (object) {
            ++this.numberOfRecordsReceivedSinceStart;
            this.totalBytesReceivedSinceStart += (long)(byArray2.length + byArray3.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize);
            this.averageBytesReceivedPerSecondSinceStart = (double)this.totalBytesReceivedSinceStart / (double)(System.currentTimeMillis() - this.serviceStartTimeMilliseconds) * 1000.0;
            this.averageRecordSize = (double)this.totalBytesReceivedSinceStart / (double)this.numberOfRecordsReceivedSinceStart;
            return true;
        }
    }

    public final boolean hasRecoveryData() throws BajaRuntimeException {
        return false;
    }

    public final void saveFailed(Throwable throwable) {
    }

    public final void saveFinished() throws BajaRuntimeException {
    }

    public final void saveStarted() throws BajaRuntimeException {
    }

    public final void shutdownStarted() {
    }

    public String checkForStationFault() {
        return null;
    }

    public final Type[] getServiceTypes() {
        return new Type[]{BIDataRecoveryService.TYPE, TYPE};
    }

    public final void serviceStarted() {
        this.serviceStartTimeMilliseconds = System.currentTimeMillis();
        this.knownApplications = new HashMap();
    }

    public final BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        block4: {
            super.spy(spyWriter);
            spyWriter.startProps("Data recovery Performance Metrics");
            spyWriter.prop((Object)"Seconds Since Service Started", (Object)new Long((System.currentTimeMillis() - this.serviceStartTimeMilliseconds) / 1000L));
            spyWriter.prop((Object)"Total Number Of Records Received", (Object)new Long(this.numberOfRecordsReceivedSinceStart));
            spyWriter.prop((Object)"Average Size of Record Received", (Object)new Double(this.averageRecordSize));
            spyWriter.prop((Object)"Total Bytes Received Since Start", (Object)new Long(this.totalBytesReceivedSinceStart));
            spyWriter.prop((Object)"Average Bytes Received/Second", (Object)new Double(this.averageBytesReceivedPerSecondSinceStart));
            spyWriter.prop((Object)"Total Bytes Flushed Since Start", (Object)new Long(this.totalBytesFlushedSinceStart));
            spyWriter.prop((Object)"Average Bytes Flushed/Second", (Object)new Double(this.averageBytesFlushedPerSecondSinceStart));
            spyWriter.endProps();
            spyWriter.startProps("Data recovery Sources");
            Object object = this.applicationMonitor;
            synchronized (object) {
                if (this.knownApplications == null) break block4;
                Collection collection = this.knownApplications.values();
                ApplicationEntry applicationEntry = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    applicationEntry = (ApplicationEntry)iterator.next();
                    if (applicationEntry.getEncodedOrd().equals(this.getOrdInSession().encodeToString())) continue;
                    spyWriter.prop((Object)"Source Ord", (Object)applicationEntry.getEncodedOrd());
                    spyWriter.prop((Object)"Source Type", (Object)BOrd.make((String)applicationEntry.getEncodedOrd()).resolve().get().getType());
                    spyWriter.prop((Object)"Source Byte", (int)applicationEntry.getId());
                    spyWriter.prop((Object)"Records Generated", applicationEntry.getRecordsGenerated());
                    spyWriter.prop((Object)"Data Generated", (Object)new Long(applicationEntry.getDataGenerated()));
                    spyWriter.prop((Object)"Average Record Size", (Object)new Double(applicationEntry.getAverageRecordSize()));
                    spyWriter.prop((Object)"", (Object)"");
                }
            }
        }
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.applicationMonitor = new Object();
        this.knownApplications = null;
        this.externalApplicationsEncountered = 0;
        this.bufferUtilMonitor = new Object();
        this.bufferUtil = new ByteBuffer();
        this.receivedMonitor = new Object();
        this.flushedMonitor = new Object();
        this.totalBytesReceivedSinceStart = 0L;
        this.totalBytesFlushedSinceStart = 0L;
        this.serviceStartTimeMilliseconds = 0L;
        this.averageBytesFlushedPerSecondSinceStart = 0.0;
        this.averageBytesReceivedPerSecondSinceStart = 0.0;
        this.numberOfRecordsReceivedSinceStart = 0L;
        this.averageRecordSize = 0.0;
    }

    public BDataRecoveryPerformanceAnalyzer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platDataRecovery$test$BDataRecoveryPerformanceAnalyzer;
        if (clazz == null) {
            clazz = class$com$tridium$platDataRecovery$test$BDataRecoveryPerformanceAnalyzer = BDataRecoveryPerformanceAnalyzer.class("[Lcom.tridium.platDataRecovery.test.BDataRecoveryPerformanceAnalyzer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"save.png"), (BIcon)BIcon.std((String)"badges/warning.png"));
        log = Log.getLog((String)"platDataRecovery.analyzer");
    }

    private static final class ApplicationEntry {
        private String encodedOrd;
        private byte id;
        private int recordsSinceStart;
        private long dataGenerated;

        public final String getEncodedOrd() {
            return this.encodedOrd;
        }

        public final byte getId() {
            return this.id;
        }

        public final void updateMetrics(int n) {
            ++this.recordsSinceStart;
            this.dataGenerated += (long)(n + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize);
        }

        public final double getAverageRecordSize() {
            return (double)this.dataGenerated / (double)this.recordsSinceStart;
        }

        public final long getDataGenerated() {
            return this.dataGenerated;
        }

        public final int getRecordsGenerated() {
            return this.recordsSinceStart;
        }

        public ApplicationEntry(String string, byte by, long l) {
            this.encodedOrd = string;
            this.id = by;
            this.dataGenerated = l;
            this.recordsSinceStart = 1;
        }
    }
}

