/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.baja.log.Log;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataRecoveryWriteQueue {
    private static final Log log = Log.getLog((String)"platDataRecovery.queue");
    private RandomAccessFile dataRecoveryFile;
    private Queue dataRecoveryBlocksToWrite;

    public final void add(DataRecoveryBlock dataRecoveryBlock, long l) {
        this.dataRecoveryBlocksToWrite.enqueue((Object)new DataRecoveryJob(dataRecoveryBlock, l));
    }

    public final boolean areWritesPending() {
        return this.dataRecoveryBlocksToWrite.isEmpty() ^ true;
    }

    public final void clear() {
        this.dataRecoveryBlocksToWrite.clear();
    }

    public final boolean commit() throws Exception {
        DataRecoveryJob dataRecoveryJob = null;
        int n = 0;
        boolean bl = log.isTraceOn();
        String string = null;
        if (bl) {
            log.trace("Commiting " + this.dataRecoveryBlocksToWrite.size() + " writes to data recovery file");
        }
        while ((dataRecoveryJob = (DataRecoveryJob)this.dataRecoveryBlocksToWrite.dequeue()) != null) {
            if (bl) {
                switch (dataRecoveryJob.block.getBlockState()) {
                    case 0: {
                        string = "Free Block";
                        break;
                    }
                    case 2: {
                        string = "Pending Block";
                        break;
                    }
                    case 1: {
                        string = "Used Block";
                        break;
                    }
                }
            }
            if (bl) {
                log.trace("Starting write for job " + n + ": " + string + ", currently at location " + this.dataRecoveryFile.getFilePointer());
            }
            int n2 = 0;
            IOException iOException = null;
            while (n2 < 2) {
                try {
                    if (dataRecoveryJob.blockOffset != (long)-1) {
                        this.dataRecoveryFile.seek(dataRecoveryJob.blockOffset);
                    }
                    dataRecoveryJob.block.write(this.dataRecoveryFile);
                    iOException = null;
                    break;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    if (dataRecoveryJob.blockOffset == (long)-1 || !this.dataRecoveryFile.getFD().valid()) break;
                    if (bl) {
                        log.trace("IOException \"" + iOException2.getMessage() + "\" occured while writing job " + n + ": " + string + ", retrying");
                    }
                    ++n2;
                }
            }
            if (iOException != null) {
                log.error("Error writing persistent job for: " + dataRecoveryJob.block.getBlockState());
                throw iOException;
            }
            this.dataRecoveryFile.getFD().sync();
            if (bl) {
                log.trace("Finished write for job " + n + ": " + string + ", currently at location " + this.dataRecoveryFile.getFilePointer());
            }
            ++n;
        }
        if (bl) {
            log.trace("Finished commiting data recovery file modification");
        }
        return true;
    }

    private final /* synthetic */ void this() {
        this.dataRecoveryFile = null;
        this.dataRecoveryBlocksToWrite = null;
    }

    public DataRecoveryWriteQueue(RandomAccessFile randomAccessFile) {
        this.this();
        this.dataRecoveryFile = randomAccessFile;
        this.dataRecoveryBlocksToWrite = new Queue();
    }

    private static final class DataRecoveryJob {
        long blockOffset;
        DataRecoveryBlock block;

        public DataRecoveryJob(DataRecoveryBlock dataRecoveryBlock, long l) {
            this.block = dataRecoveryBlock;
            this.blockOffset = l;
        }
    }
}

