/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.block.FreeDataRecoveryBlock;
import com.tridium.platDataRecovery.block.PendingDataRecoveryBlock;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInvalidException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DataRecoveryBlock
implements Comparable {
    public static final byte MAGIC_START_BYTE = -2;
    public static final byte MAGIC_END_BYTE = -17;
    private static final ByteBuffer bufferUtil = new ByteBuffer();
    private static final Object bufferMonitor = new Object();
    private static boolean debug = false;
    public static long maxReadSize = 0L;
    public static int freeBlockHeaderSize = 0;
    public static int fixedFieldsOfUsedBlockHeaderSize = 0;
    public static final byte BLOCK_STATE_FREE = 0;
    public static final byte BLOCK_STATE_USED = 1;
    public static final byte BLOCK_STATE_PENDING = 2;
    protected byte sourceSpace;
    protected int keyInSourceSpaceSize;
    protected byte[] keyInSourceSpace;
    protected int payloadSize;
    protected byte[] payload;
    private byte[] serializedForm;

    public final int getTotalSize() {
        return this.getPayloadSize() + this.getHeaderSize();
    }

    protected final int getHeaderSize() {
        if (this.getBlockState() == 0) {
            return freeBlockHeaderSize;
        }
        return fixedFieldsOfUsedBlockHeaderSize + this.getKeyInSourceSpaceSize();
    }

    protected final int getPayloadSize() {
        return this.payloadSize;
    }

    protected final int getKeyInSourceSpaceSize() {
        if (this.getBlockState() == 0) {
            Thread.dumpStack();
            throw new BajaRuntimeException("Free data recovery block does not have key size");
        }
        return this.keyInSourceSpaceSize;
    }

    public final int getOverheadSpace() {
        if (this.getBlockState() == 0) {
            return 0;
        }
        return fixedFieldsOfUsedBlockHeaderSize;
    }

    public final int getUsedSpace() {
        if (this.getBlockState() == 0) {
            return 0;
        }
        return this.getKeyInSourceSpaceSize() + this.getPayloadSize();
    }

    public final int getFreeSpace() {
        if (this.getBlockState() == 0) {
            return this.getTotalSize();
        }
        return 0;
    }

    public final byte getSpaceIdentifier() {
        if (this.getBlockState() == 0) {
            Thread.dumpStack();
            throw new BajaRuntimeException("Free data recovery block does not have source identifier");
        }
        return this.sourceSpace;
    }

    public final byte[] getKeyInSourceSpaceCopy() {
        if (this.getBlockState() == 0) {
            Thread.dumpStack();
            throw new BajaRuntimeException("Free data recovery block does not have key");
        }
        byte[] byArray = new byte[this.keyInSourceSpace.length];
        System.arraycopy(this.keyInSourceSpace, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public final byte[] getPayloadCopy() {
        if (this.getBlockState() == 0) {
            Thread.dumpStack();
            throw new BajaRuntimeException("Free data recovery block does not have payload");
        }
        byte[] byArray = new byte[this.payload.length];
        System.arraycopy(this.payload, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public abstract byte getBlockState();

    public abstract DataRecoveryBlock coalesce(DataRecoveryBlock var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(DataOutput dataOutput) throws Exception {
        long l;
        block9: {
            l = 0L;
            if (debug) {
                l = Clock.ticks();
            }
            if (this.serializedForm == null) {
                Object object = bufferMonitor;
                synchronized (object) {
                    block11: {
                        block10: {
                            if (this.serializedForm != null) break block9;
                            bufferUtil.reset();
                            bufferUtil.writeByte(-2);
                            bufferUtil.writeByte((int)this.getBlockState());
                            if (this.getBlockState() != 1) break block10;
                            bufferUtil.writeByte((int)this.sourceSpace);
                            bufferUtil.writeInt(this.keyInSourceSpaceSize);
                            bufferUtil.write(this.keyInSourceSpace, 0, this.keyInSourceSpaceSize);
                            bufferUtil.writeInt(this.payloadSize);
                            bufferUtil.write(this.payload, 0, this.payloadSize);
                            bufferUtil.writeByte(-17);
                            break block11;
                        }
                        if (this.getBlockState() == 0) {
                            bufferUtil.writeInt(this.payloadSize);
                        }
                    }
                    this.serializedForm = bufferUtil.toByteArray();
                }
            }
        }
        try {
            dataOutput.write(this.serializedForm);
        }
        catch (IOException iOException) {
            throw new IOException("IOException occurred while writing data recovery: " + iOException.getMessage());
        }
        if (debug && l != 0L) {
            System.out.println("DataRecoveryBlock::write() took: " + (Clock.ticks() - l) + " ms");
        }
    }

    public static final DataRecoveryBlock read(DataInput dataInput) throws Exception {
        long l = 0L;
        if (debug) {
            l = Clock.ticks();
        }
        byte by = 0;
        int n = 0;
        byte[] byArray = null;
        int n2 = 0;
        byte by2 = 0;
        DataRecoveryBlock dataRecoveryBlock = null;
        if (dataInput instanceof RandomAccessFile) {
            RandomAccessFile randomAccessFile;
            byte by3;
            if (debug) {
                System.out.println("DataRecoveryBlock::read() reading RandomAccessFile");
            }
            if ((by3 = (byte)(randomAccessFile = (RandomAccessFile)dataInput).readUnsignedByte()) != -2) {
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() read non-magic starting byte: " + by3);
                }
                DataRecoveryBlockInvalidException dataRecoveryBlockInvalidException = new DataRecoveryBlockInvalidException("MAGIC_START_BYTE not found");
                dataRecoveryBlockInvalidException.setMagicStartByteInvalid();
                throw dataRecoveryBlockInvalidException;
            }
            try {
                int n3;
                by2 = (byte)randomAccessFile.readUnsignedByte();
                if (by2 != 0 && by2 != 1 && by2 != 2) {
                    throw new DataRecoveryBlockInvalidException("Invalid BLOCK_STATE: " + by2);
                }
                if (debug) {
                    switch (by2) {
                        case 0: {
                            System.out.println("DataRecoveryBlock::read() reading free block");
                            break;
                        }
                        case 1: {
                            System.out.println("DataRecoveryBlock::read() reading used block");
                            break;
                        }
                        case 2: {
                            System.out.println("DataRecoveryBlock::read() reading pending block");
                            break;
                        }
                    }
                }
                if (by2 != 0) {
                    by = (byte)randomAccessFile.readUnsignedByte();
                    n = randomAccessFile.readInt();
                    if (n < 0 || maxReadSize > 0L && (long)n > maxReadSize) {
                        throw new DataRecoveryBlockInvalidException("Invalid key size: " + n);
                    }
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read key size: " + n2);
                    }
                    byArray = new byte[n];
                    n3 = randomAccessFile.read(byArray, 0, n);
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read " + n3 + " key size bytes");
                    }
                    if (n3 != n) {
                        throw new DataRecoveryBlockInvalidException("Key bytes expectation failed: " + n3 + " != " + n);
                    }
                }
                if ((n2 = randomAccessFile.readInt()) < 0 || maxReadSize > 0L && (long)n2 > maxReadSize) {
                    throw new DataRecoveryBlockInvalidException("Invalid payload size: " + n2);
                }
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() read payload size: " + n2);
                }
                if (by2 == 0) {
                    n3 = randomAccessFile.skipBytes(n2);
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() skipped " + n3 + " free payload bytes");
                    }
                    if (n3 != n2) {
                        throw new DataRecoveryBlockInvalidException("Free payload bytes expectation failed: " + n3 + " != " + n2);
                    }
                    dataRecoveryBlock = new FreeDataRecoveryBlock(n2, false);
                }
                byte[] byArray2 = new byte[n2];
                int n4 = randomAccessFile.read(byArray2, 0, n2);
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() read " + n4 + " payload bytes");
                }
                if (n4 != n2) {
                    throw new DataRecoveryBlockInvalidException("Used payload bytes expectation failed: " + n4 + " != " + n2);
                }
                byte by4 = (byte)randomAccessFile.readUnsignedByte();
                if (by4 != -17) {
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read non-magic ending byte: " + by4);
                    }
                    DataRecoveryBlockInvalidException dataRecoveryBlockInvalidException = new DataRecoveryBlockInvalidException("MAGIC_END_BYTE not found");
                    dataRecoveryBlockInvalidException.setMagicEndByteInvalid();
                    throw dataRecoveryBlockInvalidException;
                }
                if (by2 == 2) {
                    dataRecoveryBlock = new PendingDataRecoveryBlock(by, n, byArray, n2, byArray2);
                }
                dataRecoveryBlock = new UsedDataRecoveryBlock(by, n, byArray, n2, byArray2);
            }
            catch (EOFException eOFException) {
                throw new DataRecoveryBlockInvalidException("Unexpected EOF while reading block");
            }
        } else {
            byte by5;
            if (debug) {
                System.out.println("DataRecoveryBlock::read() reading standard Input");
            }
            if ((by5 = (byte)dataInput.readUnsignedByte()) != -2) {
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() read non-magic starting byte: " + by5);
                }
                DataRecoveryBlockInvalidException dataRecoveryBlockInvalidException = new DataRecoveryBlockInvalidException("MAGIC_START_BYTE not found");
                dataRecoveryBlockInvalidException.setMagicStartByteInvalid();
                throw dataRecoveryBlockInvalidException;
            }
            try {
                by2 = (byte)dataInput.readUnsignedByte();
                if (by2 != 0 && by2 != 1 && by2 != 2) {
                    throw new DataRecoveryBlockInvalidException("Invalid BLOCK_STATE: " + by2);
                }
                if (debug) {
                    switch (by2) {
                        case 0: {
                            System.out.println("DataRecoveryBlock::read() reading free block");
                            break;
                        }
                        case 1: {
                            System.out.println("DataRecoveryBlock::read() reading used block");
                            break;
                        }
                        case 2: {
                            System.out.println("DataRecoveryBlock::read() reading pending block");
                            break;
                        }
                    }
                }
                if (by2 != 0) {
                    by = (byte)dataInput.readUnsignedByte();
                    n = dataInput.readInt();
                    if (n < 0 || maxReadSize > 0L && (long)n > maxReadSize) {
                        throw new DataRecoveryBlockInvalidException("Invalid key size: " + n);
                    }
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() read key size: " + n);
                    }
                    byArray = new byte[n];
                    dataInput.readFully(byArray, 0, n);
                }
                if ((n2 = dataInput.readInt()) < 0 || maxReadSize > 0L && (long)n2 > maxReadSize) {
                    throw new DataRecoveryBlockInvalidException("Invalid payload size: " + n2);
                }
                if (debug) {
                    System.out.println("DataRecoveryBlock::read() read payload size: " + n2);
                }
                if (by2 == 0) {
                    int n5 = dataInput.skipBytes(n2);
                    if (debug) {
                        System.out.println("DataRecoveryBlock::read() skipped " + n5 + " free payload bytes");
                    }
                    if (n5 != n2) {
                        throw new DataRecoveryBlockInvalidException("Free payload bytes expectation failed: " + n5 + " != " + n2);
                    }
                    dataRecoveryBlock = new FreeDataRecoveryBlock(n2, false);
                } else {
                    byte[] byArray3 = new byte[n2];
                    dataInput.readFully(byArray3, 0, n2);
                    byte by6 = (byte)dataInput.readUnsignedByte();
                    if (by6 != -17) {
                        if (debug) {
                            System.out.println("DataRecoveryBlock::read() read non-magic ending byte: " + by6);
                        }
                        DataRecoveryBlockInvalidException dataRecoveryBlockInvalidException = new DataRecoveryBlockInvalidException("MAGIC_END_BYTE not found");
                        dataRecoveryBlockInvalidException.setMagicEndByteInvalid();
                        throw dataRecoveryBlockInvalidException;
                    }
                    dataRecoveryBlock = by2 == 2 ? new PendingDataRecoveryBlock(by, n, byArray, n2, byArray3) : new UsedDataRecoveryBlock(by, n, byArray, n2, byArray3);
                }
            }
            catch (EOFException eOFException) {
                throw new DataRecoveryBlockInvalidException("Unexpected EOF while reading block");
            }
        }
        if (debug) {
            System.out.println("DataRecoveryBlock::read() created data recovery block with total size: " + dataRecoveryBlock.getTotalSize());
        }
        if (debug && l != 0L) {
            System.out.println("DataRecoveryBlock::read() took: " + (Clock.ticks() - l) + " ms");
        }
        return dataRecoveryBlock;
    }

    public int compareTo(Object object) {
        if (object instanceof DataRecoveryBlock) {
            boolean bl = false;
            if (this.getBlockState() == 0) {
                bl = true;
            }
            boolean bl2 = false;
            if (((DataRecoveryBlock)object).getBlockState() == 0) {
                bl2 = true;
            }
            if (bl == bl2) {
                return 0;
            }
            if (this.getBlockState() == 0 && ((DataRecoveryBlock)object).getBlockState() != 0) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    public final void visual(PrintStream printStream) {
        if (this.getBlockState() == 0) {
            printStream.println("/------------\\");
            printStream.println("[ Free: " + this.getTotalSize() + "  ]  ");
            printStream.println("\\------------/");
        } else if (this.getBlockState() == 1) {
            printStream.println("/------------\\");
            printStream.println("[ Used: " + this.getTotalSize() + "  ] key = " + TextUtil.bytesToHexString((byte[])this.getKeyInSourceSpaceCopy()) + " value: " + TextUtil.bytesToHexString((byte[])this.payload));
            printStream.println("\\------------/");
        } else if (this.getBlockState() == 2) {
            printStream.println("/---------------\\");
            printStream.println("[ Pending: " + this.getTotalSize() + "  ] key = " + TextUtil.bytesToHexString((byte[])this.getKeyInSourceSpaceCopy()) + " value: " + TextUtil.bytesToHexString((byte[])this.payload));
            printStream.println("\\---------------/");
        }
    }

    private final /* synthetic */ void this() {
        this.sourceSpace = 0;
        this.keyInSourceSpaceSize = 0;
        this.keyInSourceSpace = null;
        this.payloadSize = 0;
        this.payload = null;
        this.serializedForm = null;
    }

    public DataRecoveryBlock() {
        this.this();
    }

    static {
        try {
            debug = System.getProperty("niagara.platDataRecovery.blockDebug", "false").equalsIgnoreCase("true");
        }
        catch (Exception exception) {}
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.writeByte(-2);
        byteBuffer.writeByte(-17);
        byteBuffer.writeByte(0);
        byteBuffer.writeByte(0);
        byteBuffer.writeInt(0);
        byteBuffer.writeInt(0);
        fixedFieldsOfUsedBlockHeaderSize = byteBuffer.toByteArray().length;
        ByteBuffer byteBuffer2 = new ByteBuffer();
        byteBuffer2.writeByte(-2);
        byteBuffer2.writeByte(0);
        byteBuffer2.writeInt(0);
        freeBlockHeaderSize = byteBuffer2.toByteArray().length;
    }
}

