/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.BDataRecoveryService;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.collection.DataRecoveryLinkedList;
import com.tridium.platDataRecovery.collection.DataRecoveryRecord;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInvalidException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreUnavailableException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryTooLargeEventEncounteredException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDataRecoveryBlockManager
extends BComponent {
    public static final Property maxCapacity = BDataRecoveryBlockManager.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"units", "min", "max"}, (BIDataValue[])new BIDataValue[]{BUnit.make((String)"byte", (String)"B", (BDimension)BDimension.NULL, (double)1.0), BInteger.make((int)0), BInteger.MAX}));
    public static final Property currentManagerStatus = BDataRecoveryBlockManager.newProperty((int)3, (BValue)BDataRecoveryBlockManagerStatus.unknown, null);
    public static final Action dumpRecoveryData = BDataRecoveryBlockManager.newAction((int)4, null);
    public static final Topic blockFlushed = BDataRecoveryBlockManager.newTopic((int)0, null);
    public static final Topic sizesUpdated = BDataRecoveryBlockManager.newTopic((int)0, null);
    public static final Type TYPE;
    protected static boolean debug;
    protected static boolean failFast;
    protected static final Log log;
    protected static final Comparator DATA_RECOVERY_BLOCK_COMPARATOR;
    public static final Comparator DEFAULT_RECOVERY_MANAGER_COMPARATOR;
    public static final Comparator DEFAULT_ACTIVE_FILE_COMPARATOR;
    public static final Comparator PERSISTENT_FILE_COMPARATOR;
    protected static boolean dirsInitialized;
    protected static File persistentDirectory;
    protected static File activeDirectory;
    public static final Object persistentDirectoryMonitor;
    public static final Object activeDirectoryMonitor;
    protected static int chunkSize;
    protected static int totalChunks;
    private int overheadSpaceAttribute;
    private int usedSpaceAttribute;
    private int freeSpaceAttribute;
    protected Object sizeMonitor;
    long lastMillisFired;
    protected ArrayList blocks;
    protected final Object blocksMonitor;
    protected boolean activeFileOpen;
    protected File file;
    protected int remainingChunks;
    static /* synthetic */ Class class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager;

    public int getMaxCapacity() {
        return this.getInt(maxCapacity);
    }

    public void setMaxCapacity(int n) {
        this.setInt(maxCapacity, n, null);
    }

    public BDataRecoveryBlockManagerStatus getCurrentManagerStatus() {
        return (BDataRecoveryBlockManagerStatus)this.get(currentManagerStatus);
    }

    public void setCurrentManagerStatus(BDataRecoveryBlockManagerStatus bDataRecoveryBlockManagerStatus) {
        this.set(currentManagerStatus, (BValue)bDataRecoveryBlockManagerStatus, null);
    }

    public BBoolean dumpRecoveryData() {
        return (BBoolean)this.invoke(dumpRecoveryData, null, null);
    }

    public void fireBlockFlushed(BValue bValue) {
        this.fire(blockFlushed, bValue, null);
    }

    public void fireSizesUpdated(BValue bValue) {
        this.fire(sizesUpdated, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract void openActiveFile(String var1) throws Exception;

    public abstract void closeActiveFile() throws Exception;

    protected abstract void readFromActive() throws Exception;

    protected abstract void writeToActive() throws Exception;

    protected abstract void formatActiveFile() throws Exception;

    public abstract boolean appendData(byte var1, byte[] var2, byte[] var3) throws DataRecoveryException;

    public abstract boolean updateData(byte var1, byte[] var2, byte[] var3) throws DataRecoveryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void initializeDirectories(String string, String string2) throws Exception {
        block19: {
            Object object;
            boolean bl;
            block21: {
                block17: {
                    block20: {
                        bl = log.isTraceOn();
                        if (!dirsInitialized) break block20;
                        if (bl) {
                            log.trace("Data recovery active directory already initialized");
                        }
                        if (string.equals(activeDirectory.getAbsolutePath())) break block17;
                    }
                    if (bl) {
                        log.trace("Setting active data recovery directory to: " + string);
                    }
                    object = activeDirectoryMonitor;
                    synchronized (object) {
                        block16: {
                            activeDirectory = new File(string);
                            if (!activeDirectory.exists()) break block16;
                            if (!activeDirectory.isDirectory()) {
                                log.error("Active data recovery file already exists but is not a directory.");
                                throw new BajaRuntimeException("Active data recovery file already exists but is not a directory");
                            }
                            break block17;
                        }
                        if (!activeDirectory.mkdirs()) {
                            log.error("Failed to create active data recovery directory: " + activeDirectory.getAbsolutePath());
                            throw new BajaRuntimeException("Failed to create active data recovery directory");
                        }
                    }
                }
                if (!dirsInitialized) break block21;
                if (bl) {
                    log.trace("Data recovery persistent directory already initialized");
                }
                if (string2.equals(persistentDirectory.getAbsolutePath())) break block19;
            }
            if (bl) {
                log.trace("Setting persistent data recovery directory to: " + string2);
            }
            object = persistentDirectoryMonitor;
            synchronized (object) {
                block18: {
                    persistentDirectory = new File(string2);
                    if (!persistentDirectory.exists()) break block18;
                    if (!persistentDirectory.isDirectory()) {
                        log.error("Persistent data recovery file already exists but is not a directory.");
                        throw new BajaRuntimeException("Persistent data recovery file already exists but is not a directory");
                    }
                    break block19;
                }
                if (!persistentDirectory.mkdirs()) {
                    log.error("Failed to create persistent data recovery directory: " + persistentDirectory.getAbsolutePath());
                    throw new BajaRuntimeException("Failed to create persistent data recovery directory");
                }
            }
        }
        dirsInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean recoveryDataExists() throws DataRecoveryException {
        if (!BDataRecoveryBlockManager.dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("Data recovery directories are not initialized");
        }
        var0 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
        synchronized (var0) {
            var3_1 = BDataRecoveryBlockManager.persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (var3_1.length != 0) {
                return true;
            }
        }
        var0 = BDataRecoveryBlockManager.activeDirectoryMonitor;
        synchronized (var0) {
            block12: {
                var3_1 = BDataRecoveryBlockManager.activeDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                if (var3_1.length == 0) break block12;
                var4_2 = null;
                var5_3 = 0;
                if (true) ** GOTO lbl28
                do {
                    if (BDataRecoveryService.lengthOfFile(var4_2 = var3_1[var5_3]) != 0L) {
                        return true;
                    }
                    ++var5_3;
lbl28:
                    // 2 sources

                } while (var5_3 < var3_1.length);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void recalculateSpace() throws DataRecoveryException {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        var1_1 = this.blocksMonitor;
        synchronized (var1_1) {
            if (BDataRecoveryBlockManager.log.isTraceOn()) {
                BDataRecoveryBlockManager.log.trace("Recalculating allocation sizes for file: " + this.file.getName());
            }
            var3_2 = 0;
            var4_3 = 0;
            var5_4 = 0;
            var6_5 = this.blocks.iterator();
            var7_6 = null;
            if (BDataRecoveryBlockManager.chunkSize <= 0) ** GOTO lbl34
            this.remainingChunks = BDataRecoveryBlockManager.totalChunks;
            if (true) ** GOTO lbl34
            do {
                var7_6 = (DataRecoveryBlock)var6_5.next();
                if (BDataRecoveryBlockManager.chunkSize < 0) {
                    var4_3 += var7_6.getFreeSpace();
                    var5_4 += var7_6.getUsedSpace();
                    var3_2 += var7_6.getOverheadSpace();
                    continue;
                }
                if (var7_6.getBlockState() == 0) continue;
                var8_7 = var7_6.getTotalSize() / BDataRecoveryBlockManager.chunkSize;
                if (var7_6.getTotalSize() % BDataRecoveryBlockManager.chunkSize != 0) {
                    ++var8_7;
                }
                var9_9 = var8_7 * BDataRecoveryBlockManager.chunkSize - var7_6.getTotalSize();
                var5_4 += var7_6.getUsedSpace();
                var3_2 += var7_6.getOverheadSpace() + var9_9;
                this.remainingChunks -= var8_7;
                var4_3 = this.remainingChunks * BDataRecoveryBlockManager.chunkSize;
lbl34:
                // 5 sources

            } while (var6_5.hasNext());
            var8_8 = this.sizeMonitor;
            synchronized (var8_8) {
                if (this.getMaxCapacity() == 0) {
                    if (BDataRecoveryBlockManager.log.isTraceOn()) {
                        BDataRecoveryBlockManager.log.trace("In BDataRecoveryBlockManager::recalculateSpace(), setting maxCapacity to: " + var4_3 + var5_4 + var3_2);
                    }
                    this.setMaxCapacity(var4_3 + var5_4 + var3_2);
                } else {
                    if (BDataRecoveryBlockManager.log.isTraceOn()) {
                        BDataRecoveryBlockManager.log.trace("In BDataRecoveryBlockManager::recalculateSpace(), maxCapacity was already set to: " + this.getMaxCapacity());
                    }
                    if (var5_4 + var4_3 + var3_2 != this.getMaxCapacity()) {
                        var4_3 = this.getMaxCapacity() - var5_4 - var3_2;
                    }
                    if (BDataRecoveryBlockManager.chunkSize > 0 && var4_3 == this.getMaxCapacity()) {
                        this.remainingChunks = BDataRecoveryBlockManager.totalChunks;
                    }
                }
                try {
                    this.setUsedSpace(var5_4);
                    this.setFreeSpace(var4_3);
                    this.setOverheadSpace(var3_2);
                }
                catch (Exception var10_10) {
                    throw new DataRecoveryException("Error while recalculating sizes: ", (Throwable)var10_10);
                }
                if (this.isSubscribed() && (var10_11 = System.currentTimeMillis()) - this.lastMillisFired > 5000L) {
                    this.fireSizesUpdated(null);
                    this.lastMillisFired = var10_11;
                }
                if (BDataRecoveryBlockManager.log.isTraceOn()) {
                    BDataRecoveryBlockManager.log.trace("In BDataRecoveryBlockManager::recalculateSpace(), free space is now: " + var4_3);
                }
                if (BDataRecoveryBlockManager.log.isTraceOn()) {
                    BDataRecoveryBlockManager.log.trace("In BDataRecoveryBlockManager::recalculateSpace(), used space is now: " + var5_4);
                }
                if (BDataRecoveryBlockManager.log.isTraceOn()) {
                    BDataRecoveryBlockManager.log.trace("In BDataRecoveryBlockManager::recalculateSpace(), overhead space is now: " + var3_2);
                }
                return;
            }
        }
    }

    public static final DataRecoveryLinkedList replayActiveRecoveryData() {
        return BDataRecoveryBlockManager.replayActiveRecoveryData(DEFAULT_ACTIVE_FILE_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final DataRecoveryLinkedList replayActiveRecoveryData(Comparator comparator) {
        if (comparator == null) {
            return BDataRecoveryBlockManager.replayActiveRecoveryData();
        }
        DataRecoveryLinkedList dataRecoveryLinkedList = new DataRecoveryLinkedList();
        if (!dirsInitialized) {
            return dataRecoveryLinkedList;
        }
        Object object = activeDirectoryMonitor;
        synchronized (object) {
            Object[] objectArray = activeDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            log.trace("Sorting active file database for replay...");
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)comparator);
            int n = 0;
            while (n < objectArray.length) {
                if (log.isTraceOn()) {
                    long l = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)objectArray[n], true));
                    log.trace("Replaying active file " + (n + 1) + " of " + objectArray.length + ", sequence number is " + l);
                }
                dataRecoveryLinkedList.addAll(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)objectArray[n], true));
                ++n;
            }
            return dataRecoveryLinkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final DataRecoveryLinkedList replayPersistentRecoveryData() {
        DataRecoveryLinkedList dataRecoveryLinkedList = new DataRecoveryLinkedList();
        if (!dirsInitialized) {
            return dataRecoveryLinkedList;
        }
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            Object[] objectArray = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            log.trace("Sorting persistent file database for replay...");
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)PERSISTENT_FILE_COMPARATOR);
            int n = 0;
            while (n < objectArray.length) {
                log.trace("Replaying persistent file " + (n + 1) + " of " + objectArray.length);
                dataRecoveryLinkedList.addAll(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)objectArray[n], false));
                ++n;
            }
            return dataRecoveryLinkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final DataRecoveryLinkedList replayLastPersistentFile() {
        DataRecoveryLinkedList dataRecoveryLinkedList = new DataRecoveryLinkedList();
        if (!dirsInitialized) {
            return dataRecoveryLinkedList;
        }
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            Object[] objectArray = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            log.trace("Sorting persistent file database for last replay...");
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)PERSISTENT_FILE_COMPARATOR);
            if (objectArray.length != 0) {
                log.trace("Replaying last persistent file \"" + objectArray[objectArray.length - 1] + '\"');
                dataRecoveryLinkedList.addAll(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)objectArray[objectArray.length - 1], false));
            }
            return dataRecoveryLinkedList;
        }
    }

    public static final void replayRecoveryData(HashMap hashMap) {
        BDataRecoveryBlockManager.replayRecoveryData(hashMap, DEFAULT_ACTIVE_FILE_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void replayRecoveryData(HashMap var0, Comparator var1_1) {
        block18: {
            if (var1_1 == null) {
                BDataRecoveryBlockManager.replayRecoveryData(var0);
            }
            if (!BDataRecoveryBlockManager.dirsInitialized) {
                BDataRecoveryBlockManager.log.error("Directories are not initialized, can not replay data at this time");
                return;
            }
            if (var0 == null) {
                BDataRecoveryBlockManager.log.error("Provided dataRecoverySources null, can not replay data");
                return;
            }
            try {
                var2_2 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
                synchronized (var2_2) {
                    var4_4 = BDataRecoveryBlockManager.persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                    BDataRecoveryBlockManager.log.trace("Sorting persistent file database for replay...");
                    SortUtil.sort((Object[])var4_4, (Object[])var4_4, (Comparator)BDataRecoveryBlockManager.PERSISTENT_FILE_COMPARATOR);
                    var5_5 = 0;
                    while (true) {
                        if (var5_5 >= ((Object[])var4_4).length) {
                            break;
                        }
                        BDataRecoveryBlockManager.log.trace("Replaying persistent file " + (var5_5 + 1) + " of " + ((Object)var4_4).length);
                        BDataRecoveryBlockManager.restoreRecoveryDataHelper(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)var4_4[var5_5], false), var0);
                        ++var5_5;
                    }
                }
                var2_2 = BDataRecoveryBlockManager.activeDirectoryMonitor;
                synchronized (var2_2) {
                    var4_4 = BDataRecoveryBlockManager.activeDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                    BDataRecoveryBlockManager.log.trace("Sorting active file database for replay...");
                    SortUtil.sort((Object[])var4_4, (Object[])var4_4, (Comparator)var1_1);
                    var5_5 = 0;
                    if (true) ** GOTO lbl57
                }
            }
            catch (DataRecoveryTooLargeEventEncounteredException var2_3) {
                var3_10 = var2_3.getRecord();
                BDataRecoveryBlockManager.log.warning("Encountered Data Recovery Too Large Event");
                var4_4 = var3_10.getData();
                try {
                    var5_6 = new ByteBuffer((byte[])var4_4);
                    var6_9 = (BAbsTime)BAbsTime.DEFAULT.decode((DataInput)var5_6);
                    var7_11 = (BOrd)BOrd.DEFAULT.decode((DataInput)var5_6);
                    BDataRecoveryBlockManager.log.error("Data Recovery encountered an event from source \"" + var7_11 + "\" that was too large to restore.");
                    BDataRecoveryBlockManager.log.error("The station cannot be completely restored.  Station is current as of " + var6_9);
                }
                catch (IOException var5_7) {
                    BDataRecoveryBlockManager.log.error("Error decoding Data Recovery Too Large data, can not print");
                }
                break block18;
            }
            {
                do {
                    if (BDataRecoveryBlockManager.log.isTraceOn()) {
                        var6_8 = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)var4_4[var5_5], true));
                        BDataRecoveryBlockManager.log.trace("Replaying active file " + (var5_5 + 1) + " of " + ((Object)var4_4).length + ", sequence number is " + var6_8);
                    }
                    BDataRecoveryBlockManager.restoreRecoveryDataHelper(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)var4_4[var5_5], true), var0);
                    ++var5_5;
lbl57:
                    // 2 sources

                } while (var5_5 < ((Object)var4_4).length);
            }
        }
        var2_2 = var0.entrySet();
        var3_10 = var2_2.iterator();
        while (var3_10.hasNext()) {
            var4_4 = (Map.Entry)var3_10.next();
            ((BIDataRecoverySource)var4_4.getValue()).dataRecoveryRestoreComplete();
        }
    }

    public static final DataRecoveryLinkedList replayRecoveryDataHelper(File file, boolean bl) {
        boolean bl2 = log.isTraceOn();
        if (bl2) {
            log.trace("Replaying file name: " + file.getName());
        }
        DataInputStream dataInputStream = null;
        DataRecoveryLinkedList dataRecoveryLinkedList = new DataRecoveryLinkedList();
        DataRecoveryRecord dataRecoveryRecord = null;
        DataRecoveryBlock dataRecoveryBlock = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("File not found: " + file.getName(), (Throwable)fileNotFoundException);
            return new DataRecoveryLinkedList();
        }
        DataRecoveryBlock.maxReadSize = BDataRecoveryService.lengthOfFile(file);
        boolean bl3 = false;
        int n = 0;
        while (true) {
            try {
                ++n;
                dataRecoveryBlock = DataRecoveryBlock.read(dataInputStream);
                if (dataRecoveryBlock.getBlockState() == 0) {
                    if (!bl2) continue;
                    log.trace("Ignoring free block of size " + dataRecoveryBlock.getTotalSize() + " in data recovery file.");
                    continue;
                }
                dataRecoveryRecord = new DataRecoveryRecord(dataRecoveryBlock.getSpaceIdentifier(), dataRecoveryBlock.getKeyInSourceSpaceCopy(), dataRecoveryBlock.getPayloadCopy());
                dataRecoveryLinkedList.addLast(dataRecoveryRecord);
            }
            catch (EOFException eOFException) {
                if (!bl2) break;
                log.trace("Reached expected EOF in data recovery file.");
                break;
            }
            catch (DataRecoveryBlockInvalidException dataRecoveryBlockInvalidException) {
                log.warning("Data recovery block " + n + " was determined to be corrupted (" + dataRecoveryBlockInvalidException.getMessage() + "), data may be lost");
                bl3 = true;
                if (dataRecoveryBlockInvalidException.wasMagicStartByteInvalid()) {
                    if (dataRecoveryLinkedList.size() <= 0) break;
                    dataRecoveryLinkedList.removeLast();
                    break;
                }
                dataRecoveryBlockInvalidException.wasMagicEndByteInvalid();
                break;
            }
            catch (Exception exception) {
                log.error("General exception occured while reading data recovery block, error occured on record " + n + ':', (Throwable)exception);
                bl3 = true;
                break;
            }
        }
        try {
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (IOException iOException) {}
        if (bl3 && !bl) {
            return new DataRecoveryLinkedList();
        }
        return dataRecoveryLinkedList;
    }

    private static final void restoreRecoveryDataHelper(DataRecoveryLinkedList dataRecoveryLinkedList, HashMap hashMap) {
        if (dataRecoveryLinkedList == null) {
            return;
        }
        if (hashMap == null) {
            return;
        }
        IDataRecoveryRecord iDataRecoveryRecord = null;
        BIDataRecoverySource bIDataRecoverySource = null;
        while (!dataRecoveryLinkedList.isEmpty()) {
            iDataRecoveryRecord = dataRecoveryLinkedList.remove(0);
            byte by = iDataRecoveryRecord.getDataRecoverySourceIdentifier();
            if (by == 0) {
                boolean bl;
                block12: {
                    BBlob bBlob = null;
                    bl = false;
                    try {
                        bBlob = (BBlob)BBlob.DEFAULT.decode((DataInput)new ByteBuffer(iDataRecoveryRecord.getKey()));
                        if (!bBlob.equals((Object)BDataRecoveryService.TOO_LARGE_EVENT_AS_BLOB)) break block12;
                        bl = true;
                    }
                    catch (Exception exception) {
                        log.warning("Unable to decode record that originated from service, ignoring record.");
                        continue;
                    }
                }
                if (bl) {
                    throw new DataRecoveryTooLargeEventEncounteredException("Encountered Too Large Event while restoring data.", iDataRecoveryRecord);
                }
            }
            if ((bIDataRecoverySource = (BIDataRecoverySource)hashMap.get(new Byte(iDataRecoveryRecord.getDataRecoverySourceIdentifier()))) != null) {
                try {
                    bIDataRecoverySource.dataRecoveryRestore(iDataRecoveryRecord);
                }
                catch (Exception exception) {
                    log.error("Exception restoring data recovery record", (Throwable)exception);
                    try {
                        if (!failFast) continue;
                        log.error("Data recovery Source indicated an error on restore, closing VM to preserve corrupted records.");
                        System.exit(-1);
                    }
                    catch (Exception exception2) {}
                }
                continue;
            }
            log.warning("Ignoring record with source byte " + iDataRecoveryRecord.getDataRecoverySourceIdentifier() + ", no BIDataRecoverySource available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final long getLastPersistentFileNumber() {
        if (!dirsInitialized) {
            return -1;
        }
        long l = -1;
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            Object[] objectArray = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            log.trace("Sorting persistent file database for last persistent file name...");
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)PERSISTENT_FILE_COMPARATOR);
            if (objectArray.length == 0) return l;
            Object object2 = objectArray[objectArray.length - 1];
            String string = ((File)object2).getName().substring(0, ((File)object2).getName().indexOf(46));
            return Long.parseLong(string);
        }
    }

    public static final File getPersistentDirectory() throws DataRecoveryException {
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("data recovery directories are not initialized");
        }
        return persistentDirectory;
    }

    public static final File getActiveDirectory() throws DataRecoveryException {
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("data recovery directories are not initialized");
        }
        return activeDirectory;
    }

    public static final BBlob createCombinedKey(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return BBlob.make((byte[])byArray2);
    }

    public static final byte getSourceFromCombinedKey(BBlob bBlob) {
        return bBlob.byteAt(0);
    }

    public static final byte[] getRecoveryKeyFromCombinedKey(BBlob bBlob) {
        byte[] byArray = new byte[bBlob.length() - 1];
        bBlob.copyBytes(1, byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doPurgeRecoveryData() {
        Object object = this.blocksMonitor;
        synchronized (object) {
            BDataRecoveryBlockManagerStatus bDataRecoveryBlockManagerStatus = this.getCurrentManagerStatus();
            this.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.purging);
            if (this.activeFileOpen) {
                long l = 0L;
                if (debug) {
                    l = Clock.ticks();
                }
                try {
                    this.formatActiveFile();
                }
                catch (Exception exception) {}
                if (debug && l != 0L) {
                    System.out.println("BDataRecoveryBlockManager::doPurgeRecoveryData() took: " + (Clock.ticks() - l) + " ms");
                }
            }
            if (bDataRecoveryBlockManagerStatus == BDataRecoveryBlockManagerStatus.awaitingIdle) {
                this.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
            } else {
                this.setCurrentManagerStatus(bDataRecoveryBlockManagerStatus);
            }
            return BBoolean.TRUE;
        }
    }

    public final BBoolean doFlushRecoveryData(String string) {
        return this.doFlushRecoveryData(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final BBoolean doFlushRecoveryData(String var1_1, boolean var2_2) {
        if (!this.activeFileOpen) {
            return BBoolean.FALSE;
        }
        var3_3 = this.blocksMonitor;
        // MONITORENTER : var3_3
        var6_4 = this.getCurrentManagerStatus();
        this.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.flushing);
        if (this.blocks.size() == 1 && ((DataRecoveryBlock)this.blocks.get(0)).getBlockState() == 0) {
            if (BDataRecoveryBlockManager.log.isTraceOn()) {
                BDataRecoveryBlockManager.log.trace("Not flushing formatted data recovery block: " + this.getName());
            }
            this.setCurrentManagerStatus(var6_4);
            // MONITOREXIT : var3_3
            return BBoolean.TRUE;
        }
        BDataRecoveryBlockManager.log.trace("Flushing data recovery block: " + this.getName() + "...");
        var7_5 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
        // MONITORENTER : var7_5
        ** try [egrp 2[TRYBLOCK] [8 : 158->578)] { 
lbl19:
        // 1 sources

        {
            var10_6 = new File(BDataRecoveryBlockManager.persistentDirectory, var1_1);
            if (var10_6.exists()) {
                BDataRecoveryBlockManager.log.error("Persistent file with name: " + var10_6 + " already exists!");
                this.setCurrentManagerStatus(var6_4);
                // MONITOREXIT : var7_5
                // MONITOREXIT : var3_3
                return BBoolean.FALSE;
            }
        }
lbl31:
        // 1 sources

        catch (Throwable v1) {
            // MONITOREXIT : var7_5
            throw v1;
        }
        var11_7 = new File(BDataRecoveryBlockManager.persistentDirectory, var1_1 + "_working");
        try {
            var12_8 = 0L;
            if (BDataRecoveryBlockManager.debug) {
                var12_8 = Clock.ticks();
            }
            if (!var11_7.createNewFile()) {
                BDataRecoveryBlockManager.log.error("Unable to create persistent file: " + var11_7.getName() + ", can not flush");
                this.setCurrentManagerStatus(var6_4);
                // MONITOREXIT : var7_5
                // MONITOREXIT : var3_3
                return BBoolean.FALSE;
            }
            var14_10 = null;
            var15_11 = this.blocks.iterator();
            var16_12 = new FileOutputStream(var11_7, false);
            var17_13 = new DataOutputStream(var16_12);
            var18_14 = 0;
            while (true) {
                if (!var15_11.hasNext()) {
                    var17_13.flush();
                    var16_12.getFD().sync();
                    ** try [egrp 4[TRYBLOCK] [2 : 476->484)] { 
lbl55:
                    // 1 sources

                    break;
                }
                var14_10 = (DataRecoveryBlock)var15_11.next();
                ++var18_14;
                if (var14_10.getBlockState() == 1) {
                    var14_10.write(var17_13);
                } else if (var14_10.getBlockState() == 2) {
                    BDataRecoveryBlockManager.log.error("No blocks should have pending status at time of flush, block: " + var18_14 + " was pending.");
                    var14_10.visual(System.out);
                }
                var17_13.flush();
            }
            {
                var17_13.close();
            }
lbl68:
            // 1 sources

            catch (Exception v2) {}
            var11_7.renameTo(var10_6);
            this.formatActiveFile();
            if (BDataRecoveryBlockManager.debug && var12_8 != 0L) {
                System.out.println("BDataRecoveryBlockManager::doFlushRecoveryData() took: " + (Clock.ticks() - var12_8) + " ms");
            }
        }
        catch (Exception var12_9) {
            BDataRecoveryBlockManager.log.error("Error creating persistent file: ", (Throwable)var12_9);
            this.setCurrentManagerStatus(var6_4);
            // MONITOREXIT : var7_5
            // MONITOREXIT : var3_3
            return BBoolean.FALSE;
        }
        this.setCurrentManagerStatus(var6_4);
        // MONITOREXIT : var3_3
        if (var2_2 == false) return BBoolean.TRUE;
        this.fireBlockFlushed(null);
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doDumpRecoveryData() {
        Object object = this.blocksMonitor;
        synchronized (object) {
            this.visualDump(System.out);
            return BBoolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(PrintStream printStream) {
        if (!this.activeFileOpen) {
            return;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            printStream.println("Active Path    :            " + activeDirectory);
            printStream.println("Peristant Path :            " + persistentDirectory);
            printStream.println("Status         :            " + this.getCurrentManagerStatus().getDisplayTag((Context)BFacets.NULL));
            printStream.println("File Size      :            " + this.getMaxCapacity() + " bytes");
            printStream.println("Overhead Space :            " + this.getOverheadSpace() + " bytes");
            printStream.println("Free Space     :            " + this.getFreeSpace() + " bytes");
            printStream.println("Used Space     :            " + this.getUsedSpace() + " bytes");
            printStream.println("Blocks         :            ");
            printStream.println("{");
            DataRecoveryBlock dataRecoveryBlock = null;
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 >= this.blocks.size()) {
                    printStream.println("}");
                    printStream.println();
                    return;
                }
                dataRecoveryBlock = (DataRecoveryBlock)this.blocks.get(n2);
                printStream.println("  Block Number [ " + n2 + " ] at offset: " + n);
                printStream.println("  {");
                printStream.println("    Total Size           :  " + dataRecoveryBlock.getTotalSize() + " bytes");
                printStream.println("    Header Size          :  " + dataRecoveryBlock.getHeaderSize() + " bytes");
                printStream.println("    State                :  " + dataRecoveryBlock.getBlockState());
                if (dataRecoveryBlock.getBlockState() != 0) {
                    printStream.println("    Source ID            :  " + dataRecoveryBlock.getSpaceIdentifier());
                    printStream.println("    Client Key Size      :  " + dataRecoveryBlock.getKeyInSourceSpaceSize() + " bytes");
                    printStream.println("    Client Key as String :  " + TextUtil.bytesToHexString((byte[])dataRecoveryBlock.getKeyInSourceSpaceCopy()));
                    printStream.println("    Payload Size         :  " + dataRecoveryBlock.getPayloadSize() + " bytes");
                    printStream.println("    Payload as String    :  " + TextUtil.bytesToHexString((byte[])dataRecoveryBlock.payload));
                } else {
                    printStream.println("    Payload Size         :  " + dataRecoveryBlock.getPayloadSize() + " bytes");
                }
                printStream.println("  }");
                n += dataRecoveryBlock.getTotalSize();
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visualDump(PrintStream printStream) {
        if (!this.activeFileOpen) {
            return;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            printStream.println("File Size     :            " + this.getMaxCapacity() + " bytes");
            printStream.println("Overhead Space:            " + this.getOverheadSpace() + " bytes");
            printStream.println("Free Space    :            " + this.getFreeSpace() + " bytes");
            printStream.println("Used Space    :            " + this.getUsedSpace() + " bytes");
            Iterator iterator = this.blocks.iterator();
            DataRecoveryBlock dataRecoveryBlock = null;
            int n = 0;
            while (true) {
                if (!iterator.hasNext()) {
                    printStream.println();
                    return;
                }
                dataRecoveryBlock = (DataRecoveryBlock)iterator.next();
                System.out.println("At index: " + n++);
                dataRecoveryBlock.visual(printStream);
            }
        }
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.overheadSpaceAttribute + this.usedSpaceAttribute == 0) {
            bl = true;
        }
        return bl;
    }

    public File getFile() {
        return this.file;
    }

    void setOverheadSpace(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Invalid overhead space size: " + n);
        }
        this.overheadSpaceAttribute = n;
    }

    void setUsedSpace(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Invalid used space size: " + n);
        }
        this.usedSpaceAttribute = n;
    }

    void setFreeSpace(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Invalid free space size: " + n);
        }
        this.freeSpaceAttribute = n;
    }

    public int getOverheadSpace() {
        return this.overheadSpaceAttribute;
    }

    public int getUsedSpace() {
        return this.usedSpaceAttribute;
    }

    public int getFreeSpace() {
        return this.freeSpaceAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BVector getSpaceRemote(Object object, Context context) {
        BVector bVector = new BVector();
        Object object2 = this.sizeMonitor;
        synchronized (object2) {
            bVector.add("freespace", (BValue)BInteger.make((int)this.freeSpaceAttribute));
            bVector.add("usedspace", (BValue)BInteger.make((int)this.usedSpaceAttribute));
            bVector.add("overheadspace", (BValue)BInteger.make((int)this.overheadSpaceAttribute));
            return bVector;
        }
    }

    public static final void setChunkSize(int n) {
        chunkSize = n;
    }

    public static final void setTotalChunks(int n) {
        totalChunks = n;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        this.spy(spyWriter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter, boolean bl) throws Exception {
        if (bl) {
            super.spy(spyWriter);
        }
        spyWriter.startProps("data recovery Block Manager " + this.getName() + " Sizes");
        Object object = this.sizeMonitor;
        synchronized (object) {
            spyWriter.prop((Object)"Current Status", (Object)this.getCurrentManagerStatus().encodeToString());
            spyWriter.prop((Object)"Maximum Capacity", this.getMaxCapacity());
            spyWriter.prop((Object)"Block Free Space", this.getFreeSpace());
            spyWriter.prop((Object)"Block Used Space", this.getUsedSpace());
            spyWriter.prop((Object)"Block Overhead Space", this.getOverheadSpace());
        }
        spyWriter.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataRecoveryLinkedList scanBlocksForSource(byte by) {
        DataRecoveryLinkedList dataRecoveryLinkedList = new DataRecoveryLinkedList();
        DataRecoveryBlock dataRecoveryBlock = null;
        Object object = this.blocksMonitor;
        synchronized (object) {
            Iterator iterator = this.blocks.iterator();
            while (iterator.hasNext()) {
                dataRecoveryBlock = (DataRecoveryBlock)iterator.next();
                if (!(dataRecoveryBlock instanceof UsedDataRecoveryBlock) || dataRecoveryBlock.getSpaceIdentifier() != by) continue;
                dataRecoveryLinkedList.addLast(new DataRecoveryRecord(by, dataRecoveryBlock.getKeyInSourceSpaceCopy(), dataRecoveryBlock.getPayloadCopy()));
            }
            return dataRecoveryLinkedList;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overheadSpaceAttribute = 0;
        this.usedSpaceAttribute = 0;
        this.freeSpaceAttribute = 0;
        this.sizeMonitor = new Object();
        this.lastMillisFired = 0L;
        this.blocks = null;
        this.blocksMonitor = new Object();
        this.activeFileOpen = false;
        this.file = null;
        this.remainingChunks = -1;
    }

    public BDataRecoveryBlockManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager;
        if (clazz == null) {
            clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager = BDataRecoveryBlockManager.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        debug = false;
        failFast = false;
        try {
            debug = System.getProperty("niagara.platDataRecovery.blockDebug", "false").equalsIgnoreCase("true");
            failFast = System.getProperty("niagara.platDataRecovery.exitOnRestoreFailure", "false").equalsIgnoreCase("true");
        }
        catch (Exception exception) {}
        log = Log.getLog((String)"platDataRecovery.manager");
        DATA_RECOVERY_BLOCK_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                DataRecoveryBlock dataRecoveryBlock = (DataRecoveryBlock)object;
                DataRecoveryBlock dataRecoveryBlock2 = (DataRecoveryBlock)object2;
                return dataRecoveryBlock.compareTo(dataRecoveryBlock2);
            }
        };
        DEFAULT_RECOVERY_MANAGER_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                BDataRecoveryBlockManager bDataRecoveryBlockManager = (BDataRecoveryBlockManager)((Object)object);
                BDataRecoveryBlockManager bDataRecoveryBlockManager2 = (BDataRecoveryBlockManager)((Object)object2);
                if (bDataRecoveryBlockManager.getFreeSpace() > bDataRecoveryBlockManager2.getFreeSpace()) {
                    return 1;
                }
                if (bDataRecoveryBlockManager2.getFreeSpace() > bDataRecoveryBlockManager.getFreeSpace()) {
                    return -1;
                }
                return 0;
            }
        };
        DEFAULT_ACTIVE_FILE_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                File file = (File)object;
                File file2 = (File)object2;
                if (file.length() < file2.length()) {
                    return 1;
                }
                if (file2.length() < file.length()) {
                    return -1;
                }
                return 0;
            }
        };
        PERSISTENT_FILE_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                long l;
                File file = (File)object;
                File file2 = (File)object2;
                String string = file.getName().substring(0, file.getName().indexOf(46));
                String string2 = file2.getName().substring(0, file2.getName().indexOf(46));
                long l2 = Long.parseLong(string);
                if (l2 < (l = Long.parseLong(string2))) {
                    return -1;
                }
                if (l < l2) {
                    return 1;
                }
                return 0;
            }
        };
        dirsInitialized = false;
        persistentDirectory = null;
        activeDirectory = null;
        persistentDirectoryMonitor = new Object();
        activeDirectoryMonitor = new Object();
        chunkSize = -1;
        totalChunks = -1;
    }
}

