/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.BDataRecoveryService;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.block.FreeDataRecoveryBlock;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInactiveException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreFullException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreUnavailableException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.DataRecoveryTooLargeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDataRecoveryBlockAppendManager
extends BDataRecoveryBlockManager {
    public static final Type TYPE;
    private DataOutputStream activeFileDataOutputStream;
    private FileOutputStream activeFileFileOutputStream;
    static /* synthetic */ Class class$com$tridium$platDataRecovery$block$BDataRecoveryBlockAppendManager;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void openActiveFile(String string) throws Exception {
        boolean bl = log.isTraceOn();
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("Data recovery directories are not initialized");
        }
        if (this.activeFileOpen) {
            if (bl) {
                log.trace("Data recovery active file already open");
            }
            if (this.file.getName().equals(string)) {
                return;
            }
            this.closeActiveFile();
        }
        if (bl) {
            log.trace("Opening active data recovery store with filename: " + string);
        }
        Object object = activeDirectoryMonitor;
        synchronized (object) {
            block26: {
                this.file = new File(activeDirectory, string);
                boolean bl2 = false;
                if (!this.file.exists()) {
                    try {
                        this.file.createNewFile();
                        bl2 = true;
                    }
                    catch (IOException iOException) {
                        log.error("Error creating active data recovery file with name: " + string, (Throwable)iOException);
                        throw new DataRecoveryException("Error creating active data recovery file with name: " + string, (Throwable)iOException);
                    }
                }
                try {
                    this.activeFileOpen = true;
                    if (!bl2) {
                        if (bl) {
                            log.trace("Active data recovery file already existed at: " + this.file.getCanonicalPath() + ", reading contents.");
                        }
                        this.readFromActive();
                        break block26;
                    }
                    if (bl) {
                        log.trace("Formatting new active data recovery file at: " + this.file.getCanonicalPath());
                    }
                    Object object2 = this.blocksMonitor;
                    synchronized (object2) {
                        if (this.blocks == null) {
                            this.blocks = new ArrayList();
                        } else {
                            this.blocks.clear();
                        }
                        FreeDataRecoveryBlock freeDataRecoveryBlock = new FreeDataRecoveryBlock(this.getMaxCapacity(), true);
                        this.blocks.add(freeDataRecoveryBlock);
                        this.activeFileFileOutputStream = new FileOutputStream(this.file, false);
                        this.activeFileDataOutputStream = new DataOutputStream(this.activeFileFileOutputStream);
                        Object object3 = this.sizeMonitor;
                        synchronized (object3) {
                            this.setUsedSpace(freeDataRecoveryBlock.getUsedSpace());
                            this.setFreeSpace(freeDataRecoveryBlock.getFreeSpace());
                            this.setOverheadSpace(freeDataRecoveryBlock.getOverheadSpace());
                            if (chunkSize > 0) {
                                this.remainingChunks = totalChunks;
                            }
                            if (this.isSubscribed()) {
                                this.fireSizesUpdated(null);
                                this.lastMillisFired = System.currentTimeMillis();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    log.error("Error creating/reading active data recovery file: " + this.file.getName(), (Throwable)exception);
                    throw new DataRecoveryException("Error creating/reading active data recovery file: " + this.file.getName(), (Throwable)exception);
                }
            }
            return;
        }
    }

    public final void closeActiveFile() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        try {
            if (this.activeFileDataOutputStream != null) {
                this.activeFileDataOutputStream.close();
                this.activeFileDataOutputStream = null;
            }
        }
        catch (Exception exception) {}
        this.activeFileOpen = false;
        if (BDataRecoveryService.chunkFSPresent) {
            try {
                this.activeFileFileOutputStream = new FileOutputStream(this.file, false);
                this.activeFileFileOutputStream.close();
            }
            catch (Exception exception) {}
        } else if (!this.file.delete()) {
            log.error("Could not delete active data recovery file: " + this.file.getName() + ", truncating instead");
            try {
                this.activeFileFileOutputStream = new FileOutputStream(this.file, false);
                this.activeFileFileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        this.activeFileFileOutputStream = null;
        this.activeFileFileOutputStream = null;
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void readFromActive() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            try {
                long l;
                long l2 = 0L;
                if (debug) {
                    l2 = Clock.ticks();
                }
                if (this.blocks != null) {
                    this.blocks.clear();
                } else {
                    this.blocks = new ArrayList();
                }
                DataRecoveryBlock.maxReadSize = l = BDataRecoveryService.lengthOfFile(this.file);
                long l3 = 0L;
                long l4 = 0L;
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.file));
                while (l3 < l) {
                    if (debug) {
                        System.out.println("ActiveFileInput.currentPosition: " + l3);
                        System.out.println("ActiveFileInput.length(): " + l);
                    }
                    try {
                        DataRecoveryBlock dataRecoveryBlock = DataRecoveryBlock.read(dataInputStream);
                        l3 += (long)dataRecoveryBlock.getTotalSize();
                        if (chunkSize > 0) {
                            int n = dataRecoveryBlock.getTotalSize() / chunkSize;
                            if (dataRecoveryBlock.getTotalSize() % chunkSize != 0) {
                                ++n;
                            }
                            l4 += (long)(n * chunkSize);
                        }
                        this.blocks.add(dataRecoveryBlock);
                    }
                    catch (DataRecoveryException dataRecoveryException) {
                        log.error("Error while reading in data recovery: ", (Throwable)dataRecoveryException);
                        break;
                    }
                }
                if (chunkSize < 0) {
                    if (l3 < (long)this.getMaxCapacity()) {
                        int n = (int)((long)this.getMaxCapacity() - l3);
                        this.blocks.add(new FreeDataRecoveryBlock(n, true));
                    }
                } else if (l4 < (long)this.getMaxCapacity()) {
                    int n = (int)((long)this.getMaxCapacity() - l4);
                    this.blocks.add(new FreeDataRecoveryBlock(n, true));
                }
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
                this.activeFileFileOutputStream = new FileOutputStream(this.file, true);
                this.activeFileDataOutputStream = new DataOutputStream(this.activeFileFileOutputStream);
                if (debug && l2 != 0L) {
                    System.out.println("BDataRecoveryBlockManager::readFromActive() took: " + (Clock.ticks() - l2) + " ms");
                }
            }
            catch (Exception exception) {
                log.error("Error reading blocks: ", (Throwable)exception);
                throw exception;
            }
            this.recalculateSpace();
            return;
        }
    }

    protected final void writeToActive() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void formatActiveFile() throws Exception {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            block16: {
                block15: {
                    if (this.blocks != null) break block15;
                    this.blocks = new ArrayList();
                    break block16;
                }
                this.blocks.clear();
            }
            FreeDataRecoveryBlock freeDataRecoveryBlock = new FreeDataRecoveryBlock(this.getMaxCapacity(), true);
            this.blocks.add(freeDataRecoveryBlock);
            try {
                try {
                    if (this.activeFileDataOutputStream != null) {
                        this.activeFileDataOutputStream.close();
                        this.activeFileDataOutputStream = null;
                    }
                }
                catch (Exception exception) {}
                if (!this.file.exists() && !this.file.createNewFile()) {
                    log.error("Error creating data recovery file in format.");
                    return;
                }
                this.activeFileFileOutputStream = new FileOutputStream(this.file, false);
                this.activeFileDataOutputStream = new DataOutputStream(this.activeFileFileOutputStream);
            }
            catch (Exception exception) {
                log.error("Error formatting data recovery database: ", (Throwable)exception);
            }
            Object object2 = this.sizeMonitor;
            synchronized (object2) {
                this.setUsedSpace(freeDataRecoveryBlock.getUsedSpace());
                this.setFreeSpace(freeDataRecoveryBlock.getFreeSpace());
                this.setOverheadSpace(freeDataRecoveryBlock.getOverheadSpace());
                if (chunkSize > 0) {
                    this.remainingChunks = totalChunks;
                }
                if (this.isSubscribed()) {
                    this.fireSizesUpdated(null);
                    this.lastMillisFired = System.currentTimeMillis();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean appendData(byte by, byte[] byArray, byte[] byArray2) throws DataRecoveryException {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        int n = 0;
        int n2 = 0;
        if (chunkSize <= 0) {
            n = byArray2.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize + byArray.length;
            if (n > this.getMaxCapacity()) {
                throw new DataRecoveryTooLargeException(byArray2.length, this.getMaxCapacity(), "Cannot store data with length of " + byArray2.length);
            }
        } else {
            n = byArray2.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize + byArray.length;
            n2 = n / chunkSize;
            if (n % chunkSize != 0) {
                ++n2;
            }
            n = n2 * chunkSize;
            if (n2 > totalChunks) {
                throw new DataRecoveryTooLargeException(byArray2.length, this.getMaxCapacity(), "Cannot store data with length of " + byArray2.length);
            }
        }
        boolean bl = false;
        Object object = this.blocksMonitor;
        synchronized (object) {
            int n3;
            BDataRecoveryBlockManagerStatus bDataRecoveryBlockManagerStatus = this.getCurrentManagerStatus();
            if (bDataRecoveryBlockManagerStatus != BDataRecoveryBlockManagerStatus.active && bDataRecoveryBlockManagerStatus != BDataRecoveryBlockManagerStatus.reserved) {
                throw new DataRecoveryBlockInactiveException("The current block is not active, append can not be accomplished at this time");
            }
            if (chunkSize <= 0) {
                if (n > this.getFreeSpace()) {
                    if (!log.isTraceOn()) throw new DataRecoveryStoreFullException();
                    log.trace("Size of used block exceeds free space, forcing flush of block");
                    throw new DataRecoveryStoreFullException();
                }
            } else if (n2 > this.remainingChunks) {
                if (!log.isTraceOn()) throw new DataRecoveryStoreFullException();
                log.trace("Size of used block (" + n2 + " chunks) exceeds remaining chunk space (" + this.remainingChunks + "), forcing flush of block");
                throw new DataRecoveryStoreFullException();
            }
            if ((n3 = this.blocks.size() - 1) < 0) {
                log.error("Empty DataRecoveryBlockList when appending data.");
                return false;
            }
            DataRecoveryBlock dataRecoveryBlock = (DataRecoveryBlock)this.blocks.get(n3);
            if (dataRecoveryBlock.getBlockState() != 0) {
                throw new DataRecoveryStoreFullException();
            }
            if (dataRecoveryBlock.getFreeSpace() == n) {
                try {
                    UsedDataRecoveryBlock usedDataRecoveryBlock = new UsedDataRecoveryBlock(by, byArray.length, byArray, byArray2.length, byArray2);
                    this.blocks.set(n3, usedDataRecoveryBlock);
                    usedDataRecoveryBlock.write(this.activeFileDataOutputStream);
                    this.activeFileDataOutputStream.flush();
                    if (!BDataRecoveryService.chunkFSPresent) {
                        this.activeFileFileOutputStream.getFD().sync();
                    }
                    bl = true;
                    Object object2 = this.sizeMonitor;
                    synchronized (object2) {
                        block31: {
                            block30: {
                                if (chunkSize > 0) break block30;
                                this.setFreeSpace(this.getFreeSpace() - dataRecoveryBlock.getFreeSpace());
                                this.setUsedSpace(this.getUsedSpace() + usedDataRecoveryBlock.getUsedSpace());
                                this.setOverheadSpace(this.getOverheadSpace() + usedDataRecoveryBlock.getOverheadSpace());
                                break block31;
                            }
                            this.remainingChunks -= n2;
                            int n4 = n2 * chunkSize - usedDataRecoveryBlock.getTotalSize();
                            this.setFreeSpace(this.remainingChunks * chunkSize);
                            this.setUsedSpace(this.getUsedSpace() + usedDataRecoveryBlock.getUsedSpace());
                            this.setOverheadSpace(this.getOverheadSpace() + usedDataRecoveryBlock.getOverheadSpace() + n4);
                        }
                        if (!this.isSubscribed()) return bl;
                        long l = System.currentTimeMillis();
                        if (l - this.lastMillisFired <= 1000L) return bl;
                        this.fireSizesUpdated(null);
                        this.lastMillisFired = l;
                    }
                }
                catch (Exception exception) {
                    log.error("Append data: error replacing same size free block with used block, aborting: ", (Throwable)exception);
                    return false;
                }
            }
            if (dataRecoveryBlock.getFreeSpace() <= n) {
                throw new DataRecoveryStoreFullException();
            }
            try {
                UsedDataRecoveryBlock usedDataRecoveryBlock = new UsedDataRecoveryBlock(by, byArray.length, byArray, byArray2.length, byArray2);
                FreeDataRecoveryBlock freeDataRecoveryBlock = null;
                freeDataRecoveryBlock = chunkSize <= 0 ? new FreeDataRecoveryBlock(dataRecoveryBlock.getTotalSize() - usedDataRecoveryBlock.getTotalSize(), true) : new FreeDataRecoveryBlock((this.remainingChunks - n2) * chunkSize, true);
                this.blocks.add(n3 + 1, freeDataRecoveryBlock);
                this.blocks.set(n3, usedDataRecoveryBlock);
                usedDataRecoveryBlock.write(this.activeFileDataOutputStream);
                this.activeFileDataOutputStream.flush();
                if (!BDataRecoveryService.chunkFSPresent) {
                    this.activeFileFileOutputStream.getFD().sync();
                }
                bl = true;
                Object object3 = this.sizeMonitor;
                synchronized (object3) {
                    block33: {
                        block32: {
                            if (chunkSize > 0) break block32;
                            this.setFreeSpace(this.getFreeSpace() - usedDataRecoveryBlock.getTotalSize());
                            this.setUsedSpace(this.getUsedSpace() + usedDataRecoveryBlock.getUsedSpace());
                            this.setOverheadSpace(this.getOverheadSpace() + usedDataRecoveryBlock.getOverheadSpace());
                            break block33;
                        }
                        this.remainingChunks -= n2;
                        int n5 = n2 * chunkSize - usedDataRecoveryBlock.getTotalSize();
                        this.setFreeSpace(this.remainingChunks * chunkSize);
                        this.setUsedSpace(this.getUsedSpace() + usedDataRecoveryBlock.getUsedSpace());
                        this.setOverheadSpace(this.getOverheadSpace() + usedDataRecoveryBlock.getOverheadSpace() + n5);
                    }
                    if (!this.isSubscribed()) return bl;
                    long l = System.currentTimeMillis();
                    if (l - this.lastMillisFired <= 1000L) return bl;
                    this.fireSizesUpdated(null);
                    this.lastMillisFired = l;
                }
            }
            catch (Exception exception) {
                log.error("Append data: error adding used block in free block split, aborting: ", (Throwable)exception);
                return false;
            }
            return bl;
        }
    }

    public final boolean updateData(byte by, byte[] byArray, byte[] byArray2) throws DataRecoveryException {
        return this.appendData(by, byArray, byArray2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.activeFileDataOutputStream = null;
        this.activeFileFileOutputStream = null;
    }

    public BDataRecoveryBlockAppendManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockAppendManager;
        if (clazz == null) {
            clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockAppendManager = BDataRecoveryBlockAppendManager.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockAppendManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

