/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery;

import com.tridium.platDataRecovery.BDataRecoveryServiceStatus;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockAppendManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.collection.DataRecoveryLinkedList;
import com.tridium.platDataRecovery.config.BDataRecoveryConfig;
import com.tridium.platDataRecovery.config.BDataRecoveryFullPolicy;
import com.tridium.platDataRecovery.config.BDataRecoveryPersistenceCapacity;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInactiveException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockUnavailableException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreFullException;
import com.tridium.platDataRecovery.test.BDataRecoveryTestArguments;
import com.tridium.platDataRecovery.test.BDataRecoveryTester;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.util.EscUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.DataRecoveryInvalidKeyException;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.DataRecoveryTooLargeException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.io.BIEncodable;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDataRecoveryService
extends BPlatformService
implements BIAlarmablePlatformService,
BIDataRecoveryService,
BIDataRecoverySource {
    public static final Property enabled = BDataRecoveryService.newProperty((int)0, (boolean)true, null);
    public static final Property dataRecoveryStatus = BDataRecoveryService.newProperty((int)3, (BValue)BDataRecoveryServiceStatus.unknown, null);
    public static final Property lastStationSave = BDataRecoveryService.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property lastStationSaveSuccessful = BDataRecoveryService.newProperty((int)3, (boolean)false, null);
    public static final Property persistentStorageSize = BDataRecoveryService.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String[])new String[]{"units", "min", "max"}, (BIDataValue[])new BIDataValue[]{BUnit.make((String)"kilobyte", (String)"KB", (BDimension)BDimension.NULL, (double)1024.0), BDouble.make((double)0.0), BDouble.POSITIVE_INFINITY}));
    public static final Property dataRecoveryConfiguration = BDataRecoveryService.newProperty((int)3, (BValue)new BDataRecoveryConfig(), null);
    public static final Property dataRecoveryBlocks = BDataRecoveryService.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property alertOnReplay = BDataRecoveryService.newProperty((int)0, (boolean)false, null);
    public static final Property dataRecoveryAlarmSupport = BDataRecoveryService.newProperty((int)0, (BValue)BDataRecoveryService.initDataRecoveryAlarmSupport(), null);
    public static final Property dataRecoveryAlarmProxy = BDataRecoveryService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property tooManySaves = BDataRecoveryService.newProperty((int)3, (boolean)false, null);
    public static final Property stationSaveLimit = BDataRecoveryService.newProperty((int)1, (int)3, (BFacets)BFacets.make((String[])new String[]{"min"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1)}));
    public static final Property stationSaveLimitPeriod = BDataRecoveryService.newProperty((int)1, (BValue)BRelTime.make((long)900000L), (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.make((long)0L), BBoolean.FALSE}));
    public static final Action clearStationSaveCount = BDataRecoveryService.newAction((int)4, null);
    public static final Action handleMinSaveTimeout = BDataRecoveryService.newAction((int)4, null);
    public static final Action dumpRecoveryData = BDataRecoveryService.newAction((int)4, null);
    public static final Action refreshPersistentStorageSize = BDataRecoveryService.newAction((int)4, null);
    public static final Action testDataRecovery = BDataRecoveryService.newAction((int)4, (BValue)new BDataRecoveryTestArguments(), null);
    public static final Action resetDataRecoveryStatistics = BDataRecoveryService.newAction((int)4, null);
    public static final Action handleConfigChange = BDataRecoveryService.newAction((int)4, null);
    public static final Topic blocksWritten = BDataRecoveryService.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final Comparator BLOCK_MANAGER_SEQUENCE_COMPARATOR;
    private static final Comparator ACTIVE_FILE_SEQUENCE_COMPARATOR;
    private static final Log log;
    public static boolean chunkFSPresent;
    public static final String DATA_RECOVERY_FILE_EXTENSION = ".drdb";
    public static final String DATA_RECOVERY_FILE_RESERVED_EXTENSION = ".drdbr";
    public static final String DATA_RECOVERY_FILE_CHUNK_EXTENSION = ".chunkfs";
    public static final String DATA_RECOVERY_FILE_CHUNK_PREFIX = "chunkfs";
    public static final String DATA_RECOVERY_FILE_PREFIX = "datarecoveryblock";
    private static final String LICENSE_FEATURE = "dataRecovery";
    private static final String LICENSE_VENDOR = "tridium";
    public static final FileFilter DATA_RECOVERY_FILE_FILTER;
    public static final FileFilter DATA_RECOVERY_WORKING_FILE_FILTER;
    public static final byte SELF_ORD_AS_BYTE = 0;
    public static final byte[] APPLICATIONS_KEY_AS_BYTES;
    public static final byte[] TOO_LARGE_EVENT_AS_BYTES;
    public static final BBlob TOO_LARGE_EVENT_AS_BLOB;
    public static final BBlob APPLICATIONS_KEY_AS_BLOB;
    private static final double DATA_RECOVERY_MAX_FILESPACE;
    private static int chunkfsDeviceSize;
    private static int chunkfsNumFiles;
    private static int chunkfsChunkSize;
    private static int chunkfsNumChunks;
    private Clock.Ticket clearStationSaveTimer;
    int stationSavesGenerated;
    private final Object receivedMonitor;
    private final Object flushedMonitor;
    private long totalBytesReceivedSinceStart;
    private long totalBytesFlushedSinceStart;
    private long timesFlushedSinceStart;
    private double averageBytesFlushedPerFlush;
    private long serviceStartTimeMilliseconds;
    private double averageBytesFlushedPerSecondSinceStart;
    private double averageBytesReceivedPerSecondSinceStart;
    private long numberOfRecordsReceivedSinceStart;
    private double averageRecordSize;
    private long tooLargeEventsSinceStart;
    private long ticksOfLastTooLargeEvent;
    private long ticksOfLastSaveStarted;
    private final Object blockMonitor;
    private boolean serviceStarted;
    private boolean shutdownStarted;
    private final Object applicationMonitor;
    private HashMap knownApplications;
    private int externalApplicationsEncountered;
    private BDataRecoveryConfig lastConfig;
    private boolean replayOccurred;
    private final Object bufferUtilMonitor;
    private final ByteBuffer bufferUtil;
    private final TimeoutSaveManager timeoutSaveManager;
    private long persistentFileCounter;
    private long activeSequenceNumber;
    static /* synthetic */ Class class$com$tridium$platDataRecovery$BDataRecoveryService;
    static /* synthetic */ Class class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager;
    static /* synthetic */ Class class$java$lang$Long;

    public final boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public final void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public final BDataRecoveryServiceStatus getDataRecoveryStatus() {
        return (BDataRecoveryServiceStatus)this.get(dataRecoveryStatus);
    }

    public final void setDataRecoveryStatus(BDataRecoveryServiceStatus bDataRecoveryServiceStatus) {
        this.set(dataRecoveryStatus, (BValue)bDataRecoveryServiceStatus, null);
    }

    public final BAbsTime getLastStationSave() {
        return (BAbsTime)this.get(lastStationSave);
    }

    public final void setLastStationSave(BAbsTime bAbsTime) {
        this.set(lastStationSave, (BValue)bAbsTime, null);
    }

    public final boolean getLastStationSaveSuccessful() {
        return this.getBoolean(lastStationSaveSuccessful);
    }

    public final void setLastStationSaveSuccessful(boolean bl) {
        this.setBoolean(lastStationSaveSuccessful, bl, null);
    }

    public final double getPersistentStorageSize() {
        return this.getDouble(persistentStorageSize);
    }

    public final void setPersistentStorageSize(double d) {
        this.setDouble(persistentStorageSize, d, null);
    }

    public final BDataRecoveryConfig getDataRecoveryConfiguration() {
        return (BDataRecoveryConfig)this.get(dataRecoveryConfiguration);
    }

    public final void setDataRecoveryConfiguration(BDataRecoveryConfig bDataRecoveryConfig) {
        this.set(dataRecoveryConfiguration, (BValue)bDataRecoveryConfig, null);
    }

    public final BVector getDataRecoveryBlocks() {
        return (BVector)this.get(dataRecoveryBlocks);
    }

    public final void setDataRecoveryBlocks(BVector bVector) {
        this.set(dataRecoveryBlocks, (BValue)bVector, null);
    }

    public final boolean getAlertOnReplay() {
        return this.getBoolean(alertOnReplay);
    }

    public final void setAlertOnReplay(boolean bl) {
        this.setBoolean(alertOnReplay, bl, null);
    }

    public final BPlatformAlarmSupport getDataRecoveryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(dataRecoveryAlarmSupport);
    }

    public final void setDataRecoveryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(dataRecoveryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public final BPlatformAlarmProxy getDataRecoveryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(dataRecoveryAlarmProxy);
    }

    public final void setDataRecoveryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(dataRecoveryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public final boolean getTooManySaves() {
        return this.getBoolean(tooManySaves);
    }

    public final void setTooManySaves(boolean bl) {
        this.setBoolean(tooManySaves, bl, null);
    }

    public final int getStationSaveLimit() {
        return this.getInt(stationSaveLimit);
    }

    public final void setStationSaveLimit(int n) {
        this.setInt(stationSaveLimit, n, null);
    }

    public final BRelTime getStationSaveLimitPeriod() {
        return (BRelTime)this.get(stationSaveLimitPeriod);
    }

    public final void setStationSaveLimitPeriod(BRelTime bRelTime) {
        this.set(stationSaveLimitPeriod, (BValue)bRelTime, null);
    }

    public final BBoolean clearStationSaveCount() {
        return (BBoolean)this.invoke(clearStationSaveCount, null, null);
    }

    public final BBoolean handleMinSaveTimeout() {
        return (BBoolean)this.invoke(handleMinSaveTimeout, null, null);
    }

    public final BBoolean dumpRecoveryData() {
        return (BBoolean)this.invoke(dumpRecoveryData, null, null);
    }

    public final BBoolean refreshPersistentStorageSize() {
        return (BBoolean)this.invoke(refreshPersistentStorageSize, null, null);
    }

    public final BBoolean testDataRecovery(BDataRecoveryTestArguments bDataRecoveryTestArguments) {
        return (BBoolean)this.invoke(testDataRecovery, (BValue)bDataRecoveryTestArguments, null);
    }

    public final BBoolean resetDataRecoveryStatistics() {
        return (BBoolean)this.invoke(resetDataRecoveryStatistics, null, null);
    }

    public final BBoolean handleConfigChange() {
        return (BBoolean)this.invoke(handleConfigChange, null, null);
    }

    public final void fireBlocksWritten(BValue bValue) {
        this.fire(blocksWritten, bValue, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type[] getServiceTypes() {
        return new Type[]{BIDataRecoveryService.TYPE, TYPE};
    }

    public final int getSlotFlags() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void serviceStarted() throws Exception {
        Object object;
        if (this.serviceStarted) {
            return;
        }
        if (!this.getEnabled()) {
            log.trace("Data Recovery Service is disabled, preventing startup");
            return;
        }
        try {
            object = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            object.check();
        }
        catch (Exception exception) {
            log.error("Error starting service: ", (Throwable)exception);
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            this.serviceStarted = false;
            throw new DataRecoveryServiceInFaultException("Error starting service: ", (Throwable)exception);
        }
        if (!this.isValidPlatform()) {
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            throw new DataRecoveryServiceInFaultException("Data recovery Service is not suppoted on the current platform, setting status to fault.");
        }
        if (new File("/etc/format-sramopt").exists()) {
            log.warning("The file \"/etc/format-sramopt\" is present, DATA WILL NOT BE RECOVERED on next power cycle.");
        }
        super.serviceStarted();
        this.serviceStarted = true;
        if (log.isTraceOn()) {
            log.trace("Service starting");
        }
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.starting);
        try {
            object = this.applicationMonitor;
            synchronized (object) {
                this.knownApplications = new HashMap();
                this.knownApplications.put(this.getOrdInSession(), new ApplicationEntry(this.getOrdInSession().encodeToString(), 0, 0L));
                this.externalApplicationsEncountered = 0;
            }
            object = this.blockMonitor;
            synchronized (object) {
                this.configureDataRecoveryBlocks(this.getDataRecoveryConfiguration(), true);
                // MONITOREXIT @DISABLED, blocks:[1, 3, 5] lbl42 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
                this.doRefreshPersistentStorageSize();
            }
            this.linkTo(this.getDataRecoveryConfiguration(), (Slot)BDataRecoveryConfig.configurationChanged, (Slot)handleConfigChange);
            Nre.spySysManagers.add("dataRecoveryManager", (Spy)new DataRecoveryServiceSpyPage());
            this.serviceStartTimeMilliseconds = System.currentTimeMillis();
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.ready);
            return;
        }
        catch (Exception exception) {
            log.error("Error starting service: ", (Throwable)exception);
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            this.serviceStarted = false;
            throw new DataRecoveryServiceInFaultException("Error starting service: ", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void serviceStopped() throws Exception {
        block20: {
            if (!this.serviceStarted) {
                return;
            }
            super.serviceStopped();
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.stopping);
            if (this.clearStationSaveTimer != null) {
                this.clearStationSaveTimer.cancel();
            }
            var1_1 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
            synchronized (var1_1) {
                var3_2 /* !! */  = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                var4_4 = 0;
                while (true) {
                    if (var4_4 >= var3_2 /* !! */ .length) {
                        break;
                    }
                    if (!var3_2 /* !! */ [var4_4].delete()) {
                        BDataRecoveryService.log.error("Error deleting persistent file: " + var3_2 /* !! */ [var4_4] + ", unintended data recovery may replay on start.");
                    }
                    ++var4_4;
                }
            }
            var1_1 = BDataRecoveryBlockManager.activeDirectoryMonitor;
            synchronized (var1_1) {
                ** try [egrp 2[TRYBLOCK] [5 : 129->215)] { 
lbl26:
                // 1 sources

                {
                    var3_2 /* !! */  = this.blockMonitor;
                    synchronized (var3_2 /* !! */ ) {
                        var5_5 = null;
                        var6_6 = this.getDataRecoveryBlocks().getProperties();
                        while (true) {
                            if ((v3 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) == null) {
                                v3 = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                            }
                            if (!var6_6.next(v3)) {
                                this.getDataRecoveryBlocks().removeAll();
                                break block20;
                            }
                            var5_5 = (BDataRecoveryBlockManager)var6_6.get();
                            var5_5.closeActiveFile();
                        }
                    }
                }
lbl46:
                // 1 sources

                catch (Exception var3_3) {
                    BDataRecoveryService.log.error("Error stopping service: ", (Throwable)var3_3);
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                }
            }
        }
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.stopped);
        if (BDataRecoveryService.log.isTraceOn()) {
            BDataRecoveryService.log.trace("Service stopped");
        }
        this.serviceStarted = false;
    }

    public final String getLicenseFeature() {
        return LICENSE_FEATURE;
    }

    public final String getLicenseVendor() {
        return LICENSE_VENDOR;
    }

    public final boolean isValidPlatform() {
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx)) {
            return new File("/sram").exists() || new File("/sramopt").exists();
        }
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.windows)) {
            try {
                if (System.getProperty("niagara.platDataRecovery.development", "false").equalsIgnoreCase("true")) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }
        String string = System.getProperty("niagara.platDataRecovery.mountPath");
        return string != null && new File(string).exists();
    }

    public final void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!this.serviceStarted) {
            return;
        }
    }

    public final void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        if (this.replayOccurred) {
            if (this.getAlertOnReplay()) {
                this.getDataRecoveryAlarmProxy().setAlarmSupport(this.getDataRecoveryAlarmSupport());
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getDataRecoveryAlarmSupport().makeNewAlert();
                this.getDataRecoveryAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
            this.replayOccurred = false;
        }
        this.clearStationSaveTimer = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getStationSaveLimitPeriod(), (Action)clearStationSaveCount, null);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 1001) {
            BDataRecoveryConfig bDataRecoveryConfig = BDataRecoveryService.generatePlatformConfiguration();
            if (bDataRecoveryConfig == null) {
                log.error("Error generating platform configuration, service will be disabled");
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            } else {
                this.setDataRecoveryConfiguration(bDataRecoveryConfig);
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private static final BDataRecoveryConfig generatePlatformConfiguration() {
        BDataRecoveryConfig bDataRecoveryConfig = new BDataRecoveryConfig();
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        bSystemPlatformService.checkPropertiesLoaded();
        BString bString = null;
        BFilesystemAttributes bFilesystemAttributes = null;
        bDataRecoveryConfig.setActiveFullPolicy(BDataRecoveryFullPolicy.flush);
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx)) {
            chunkFSPresent = true;
            bDataRecoveryConfig.setPersistentDirectory(Nre.stationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE);
            bString = bSystemPlatformService.getFilesystemForPath(BString.make((String)bDataRecoveryConfig.getPersistentDirectory()));
            bFilesystemAttributes = (BFilesystemAttributes)bSystemPlatformService.getFilesystemAttributes().get(SlotPath.escape((String)bString.getString()));
            int n = (int)(bFilesystemAttributes.getFreeSpace() * 1024L);
            bDataRecoveryConfig.setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeByStorageSize((int)Math.floor((double)n * DATA_RECOVERY_MAX_FILESPACE)));
            if (new File("/sram").exists()) {
                bDataRecoveryConfig.setActiveDirectory("/sram");
            } else if (new File("/sramopt").exists()) {
                bDataRecoveryConfig.setActiveDirectory("/sramopt");
            }
            try {
                BDataRecoveryService.loadGeom(bDataRecoveryConfig.getActiveDirectory() + "/geom");
            }
            catch (Exception exception) {
                log.error("Error loading chunkfs geometry: ", (Throwable)exception);
                return null;
            }
            bDataRecoveryConfig.setNumberBlocks(chunkfsNumFiles);
            bDataRecoveryConfig.setDataRecoverySize(chunkfsDeviceSize);
            BDataRecoveryBlockManager.setChunkSize(chunkfsChunkSize);
            BDataRecoveryBlockManager.setTotalChunks(chunkfsNumChunks);
        } else if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.windows)) {
            chunkFSPresent = false;
            bDataRecoveryConfig.setActiveDirectory(Nre.stationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE + File.separator + "active");
            bDataRecoveryConfig.setPersistentDirectory(Nre.stationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE + File.separator + "persist");
            bDataRecoveryConfig.setDataRecoverySize(524288);
            bDataRecoveryConfig.setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeUnlimited());
        } else if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.linux)) {
            String string;
            chunkFSPresent = true;
            String string2 = Nre.stationHome.getAbsolutePath() + File.separator + LICENSE_FEATURE;
            String string3 = System.getProperty("niagara.platDataRecovery.persistentDirectoryPath", string2);
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdirs();
            }
            bDataRecoveryConfig.setPersistentDirectory(string3);
            bString = bSystemPlatformService.getFilesystemForPath(BString.make((String)bDataRecoveryConfig.getPersistentDirectory()));
            bFilesystemAttributes = (BFilesystemAttributes)bSystemPlatformService.getFilesystemAttributes().get(SlotPath.escape((String)bString.getString()));
            long l = 0L;
            l = bFilesystemAttributes == null ? 102400000L : bFilesystemAttributes.getFreeSpace() * 1024L;
            bDataRecoveryConfig.setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeByStorageSize((int)Math.floor((double)l * DATA_RECOVERY_MAX_FILESPACE)));
            try {
                string = System.getProperty("niagara.platDataRecovery.activeDirectoryPath");
                if (string == null) {
                    throw new Exception("niagara.platDataRecovery.activeDirectoryPath not defined");
                }
                if (!new File(string).exists()) {
                    throw new Exception("provided niagara.platDataRecovery.activeDirectoryPath path does not exist");
                }
                bDataRecoveryConfig.setActiveDirectory(string);
            }
            catch (Exception exception) {
                log.error("Error setting up active directory", (Throwable)exception);
                return null;
            }
            try {
                string = System.getProperty("niagara.platDataRecovery.geomPath");
                if (string == null) {
                    throw new Exception("niagara.platDataRecovery.geomPath not defined");
                }
                if (!new File(string).exists()) {
                    throw new Exception("provided niagara.platDataRecovery.geomPath path does not exist");
                }
                BDataRecoveryService.loadGeom(string);
            }
            catch (Exception exception) {
                log.error("Error loading chunkfs geometry: ", (Throwable)exception);
                return null;
            }
            bDataRecoveryConfig.setNumberBlocks(chunkfsNumFiles);
            bDataRecoveryConfig.setDataRecoverySize(chunkfsDeviceSize);
            BDataRecoveryBlockManager.setChunkSize(chunkfsChunkSize);
            BDataRecoveryBlockManager.setTotalChunks(chunkfsNumChunks);
        } else {
            throw new BajaRuntimeException("DataRecoveryPlatformSupport not available on current platform");
        }
        return bDataRecoveryConfig;
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (context == Context.decoding) {
            return;
        }
        if (!this.serviceStarted) {
            return;
        }
        if (property == persistentStorageSize) {
            double d;
            double d2 = this.getPersistentStorageSize();
            if (this.getDataRecoveryConfiguration().getPersistentStorageCapacity().isByStorageSize() && d2 >= (d = (double)this.getDataRecoveryConfiguration().getPersistentStorageCapacity().getMaxStorage()) / 1024.0 && !this.getDataRecoveryStatus().equals((Object)BDataRecoveryServiceStatus.saving) && !this.getDataRecoveryStatus().equals((Object)BDataRecoveryServiceStatus.replaying)) {
                log.message("Data recovery persistent storage capacity exceeded, saving station...");
                try {
                    ++this.stationSavesGenerated;
                    Station.saveAsync(null);
                }
                catch (Exception exception) {
                    log.error("Error while saving station: ", (Throwable)exception);
                }
            }
        } else if (property == dataRecoveryConfiguration) {
            this.dataRecoveryConfigChanged(this.getDataRecoveryConfiguration());
        } else if ((property == stationSaveLimitPeriod || property == stationSaveLimit) && this.clearStationSaveTimer != null) {
            this.clearStationSaveTimer.cancel();
            this.stationSavesGenerated = 0;
            this.clearStationSaveTimer = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getStationSaveLimitPeriod(), (Action)clearStationSaveCount, null);
        }
    }

    public final void dataRecoveryConfigChanged(BDataRecoveryConfig bDataRecoveryConfig) {
        if (!this.serviceStarted) {
            return;
        }
        if (bDataRecoveryConfig != this.getDataRecoveryConfiguration()) {
            return;
        }
        boolean bl = false;
        if (this.lastConfig != null) {
            boolean bl2 = true;
            if (bDataRecoveryConfig.getActiveDirectory().equals(this.lastConfig.getActiveDirectory())) {
                bl2 = bl;
            }
            bl = bl2;
            boolean bl3 = true;
            if (bDataRecoveryConfig.getPersistentDirectory().equals(this.lastConfig.getPersistentDirectory())) {
                bl3 = bl;
            }
            bl = bl3;
            boolean bl4 = true;
            if (bDataRecoveryConfig.getDataRecoverySize() == this.lastConfig.getDataRecoverySize()) {
                bl4 = bl;
            }
            bl = bl4;
            boolean bl5 = true;
            if (bDataRecoveryConfig.getNumberBlocks() == this.lastConfig.getNumberBlocks()) {
                bl5 = bl;
            }
            bl = bl5;
        }
        this.lastConfig = (BDataRecoveryConfig)bDataRecoveryConfig.newCopy(true);
        if (bl) {
            try {
                this.reconfigureDataRecoveryBlocks(bDataRecoveryConfig);
            }
            catch (Exception exception) {
                log.error("Error reconfiguring data recovery blocks: ", (Throwable)exception);
                this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void configureDataRecoveryBlocks(BDataRecoveryConfig var1_1, boolean var2_2) throws Exception {
        var3_3 = this.blockMonitor;
        synchronized (var3_3) {
            block40: {
                block39: {
                    block36: {
                        block37: {
                            var5_4 = this.getDataRecoveryStatus();
                            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.configuring);
                            var6_5 = var1_1.getActiveDirectory();
                            var7_6 = var1_1.getPersistentDirectory();
                            if (!var2_2 || !new File(var6_5).exists() || new File(var7_6).exists()) break block36;
                            var8_7 = false;
                            var9_11 = new File(var6_5);
                            var10_12 = var9_11.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                            if (var10_12.length == 0) break block37;
                            var11_14 = null;
                            var12_20 = 0;
                            while (var12_20 < var10_12.length) {
                                var11_14 = var10_12[var12_20];
                                if (BDataRecoveryService.lengthOfFile(var11_14) != 0L) {
                                    var8_7 = true;
                                    break;
                                }
                                ++var12_20;
                            }
                        }
                        if (var8_7) {
                            BDataRecoveryService.log.warning("Truncating data in active directory, it was not generated by this instance of the service");
                            var11_15 = 0;
                            while (var11_15 < var10_12.length) {
                                if (BDataRecoveryService.chunkFSPresent) {
                                    try {
                                        var12_21 = new FileOutputStream(var10_12[var11_15], false);
                                        var12_21.close();
                                    }
                                    catch (Exception v1) {}
                                } else if (!var10_12[var11_15].delete()) {
                                    BDataRecoveryService.log.error("Error deleting uninitialized active file: " + var10_12[var11_15]);
                                }
                                ++var11_15;
                            }
                        }
                    }
                    try {
                        BDataRecoveryBlockManager.initializeDirectories(var6_5, var7_6);
                        var8_8 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
                        synchronized (var8_8) {
                            var10_12 = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(BDataRecoveryService.DATA_RECOVERY_WORKING_FILE_FILTER);
                            var11_16 = 0;
                            while (true) {
                                if (var11_16 >= var10_12.length) {
                                    break;
                                }
                                var12_22 = var10_12[var11_16];
                                var12_22.delete();
                                ++var11_16;
                            }
                        }
                    }
                    catch (Exception var8_9) {
                        BDataRecoveryService.log.error("Error initializing data recovery directories: ", (Throwable)var8_9);
                        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                        throw var8_9;
                    }
                    if (var2_2 && BDataRecoveryBlockManager.recoveryDataExists()) {
                        BDataRecoveryService.log.warning("Recovery data detected, replaying...");
                        var8_8 = this.doReplayRecoveryData();
                        if (!var8_8.getBoolean()) {
                            BDataRecoveryService.log.error("Error replaying recovery data!");
                            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                            return;
                        }
                        this.replayOccurred = true;
                    }
                    var8_10 = var1_1.getNumberBlocks();
                    var9_11 = null;
                    var10_13 = true;
                    var11_16 = 0;
                    while (var11_16 < var8_10) {
                        var12_23 = null;
                        var12_23 = BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx) != false ? var11_16 + ".chunkfs" : (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.linux) != false ? "chunkfs" + var11_16 : "datarecoveryblock" + var11_16 + ".drdb");
                        var9_11 = new BDataRecoveryBlockAppendManager();
                        if (BDataRecoveryService.chunkFSPresent) {
                            var9_11.setMaxCapacity(BDataRecoveryService.chunkfsChunkSize * BDataRecoveryService.chunkfsNumChunks);
                        } else {
                            var9_11.setMaxCapacity(var1_1.getCritcalDataBlockSize());
                        }
                        var9_11.openActiveFile(var12_23);
                        this.linkTo(null, (BComponent)var9_11, (Slot)BDataRecoveryBlockManager.blockFlushed, (Slot)BDataRecoveryService.refreshPersistentStorageSize);
                        if (!var9_11.isEmpty()) {
                            var10_13 = false;
                        }
                        this.getDataRecoveryBlocks().add(SlotPath.escape((String)("datarecoveryblock" + var11_16)), (BValue)var9_11, 3);
                        ++var11_16;
                    }
                    if (!var10_13) break block39;
                    BDataRecoveryService.log.trace("All data block managers are empty, activating first block...");
                    var11_16 = 1;
                    var12_24 = this.getDataRecoveryBlocks().getProperties();
                    if (true) ** GOTO lbl118
                }
                BDataRecoveryService.log.trace("Data block managers were non empty, flushing contents to flash...");
                v3 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager;
                if (v3 == null) {
                    v3 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                }
                var11_17 = new Array(v3);
                v4 = BDataRecoveryService.class$java$lang$Long;
                if (v4 == null) {
                    v4 = BDataRecoveryService.class$java$lang$Long = BDataRecoveryService.class("[Ljava.lang.Long;", false);
                }
                var12_25 = new Array(v4);
                var13_26 = this.getDataRecoveryBlocks().getProperties();
                if (true) ** GOTO lbl128
                do {
                    var9_11 = (BDataRecoveryBlockManager)var12_24.get();
                    if (var11_16 != 0) {
                        var9_11.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                        var11_16 = 0;
                    } else {
                        var9_11.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                    }
lbl118:
                    // 3 sources

                    if ((v5 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) != null) continue;
                    v5 = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                } while (var12_24.next(v5));
                break block40;
                do {
                    var9_11 = (BDataRecoveryBlockManager)var13_26.get();
                    var11_17.add(var9_11);
                    var12_25.add((Object)new Long(BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(BDataRecoveryBlockManager.replayRecoveryDataHelper(var9_11.getFile(), true))));
lbl128:
                    // 2 sources

                    if ((v6 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) != null) continue;
                    v6 = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                } while (var13_26.next(v6));
                var13_26 = (BDataRecoveryBlockManager[])var11_17.trim();
                var14_27 = (Long[])var12_25.trim();
                SortUtil.sort((Object[])var14_27, (Object[])var13_26, (Comparator)BDataRecoveryService.BLOCK_MANAGER_SEQUENCE_COMPARATOR);
                var15_28 = 0;
                while (var15_28 < var13_26.length) {
                    var16_29 = String.valueOf(this.persistentFileCounter++);
                    var13_26[var15_28].doFlushRecoveryData(var16_29 + ".drdb");
                    var13_26[var15_28].setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                    ++var15_28;
                }
                var13_26[0].setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                BDataRecoveryService.log.trace("Flush of old data complete.");
            }
            if (this.replayOccurred) {
                try {
                    var11_18 = this.serializeKnownApplications();
                    if (var11_18.length != 0) {
                        this.append(this, (BIEncodable)BDataRecoveryService.APPLICATIONS_KEY_AS_BLOB, var11_18);
                    }
                }
                catch (Exception var11_19) {
                    BDataRecoveryService.log.error("Error persisting previously known application map: ", (Throwable)var11_19);
                }
            }
            this.setDataRecoveryStatus(var5_4);
        }
        this.fireBlocksWritten(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void reconfigureDataRecoveryBlocks(BDataRecoveryConfig var1_1) throws Exception {
        var2_2 = BDataRecoveryService.log.isTraceOn();
        if (var2_2) {
            BDataRecoveryService.log.trace("Reconfiguring data recovery blocks...");
        }
        var3_3 = this.blockMonitor;
        synchronized (var3_3) {
            block14: {
                var5_4 = null;
                var6_5 /* !! */  = this.getDataRecoveryBlocks().getProperties();
                while (true) {
                    if ((v1 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) == null) {
                        v1 = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                    }
                    if (!var6_5 /* !! */ .next(v1)) {
                        this.getDataRecoveryBlocks().removeAll();
                        ** try [egrp 1[TRYBLOCK] [2 : 153->199)] { 
lbl18:
                        // 1 sources

                        break;
                    }
                    var5_4 = (BDataRecoveryBlockManager)var6_5 /* !! */ .get();
                    if (var1_1.getActiveFullPolicy() == BDataRecoveryFullPolicy.flush) {
                        var7_8 = String.valueOf(this.persistentFileCounter++);
                        var5_4.doFlushRecoveryData(var7_8 + ".drdb");
                    }
                    var5_4.closeActiveFile();
                }
                {
                    this.configureDataRecoveryBlocks(var1_1, false);
                    try {
                        var6_5 /* !! */  = (SlotCursor)this.serializeKnownApplications();
                        if (((SlotCursor)var6_5 /* !! */ ).length != 0) {
                            this.append(this, (BIEncodable)BDataRecoveryService.APPLICATIONS_KEY_AS_BLOB, (byte[])var6_5 /* !! */ );
                        }
                        break block14;
                    }
                    catch (Exception var6_6) {
                        BDataRecoveryService.log.warning("Failed to append application list on reconfiguration.");
                    }
                }
lbl37:
                // 1 sources

                catch (Exception var6_7) {
                    BDataRecoveryService.log.error("Error reconfiguring data recovery blocks: ", (Throwable)var6_7);
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                    throw var6_7;
                }
            }
            ** if (!var2_2) goto lbl44
        }
lbl-1000:
        // 1 sources

        {
            BDataRecoveryService.log.trace("Finished reconfiguring blocks");
        }
lbl44:
        // 2 sources

    }

    public final boolean isEnabled() {
        return this.getEnabled();
    }

    public final boolean append(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray) throws BajaRuntimeException {
        return this.append(bIDataRecoverySource, bIEncodable, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean append(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray, int n, int n2) throws BajaRuntimeException {
        Object object;
        Exception exception;
        byte[] byArray2;
        byte[] byArray3;
        boolean bl;
        byte by;
        block46: {
            if (!this.serviceStarted) {
                throw new DataRecoveryServiceInFaultException("Service not started");
            }
            BDataRecoveryServiceStatus bDataRecoveryServiceStatus = this.getDataRecoveryStatus();
            if (bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.ready && bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.saving && bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.configuring) {
                throw new DataRecoveryServiceInFaultException("Can not append data recovery at this time, state is " + (Object)((Object)this.getDataRecoveryStatus()));
            }
            if (bIDataRecoverySource == null) {
                throw new NullPointerException("Provided source can not be null");
            }
            if (bIEncodable == null) {
                throw new DataRecoveryInvalidKeyException("Provided key can not be null");
            }
            if (byArray == null) {
                throw new NullPointerException("Provided data can not be null");
            }
            if (n < 0) {
                throw new DataRecoveryException("Invalid data offset, offset < 0");
            }
            if (n >= byArray.length && byArray.length != 0) {
                throw new DataRecoveryException("Invalid data offset, offset >= non-zero data.length");
            }
            if (n2 < 0) {
                throw new DataRecoveryException("Invalid data length, length < 0");
            }
            if (n2 > byArray.length - n) {
                n2 = byArray.length - n;
            }
            by = 0;
            bl = log.isTraceOn();
            byArray3 = null;
            byArray2 = null;
            exception = null;
            Object object2 = this.bufferUtilMonitor;
            synchronized (object2) {
                try {
                    this.bufferUtil.reset();
                    bIEncodable.encode((DataOutput)this.bufferUtil);
                    byArray3 = this.bufferUtil.toByteArray();
                    this.bufferUtil.reset();
                    this.bufferUtil.write(byArray, n, n2);
                    byArray2 = this.bufferUtil.toByteArray();
                }
                catch (Exception exception2) {
                    log.error("Could not encode data recovery key: ", (Throwable)exception2);
                    byArray3 = null;
                    exception = exception2;
                }
                if (byArray2 != null) break block46;
                throw new DataRecoveryException("Invalid data, recoveryData == null after byte array conversion");
            }
        }
        if (byArray3 == null) {
            if (exception == null) throw new DataRecoveryInvalidKeyException("Invalid key, data recovery == null after encoding");
            throw new DataRecoveryInvalidKeyException("Could not encode data recovery key: " + exception.getMessage());
        }
        BOrd bOrd = null;
        try {
            bOrd = bIDataRecoverySource.getOrdInSession();
        }
        catch (Exception exception3) {
            log.error("Could not obtain source ord: ", (Throwable)exception3);
            return false;
        }
        if (bOrd.equals((Object)this.getOrdInSession()) && bIDataRecoverySource == this) {
            if (bl) {
                log.trace("Narcissistic append(encoded key bytes: " + bIEncodable.toString() + ", data bytes: " + TextUtil.bytesToHexString((byte[])byArray2) + ')');
            }
        } else {
            if (bl) {
                log.trace("External append(" + bOrd + ", encoded key bytes: " + bIEncodable.toString() + ", data bytes: " + TextUtil.bytesToHexString((byte[])byArray2) + ')');
            }
            Object object3 = this.applicationMonitor;
            synchronized (object3) {
                ApplicationEntry applicationEntry = (ApplicationEntry)this.knownApplications.get(bOrd);
                if (applicationEntry == null) {
                    if (bl) {
                        log.trace("Append encountered new data recovery source: " + bOrd);
                    }
                    ++this.externalApplicationsEncountered;
                    if (this.externalApplicationsEncountered != (byte)this.externalApplicationsEncountered) {
                        throw new DataRecoveryException("Data Recovery Service can not respond to request from source: " + bOrd + ", byte overflow detected.");
                    }
                    by = (byte)this.externalApplicationsEncountered;
                    this.knownApplications.put(bOrd, new ApplicationEntry(bOrd.encodeToString(), by, byArray2.length + byArray3.length));
                    try {
                        byte[] byArray4 = this.serializeKnownApplications();
                        if (byArray4.length != 0) {
                            this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, byArray4);
                        }
                    }
                    catch (Exception exception4) {
                        log.error("Error persisting known application map: ", (Throwable)exception4);
                        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                        return false;
                    }
                    if (bl) {
                        log.trace("Successfully appended data recovery source");
                    }
                } else {
                    by = applicationEntry.getId();
                    applicationEntry.updateMetrics(byArray2.length + byArray3.length);
                }
            }
        }
        boolean bl2 = false;
        int n3 = 0;
        while (n3 <= 1) {
            try {
                object = this.blockMonitor;
                synchronized (object) {
                    if (this.shutdownStarted) {
                        if (!bl) return true;
                        log.trace("Ignoring external append(" + bOrd + ", encoded key bytes: " + bIEncodable.toString() + "), application is shutting down");
                        return true;
                    }
                    bl2 = this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.saving ? this.getBlock(BDataRecoveryBlockManagerStatus.reserved).appendData(by, byArray3, byArray2) : this.getBlock(BDataRecoveryBlockManagerStatus.active).appendData(by, byArray3, byArray2);
                    break;
                }
            }
            catch (DataRecoveryStoreFullException dataRecoveryStoreFullException) {
                if (this.getDataRecoveryConfiguration().getActiveFullPolicy() != BDataRecoveryFullPolicy.flush) continue;
                this.doFlushRecoveryData();
                ++n3;
            }
            catch (DataRecoveryTooLargeException dataRecoveryTooLargeException) {
                this.handleTooLargeEvent(dataRecoveryTooLargeException, bIDataRecoverySource);
                throw dataRecoveryTooLargeException;
            }
            catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
                this.checkIdleCondition();
            }
            catch (DataRecoveryBlockInactiveException dataRecoveryBlockInactiveException) {
                // empty catch block
            }
        }
        if (!bl2) {
            log.error("Attempt to append data with key: " + bIEncodable.toString() + " failed");
            return bl2;
        }
        object = this.receivedMonitor;
        synchronized (object) {
            ++this.numberOfRecordsReceivedSinceStart;
            this.totalBytesReceivedSinceStart += (long)(byArray2.length + byArray3.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize);
            this.averageBytesReceivedPerSecondSinceStart = (double)this.totalBytesReceivedSinceStart / (double)(System.currentTimeMillis() - this.serviceStartTimeMilliseconds) * 1000.0;
            this.averageRecordSize = (double)this.totalBytesReceivedSinceStart / (double)this.numberOfRecordsReceivedSinceStart;
            // MONITOREXIT @DISABLED, blocks:[7, 11] lbl142 : MonitorExitStatement: MONITOREXIT : var18_22
            if (!bl) return bl2;
        }
        log.trace("Attempt to append data with key encoded as bytes: " + bIEncodable.toString() + " successful");
        return bl2;
    }

    public final boolean update(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray) throws BajaRuntimeException {
        return this.update(bIDataRecoverySource, bIEncodable, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean update(BIDataRecoverySource bIDataRecoverySource, BIEncodable bIEncodable, byte[] byArray, int n, int n2) throws BajaRuntimeException {
        Object object;
        Exception exception;
        byte[] byArray2;
        byte[] byArray3;
        boolean bl;
        byte by;
        block46: {
            if (!this.serviceStarted) {
                throw new DataRecoveryServiceInFaultException("Service not started");
            }
            BDataRecoveryServiceStatus bDataRecoveryServiceStatus = this.getDataRecoveryStatus();
            if (bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.ready && bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.saving && bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.configuring) {
                throw new DataRecoveryServiceInFaultException("Can not update data recovery at this time, state is " + (Object)((Object)this.getDataRecoveryStatus()));
            }
            if (bIDataRecoverySource == null) {
                throw new NullPointerException("Provided source can not be null");
            }
            if (bIEncodable == null) {
                throw new DataRecoveryInvalidKeyException("Provided key can not be null");
            }
            if (byArray == null) {
                throw new NullPointerException("Provided data can not be null");
            }
            if (n < 0) {
                throw new DataRecoveryException("Invalid data offset, offset < 0");
            }
            if (n >= byArray.length && byArray.length != 0) {
                throw new DataRecoveryException("Invalid data offset, offset >= non-zero data.length");
            }
            if (n2 < 0) {
                throw new DataRecoveryException("Invalid data length, length < 0");
            }
            if (n2 > byArray.length - n) {
                n2 = byArray.length - n;
            }
            by = 0;
            bl = log.isTraceOn();
            byArray3 = null;
            byArray2 = null;
            exception = null;
            Object object2 = this.bufferUtilMonitor;
            synchronized (object2) {
                try {
                    this.bufferUtil.reset();
                    bIEncodable.encode((DataOutput)this.bufferUtil);
                    byArray3 = this.bufferUtil.toByteArray();
                    this.bufferUtil.reset();
                    this.bufferUtil.write(byArray, n, n2);
                    byArray2 = this.bufferUtil.toByteArray();
                }
                catch (Exception exception2) {
                    log.error("Could not encode data recovery key: ", (Throwable)exception2);
                    byArray3 = null;
                    exception = exception2;
                }
                if (byArray2 != null) break block46;
                throw new DataRecoveryException("Invalid data, recoveryData == null after byte array conversion");
            }
        }
        if (byArray3 == null) {
            if (exception == null) throw new DataRecoveryInvalidKeyException("Invalid key, data recovery == null after encoding");
            throw new DataRecoveryInvalidKeyException("Could not encode data recovery key: " + exception.getMessage());
        }
        BOrd bOrd = null;
        try {
            bOrd = bIDataRecoverySource.getOrdInSession();
        }
        catch (Exception exception3) {
            log.error("Could not obtain source ord: ", (Throwable)exception3);
            return false;
        }
        if (bOrd.equals((Object)this.getOrdInSession()) && bIDataRecoverySource == this) {
            if (bl) {
                log.trace("Narcissistic update(encoded key bytes: " + bIEncodable.toString() + ", data bytes: " + TextUtil.bytesToHexString((byte[])byArray2) + ')');
            }
        } else {
            if (bl) {
                log.trace("External update(" + bOrd + ", encoded key bytes: " + bIEncodable.toString() + ", data bytes: " + TextUtil.bytesToHexString((byte[])byArray2) + ')');
            }
            Object object3 = this.applicationMonitor;
            synchronized (object3) {
                ApplicationEntry applicationEntry = (ApplicationEntry)this.knownApplications.get(bOrd);
                if (applicationEntry == null) {
                    if (bl) {
                        log.trace("Update encountered new data recovery source: " + bOrd);
                    }
                    ++this.externalApplicationsEncountered;
                    if (this.externalApplicationsEncountered != (byte)this.externalApplicationsEncountered) {
                        throw new DataRecoveryException("Data Recovery Service can not respond to request from source: " + bOrd + ", byte overflow detected.");
                    }
                    by = (byte)this.externalApplicationsEncountered;
                    this.knownApplications.put(bOrd, new ApplicationEntry(bOrd.encodeToString(), by, byArray2.length + byArray3.length));
                    try {
                        byte[] byArray4 = this.serializeKnownApplications();
                        if (byArray4.length != 0) {
                            this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, byArray4);
                        }
                    }
                    catch (Exception exception4) {
                        log.error("Error persisting known application map: ", (Throwable)exception4);
                        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                        return false;
                    }
                    if (bl) {
                        log.trace("Successfully appended data recovery source");
                    }
                } else {
                    by = applicationEntry.getId();
                    applicationEntry.updateMetrics(byArray2.length + byArray3.length);
                }
            }
        }
        boolean bl2 = false;
        int n3 = 0;
        while (n3 <= 1) {
            try {
                object = this.blockMonitor;
                synchronized (object) {
                    if (this.shutdownStarted) {
                        if (!bl) return true;
                        log.trace("Ignoring external update(" + bOrd + ", encoded key bytes: " + bIEncodable.toString() + "), application is shutting down");
                        return true;
                    }
                    bl2 = this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.saving ? this.getBlock(BDataRecoveryBlockManagerStatus.reserved).updateData(by, byArray3, byArray2) : this.getBlock(BDataRecoveryBlockManagerStatus.active).updateData(by, byArray3, byArray2);
                    break;
                }
            }
            catch (DataRecoveryStoreFullException dataRecoveryStoreFullException) {
                if (this.getDataRecoveryConfiguration().getActiveFullPolicy() != BDataRecoveryFullPolicy.flush) continue;
                this.doFlushRecoveryData();
                ++n3;
            }
            catch (DataRecoveryTooLargeException dataRecoveryTooLargeException) {
                this.handleTooLargeEvent(dataRecoveryTooLargeException, bIDataRecoverySource);
                throw dataRecoveryTooLargeException;
            }
            catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
                this.checkIdleCondition();
            }
            catch (DataRecoveryBlockInactiveException dataRecoveryBlockInactiveException) {
                // empty catch block
            }
        }
        if (!bl2) {
            log.error("Attempt to update data with key: " + bIEncodable.toString() + " failed");
            return bl2;
        }
        object = this.receivedMonitor;
        synchronized (object) {
            ++this.numberOfRecordsReceivedSinceStart;
            this.totalBytesReceivedSinceStart += (long)(byArray2.length + byArray3.length + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize);
            this.averageBytesReceivedPerSecondSinceStart = (double)this.totalBytesReceivedSinceStart / (double)(System.currentTimeMillis() - this.serviceStartTimeMilliseconds) * 1000.0;
            this.averageRecordSize = (double)this.totalBytesReceivedSinceStart / (double)this.numberOfRecordsReceivedSinceStart;
            // MONITOREXIT @DISABLED, blocks:[7, 11] lbl142 : MonitorExitStatement: MONITOREXIT : var18_22
            if (!bl) return bl2;
        }
        log.trace("Attempt to update data with key encoded as bytes: " + bIEncodable.toString() + " successful");
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleTooLargeEvent(DataRecoveryTooLargeException dataRecoveryTooLargeException, BIDataRecoverySource bIDataRecoverySource) {
        block7: {
            ++this.tooLargeEventsSinceStart;
            this.ticksOfLastTooLargeEvent = Clock.ticks();
            log.error("Can never append this data: ", (Throwable)dataRecoveryTooLargeException);
            byte[] byArray = null;
            Object object = this.bufferUtilMonitor;
            synchronized (object) {
                try {
                    this.bufferUtil.reset();
                    BAbsTime.now().encode((DataOutput)this.bufferUtil);
                    bIDataRecoverySource.getOrdInSession().encode((DataOutput)this.bufferUtil);
                    byArray = this.bufferUtil.toByteArray();
                }
                catch (Exception exception) {
                    log.error("Could not encode data too large event: ", (Throwable)exception);
                    byArray = null;
                    this.setDataRecoveryStatus(BDataRecoveryServiceStatus.fault);
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var4_4
                if (byArray == null) break block7;
            }
            if (byArray.length != 0) {
                this.append(this, (BIEncodable)TOO_LARGE_EVENT_AS_BLOB, byArray);
            }
        }
        this.timeoutSaveManager.requestSave();
    }

    public final boolean hasRecoveryData() throws BajaRuntimeException {
        return BDataRecoveryBlockManager.recoveryDataExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveStarted() {
        if (!this.serviceStarted) {
            return;
        }
        byte[] byArray = null;
        try {
            byArray = this.serializeKnownApplications();
        }
        catch (Exception exception) {
            log.error("Error serializing application mapping, service may be suceptible to data loss", (Throwable)exception);
        }
        Object object = this.blockMonitor;
        synchronized (object) {
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.saving);
            BDataRecoveryBlockManager bDataRecoveryBlockManager = null;
            int n = 0;
            while (n < 3) {
                try {
                    bDataRecoveryBlockManager = this.getBlock(BDataRecoveryBlockManagerStatus.idle);
                    break;
                }
                catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
                    log.warning("No idle block available at time of save on thread \"" + Thread.currentThread().getName() + "\", waiting until one is available (attempt " + (n + 1) + " of 3)");
                    try {
                        this.blockMonitor.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                }
            }
            if (bDataRecoveryBlockManager != null) {
                bDataRecoveryBlockManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.reserved);
            } else {
                log.error("Could not obtain an idle block when attempting to save, a serious error has occured");
                Thread.dumpStack();
            }
            if (byArray != null && byArray.length != 0) {
                this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, byArray);
            }
            BDataRecoveryBlockManager bDataRecoveryBlockManager2 = this.getBlock(BDataRecoveryBlockManagerStatus.active);
            String string = String.valueOf(this.persistentFileCounter++);
            bDataRecoveryBlockManager2.doFlushRecoveryData(string + DATA_RECOVERY_FILE_EXTENSION, false);
            bDataRecoveryBlockManager2.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
            this.blockMonitor.notify();
        }
        this.ticksOfLastSaveStarted = Clock.ticks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveFinished() {
        if (!this.serviceStarted) {
            return;
        }
        var1_1 = this.blockMonitor;
        synchronized (var1_1) {
            block17: {
                var3_2 = this.doPurgeRecovery();
                if (!var3_2.getBoolean()) {
                    BDataRecoveryService.log.error("Error purging data recovery in saveFinished(), duplicate records may occur.");
                }
                this.setLastStationSaveSuccessful(true);
                this.setLastStationSave(BAbsTime.now());
                ** try [egrp 1[TRYBLOCK] [1 : 54->74)] { 
lbl12:
                // 1 sources

                {
                    var4_3 /* !! */  = this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                    var4_3 /* !! */ .setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                }
lbl18:
                // 1 sources

                catch (DataRecoveryBlockUnavailableException var4_4) {
                    BDataRecoveryService.log.trace("No block was set to reserved, skipping reserved block activation");
                }
                var4_3 /* !! */  = BDataRecoveryBlockManager.persistentDirectoryMonitor;
                synchronized (var4_3 /* !! */ ) {
                    var6_5 = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                    var7_6 = 0;
                    while (true) {
                        if (var7_6 >= ((File[])var6_5).length) {
                            // MONITOREXIT @DISABLED, blocks:[16, 4, 5, 10] lbl32 : MonitorExitStatement: MONITOREXIT : var4_3 /* !! */ 
                            if (BDataRecoveryService.chunkFSPresent) {
                                break;
                            }
                            break block17;
                        }
                        if (var6_5[var7_6].getName().endsWith(".drdbr")) {
                            var8_8 = var6_5[var7_6].getAbsolutePath();
                            var9_9 = var8_8.substring(0, var8_8.length() - 1);
                            BDataRecoveryService.log.trace("Renaming reserved file " + var8_8 + " to " + var9_9);
                            if (!var6_5[var7_6].renameTo(new File(var9_9))) {
                                BDataRecoveryService.log.error("Error renaming persistent child: " + var8_8);
                            }
                        }
                        ++var7_6;
                    }
                }
                try {
                    var6_5 = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                    var6_5.poll();
                    var7_7 = null;
                    var8_8 = null;
                    var7_7 = var6_5.getFilesystemForPath(BString.make((String)this.getDataRecoveryConfiguration().getPersistentDirectory()));
                    var8_8 = (BFilesystemAttributes)var6_5.getFilesystemAttributes().get(SlotPath.escape((String)var7_7.getString()));
                    var9_10 = 0L;
                    var9_10 = var8_8 == null ? 102400000L : var8_8.getFreeSpace() * 1024L;
                    this.getDataRecoveryConfiguration().setPersistentStorageCapacity(BDataRecoveryPersistenceCapacity.makeByStorageSize((int)Math.floor((double)var9_10 * BDataRecoveryService.DATA_RECOVERY_MAX_FILESPACE)));
                }
                catch (ServiceNotFoundException v2) {}
            }
            this.timeoutSaveManager.resetTimeout();
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.ready);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveFailed(Throwable var1_1) {
        if (!this.serviceStarted) {
            return;
        }
        var2_2 = this.blockMonitor;
        synchronized (var2_2) {
            this.setLastStationSaveSuccessful(false);
            ** try [egrp 1[TRYBLOCK] [1 : 26->46)] { 
lbl8:
            // 1 sources

            {
                var4_3 /* !! */  = this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                var4_3 /* !! */ .setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
            }
lbl14:
            // 1 sources

            catch (DataRecoveryBlockUnavailableException var4_4) {
                BDataRecoveryService.log.trace("No block was set to reserved, skipping reserved block activation");
            }
            var4_3 /* !! */  = BDataRecoveryBlockManager.persistentDirectoryMonitor;
            synchronized (var4_3 /* !! */ ) {
                var6_5 = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                var7_6 = 0;
                while (true) {
                    if (var7_6 >= var6_5.length) {
                        break;
                    }
                    if (var6_5[var7_6].getName().endsWith(".drdbr")) {
                        var8_7 = var6_5[var7_6].getAbsolutePath();
                        var9_8 = var8_7.substring(0, var8_7.length() - 1);
                        BDataRecoveryService.log.trace("Renaming reserved file " + var8_7 + " to " + var9_8);
                        if (!var6_5[var7_6].renameTo(new File(var9_8))) {
                            BDataRecoveryService.log.error("Error renaming persistent child: " + var8_7);
                        }
                    }
                    ++var7_6;
                }
            }
            this.timeoutSaveManager.resetTimeout();
            this.setDataRecoveryStatus(BDataRecoveryServiceStatus.ready);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdownStarted() {
        Object object = this.blockMonitor;
        synchronized (object) {
            this.shutdownStarted = true;
            return;
        }
    }

    public final BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final BDataRecoveryBlockManager getBlock(BDataRecoveryBlockManagerStatus bDataRecoveryBlockManagerStatus) throws DataRecoveryBlockUnavailableException {
        BDataRecoveryBlockManager bDataRecoveryBlockManager = null;
        Object object = this.blockMonitor;
        synchronized (object) {
            BDataRecoveryBlockManager bDataRecoveryBlockManager2 = null;
            SlotCursor slotCursor = this.getDataRecoveryBlocks().getProperties();
            while (true) {
                Class clazz;
                if ((clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) == null) {
                    clazz = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                }
                if (!slotCursor.next(clazz)) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (bDataRecoveryBlockManager != null) break;
                    throw new DataRecoveryBlockUnavailableException("No data blocks available with status: " + bDataRecoveryBlockManagerStatus.toString());
                }
                bDataRecoveryBlockManager2 = (BDataRecoveryBlockManager)slotCursor.get();
                if (bDataRecoveryBlockManager2.getCurrentManagerStatus() != bDataRecoveryBlockManagerStatus) continue;
                bDataRecoveryBlockManager = bDataRecoveryBlockManager2;
            }
        }
        return bDataRecoveryBlockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void checkIdleCondition() {
        BDataRecoveryBlockManager bDataRecoveryBlockManager;
        byte[] byArray;
        boolean bl;
        block12: {
            bl = true;
            byArray = null;
            try {
                byArray = this.serializeKnownApplications();
            }
            catch (Exception exception) {
                log.error("Error serializing application mapping, service may be suceptible to data loss", (Throwable)exception);
            }
            Object object = this.blockMonitor;
            // MONITORENTER : object
            bDataRecoveryBlockManager = null;
            SlotCursor slotCursor = this.getDataRecoveryBlocks().getProperties();
            do {
                Class clazz;
                if ((clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) == null) {
                    clazz = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                }
                if (slotCursor.next(clazz)) continue;
                if (bDataRecoveryBlockManager == null) {
                    // MONITOREXIT : object
                    return;
                }
                break block12;
            } while ((bDataRecoveryBlockManager = (BDataRecoveryBlockManager)slotCursor.get()).getCurrentManagerStatus() == BDataRecoveryBlockManagerStatus.idle);
            bl = false;
            // MONITOREXIT : object
            return;
        }
        if (bl) {
            log.warning("All data recovery blocks were idle during executing, activating a block");
            if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.saving) {
                bDataRecoveryBlockManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.reserved);
            } else {
                bDataRecoveryBlockManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
            }
            if (byArray != null && byArray.length != 0) {
                this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, byArray);
            }
        }
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] serializeKnownApplications() throws Exception {
        ByteBuffer byteBuffer = new ByteBuffer();
        Object object = this.applicationMonitor;
        synchronized (object) {
            byteBuffer.writeLong(this.activeSequenceNumber++);
            ApplicationEntry applicationEntry = null;
            Collection collection = this.knownApplications.values();
            Iterator iterator = collection.iterator();
            if (log.isTraceOn()) {
                log.trace("Serializing known applications...");
            }
            while (iterator.hasNext()) {
                applicationEntry = (ApplicationEntry)iterator.next();
                if (log.isTraceOn()) {
                    log.trace("Serializing application entry: " + applicationEntry.getId() + " -> " + applicationEntry.getEncodedOrd());
                }
                byteBuffer.write(applicationEntry.toRecoveryBytes());
            }
            return byteBuffer.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final long extractActiveSequenceNumberFromRecoveryData(DataRecoveryLinkedList dataRecoveryLinkedList) {
        long l;
        long l2 = -1;
        IDataRecoveryRecord iDataRecoveryRecord = null;
        byte by = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (dataRecoveryLinkedList == null) return -1L;
        if (dataRecoveryLinkedList.isEmpty()) {
            return -1;
        }
        while (true) {
            boolean bl;
            block16: {
                if (dataRecoveryLinkedList.isEmpty()) {
                    return l2;
                }
                iDataRecoveryRecord = dataRecoveryLinkedList.remove(0);
                by = iDataRecoveryRecord.getDataRecoverySourceIdentifier();
                byArray = iDataRecoveryRecord.getKey();
                byArray2 = iDataRecoveryRecord.getData();
                if (byArray == null) {
                    log.warning("Null recovery data key detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (byArray2 == null) {
                    log.warning("Null recovery data detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (by != 0) continue;
                BBlob bBlob = null;
                bl = false;
                try {
                    bBlob = (BBlob)BBlob.DEFAULT.decode((DataInput)new ByteBuffer(byArray));
                    if (!bBlob.equals((Object)APPLICATIONS_KEY_AS_BLOB)) break block16;
                    bl = true;
                }
                catch (Exception exception) {
                    log.error("Error decoding suspect application bytes, skipping record: ", (Throwable)exception);
                    continue;
                }
            }
            if (bl) break;
        }
        FilterInputStream filterInputStream = null;
        try {
            try {
                filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
                l = l2 = ((DataInputStream)filterInputStream).readLong();
                Object var11_12 = null;
            }
            catch (Exception exception) {
                log.error("Unexpected error while replaying applcation map: ", (Throwable)exception);
                long l3 = -1;
                Object var11_13 = null;
                try {
                    filterInputStream.close();
                    return l3;
                }
                catch (Exception exception2) {}
                return l3;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {}
            catch (Exception exception) {}
            filterInputStream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        filterInputStream.close();
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ApplicationEntry[] extractMapFromRecoveryData(DataRecoveryLinkedList dataRecoveryLinkedList) {
        int n;
        boolean bl = false;
        IDataRecoveryRecord iDataRecoveryRecord = null;
        byte by = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        ApplicationEntry[] applicationEntryArray = new ApplicationEntry[255];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= 255) {
                applicationEntryArray[0] = new ApplicationEntry(this.getOrdInSession().encodeToString(), 0, 0L);
                n2 = 1;
                if (dataRecoveryLinkedList == null) return null;
                if (!dataRecoveryLinkedList.isEmpty()) break;
                return null;
            }
            applicationEntryArray[n3] = null;
            ++n3;
        }
        while (!dataRecoveryLinkedList.isEmpty()) {
            block21: {
                iDataRecoveryRecord = dataRecoveryLinkedList.remove(0);
                by = iDataRecoveryRecord.getDataRecoverySourceIdentifier();
                byArray = iDataRecoveryRecord.getKey();
                byArray2 = iDataRecoveryRecord.getData();
                if (byArray == null) {
                    log.warning("Null recovery data key detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (byArray2 == null) {
                    log.warning("Null recovery data detected when replaying, skipping corrupted record.");
                    continue;
                }
                if (by != 0) continue;
                BBlob bBlob = null;
                n = 0;
                try {
                    bBlob = (BBlob)BBlob.DEFAULT.decode((DataInput)new ByteBuffer(byArray));
                    if (!bBlob.equals((Object)APPLICATIONS_KEY_AS_BLOB)) break block21;
                    n = 1;
                }
                catch (Exception exception) {
                    log.error("Error decoding suspect application bytes, skipping record: ", (Throwable)exception);
                    continue;
                }
            }
            if (n == 0) continue;
            ApplicationEntry applicationEntry = null;
            DataInputStream dataInputStream = null;
            try {
                Object var14_16;
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
                dataInputStream.readLong();
                try {
                    while (true) {
                        block22: {
                            ApplicationEntry[] applicationEntryArray2;
                            try {
                                applicationEntry = new ApplicationEntry();
                                applicationEntry.fromRecoveryBytes(dataInputStream);
                                if (log.isTraceOn()) {
                                    log.trace("Found application entry: " + applicationEntry.getId() + " -> " + applicationEntry.getEncodedOrd());
                                }
                                if (applicationEntryArray[applicationEntry.id] == null) {
                                    applicationEntryArray[applicationEntry.id] = applicationEntry;
                                    ++n2;
                                    break block22;
                                }
                                if (applicationEntry.id == 0 || applicationEntryArray[applicationEntry.id].getEncodedOrd().equals(applicationEntry.getEncodedOrd())) break block22;
                                log.error("Duplicate id encountered: " + applicationEntry.getEncodedOrd() + " != " + applicationEntryArray[applicationEntry.id].getEncodedOrd());
                                applicationEntryArray2 = null;
                            }
                            catch (EOFException eOFException) {
                                break;
                            }
                            catch (Exception exception) {
                                log.error("Unexpected error while replaying applcation map: ", (Throwable)exception);
                                ApplicationEntry[] applicationEntryArray3 = null;
                                var14_16 = null;
                                dataInputStream.close();
                                return applicationEntryArray3;
                            }
                            var14_16 = null;
                            dataInputStream.close();
                            return applicationEntryArray2;
                        }
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    var14_16 = null;
                    dataInputStream.close();
                    throw throwable;
                }
                {
                    var14_16 = null;
                    dataInputStream.close();
                }
            }
            catch (Exception exception) {
                log.error("Error while reading byte buffer inputstream: ", (Throwable)exception);
                return null;
            }
        }
        if (!bl) {
            return null;
        }
        ApplicationEntry[] applicationEntryArray4 = new ApplicationEntry[n2];
        n = 0;
        while (n < n2) {
            applicationEntryArray4[n] = applicationEntryArray[n];
            ++n;
        }
        return applicationEntryArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doReplayRecoveryData() {
        int n;
        Object object;
        BDataRecoveryServiceStatus bDataRecoveryServiceStatus = this.getDataRecoveryStatus();
        this.setDataRecoveryStatus(BDataRecoveryServiceStatus.replaying);
        log.trace("Starting data recovery replay...");
        log.trace("Locating data recovery source map...");
        DataRecoveryLinkedList dataRecoveryLinkedList = BDataRecoveryBlockManager.replayActiveRecoveryData(ACTIVE_FILE_SEQUENCE_COMPARATOR);
        ApplicationEntry[] applicationEntryArray = this.extractMapFromRecoveryData(dataRecoveryLinkedList);
        if (applicationEntryArray == null || applicationEntryArray.length <= 1) {
            log.warning("Data recovery map not located in active store, continue search to persistent...");
            object = BDataRecoveryBlockManager.replayLastPersistentFile();
            applicationEntryArray = this.extractMapFromRecoveryData((DataRecoveryLinkedList)object);
            if (applicationEntryArray == null || applicationEntryArray.length <= 1) {
                log.error("Could not locate data recovery source map, data can not be recovered.");
                this.setDataRecoveryStatus(bDataRecoveryServiceStatus);
                return BBoolean.FALSE;
            }
        }
        this.persistentFileCounter = BDataRecoveryBlockManager.getLastPersistentFileNumber() + 1L;
        object = new HashMap();
        HashMap<BObject, ApplicationEntry> hashMap = new HashMap<BObject, ApplicationEntry>();
        log.trace("Data recovery map located, resolving sources...");
        if (log.isTraceOn()) {
            n = 0;
            while (n < applicationEntryArray.length) {
                log.trace("Found map for: " + applicationEntryArray[n].getId() + " -> " + applicationEntryArray[n].getEncodedOrd());
                ++n;
            }
        }
        n = 0;
        while (n < applicationEntryArray.length) {
            try {
                hashMap.put(BOrd.DEFAULT.decodeFromString(applicationEntryArray[n].getEncodedOrd()), new ApplicationEntry(applicationEntryArray[n].getEncodedOrd(), applicationEntryArray[n].getId(), 0L));
                BIDataRecoverySource bIDataRecoverySource = (BIDataRecoverySource)BOrd.make((String)applicationEntryArray[n].getEncodedOrd()).resolve().get();
                ((HashMap)object).put(new Byte(applicationEntryArray[n].getId()), bIDataRecoverySource);
            }
            catch (Exception exception) {
                log.error("Could not resolve Ord \"" + applicationEntryArray[n].getEncodedOrd() + "\", skipping...", (Throwable)exception);
            }
            ++n;
        }
        log.trace("Sources resolved, replaying data to sources...");
        BDataRecoveryBlockManager.replayRecoveryData((HashMap)object, ACTIVE_FILE_SEQUENCE_COMPARATOR);
        Object object2 = this.applicationMonitor;
        synchronized (object2) {
            this.knownApplications = hashMap;
            int n2 = 0;
            if (this.knownApplications.size() != 0) {
                n2 = this.knownApplications.size() - 1;
            }
            this.externalApplicationsEncountered = n2;
        }
        log.trace("Replay completed");
        this.setDataRecoveryStatus(bDataRecoveryServiceStatus);
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doRefreshPersistentStorageSize() {
        Object object = BDataRecoveryBlockManager.persistentDirectoryMonitor;
        synchronized (object) {
            double d;
            block4: {
                File[] fileArray;
                String string = this.getDataRecoveryConfiguration().getPersistentDirectory();
                File file = new File(string);
                d = 0.0;
                if (!file.exists() || !file.isDirectory() || (fileArray = file.listFiles(DATA_RECOVERY_FILE_FILTER)).length == 0) break block4;
                int n = 0;
                while (n < fileArray.length) {
                    d += (double)fileArray[n].length();
                    ++n;
                }
            }
            double d2 = d / 1024.0;
            this.setPersistentStorageSize(d2);
            return BBoolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doPurgeRecovery() {
        var1_1 = BBoolean.FALSE;
        var2_2 = false;
        var3_3 = BDataRecoveryService.log.isTraceOn();
        var4_4 = this.applicationMonitor;
        synchronized (var4_4) {
            var7_5 = this.blockMonitor;
            synchronized (var7_5) {
                ** try [egrp 1[TRYBLOCK] [7 : 43->733)] { 
lbl10:
                // 1 sources

                break block36;
            }
lbl-1000:
            // 1 sources

            {
                block37: {
                    block38: {
                        block36: {
                            catch (Throwable v1) {
                                throw v1;
                            }
                        }
                        var10_6 = BDataRecoveryBlockManager.persistentDirectoryMonitor;
                        synchronized (var10_6) {
                            var13_7 /* !! */  = BDataRecoveryBlockManager.getPersistentDirectory().listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                            SortUtil.sort((Object[])var13_7 /* !! */ , (Object[])var13_7 /* !! */ , (Comparator)BDataRecoveryBlockManager.PERSISTENT_FILE_COMPARATOR);
                            var14_8 = 0;
                            while (true) {
                                if (var14_8 >= var13_7 /* !! */ .length) {
                                    break;
                                }
                                if (!var13_7 /* !! */ [var14_8].getName().endsWith(".drdbr")) {
                                    if (var3_3) {
                                        BDataRecoveryService.log.trace("Deleting persistent file " + var13_7 /* !! */ [var14_8].getName());
                                    }
                                    if (!var13_7 /* !! */ [var14_8].delete()) {
                                        BDataRecoveryService.log.error("Error deleting persistent file " + var13_7 /* !! */ [var14_8].getAbsolutePath());
                                    }
                                }
                                ++var14_8;
                            }
                        }
                        var13_7 /* !! */  = null;
                        var14_9 = BBoolean.FALSE;
                        var15_10 = false;
                        v3 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager;
                        v4 = v3;
                        if (v3 == null) {
                            v4 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                        }
                        var16_11 = new Array(v4);
                        var17_12 /* !! */  = this.getDataRecoveryBlocks().getProperties();
                        if (true) ** GOTO lbl54
                        do {
                            var15_10 = true;
                            var13_7 /* !! */  = (BDataRecoveryBlockManager)var17_12 /* !! */ .get();
                            if (var13_7 /* !! */ .getCurrentManagerStatus() != BDataRecoveryBlockManagerStatus.reserved) {
                                var16_11.add((Object)var13_7 /* !! */ );
                            } else if (var3_3) {
                                BDataRecoveryService.log.trace("Skipping purge operation on " + var13_7 /* !! */ .getName() + ", manager state is reserved");
                            }
lbl54:
                            // 5 sources

                            if ((v5 = BDataRecoveryService.class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) != null) continue;
                            v5 = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                        } while (var17_12 /* !! */ .next(v5));
                        if (!var15_10) break block38;
                        var17_12 /* !! */  = (BDataRecoveryBlockManager[])var16_11.trim();
                        SortUtil.sort((Object[])var17_12 /* !! */ , (Object[])var17_12 /* !! */ , (Comparator)BDataRecoveryBlockManager.DEFAULT_RECOVERY_MANAGER_COMPARATOR);
                        var18_13 = 0;
                        if (true) ** GOTO lbl98
                    }
                    var17_12 /* !! */  = BDataRecoveryBlockManager.activeDirectoryMonitor;
                    synchronized (var17_12 /* !! */ ) {
                        var20_14 = BDataRecoveryBlockManager.getActiveDirectory().listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                        SortUtil.sort((Object[])var20_14, (Object[])var20_14, (Comparator)BDataRecoveryService.ACTIVE_FILE_SEQUENCE_COMPARATOR);
                        var21_15 = 0;
                        while (true) {
                            if (var21_15 >= var20_14.length) {
                                break block37;
                            }
                            if (BDataRecoveryService.chunkFSPresent) {
                                try {
                                    BDataRecoveryService.log.trace("Truncating active file " + var20_14[var21_15]);
                                    var22_16 = new FileOutputStream((File)var20_14[var21_15], false);
                                    var22_16.close();
                                }
                                catch (Exception var22_17) {
                                    BDataRecoveryService.log.error("Error truncating the active file", (Throwable)var22_17);
                                }
                            } else if (!var20_14[var21_15].delete()) {
                                BDataRecoveryService.log.error("Error deleting uninitialized active file: " + var20_14[var21_15]);
                            }
                            ++var21_15;
                        }
                    }
                    do {
                        if (var3_3) {
                            BDataRecoveryService.log.trace("Purging manager " + var17_12 /* !! */ [var18_13].getName() + " (" + (var17_12 /* !! */ [var18_13].getUsedSpace() + var17_12 /* !! */ [var18_13].getOverheadSpace()) + " bytes)");
                        }
                        if ((var14_9 = var17_12 /* !! */ [var18_13].doPurgeRecoveryData()).getBoolean()) {
                            if (var3_3) {
                                BDataRecoveryService.log.trace("Purge operation on " + var17_12 /* !! */ [var18_13].getName() + " successful");
                            }
                        } else {
                            var2_2 = true;
                            BDataRecoveryService.log.error("Purge operation on " + var17_12 /* !! */ [var18_13].getName() + " failed");
                        }
                        ++var18_13;
lbl98:
                        // 2 sources

                    } while (var18_13 < var17_12 /* !! */ .length);
                }
                this.doRefreshPersistentStorageSize();
                var1_1 = BBoolean.TRUE;
                ** if (var1_1.getBoolean()) goto lbl106
            }
        }
lbl-1000:
        // 1 sources

        {
            BDataRecoveryService.log.error("Purge operation failed.");
            return var1_1;
        }
lbl106:
        // 1 sources

        if (!var2_2) {
            if (var3_3 == false) return var1_1;
            BDataRecoveryService.log.trace("Purge operation successful.");
            return var1_1;
        }
        BDataRecoveryService.log.warning("Purge operation completed but not all blocks were purged.");
        return var1_1;
    }

    public final BBoolean doHandleMinSaveTimeout() {
        this.timeoutSaveManager.timeoutExpired();
        return BBoolean.TRUE;
    }

    public final BBoolean doHandleConfigChange() {
        this.dataRecoveryConfigChanged(this.getDataRecoveryConfiguration());
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doResetDataRecoveryStatistics() {
        Object object = this.receivedMonitor;
        synchronized (object) {
            this.totalBytesReceivedSinceStart = 0L;
            this.averageBytesReceivedPerSecondSinceStart = 0.0;
            this.averageRecordSize = 0.0;
            this.numberOfRecordsReceivedSinceStart = 0L;
            this.tooLargeEventsSinceStart = 0L;
        }
        object = this.flushedMonitor;
        synchronized (object) {
            this.totalBytesFlushedSinceStart = 0L;
            this.timesFlushedSinceStart = 0L;
            this.averageBytesFlushedPerFlush = 0.0;
            this.averageBytesFlushedPerSecondSinceStart = 0.0;
        }
        this.serviceStartTimeMilliseconds = System.currentTimeMillis();
        object = this.applicationMonitor;
        synchronized (object) {
            block10: {
                if (this.knownApplications == null) break block10;
                Collection collection = this.knownApplications.values();
                ApplicationEntry applicationEntry = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    applicationEntry = (ApplicationEntry)iterator.next();
                    applicationEntry.clearMetrics();
                }
            }
            return BBoolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doFlushRecoveryData() {
        BBoolean bBoolean;
        block21: {
            bBoolean = BBoolean.FALSE;
            try {
                BDataRecoveryBlockManager bDataRecoveryBlockManager = null;
                BDataRecoveryBlockManager bDataRecoveryBlockManager2 = null;
                boolean bl = false;
                byte[] byArray = null;
                try {
                    byArray = this.serializeKnownApplications();
                }
                catch (Exception exception) {
                    log.error("Error serializing application mapping, service may be suceptible to data loss", (Throwable)exception);
                }
                Object object = this.blockMonitor;
                synchronized (object) {
                    BDataRecoveryServiceStatus bDataRecoveryServiceStatus = this.getDataRecoveryStatus();
                    if (bDataRecoveryServiceStatus == BDataRecoveryServiceStatus.ready) {
                        bDataRecoveryBlockManager = this.getBlock(BDataRecoveryBlockManagerStatus.active);
                    } else {
                        if (bDataRecoveryServiceStatus != BDataRecoveryServiceStatus.saving) {
                            log.warning("Attempted to flush while status was neither ready or saving, aborting operation.");
                            throw new Exception("IllegalStatus during flush");
                        }
                        bDataRecoveryBlockManager = this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                        bl = true;
                    }
                    int n = 0;
                    while (n < 3) {
                        try {
                            bDataRecoveryBlockManager2 = this.getBlock(BDataRecoveryBlockManagerStatus.idle);
                            break;
                        }
                        catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
                            log.warning("No idle block available at time of flush on thread \"" + Thread.currentThread().getName() + "\", waiting until one is available (attempt " + (n + 1) + " of 3)");
                            try {
                                this.blockMonitor.wait(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++n;
                        }
                    }
                    bDataRecoveryBlockManager.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.flushQueued);
                    if (bDataRecoveryBlockManager2 == null) {
                        log.error("Could not obtain an idle block when attempting to flush, a serious error has occured");
                        Thread.dumpStack();
                        bBoolean = BBoolean.FALSE;
                        break block21;
                    }
                    if (this.getDataRecoveryStatus() == BDataRecoveryServiceStatus.ready) {
                        bDataRecoveryBlockManager2.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.active);
                    } else {
                        bDataRecoveryBlockManager2.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.reserved);
                    }
                    if (byArray != null && byArray.length != 0) {
                        this.append(this, (BIEncodable)APPLICATIONS_KEY_AS_BLOB, byArray);
                    }
                }
                new RecoveryDataFlusher(bDataRecoveryBlockManager, bl).start();
                bBoolean = BBoolean.TRUE;
            }
            catch (Exception exception) {
                log.error("Error retrieving active or inactive block, could not flush: ", (Throwable)exception);
                bBoolean = BBoolean.FALSE;
            }
        }
        if (bBoolean.getBoolean()) {
            if (!log.isTraceOn()) return bBoolean;
            log.trace("Flush operation successful.");
            return bBoolean;
        }
        log.error("Flush operation failed.");
        return bBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BBoolean doDumpRecoveryData() {
        BBoolean bBoolean = BBoolean.FALSE;
        try {
            SlotCursor slotCursor;
            Object object;
            System.out.println("Current Application (Nav Ord) to Source ID Byte Map:");
            System.out.println("{");
            Object object2 = this.applicationMonitor;
            synchronized (object2) {
                object = null;
                slotCursor = this.knownApplications.values();
                Iterator iterator = slotCursor.iterator();
                while (iterator.hasNext()) {
                    object = (ApplicationEntry)iterator.next();
                    System.out.println("  Encoded Ord: " + ((ApplicationEntry)object).getEncodedOrd() + " -> " + ((ApplicationEntry)object).getId());
                }
            }
            System.out.println("}");
            System.out.println();
            object2 = this.blockMonitor;
            synchronized (object2) {
                object = null;
                slotCursor = this.getDataRecoveryBlocks().getProperties();
                while (true) {
                    Class clazz;
                    if ((clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) == null) {
                        clazz = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                    }
                    if (!slotCursor.next(clazz)) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 9, 13] lbl37 : MonitorExitStatement: MONITOREXIT : var2_2
                        bBoolean = BBoolean.TRUE;
                        break;
                    }
                    object = (BDataRecoveryBlockManager)slotCursor.get();
                    ((BDataRecoveryBlockManager)((Object)object)).dump(System.out);
                }
            }
        }
        catch (Exception exception) {
            log.error("Error printing data recovery debug information: ", (Throwable)exception);
            bBoolean = BBoolean.FALSE;
        }
        if (bBoolean.getBoolean()) {
            if (!log.isTraceOn()) return bBoolean;
            log.trace("Dump operation successful.");
            return bBoolean;
        }
        log.error("Dump operation failed.");
        return bBoolean;
    }

    public final BBoolean doTestDataRecovery(BDataRecoveryTestArguments bDataRecoveryTestArguments) {
        int n = bDataRecoveryTestArguments.getThreadCount();
        BDataRecoveryTester bDataRecoveryTester = null;
        int n2 = 0;
        while (n2 < n) {
            try {
                bDataRecoveryTester = new BDataRecoveryTester((BDataRecoveryTestArguments)bDataRecoveryTestArguments.newCopy());
                new Thread(bDataRecoveryTester).start();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                log.error("Error spawning test or sleeping: " + exception);
                break;
            }
            ++n2;
        }
        return BBoolean.TRUE;
    }

    public final void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getDataRecoveryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public final void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getDataRecoveryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public final void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public final BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static final BPlatformAlarmSupport initDataRecoveryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setAlertText(BFormat.make((String)"%lexicon(platDataRecovery:recoveryDataReplay)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)LICENSE_FEATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    public final void dataRecoverySpy(SpyWriter spyWriter, Iterator iterator) {
    }

    public final boolean dataRecoveryRestore(IDataRecoveryRecord iDataRecoveryRecord) throws Exception {
        return false;
    }

    public final void dataRecoveryRestoreComplete() {
    }

    public final BBoolean doClearStationSaveCount() {
        this.stationSavesGenerated = 0;
        return BBoolean.TRUE;
    }

    private final boolean tooManySaves() {
        boolean bl = false;
        if (this.stationSavesGenerated >= this.getStationSaveLimit()) {
            bl = true;
            if (!this.getTooManySaves()) {
                BPlatform.log.warning("Data Recovery Service save limit exceeded");
            }
        } else {
            bl = false;
        }
        this.setTooManySaves(bl);
        return bl;
    }

    public final String checkForStationFault() {
        if (this.tooManySaves()) {
            return "stationFault.dataRecoverySave";
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final long lengthOfFile(File file) {
        long l = 0L;
        FileInputStream fileInputStream = null;
        try {
            try {
                byte[] byArray = new byte[1024];
                long l2 = 0L;
                long l3 = 0L;
                fileInputStream = new FileInputStream(file);
                while (true) {
                    if ((l2 = (long)fileInputStream.read(byArray)) == (long)-1) {
                        l = l3;
                    }
                    l3 += l2;
                }
            }
            catch (Exception exception) {
                l = 0L;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        try {}
        catch (Exception exception) {
            return l;
        }
        fileInputStream.close();
        return l;
    }

    private static final void loadGeom(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        chunkfsDeviceSize = Integer.valueOf(properties.getProperty("deviceSize"));
        chunkfsNumFiles = Integer.valueOf(properties.getProperty("numFiles"));
        chunkfsChunkSize = Integer.valueOf(properties.getProperty("chunkSize"));
        chunkfsNumChunks = Integer.valueOf(properties.getProperty("numChunks"));
        fileInputStream.close();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.clearStationSaveTimer = null;
        this.stationSavesGenerated = 0;
        this.receivedMonitor = new Object();
        this.flushedMonitor = new Object();
        this.totalBytesReceivedSinceStart = 0L;
        this.totalBytesFlushedSinceStart = 0L;
        this.timesFlushedSinceStart = 0L;
        this.averageBytesFlushedPerFlush = 0.0;
        this.serviceStartTimeMilliseconds = 0L;
        this.averageBytesFlushedPerSecondSinceStart = 0.0;
        this.averageBytesReceivedPerSecondSinceStart = 0.0;
        this.numberOfRecordsReceivedSinceStart = 0L;
        this.averageRecordSize = 0.0;
        this.tooLargeEventsSinceStart = 0L;
        this.ticksOfLastTooLargeEvent = -1;
        this.ticksOfLastSaveStarted = -1;
        this.blockMonitor = new Object();
        this.serviceStarted = false;
        this.shutdownStarted = false;
        this.applicationMonitor = new Object();
        this.knownApplications = null;
        this.externalApplicationsEncountered = 0;
        this.lastConfig = null;
        this.replayOccurred = false;
        this.bufferUtilMonitor = new Object();
        this.bufferUtil = new ByteBuffer();
        this.timeoutSaveManager = new TimeoutSaveManager();
        this.persistentFileCounter = 0L;
        this.activeSequenceNumber = 0L;
    }

    public BDataRecoveryService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("DataRecoveryService.description"));
    }

    static {
        Class clazz = class$com$tridium$platDataRecovery$BDataRecoveryService;
        if (clazz == null) {
            clazz = class$com$tridium$platDataRecovery$BDataRecoveryService = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.BDataRecoveryService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"save.png"), (BIcon)BIcon.std((String)"badges/warning.png"));
        BLOCK_MANAGER_SEQUENCE_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                long l = (Long)object;
                long l2 = (Long)object2;
                if (l == (long)-1 && l2 == (long)-1) {
                    return 0;
                }
                if (l2 == (long)-1) {
                    return -1;
                }
                if (l == (long)-1) {
                    return 1;
                }
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                throw new RuntimeException("Sequence numbers are equal (" + l + "), can not compare.");
            }
        };
        ACTIVE_FILE_SEQUENCE_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                File file = (File)object;
                File file2 = (File)object2;
                DataRecoveryLinkedList dataRecoveryLinkedList = BDataRecoveryBlockManager.replayRecoveryDataHelper(file, true);
                DataRecoveryLinkedList dataRecoveryLinkedList2 = BDataRecoveryBlockManager.replayRecoveryDataHelper(file2, true);
                long l = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(dataRecoveryLinkedList);
                long l2 = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(dataRecoveryLinkedList2);
                if (l == (long)-1 && l2 == (long)-1) {
                    return 0;
                }
                if (l2 == (long)-1) {
                    return -1;
                }
                if (l == (long)-1) {
                    return 1;
                }
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                throw new RuntimeException("Sequence numbers are equal (" + l + "), can not compare.");
            }
        };
        log = Log.getLog((String)"platDataRecovery.service");
        chunkFSPresent = false;
        DATA_RECOVERY_FILE_FILTER = new FileFilter(){

            public final boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String string = file.getName().toLowerCase();
                if (string.endsWith(BDataRecoveryService.DATA_RECOVERY_FILE_EXTENSION) || string.endsWith(BDataRecoveryService.DATA_RECOVERY_FILE_RESERVED_EXTENSION) || string.endsWith(BDataRecoveryService.DATA_RECOVERY_FILE_CHUNK_EXTENSION)) {
                    return true;
                }
                return string.startsWith(BDataRecoveryService.DATA_RECOVERY_FILE_CHUNK_PREFIX) && Character.isDigit(string.charAt(string.length() - 1));
            }
        };
        DATA_RECOVERY_WORKING_FILE_FILTER = new FileFilter(){

            public final boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.getName().toLowerCase().endsWith("_working");
            }
        };
        APPLICATIONS_KEY_AS_BYTES = new byte[1];
        TOO_LARGE_EVENT_AS_BYTES = new byte[]{1};
        TOO_LARGE_EVENT_AS_BLOB = BBlob.make((byte[])TOO_LARGE_EVENT_AS_BYTES);
        APPLICATIONS_KEY_AS_BLOB = BBlob.make((byte[])APPLICATIONS_KEY_AS_BYTES);
        DATA_RECOVERY_MAX_FILESPACE = Double.valueOf(System.getProperty("dataRecovery.flashFilespacePercentage", "0.10"));
        chunkfsDeviceSize = 0;
        chunkfsNumFiles = 0;
        chunkfsChunkSize = 0;
        chunkfsNumChunks = 0;
    }

    private static final class ApplicationEntry {
        private static final int MAGIC = 45323;
        private String encodedOrd;
        byte id;
        private int recordsSinceStart;
        private long dataGenerated;

        public final String getEncodedOrd() {
            return this.encodedOrd;
        }

        public final byte getId() {
            return this.id;
        }

        public final void updateMetrics(int n) {
            ++this.recordsSinceStart;
            this.dataGenerated += (long)(n + DataRecoveryBlock.fixedFieldsOfUsedBlockHeaderSize);
        }

        public final void clearMetrics() {
            this.recordsSinceStart = 1;
            this.dataGenerated = 0L;
        }

        public final double getAverageRecordSize() {
            return (double)this.dataGenerated / (double)this.recordsSinceStart;
        }

        public final long getDataGenerated() {
            return this.dataGenerated;
        }

        public final int getRecordsGenerated() {
            return this.recordsSinceStart;
        }

        public final byte[] toRecoveryBytes() throws Exception {
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.writeInt(45323);
            byteBuffer.writeUTF(this.encodedOrd);
            byteBuffer.writeByte((int)this.id);
            return byteBuffer.toByteArray();
        }

        public final void fromRecoveryBytes(DataInputStream dataInputStream) throws Exception {
            int n = dataInputStream.readInt();
            if (n != 45323) {
                throw new Exception("Wrong magic number ( " + n + " ) while reading table of contents");
            }
            this.encodedOrd = dataInputStream.readUTF();
            this.id = (byte)dataInputStream.readUnsignedByte();
        }

        public ApplicationEntry() {
            this.encodedOrd = BOrd.NULL.encodeToString();
            this.id = 0;
        }

        public ApplicationEntry(String string, byte by, long l) {
            this.encodedOrd = string;
            this.id = by;
            this.dataGenerated = l;
            this.recordsSinceStart = 1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class DataRecoveryServiceSpyPage
    extends SpyDir {
        HashMap pages;

        public final Spy find(String string) {
            if (string.equals("CHUNK_FS_STATS")) {
                return new DataRecoveryChunkFSSpyPage();
            }
            return (DataRecoverySourceSpyPage)((Object)this.pages.get(string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void write(SpyWriter spyWriter) throws Exception {
            block16: {
                Object object;
                Object object2;
                spyWriter.startProps("Data recovery Performance Metrics");
                spyWriter.prop((Object)"Seconds Since Service Started / Last Reset", (Object)new Long((System.currentTimeMillis() - BDataRecoveryService.this.serviceStartTimeMilliseconds) / 1000L));
                spyWriter.prop((Object)"Total Number Of Records Received", (Object)new Long(BDataRecoveryService.this.numberOfRecordsReceivedSinceStart));
                spyWriter.prop((Object)"Average Size of Record Received", (Object)new Double(BDataRecoveryService.this.averageRecordSize));
                spyWriter.prop((Object)"Total Bytes Received Since Start / Last Reset", (Object)new Long(BDataRecoveryService.this.totalBytesReceivedSinceStart));
                spyWriter.prop((Object)"Average Bytes Received/Second", (Object)new Double(BDataRecoveryService.this.averageBytesReceivedPerSecondSinceStart));
                spyWriter.prop((Object)"Total Bytes Flushed Since Start / Last Reset", (Object)new Long(BDataRecoveryService.this.totalBytesFlushedSinceStart));
                spyWriter.prop((Object)"Average Bytes Flushed/Second", (Object)new Double(BDataRecoveryService.this.averageBytesFlushedPerSecondSinceStart));
                spyWriter.prop((Object)"Total Number of Times Flush Occured", (Object)new Long(BDataRecoveryService.this.timesFlushedSinceStart));
                spyWriter.prop((Object)"Average Bytes Flushed/Flush", (Object)new Double(BDataRecoveryService.this.averageBytesFlushedPerFlush));
                spyWriter.prop((Object)"Number of Too Large Events Encountered", (Object)new Long(BDataRecoveryService.this.tooLargeEventsSinceStart));
                if (chunkFSPresent) {
                    spyWriter.prop((Object)"Chunk FS", (Object)("<a href='" + spyWriter.href("CHUNK_FS_STATS") + "'> Statistics </a>"));
                }
                spyWriter.endProps();
                Object object3 = BDataRecoveryService.this.blockMonitor;
                synchronized (object3) {
                    object2 = null;
                    object = BDataRecoveryService.this.getDataRecoveryBlocks().getProperties();
                    while (true) {
                        Class clazz;
                        if ((clazz = class$com$tridium$platDataRecovery$block$BDataRecoveryBlockManager) == null) {
                            clazz = BDataRecoveryService.class("[Lcom.tridium.platDataRecovery.block.BDataRecoveryBlockManager;", false);
                        }
                        if (!object.next(clazz)) {
                            break;
                        }
                        object2 = (BDataRecoveryBlockManager)object.get();
                        ((BDataRecoveryBlockManager)((Object)object2)).spy(spyWriter, false);
                    }
                }
                spyWriter.startProps("Data recovery Sources");
                if (this.pages != null) {
                    this.pages.clear();
                }
                object3 = BDataRecoveryService.this.applicationMonitor;
                synchronized (object3) {
                    if (BDataRecoveryService.this.knownApplications == null) break block16;
                    object2 = BDataRecoveryService.this.knownApplications.values();
                    object = null;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (ApplicationEntry)iterator.next();
                        if (((ApplicationEntry)object).getEncodedOrd().equals(BDataRecoveryService.this.getOrdInSession().encodeToString())) continue;
                        spyWriter.prop((Object)"Source Ord", (Object)((ApplicationEntry)object).getEncodedOrd());
                        spyWriter.prop((Object)"Source Type", (Object)BOrd.make((String)((ApplicationEntry)object).getEncodedOrd()).resolve().get().getType());
                        spyWriter.prop((Object)"Source Byte", (int)((ApplicationEntry)object).getId());
                        spyWriter.prop((Object)"Records Generated", ((ApplicationEntry)object).getRecordsGenerated());
                        spyWriter.prop((Object)"Data Generated", (Object)new Long(((ApplicationEntry)object).getDataGenerated()));
                        spyWriter.prop((Object)"Average Record Size", (Object)new Double(((ApplicationEntry)object).getAverageRecordSize()));
                        BIDataRecoverySource bIDataRecoverySource = null;
                        try {
                            bIDataRecoverySource = (BIDataRecoverySource)BOrd.make((String)((ApplicationEntry)object).getEncodedOrd()).resolve().get();
                        }
                        catch (ClassCastException classCastException) {
                            spyWriter.prop((Object)"", (Object)"");
                            continue;
                        }
                        if (bIDataRecoverySource == null) {
                            spyWriter.prop((Object)"", (Object)"");
                            continue;
                        }
                        DataRecoverySourceSpyPage dataRecoverySourceSpyPage = new DataRecoverySourceSpyPage(bIDataRecoverySource, ((ApplicationEntry)object).getId());
                        if (this.pages == null) {
                            this.pages = new HashMap();
                        }
                        this.pages.put(EscUtil.slot.escape(bIDataRecoverySource.getType().getTypeSpec().encodeToString()), dataRecoverySourceSpyPage);
                        spyWriter.prop((Object)"Additional statistics", (Object)("<a href='" + spyWriter.href(EscUtil.slot.escape(bIDataRecoverySource.getType().getTypeSpec().encodeToString())) + "'> " + ((ApplicationEntry)object).getEncodedOrd() + "</a>"));
                        spyWriter.prop((Object)"", (Object)"");
                    }
                }
            }
            spyWriter.endProps();
        }

        private final /* synthetic */ void this() {
            this.pages = null;
        }

        public DataRecoveryServiceSpyPage() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class TimeoutSaveManager {
        private Clock.Ticket minSaveTimer;
        private BRelTime minTime;
        private boolean saveRequested;
        private boolean saving;

        public final synchronized void requestSave() {
            if (this.minSaveTimer != null && !this.minSaveTimer.isExpired() || this.saving) {
                this.saveRequested = true;
            } else {
                try {
                    Station.saveAsync(null);
                    this.saving = true;
                    this.saveRequested = false;
                }
                catch (Exception exception) {
                    log.error("Error while attempting to save station during too large event: ", (Throwable)exception);
                }
            }
        }

        private final synchronized void timeoutExpired() {
            if (this.saveRequested) {
                try {
                    if (BDataRecoveryService.this.ticksOfLastTooLargeEvent < BDataRecoveryService.this.ticksOfLastSaveStarted) {
                        return;
                    }
                    Station.saveAsync(null);
                    this.saving = true;
                    this.saveRequested = false;
                }
                catch (Exception exception) {
                    log.error("Error while attempting to save station during too large event: ", (Throwable)exception);
                }
            }
        }

        public final synchronized void resetTimeout() {
            if (this.minSaveTimer != null && !this.minSaveTimer.isExpired()) {
                this.minSaveTimer.cancel();
            }
            this.minSaveTimer = Clock.schedule((BComponent)BDataRecoveryService.this, (BRelTime)this.minTime, (Action)handleMinSaveTimeout, null);
            this.saving = false;
        }

        private final /* synthetic */ void this() {
            this.minSaveTimer = null;
            this.minTime = BRelTime.make((long)Long.valueOf(System.getProperty("niagara.platDataRecovery.tooLargeTimeout", "600000")));
            this.saveRequested = false;
            this.saving = false;
        }

        public TimeoutSaveManager() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class RecoveryDataFlusher
    extends Thread {
        BDataRecoveryBlockManager managerToFlush;
        boolean flushingReserved;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            Object object;
            BBoolean bBoolean = BBoolean.FALSE;
            double d = 0.0;
            if (this.managerToFlush != null) {
                d = this.managerToFlush.getMaxCapacity() - this.managerToFlush.getFreeSpace();
                BDataRecoveryService bDataRecoveryService = BDataRecoveryService.this;
                long l = bDataRecoveryService.persistentFileCounter;
                bDataRecoveryService.persistentFileCounter = l + 1L;
                object = String.valueOf(l);
                bBoolean = this.flushingReserved ? this.managerToFlush.doFlushRecoveryData((String)object + BDataRecoveryService.DATA_RECOVERY_FILE_RESERVED_EXTENSION) : this.managerToFlush.doFlushRecoveryData((String)object + BDataRecoveryService.DATA_RECOVERY_FILE_EXTENSION);
            }
            if (!bBoolean.getBoolean()) {
                log.error("The manager failed to flush data successfully, a save is required");
                this.managerToFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.fail);
                return;
            }
            object = BDataRecoveryService.this.flushedMonitor;
            synchronized (object) {
                BDataRecoveryService bDataRecoveryService = BDataRecoveryService.this;
                bDataRecoveryService.totalBytesFlushedSinceStart = (long)((double)bDataRecoveryService.totalBytesFlushedSinceStart + d);
                BDataRecoveryService bDataRecoveryService2 = BDataRecoveryService.this;
                bDataRecoveryService2.timesFlushedSinceStart = bDataRecoveryService2.timesFlushedSinceStart + 1L;
                BDataRecoveryService.this.averageBytesFlushedPerSecondSinceStart = (double)BDataRecoveryService.this.totalBytesFlushedSinceStart / (double)(System.currentTimeMillis() - BDataRecoveryService.this.serviceStartTimeMilliseconds) * 1000.0;
                BDataRecoveryService.this.averageBytesFlushedPerFlush = (double)BDataRecoveryService.this.totalBytesFlushedSinceStart / (double)BDataRecoveryService.this.timesFlushedSinceStart;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl23 : MonitorExitStatement: MONITOREXIT : var4_3
                this.managerToFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.awaitingIdle);
            }
            object = BDataRecoveryService.this.blockMonitor;
            synchronized (object) {
                this.managerToFlush.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
                BDataRecoveryService.this.blockMonitor.notify();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.managerToFlush = null;
            this.flushingReserved = false;
        }

        public RecoveryDataFlusher(BDataRecoveryBlockManager bDataRecoveryBlockManager, boolean bl) {
            super("BDataRecoveryService::FlushThread");
            this.this();
            this.managerToFlush = bDataRecoveryBlockManager;
            this.flushingReserved = bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class DataRecoveryChunkFSSpyPage
    extends SpyDir {
        public final Spy find(String string) {
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void write(SpyWriter spyWriter) throws Exception {
            String string;
            BufferedReader bufferedReader = null;
            if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx)) {
                if (new File("/sram/stats").exists()) {
                    bufferedReader = new BufferedReader(new FileReader("/sram/stats"));
                } else {
                    if (!new File("/sramopt/stats").exists()) return;
                    bufferedReader = new BufferedReader(new FileReader("/sramopt/stats"));
                }
            } else {
                string = System.getProperty("niagara.platDataRecovery.chunkfsStatsPath", null);
                if (string != null) {
                    bufferedReader = new BufferedReader(new FileReader(string));
                }
            }
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"Chunk FS Geom/Statistics", 1);
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                spyWriter.tr((Object)string);
            }
            spyWriter.endTable();
            try {
                bufferedReader.close();
                return;
            }
            catch (Exception exception) {}
        }

        DataRecoveryChunkFSSpyPage() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class DataRecoverySourceSpyPage
    extends SpyDir {
        BIDataRecoverySource source;
        byte sourceByte;

        public final Spy find(String string) {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void write(SpyWriter spyWriter) throws Exception {
            if (this.source == null) {
                return;
            }
            Object object = BDataRecoveryService.this.blockMonitor;
            synchronized (object) {
                Object object2;
                BDataRecoveryBlockManager bDataRecoveryBlockManager;
                block9: {
                    bDataRecoveryBlockManager = null;
                    try {
                        object2 = BDataRecoveryService.this.getDataRecoveryStatus();
                        if (object2 == BDataRecoveryServiceStatus.ready) {
                            bDataRecoveryBlockManager = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.active);
                            break block9;
                        }
                        if (object2 == BDataRecoveryServiceStatus.saving) {
                            bDataRecoveryBlockManager = BDataRecoveryService.this.getBlock(BDataRecoveryBlockManagerStatus.reserved);
                        }
                    }
                    catch (DataRecoveryBlockUnavailableException dataRecoveryBlockUnavailableException) {
                        return;
                    }
                }
                if (bDataRecoveryBlockManager == null) {
                    return;
                }
                object2 = bDataRecoveryBlockManager.scanBlocksForSource(this.sourceByte);
                this.source.dataRecoverySpy(spyWriter, ((DataRecoveryLinkedList)object2).iterator());
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.source = null;
            this.sourceByte = 0;
        }

        public DataRecoverySourceSpyPage(BIDataRecoverySource bIDataRecoverySource, byte by) {
            this.this();
            this.source = bIDataRecoverySource;
            this.sourceByte = by;
        }
    }
}

