/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioning.ui.station.BStationProxyOutputPane;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.util.Lexicon;

public class PauseOutputCommand
extends ToggleCommand {
    private BStationProxyOutputPane outputPane;
    private static Lexicon lex = Lexicon.make((String)"provisioning");

    public PauseOutputCommand(BAbstractButton bAbstractButton, BStationProxyOutputPane bStationProxyOutputPane) {
        super((BWidget)bAbstractButton, lex, "");
        this.outputPane = bStationProxyOutputPane;
    }

    public void checkEnabled() {
        if (this.outputPane.getStation().getStationStatus() == BStationStatus.unknown) {
            this.setSelected(false);
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public String getLabel() {
        if (this.isSelected()) {
            return lex.getText("ProvisioningStationDirector.pauseOutputCommand.loadOutput.label");
        }
        return lex.getText("ProvisioningStationDirector.pauseOutputCommand.pauseOutput.label");
    }

    public String getDescription() {
        if (this.isSelected()) {
            return lex.getText("ProvisioningStationDirector.pauseOutputCommand.loadOutput.description");
        }
        return lex.getText("ProvisioningStationDirector.pauseOutputCommand.pauseOutput.description");
    }

    public CommandArtifact doInvoke() {
        try {
            BAbstractButton bAbstractButton = (BAbstractButton)this.getOwner();
            bAbstractButton.setText(this.getLabel());
            if (this.isSelected()) {
                this.outputPane.stopUpdates();
            } else {
                this.outputPane.load();
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
        return null;
    }
}

