/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioning.station.BStationProxy;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

public class DumpThreadCommand
extends Command {
    private BStationProxy station;

    public DumpThreadCommand(BWidget bWidget, BStationProxy bStationProxy) {
        this(bWidget);
        this.loadStation(bStationProxy);
    }

    public DumpThreadCommand(BWidget bWidget) {
        super(bWidget, Lexicon.make((String)"provisioning"), "ProvisioningStationDirector.command.dumpThread");
        this.setEnabled(false);
    }

    public void loadStation(BStationProxy bStationProxy) {
        this.station = bStationProxy;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getStationStatus() == BStationStatus.running || this.station.getStationStatus() == BStationStatus.stopping || this.station.getStationStatus() == BStationStatus.starting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact doInvoke() {
        BWidgetShell bWidgetShell = this.getOwner().getShell();
        try {
            if (bWidgetShell != null) {
                bWidgetShell.enterBusy();
            }
            this.station.dumpThreads();
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
        finally {
            if (bWidgetShell != null) {
                bWidgetShell.exitBusy();
            }
        }
        return null;
    }
}

