/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioning.station.BStationProxy;
import com.tridium.provisioning.ui.station.BStationProxyOutputPane;
import com.tridium.provisioning.ui.station.ClearOutputCommand;
import com.tridium.provisioning.ui.station.DumpThreadCommand;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.ConnectException;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

public class BStationProxyOutputDialog
extends BFrame {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$station$BStationProxyOutputDialog == null ? (class$com$tridium$provisioning$ui$station$BStationProxyOutputDialog = BStationProxyOutputDialog.class$("com.tridium.provisioning.ui.station.BStationProxyOutputDialog")) : class$com$tridium$provisioning$ui$station$BStationProxyOutputDialog));
    private static Lexicon lex = TYPE.getModule().getLexicon();
    private BStationProxyOutputPane outputPane = new BStationProxyOutputPane();
    private ToggleCommand pauseOutputCommand;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$station$BStationProxyOutputDialog;

    public Type getType() {
        return TYPE;
    }

    public BStationProxyOutputDialog(BWidget bWidget, BStationProxy bStationProxy) throws ConnectException, AuthenticationException {
        this(bWidget, bStationProxy, null);
    }

    public BStationProxyOutputDialog(BWidget bWidget, BStationProxy bStationProxy, FilePath filePath) throws ConnectException, AuthenticationException {
        super(lex.getText("StationProxyOutputDialog.stationTitle", new Object[]{bStationProxy.getStationName()}));
        this.setIconImage(BImage.make((String)lex.getText("StationProxyOutputDialog.icon")));
        BButtonPane bButtonPane = new BButtonPane();
        bButtonPane.add((Command)new DumpThreadCommand(bWidget, bStationProxy));
        BToggleButton bToggleButton = new BToggleButton();
        bButtonPane.add((BWidget)bToggleButton);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)bToggleButton);
        bToggleButton.setCommand((Command)this.pauseOutputCommand, true, false);
        bButtonPane.add((Command)new ClearOutputCommand(bWidget, this.outputPane));
        bButtonPane.add((Command)new CloseCommand());
        BStationProxyOutputPane bStationProxyOutputPane = null;
        if (filePath == null) {
            bStationProxyOutputPane = this.outputPane;
        } else {
            BFlowPane bFlowPane = new BFlowPane(BHalign.left);
            bFlowPane.add("capture", (BValue)new BLabel(this.getLexicon().getText("StationProxyOutputDialog.capture", new Object[]{filePath.getBody()})));
            bStationProxyOutputPane = new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)this.outputPane);
            this.outputPane.setCapturePath(filePath);
        }
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bButtonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)bStationProxyOutputPane, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        this.outputPane.loadStation(bStationProxy);
    }

    private void loadBounds() {
        try {
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BComponent bComponent = (BComponent)bOptions.get("bounds");
            if (bComponent == null) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setPreferredSize((int)(0.9 * dimension.getWidth()), (int)(0.9 * dimension.getHeight()));
                this.setBoundsCenteredOnScreen();
            } else {
                this.setScreenBounds(bComponent.getInt(bComponent.getProperty("x")), bComponent.getInt(bComponent.getProperty("y")), bComponent.getInt(bComponent.getProperty("width")), bComponent.getInt(bComponent.getProperty("height")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBoundsCenteredOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)dimension.width, (double)dimension.height));
    }

    public void setBoundsCenteredOn(RectGeom rectGeom) {
        this.computePreferredSize();
        double d = this.getPreferredWidth() + 8.0;
        double d2 = this.getPreferredHeight() + 27.0;
        double d3 = rectGeom.x + (rectGeom.width - d) / 2.0;
        double d4 = rectGeom.y + (rectGeom.height - d2) / 2.0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d5 = dimension.width;
        double d6 = dimension.height;
        if (d3 + d > d5) {
            d3 = d5 - d;
        }
        if (d4 + d2 > d6) {
            d4 = d6 - d2;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        this.setScreenBounds(d3, d4, d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.outputPane.stop();
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BFolder bFolder = new BFolder();
            IRectGeom iRectGeom = this.getScreenBounds();
            bFolder.add("x", (BValue)BInteger.make((int)((int)iRectGeom.x())));
            bFolder.add("y", (BValue)BInteger.make((int)((int)iRectGeom.y())));
            bFolder.add("width", (BValue)BInteger.make((int)((int)iRectGeom.width())));
            bFolder.add("height", (BValue)BInteger.make((int)((int)iRectGeom.height())));
            if (bOptions.get("bounds") == null) {
                bOptions.add("bounds", (BValue)bFolder);
            } else {
                bOptions.set("bounds", (BValue)bFolder);
            }
            bOptions.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PauseOutputCommand
    extends ToggleCommand {
        public PauseOutputCommand(BAbstractButton bAbstractButton) {
            super((BWidget)bAbstractButton, TYPE.getModule(), "");
        }

        public String getLabel() {
            if (this.isSelected()) {
                return BStationProxyOutputDialog.this.getLexicon().getText("ProvisioningStationDirector.pauseOutputCommand.loadOutput.label");
            }
            return BStationProxyOutputDialog.this.getLexicon().getText("ProvisioningStationDirector.pauseOutputCommand.pauseOutput.label");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BAbstractButton bAbstractButton = (BAbstractButton)this.getOwner();
                bAbstractButton.setText(this.getLabel());
                if (this.isSelected()) {
                    BStationProxyOutputDialog.this.outputPane.stopUpdates();
                } else {
                    BStationProxyOutputDialog.this.outputPane.load();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BStationProxyOutputDialog.this, TYPE.getModule(), "StationProxyOutputDialog.closeCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            try {
                BStationProxyOutputDialog.this.outputPane.deactivated();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                BStationProxyOutputDialog.this.close();
            }
            return null;
        }
    }
}

