/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.provisioning.station.BStationProxy;
import com.tridium.provisioning.ui.station.BStationProxyOutputPane;
import com.tridium.provisioning.ui.station.ClearOutputCommand;
import com.tridium.provisioning.ui.station.DumpThreadCommand;
import com.tridium.provisioning.ui.station.KillCommand;
import com.tridium.provisioning.ui.station.OutputDialogCommand;
import com.tridium.provisioning.ui.station.PauseOutputCommand;
import com.tridium.provisioning.ui.station.RebootCommand;
import com.tridium.provisioning.ui.station.RestartCommand;
import com.tridium.provisioning.ui.station.SaveCommand;
import com.tridium.provisioning.ui.station.StartCommand;
import com.tridium.provisioning.ui.station.StopCommand;
import com.tridium.provisioning.ui.station.StreamOutputCommand;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BProvisioningStationDirector
extends BWbComponentView {
    public static final Action markStartFieldDirty = BProvisioningStationDirector.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$station$BProvisioningStationDirector == null ? (class$com$tridium$provisioning$ui$station$BProvisioningStationDirector = BProvisioningStationDirector.class$("com.tridium.provisioning.ui.station.BProvisioningStationDirector")) : class$com$tridium$provisioning$ui$station$BProvisioningStationDirector));
    private BStationProxyOutputPane outputPane;
    private StartCommand startCommand;
    private StopCommand stopCommand;
    private RestartCommand restartCommand;
    private RebootCommand rebootCommand;
    private KillCommand killCommand;
    private ClearOutputCommand clearOutputCommand;
    private DumpThreadCommand dumpThreadCommand;
    private OutputDialogCommand outputDialogCommand;
    private StreamOutputCommand streamCommand;
    private PauseOutputCommand pauseOutputCommand;
    private SaveCommand saveCommand;
    private BLabel nameLabel;
    private BLabel statusLabel;
    private BCheckBox autoStartCheckBox;
    private BCheckBox autoRestartCheckBox;
    private BButtonPane buttons;
    private BWidget downContent;
    private BWidget upContent;
    private DaemonSessionTaskListener taskListener;
    private boolean startFieldDirty = false;
    public static BIcon ICON = BIcon.std((String)"computer.png");
    static /* synthetic */ Class class$com$tridium$provisioning$ui$station$BProvisioningStationDirector;

    public void markStartFieldDirty() {
        this.invoke(markStartFieldDirty, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProvisioningStationDirector() {
        this.autoRegisterForComponentEvents = false;
        BScrollPane bScrollPane = new BScrollPane();
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BEdgePane bEdgePane = new BEdgePane();
        this.taskListener = new DaemonSessionTaskHandler((BWidget)this);
        this.outputPane = new BStationProxyOutputPane(1, 1);
        bEdgePane.setCenter((BWidget)this.outputPane);
        this.setTransferWidget((BTransferWidget)this.outputPane.getEditor());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setRowGap(4.0);
        this.startCommand = new StartCommand((BWidget)this, this.outputPane);
        BButton bButton = new BButton((Command)this.startCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.stopCommand = new StopCommand((BWidget)this, this.taskListener);
        bButton = new BButton((Command)this.stopCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.restartCommand = new RestartCommand((BWidget)this, this.outputPane);
        bButton = new BButton((Command)this.restartCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.rebootCommand = new RebootCommand((BWidget)this);
        bButton = new BButton((Command)this.rebootCommand, true, false);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.killCommand = new KillCommand((BWidget)this, this.taskListener);
        bButton = new BButton((Command)this.killCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.dumpThreadCommand = new DumpThreadCommand((BWidget)this);
        bButton = new BButton((Command)this.dumpThreadCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.saveCommand = new SaveCommand((BWidget)this, this.taskListener);
        bButton = new BButton((Command)this.saveCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bGridPane.add(null, (BValue)new BBox(0.0, 10.0));
        this.clearOutputCommand = new ClearOutputCommand((BWidget)this, this.outputPane);
        bButton = new BButton((Command)this.clearOutputCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bButton = new BToggleButton();
        bGridPane.add(null, (BValue)bButton);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)bButton, this.outputPane);
        bButton.setCommand((Command)this.pauseOutputCommand, true, false);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.outputDialogCommand = new OutputDialogCommand((BWidget)this);
        bButton = new BButton((Command)this.outputDialogCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.streamCommand = new StreamOutputCommand((BWidget)this);
        bButton = new BButton((Command)this.streamCommand);
        bGridPane.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bGridPane.add(null, (BValue)new BBox(0.0, 10.0));
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bGridPane.computePreferredSize();
        bEdgePane.setRight((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 0.0, 3.0));
        bScrollPane.setContent((BWidget)bEdgePane);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setHalign(BHalign.left);
        this.nameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningStationDirector.station.label"), (BWidget)this.nameLabel);
        this.statusLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningStationDirector.status.label"), (BWidget)this.statusLabel);
        this.autoStartCheckBox = new BCheckBox(this.getLexicon().getText("ProvisioningStationDirector.autoStart.checkBox"));
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningStationDirector.autoStart.label"), (BWidget)this.autoStartCheckBox);
        this.autoRestartCheckBox = new BCheckBox(this.getLexicon().getText("ProvisioningStationDirector.autoRestart.checkBox"));
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningStationDirector.autoRestart.label"), (BWidget)this.autoRestartCheckBox);
        this.linkTo(null, (BComponent)this.autoStartCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)markStartFieldDirty);
        this.linkTo(null, (BComponent)this.autoStartCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)markStartFieldDirty);
        this.buttons = new BButtonPane();
        this.upContent = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane2, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.buttons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)bScrollPane), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        this.downContent = new BLabel(this.getLexicon().getText("ProvisioningStationDirector.proxyDown"));
        this.setContent(this.downContent);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        try {
            BStationProxy bStationProxy = (BStationProxy)bObject;
            this.registerForComponentEvents((BComponent)bStationProxy, 1);
            this.buttons.removeAll();
            this.buttons.addWorkbenchButtons((BWidget)this);
            this.startCommand.loadStation(bStationProxy);
            this.stopCommand.loadStation(bStationProxy);
            this.restartCommand.loadStation(bStationProxy);
            this.rebootCommand.loadStation(bStationProxy);
            this.killCommand.loadStation(bStationProxy);
            this.dumpThreadCommand.loadStation(bStationProxy);
            this.outputDialogCommand.loadStation(bStationProxy);
            this.streamCommand.loadStation(bStationProxy);
            this.saveCommand.loadStation(bStationProxy);
            this.nameLabel.setText(bStationProxy.getStationName());
            this.statusLabel.setText(bStationProxy.getStationStatus().toString());
            this.autoStartCheckBox.setSelected(bStationProxy.getIsAutoStart());
            this.autoRestartCheckBox.setSelected(bStationProxy.getIsAutoRestart());
            this.outputPane.loadStation(bStationProxy);
            this.checkEnabledStates();
            this.checkContent();
            this.startFieldDirty = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void checkContent() {
        BStationProxy bStationProxy = (BStationProxy)this.getCurrentValue();
        if (bStationProxy.isDown() || bStationProxy.isFault() || bStationProxy.isDisabled() || bStationProxy.getStationStatus() == BStationStatus.unknown) {
            this.setContent(this.downContent);
        } else {
            this.setContent(this.upContent);
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BStationProxy bStationProxy = (BStationProxy)bObject;
        if (this.startFieldDirty) {
            bStationProxy.setIsAutoStart(this.autoStartCheckBox.isSelected());
            bStationProxy.setIsAutoRestart(this.autoRestartCheckBox.isSelected());
            bStationProxy.updateStartSettings();
            this.startFieldDirty = false;
        }
        return bStationProxy;
    }

    public void deactivated() {
        super.deactivated();
        this.outputPane.deactivated();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.isModifiedStateLocked()) {
            return;
        }
        if (bComponentEvent.getSourceComponent() instanceof BStationProxy && bComponentEvent.getId() == 0) {
            if (bComponentEvent.getSlot() == BStationProxy.isAutoStart) {
                this.lockModifiedState();
                this.autoStartCheckBox.setSelected(((BBoolean)bComponentEvent.getValue()).getBoolean());
                this.unlockModifiedState();
            } else if (bComponentEvent.getSlot() == BStationProxy.isAutoRestart) {
                this.lockModifiedState();
                this.autoRestartCheckBox.setSelected(((BBoolean)bComponentEvent.getValue()).getBoolean());
                this.unlockModifiedState();
            } else if (bComponentEvent.getSlot() == BStationProxy.status) {
                this.checkContent();
            } else if (bComponentEvent.getSlot() == BStationProxy.stationStatus) {
                this.statusLabel.setText(bComponentEvent.getValue().toString());
                this.checkContent();
            }
            this.checkEnabledStates();
        }
    }

    private void checkEnabledStates() {
        this.startCommand.checkEnabled();
        this.stopCommand.checkEnabled();
        this.restartCommand.checkEnabled();
        this.rebootCommand.checkEnabled();
        this.killCommand.checkEnabled();
        this.dumpThreadCommand.checkEnabled();
        this.outputDialogCommand.checkEnabled();
        this.streamCommand.checkEnabled();
        this.saveCommand.checkEnabled();
        this.clearOutputCommand.checkEnabled();
        this.pauseOutputCommand.checkEnabled();
        this.autoStartCheckBox.setEnabled(this.outputPane.getStation().getStationStatus() != BStationStatus.unknown);
        this.autoRestartCheckBox.setEnabled(this.outputPane.getStation().getStationStatus() != BStationStatus.unknown);
    }

    public void doMarkStartFieldDirty() {
        if (!this.isModifiedStateLocked()) {
            this.startFieldDirty = true;
            this.invoke(setModified, null, null);
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

