/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.part.BPart;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.BProvisioningStationExt;
import com.tridium.provisioning.software.BInstallBySpecStep;
import com.tridium.provisioning.software.BSoftwareStationExt;
import com.tridium.provisioning.ui.job.ViewQueryParameter;
import com.tridium.provisioning.ui.software.SoftwareTableRow;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class StationSoftwareStatusTable {
    public static final Lexicon lex = Lexicon.make((String)"provisioning");
    private static final int STATUS_NO_SNAPSHOT = -1;
    private static final int STATUS_UNOPERATIONAL = -2;
    private static final int COL_STATION = 0;
    private static final int COL_DATE = 1;
    private static final int COL_VERSION = 2;
    private static final int COL_STATUS = 3;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$software$StationSoftwareStatusTable$StationStatusRow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(BWbView bWbView, BProvisioningService bProvisioningService, BInstallable bInstallable, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        Object object;
        Object object2;
        TableCursor tableCursor;
        BSpace bSpace = BOrd.toSpace((BObject)bProvisioningService);
        if (bInstallable == null || bInstallable.getPart() == null) {
            return;
        }
        String string = bInstallable.getPart().getPartName();
        BIDataTable bIDataTable = (BIDataTable)BOrd.make((String)"bql:select slotPath from provisioning:SoftwareStationExt").get((BObject)bSpace);
        Column column = bIDataTable.getColumns().get(0);
        Array array = new Array(class$com$tridium$provisioning$ui$software$StationSoftwareStatusTable$StationStatusRow == null ? (class$com$tridium$provisioning$ui$software$StationSoftwareStatusTable$StationStatusRow = StationSoftwareStatusTable.class$("com.tridium.provisioning.ui.software.StationSoftwareStatusTable$StationStatusRow")) : class$com$tridium$provisioning$ui$software$StationSoftwareStatusTable$StationStatusRow);
        BLabel bLabel = new BLabel(lex.getText("SoftwareContainerTree.checking.dlgTitle"));
        bLabel.setHalign(BHalign.left);
        bLabel.setValign(BValign.center);
        Cancel cancel = new Cancel((BWidget)bWbView);
        BCommandDialog bCommandDialog = BCommandDialog.make((BWidget)bWbView, (String)lex.getText("SoftwareContainerTree.checking.dlgTitle"), (boolean)false, (Object)new BEdgePane(null, (BWidget)new BBox(200.0, 0.0), null, null, (BWidget)bLabel), (DialogCommand[])new DialogCommand[]{cancel}, (BImage)BImage.make((String)"module://icons/x32/clock.png"));
        bCommandDialog.setBoundsCenteredOnOwner();
        bCommandDialog.open();
        try {
            tableCursor = (TableCursor)bIDataTable.cursor();
            while (tableCursor.next()) {
                if (cancel.isCanceled) {
                    return;
                }
                object2 = (BSoftwareStationExt)BOrd.make((String)tableCursor.getString(column)).get((BObject)bSpace);
                bLabel.setText(lex.getText("SoftwareContainerTree.checking.dlgMessage", new Object[]{((BProvisioningStationExt)((Object)object2)).getNiagaraStation().getStationName()}));
                if (!((BProvisioningStationExt)((Object)object2)).getEnabled()) continue;
                object = new StationStatusRow((BSoftwareStationExt)((Object)object2), bInstallable);
                array.add(object);
            }
        }
        finally {
            bCommandDialog.close();
        }
        tableCursor = new CommandBindings();
        object2 = new StationStatusModel(array);
        tableCursor.setSupport((CommandBindings.Support)new CommandSupport((StationStatusModel)((Object)object2)));
        object = new BCommandBoundTable((TableModel)object2, new CommandBindings.TableController((CommandBindings)tableCursor));
        Close close = new Close((BWidget)bWbView);
        tableCursor.addCommand((Command)close, BCommandEnablePolicy.anySelection);
        SelectOutOfDateCommand selectOutOfDateCommand = new SelectOutOfDateCommand((BWidget)bWbView, (StationStatusModel)((Object)object2));
        SnapshotCommand snapshotCommand = new SnapshotCommand((BWidget)bWbView, (StationStatusModel)((Object)object2), daemonSessionTaskListener);
        tableCursor.addCommand((Command)snapshotCommand, BCommandEnablePolicy.anySelection);
        object.setSelection((TableSelection)new CommandBindings.TableSelection((CommandBindings)tableCursor));
        object.setCellRenderer((TableCellRenderer)new StationStatusCellRenderer((StationStatusModel)((Object)object2)));
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        BScrollPane bScrollPane = new BScrollPane((BWidget)object);
        bScrollPane.setViewportBackground(bBrush);
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        if (1 == BCommandDialog.open((BWidget)bWbView, (String)bInstallable.toString(), (Object)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBox(550.0, 0.0), (BWidget)new BBox(0.0, 250.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{selectOutOfDateCommand, snapshotCommand, close, DialogCommand.makeCancel((BWidget)bWbView)})) {
            int[] nArray = object.getSelection().getRows();
            StringBuffer stringBuffer = new StringBuffer("provisioning:ProvisioningJobBuilder?stations=");
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(((StationStatusModel)((Object)object2)).getRow(nArray[i]).getStationName());
            }
            stringBuffer.append(";steps=");
            stringBuffer.append(ViewQueryParameter.encode(new BInstallBySpecStep(BInstallableSpec.make((BInstallable)bInstallable))));
            BOrd bOrd = BOrd.make((BOrd)bProvisioningService.getNavOrd(), (OrdQuery)new ViewQuery(stringBuffer.toString()));
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)bWbView);
            bWbShell.hyperlink(bOrd);
        }
        ((StationStatusModel)((Object)object2)).cleanup();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SnapshotCommand
    extends DialogCommand
    implements Runnable {
        public StationStatusModel model;
        public DaemonSessionTaskListener listener;

        public SnapshotCommand(BWidget bWidget, StationStatusModel stationStatusModel, DaemonSessionTaskListener daemonSessionTaskListener) {
            super(bWidget, -1, lex.getText("SoftwareContainerTree.stationStatus.snapshot"), null, null, null);
            this.model = stationStatusModel;
            this.listener = daemonSessionTaskListener;
        }

        public CommandArtifact doInvoke() throws Exception {
            new Thread(this).start();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setEnabled(false);
            try {
                int[] nArray = this.model.getSelection().getRows();
                DaemonSessionTask daemonSessionTask = new DaemonSessionTask(lex, "SoftwareContainerTree.stationStatus.snapshot.taskTitle", "");
                this.listener.taskStarted(daemonSessionTask);
                try {
                    for (int i = 0; i < nArray.length; ++i) {
                        daemonSessionTask.setMessage(lex.getText("SoftwareContainerTree.stationStatus.snapshot.taskMessage", new Object[]{this.model.getRow(nArray[i]).getStation().getStationName()}));
                        this.listener.taskUpdated(daemonSessionTask);
                        this.model.getRow(nArray[i]).updateSnapshot();
                    }
                    this.model.updateTable();
                }
                finally {
                    this.listener.taskFinished(daemonSessionTask);
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    private static class SelectOutOfDateCommand
    extends DialogCommand {
        public StationStatusModel model;

        public SelectOutOfDateCommand(BWidget bWidget, StationStatusModel stationStatusModel) {
            super(bWidget, -1, lex.getText("SoftwareContainerTree.stationStatus.selectOod"), null, null, null);
            this.model = stationStatusModel;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.model.getSelection().deselectAll();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                if (this.model.getStatusAt(i) != 8 && this.model.getStatusAt(i) != 16) continue;
                this.model.getSelection().select(i);
            }
            return null;
        }
    }

    private static class StationStatusModel
    extends TableModel
    implements SortableTableUtil.Model {
        private int sortColumn = 3;
        private boolean sortAscending = true;
        private boolean needsSort = false;
        private Array rows;

        public StationStatusModel(Array array) {
            this.rows = array;
            for (int i = 0; i < array.size(); ++i) {
                ((StationStatusRow)((Object)array.get(i))).setModel(this);
            }
            this.sortValues((Comparator)new SortableTableUtil.OriginalOrderComparator((SortableTableUtil.Model)this));
        }

        public void cleanup() {
            for (int i = 0; i < this.rows.size(); ++i) {
                ((StationStatusRow)((Object)this.rows.get(i))).cleanup();
            }
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("SoftwareContainerTree.stationStatus.station");
                }
                case 1: {
                    return lex.getText("SoftwareContainerTree.stationStatus.date");
                }
                case 2: {
                    return lex.getText("SoftwareContainerTree.stationStatus.version");
                }
                case 3: {
                    return lex.getText("SoftwareContainerTree.stationStatus.status");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getRow(n).getStation().getStationName();
                }
                case 1: {
                    return this.getRow(n).getExtension().getLastUpdate();
                }
                case 2: {
                    return this.getRow(n).getCurrentVersion();
                }
                case 3: {
                    return this.getRow(n).getComment();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getStatusAt(int n) {
            return this.getRow(n).getStatus();
        }

        public SortableTableUtil.SortableRow getSortableRow(int n) {
            return this.getRow(n);
        }

        public StationStatusRow getRow(int n) {
            return (StationStatusRow)((Object)this.rows.get(n));
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            if (!this.needsSort && n == this.sortColumn && bl == this.sortAscending) {
                return;
            }
            this.sortColumn = n;
            this.sortAscending = bl;
            this.sortValues(null);
        }

        protected void sortValues(Comparator comparator) {
            this.needsSort = false;
            this.rows = new Array(this.rows.trim()).sort((Comparator)new SortableTableUtil.RowComparator((SortableTableUtil.Model)this, comparator));
            if (this.getTable() != null) {
                this.getTable().getSelection().deselectAll();
                this.updateTable(true);
            }
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }
    }

    private static class StationStatusCellRenderer
    extends TableCellRenderer {
        private StationStatusModel model;

        public StationStatusCellRenderer(StationStatusModel stationStatusModel) {
            this.model = stationStatusModel;
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            int n = this.model.getStatusAt(cell.row);
            if (cell.column == 3) {
                switch (n) {
                    case -1: 
                    case 20: 
                    case 511: 
                    case 767: 
                    case 1279: {
                        return BColor.blue.toBrush();
                    }
                    case -2: 
                    case 8: 
                    case 16: 
                    case 24: 
                    case 32: 
                    case 34: {
                        return BColor.red.toBrush();
                    }
                }
            }
            return super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            int n = this.model.getStatusAt(cell.row);
            if (cell.column == 3) {
                switch (n) {
                    case -2: 
                    case 8: 
                    case 16: 
                    case 24: 
                    case 32: 
                    case 34: {
                        return BColor.red.toBrush();
                    }
                }
            }
            return super.getSelectionForeground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String string = this.getCellText(cell);
            double d = Theme.table().getCellFont().width(string) + 12.0;
            return d;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            this.paintCellBackground(graphics, cell);
            double d = 2.0;
            double d2 = (cell.height - 16.0) / 2.0;
            String string = this.getCellText(cell);
            BFont bFont = Theme.table().getCellFont();
            switch (this.model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    d = cell.width - 2.0 - bFont.width(string);
                    break;
                }
                case 1: {
                    d = (cell.width - bFont.width(string)) / 2.0;
                }
            }
            graphics.setFont(bFont);
            graphics.drawString(string, d, bFont.getAscent() + 2.0);
        }
    }

    private static class StationStatusRow
    extends Subscriber
    implements SortableTableUtil.SortableRow {
        private BSoftwareStationExt softwareExt;
        private BInstallable installable;
        private TableModel model = null;
        private BDaemonPlatform snapshot = null;

        public StationStatusRow(BSoftwareStationExt bSoftwareStationExt, BInstallable bInstallable) {
            this.softwareExt = bSoftwareStationExt;
            this.installable = bInstallable;
            this.subscribe((BComponent)bSoftwareStationExt, Integer.MAX_VALUE);
            if (!bSoftwareStationExt.getLastUpdate().isNull()) {
                this.snapshot = bSoftwareStationExt.getPlatformSnapshot();
            }
        }

        public void cleanup() {
            this.unsubscribeAll();
        }

        public void event(BComponentEvent bComponentEvent) {
            if (this.model != null) {
                this.model.updateTable();
            }
        }

        public String getStationName() {
            return this.getStation().getStationName();
        }

        public BNiagaraStation getStation() {
            return this.softwareExt.getNiagaraStation();
        }

        public BSoftwareStationExt getExtension() {
            return this.softwareExt;
        }

        public String getCurrentVersion() {
            BPart bPart = this.getCurrentPart();
            return bPart == null ? lex.getText("SoftwareContainerTree.stationStatus.none") : bPart.getVersion().toString();
        }

        public String getComment() {
            int n = this.getStatus();
            if (n == -2) {
                return lex.getText("SoftwareContainerTree.stationStatus.unoperational", new Object[]{this.getExtension().getStatus()});
            }
            if (n == -1) {
                return lex.getText("SoftwareContainerTree.stationStatus.unknown");
            }
            return SoftwareTableRow.statusToComment(n);
        }

        public Object getRowId() {
            return this.getStationName();
        }

        public int compareToRowForColumn(SortableTableUtil.SortableRow sortableRow, int n) {
            StationStatusRow stationStatusRow = (StationStatusRow)sortableRow;
            switch (n) {
                case 0: {
                    return TextUtil.toLowerCase((String)this.getStationName()).compareTo(TextUtil.toLowerCase((String)stationStatusRow.getStationName()));
                }
                case 3: {
                    return this.compareComment(stationStatusRow);
                }
                case 1: {
                    return this.getExtension().getLastUpdate().compareTo((Object)stationStatusRow.getExtension().getLastUpdate());
                }
                case 2: {
                    if (this.getCurrentPart() == null) {
                        if (stationStatusRow.getCurrentPart() == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (stationStatusRow.getCurrentPart() == null) {
                        return 1;
                    }
                    return this.getCurrentPart().getVersion().compareTo((Object)stationStatusRow.getCurrentPart().getVersion());
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getStatus() {
            if (this.getExtension().isUnoperational()) {
                return -2;
            }
            if (this.getExtension().getLastUpdate().isNull()) {
                return -1;
            }
            return SoftwareTableRow.getStatus(this.installable, this.getCurrentPart());
        }

        public void updateSnapshot() throws Exception {
            this.softwareExt.takeSnapshotSync();
            this.snapshot = this.getExtension().getPlatformSnapshot();
            if (this.model != null) {
                this.model.updateTable();
            }
        }

        public BPart getCurrentPart() {
            return this.snapshot == null ? null : this.snapshot.getPart(this.installable.getPart());
        }

        public int compareComment(StationStatusRow stationStatusRow) {
            int n;
            int n2 = SoftwareTableRow.getStatusRank(this.getStatus());
            if (n2 < (n = SoftwareTableRow.getStatusRank(stationStatusRow.getStatus()))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return TextUtil.toLowerCase((String)this.getComment()).compareTo(TextUtil.toLowerCase((String)stationStatusRow.getComment()));
        }

        public void setModel(TableModel tableModel) {
            this.model = tableModel;
        }
    }

    private static class Cancel
    extends DialogCommand {
        public boolean isCanceled = false;

        public Cancel(BWidget bWidget) {
            super(bWidget, 2, UiLexicon.bajaui.getText("dialog.cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            this.isCanceled = true;
            return null;
        }
    }

    private static class Close
    extends DialogCommand {
        public Close(BWidget bWidget) {
            super(bWidget, 1, lex.getText("SoftwareContainerTree.stationStatus.buildJob"), null, null, null);
        }
    }

    private static class CommandSupport
    implements CommandBindings.Support {
        private StationStatusModel model;

        public CommandSupport(StationStatusModel stationStatusModel) {
            this.model = stationStatusModel;
        }

        public void setBoundCommandEnabled(Command command, boolean bl) {
            if (bl && (command instanceof SnapshotCommand || command instanceof Close)) {
                int[] nArray = this.model.getSelection().getRows();
                for (int i = 0; i < nArray.length; ++i) {
                    if (this.model.getRow(nArray[i]).getStatus() != -2) continue;
                    command.setEnabled(false);
                    return;
                }
            }
            command.setEnabled(bl);
        }
    }
}

