/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.software;

import com.tridium.provisioning.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.ui.table.TableCellRenderer;

public class SoftwareCellRenderer
extends TableCellRenderer {
    public SoftwareTableModel getSoftwareTableModel() {
        return (SoftwareTableModel)this.getTable().getModel();
    }

    public BBrush getForeground(TableCellRenderer.Cell cell) {
        int n = this.getSoftwareTableModel().getStatusAt(cell.row);
        if (cell.column == 5) {
            switch (n) {
                case 20: 
                case 511: 
                case 767: 
                case 1279: {
                    return BColor.blue.toBrush();
                }
                case 8: 
                case 16: 
                case 24: 
                case 32: 
                case 34: {
                    return BColor.red.toBrush();
                }
            }
        }
        return super.getForeground(cell);
    }

    public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
        int n = this.getSoftwareTableModel().getStatusAt(cell.row);
        if (cell.column == 5) {
            switch (n) {
                case 8: 
                case 16: 
                case 24: 
                case 32: 
                case 34: {
                    return BColor.red.toBrush();
                }
            }
        }
        return super.getSelectionForeground(cell);
    }

    public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
        String string = this.getCellText(cell);
        double d = Theme.table().getCellFont().width(string) + 12.0;
        if (this.getSoftwareTableModel().getCellIcon(cell.row, cell.column) != null) {
            d += 20.0;
        }
        return d;
    }

    public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
        SoftwareTableModel softwareTableModel = this.getSoftwareTableModel();
        this.paintCellBackground(graphics, cell);
        double d = 2.0;
        double d2 = (cell.height - 16.0) / 2.0;
        BImage bImage = softwareTableModel.getCellIcon(cell.row, cell.column);
        if (bImage != null) {
            graphics.drawImage(bImage, d, d2);
            d += 20.0;
        }
        String string = this.getCellText(cell);
        BFont bFont = Theme.table().getCellFont();
        switch (softwareTableModel.getColumnAlignment(cell.column).getOrdinal()) {
            case 2: {
                d = cell.width - 2.0 - bFont.width(string);
                break;
            }
            case 1: {
                d = (cell.width - bFont.width(string)) / 2.0;
            }
        }
        graphics.setFont(bFont);
        graphics.drawString(string, d, bFont.getAscent() + 2.0);
    }
}

