/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.ToggleButtonTheme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class JobTable {
    public static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    public static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    public static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    public static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    public static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    public static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    public static final BImage openIcon = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    public static final BImage disposeIcon = BImage.make((String)"module://icons/x16/close.png");
    public static final Lexicon lex = Lexicon.make((String)"provisioning");
    public static final String lexStatus = UiLexicon.bajaui.getText("status");
    public static final String lexTimestamp = UiLexicon.bajaui.getText("timestamp");
    public static final String lexMessage = UiLexicon.bajaui.getText("message");
    public static final String lexDetails = UiLexicon.bajaui.getText("details");
    public static final String lexCancel = UiLexicon.bajaui.getText("cancel");
    public static final String lexLog = UiLexicon.bajaui.getText("log");
    public static final String lexJobLog = UiLexicon.bajaui.getText("job.log");
    public static final String lexLogDetails = UiLexicon.bajaui.getText("log.details");

    public static BCommandBoundTable makeListTable(TableModel tableModel, CommandBindings commandBindings, int n, Command command, Command command2) {
        return JobTable.makeListTable(tableModel, new ListTableController(commandBindings, n, command, command2));
    }

    public static BCommandBoundTable makeListTable(TableModel tableModel, int n, Command command, Command command2) {
        return JobTable.makeListTable(tableModel, new ListTableController(new CommandBindings(), n, command, command2));
    }

    public static BCommandBoundTable makeListTable(TableModel tableModel, ListTableController listTableController) {
        BCommandBoundTable bCommandBoundTable = new BCommandBoundTable(tableModel, (CommandBindings.TableController)listTableController);
        bCommandBoundTable.setCellRenderer((TableCellRenderer)new ListTableRenderer());
        return bCommandBoundTable;
    }

    public static void showLogDialog(BWidget bWidget, String string) throws Exception {
        JobTable.showLogDialog(bWidget, JobLog.decode((String)string));
    }

    public static void showLogDialog(BWidget bWidget, BJob bJob) throws Exception {
        JobTable.showLogDialog(bWidget, bJob.readLog().toString());
    }

    public static void showLogDialog(BWidget bWidget, JobLog jobLog) {
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)JobTable.makeLogDisplay(jobLog));
        bConstrainedPane.setFixedSize(800.0, 400.0);
        BDialog.open((BWidget)bWidget, (String)lexJobLog, (Object)bConstrainedPane, (int)1);
    }

    public static BTable makeLogDisplay(JobLog jobLog) {
        return new BTable((TableModel)new LogModel(jobLog), (TableController)new LogController());
    }

    public static BTable makeLogDisplay() {
        return new BTable((TableModel)new LogModel(), (TableController)new LogController());
    }

    public static BImage stateToIcon(BJobState bJobState) {
        switch (bJobState.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    public static BImage itemToIcon(JobLogItem jobLogItem) {
        switch (jobLogItem.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    private static class LogController
    extends TableController {
        private LogController() {
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            JobLogItem jobLogItem = ((LogModel)this.getModel()).items[n];
            BTextEditor bTextEditor = new BTextEditor(jobLogItem.toString(), false);
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lexLogDetails, (Object)bTextEditorPane, (int)1);
        }
    }

    public static class LogModel
    extends TableModel {
        private int count = 0;
        private JobLogItem[] items;
        private String[] messages;
        private String[] details;

        public LogModel() {
        }

        public LogModel(JobLog jobLog) {
            this.load(jobLog);
        }

        public void load(BJob bJob) throws Exception {
            this.load(bJob.readLog().toString());
        }

        public void load(String string) throws Exception {
            this.load(JobLog.decode((String)string));
        }

        public void load(JobLog jobLog) {
            this.items = jobLog.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage());
                this.details[i] = this.str(this.items[i].getDetails());
            }
            this.updateTable(true);
        }

        private String str(String string) {
            if (string == null) {
                return "";
            }
            int n = string.indexOf(10);
            if (n < 0) {
                return string;
            }
            return string.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.items[n].getIdString();
                }
                case 1: {
                    return this.items[n].getTimestamp();
                }
                case 2: {
                    return this.messages[n];
                }
                case 3: {
                    return this.details[n];
                }
            }
            return "???";
        }

        public Object getSubject(int n) {
            return this.items[n];
        }

        public BObject export(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.export(this.items[n].getIdString());
                }
                case 1: {
                    return this.items[n].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[n].getMessage());
                }
                case 3: {
                    return this.export(this.items[n].getDetails());
                }
            }
            return BString.DEFAULT;
        }

        private BString export(String string) {
            if (string == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)string);
        }

        public BImage getRowIcon(int n) {
            return JobTable.itemToIcon(this.items[n]);
        }
    }

    public static class ListTableRenderer
    extends TableCellRenderer {
        protected ListTableController controller() {
            return (ListTableController)this.getController();
        }

        public double getCellHeight() {
            return Math.max(Theme.table().getCellFont().getHeight() + 3.0, 20.0);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            double d = super.getPreferredCellWidth(cell);
            if (cell.column == this.controller().getButtonsCol()) {
                d += 37.0;
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintImageBorder(Graphics graphics, TableCellRenderer.Cell cell, double d) {
            graphics.push();
            try {
                double d2 = 18.0;
                double d3 = 18.0;
                graphics.translate(d, (cell.height - d3) / 2.0);
                ToggleButtonTheme toggleButtonTheme = Theme.toggleButton();
                graphics.setBrush(toggleButtonTheme.getControlForeground());
                graphics.strokeRect(0.0, 0.0, d2 - 1.0, d3 - 1.0);
                if (this.controller().isMouseDown()) {
                    graphics.setBrush(toggleButtonTheme.getControlShadow());
                } else {
                    graphics.setBrush(toggleButtonTheme.getControlHighlight());
                }
                graphics.strokeLine(1.0, 1.0, d2 - 3.0, 1.0);
                graphics.strokeLine(1.0, 1.0, 1.0, d3 - 3.0);
                if (this.controller().isMouseDown()) {
                    graphics.setBrush(toggleButtonTheme.getControlShadow());
                } else {
                    graphics.setBrush(toggleButtonTheme.getControlAuxiliary());
                }
                graphics.strokeLine(d2 - 2.0, 1.0, d2 - 2.0, d3 - 2.0);
                graphics.strokeLine(1.0, d3 - 2.0, d2 - 2.0, d3 - 2.0);
            }
            finally {
                graphics.pop();
            }
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.column == this.controller().getButtonsCol()) {
                this.paintCellBackground(graphics, cell);
                double d = (cell.height - 16.0) / 2.0;
                String string = this.getCellText(cell);
                BFont bFont = this.getFont(cell);
                double d2 = bFont.width(string) + 2.0;
                double d3 = 0.0;
                double d4 = cell.width - d2 - 2.0;
                if (this.controller().openVisible()) {
                    d4 -= 20.0;
                }
                if (this.controller().disposeVisible()) {
                    d4 -= 20.0;
                }
                graphics.setFont(bFont);
                graphics.drawString(string, d4, bFont.getAscent() + 2.0);
                d4 += d2;
                if (this.controller().openVisible()) {
                    if (this.controller().getRowHoveredOpen() == cell.row) {
                        this.paintImageBorder(graphics, cell, d4);
                    }
                    graphics.drawImage(openIcon, d4 + 1.0, d);
                    d4 += 20.0;
                }
                if (this.controller().disposeVisible()) {
                    if (this.controller().getRowHoveredDispose() == cell.row) {
                        this.paintImageBorder(graphics, cell, d4);
                    }
                    graphics.drawImage(disposeIcon, d4 + 1.0, d);
                }
            } else {
                super.paintCell(graphics, cell);
            }
        }
    }

    public static class ListTableController
    extends CommandBindings.TableController {
        private int buttonsCol;
        private int overDispose = -1;
        private int overOpen = -1;
        private boolean mouseDown = false;
        private Command disposeCommand = null;
        private Command openCommand = null;

        public ListTableController(CommandBindings commandBindings, int n, Command command, Command command2) {
            super(commandBindings);
            this.buttonsCol = n;
            this.disposeCommand = command2;
            this.openCommand = command;
        }

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            this.cellMoved(bMouseEvent, n, n2);
        }

        private boolean overDispose(int n, double d) {
            double d2;
            if (this.disposeCommand == null) {
                return false;
            }
            RectGeom rectGeom = this.getTable().getCellBounds(n, this.buttonsCol);
            double d3 = d - rectGeom.x();
            if (this.getTable().getHscrollBar().isVisible()) {
                d3 += (double)this.getTable().getHscrollBar().getPosition();
            }
            if ((d2 = rectGeom.width()) < 40.0) {
                if (d2 < 20.0) {
                    return false;
                }
                return d3 > d2 - 20.0;
            }
            return d3 > d2 - 20.0;
        }

        private boolean overOpen(int n, double d) {
            if (this.openCommand == null) {
                return false;
            }
            RectGeom rectGeom = this.getTable().getCellBounds(n, this.buttonsCol);
            double d2 = d - rectGeom.x();
            if (this.getTable().getHscrollBar().isVisible()) {
                d2 += (double)this.getTable().getHscrollBar().getPosition();
            }
            double d3 = rectGeom.width();
            if (this.disposeVisible()) {
                if (d3 < 40.0) {
                    return false;
                }
                if (d2 > d3 - 20.0) {
                    return false;
                }
                return d2 > d3 - 40.0;
            }
            if (d3 < 40.0) {
                if (d3 < 20.0) {
                    return false;
                }
                return d2 > d3 - 20.0;
            }
            return d2 > d3 - 20.0;
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            this.mouseDown = true;
            super.cellPressed(bMouseEvent, n, n2);
            if (n2 == this.buttonsCol) {
                this.getTable().repaint();
            }
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            this.mouseDown = false;
            super.cellReleased(bMouseEvent, n, n2);
            if (n2 == this.buttonsCol) {
                this.getTable().repaint();
                if (!bMouseEvent.isPopupTrigger() && bMouseEvent.getClickCount() == 1) {
                    if (this.overDispose(n, bMouseEvent.getX())) {
                        this.disposeCommand.invoke();
                    }
                    if (this.overOpen(n, bMouseEvent.getX())) {
                        this.getSelection().select(n, true);
                        this.openCommand.invoke();
                    }
                }
            }
        }

        protected void cellMoved(BMouseEvent bMouseEvent, int n, int n2) {
            BWidgetShell bWidgetShell = this.getShell();
            if (n2 == this.buttonsCol) {
                if (this.overDispose(n, bMouseEvent.getX())) {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus(this.disposeCommand.getDescription());
                    }
                    this.overDispose = n;
                    this.overOpen = -1;
                } else if (this.overOpen(n, bMouseEvent.getX())) {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus(this.openCommand.getDescription());
                    }
                    this.overDispose = -1;
                    this.overOpen = n;
                } else {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus("");
                    }
                    this.overDispose = -1;
                    this.overOpen = -1;
                }
                this.getTable().repaint();
            } else {
                if (this.overDispose != -1) {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus("");
                    }
                    this.overDispose = -1;
                    this.getTable().repaint();
                }
                if (this.overOpen != -1) {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus("");
                    }
                    this.overOpen = -1;
                    this.getTable().repaint();
                }
            }
        }

        protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 == this.buttonsCol) {
                BWidgetShell bWidgetShell = this.getShell();
                if (this.overDispose == n) {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus("");
                    }
                    this.overDispose = -1;
                    this.getTable().repaint();
                }
                if (this.overOpen == n) {
                    if (bWidgetShell != null) {
                        bWidgetShell.showStatus("");
                    }
                    this.overOpen = -1;
                    this.getTable().repaint();
                }
            }
        }

        public int getRowHoveredOpen() {
            return this.overOpen;
        }

        public int getRowHoveredDispose() {
            return this.overDispose;
        }

        public boolean isMouseDown() {
            return this.mouseDown;
        }

        public int getButtonsCol() {
            return this.buttonsCol;
        }

        public boolean openVisible() {
            return this.openCommand != null;
        }

        public boolean disposeVisible() {
            return this.disposeCommand != null;
        }
    }
}

