/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.ui.job.JobTable;
import javax.baja.gx.BInsets;
import javax.baja.job.BJobState;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BStationStepRecordView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$job$BStationStepRecordView == null ? (class$com$tridium$provisioning$ui$job$BStationStepRecordView = BStationStepRecordView.class$("com.tridium.provisioning.ui.job.BStationStepRecordView")) : class$com$tridium$provisioning$ui$job$BStationStepRecordView));
    protected JobTable.LogModel model;
    protected BGridPane upperPane;
    protected BButtonPane buttons;
    protected Command refreshLogCommand;
    private BLabel stationLabel;
    private BLabel typeLabel;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$job$BStationStepRecordView;

    public Type getType() {
        return TYPE;
    }

    public BStationStepRecordView() {
        this.autoRegisterForComponentEvents = false;
        this.upperPane = new BGridPane(2);
        this.upperPane.setHalign(BHalign.left);
        this.buttons = new BButtonPane();
        BTable bTable = JobTable.makeLogDisplay();
        this.model = (JobTable.LogModel)bTable.getModel();
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)this.upperPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.buttons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.upperPane.removeAll();
        this.buttons.removeAll();
        BStationStepRecord bStationStepRecord = (BStationStepRecord)bObject;
        for (BComplex bComplex = bStationStepRecord.getParent(); bComplex != null; bComplex = bComplex.getParent()) {
            if (!(bComplex instanceof BProvisioningJob)) continue;
            this.buttons.add((Command)new GoJobCommand((BProvisioningJob)bComplex));
            break;
        }
        this.loadRecord((BWidget)this, bObject, bStationStepRecord, this.upperPane, this.buttons, this.model);
    }

    public void loadRecord(BWidget bWidget, BObject bObject, BStationStepRecord bStationStepRecord, BGridPane bGridPane, BButtonPane bButtonPane, JobTable.LogModel logModel) throws Exception {
        this.stationLabel = new BLabel();
        this.typeLabel = new BLabel();
        this.startedLabel = new BLabel();
        this.endedLabel = new BLabel();
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"StationStepRecordView.station"), (BWidget)this.stationLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"StationStepRecordView.type"), (BWidget)this.typeLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"StationStepRecordView.started"), (BWidget)this.startedLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"StationStepRecordView.ended"), (BWidget)this.endedLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"StationStepRecordView.state"), (BWidget)this.stateLabel);
        this.stationLabel.setText(bStationStepRecord.getStationName());
        this.typeLabel.setText(bStationStepRecord.getStepDescription());
        this.startedLabel.setText(bStationStepRecord.getStartTime().toString());
        this.endedLabel.setText(bStationStepRecord.getStartTime().toString());
        this.stateLabel.setText(bStationStepRecord.getState().toString());
        logModel.load(bStationStepRecord.readLog().toString());
        this.refreshLogCommand = new RefreshLogCommand(bStationStepRecord);
        this.refreshLogCommand.setEnabled(!bStationStepRecord.getState().isComplete());
        bButtonPane.add(this.refreshLogCommand);
        if (bStationStepRecord.isMounted() && !bStationStepRecord.getState().isComplete()) {
            this.registerForComponentEvents(bStationStepRecord, Integer.MAX_VALUE);
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BStationStepRecord && bComponentEvent.getId() == 0) {
            if (bComponentEvent.getSlot() == BStationStepRecord.stationName) {
                this.stationLabel.setText(bComponentEvent.getValue().toString());
            } else if (bComponentEvent.getSlot() == BStationStepRecord.startTime) {
                this.startedLabel.setText(bComponentEvent.getValue().toString());
            } else if (bComponentEvent.getSlot() == BStationStepRecord.endTime) {
                this.endedLabel.setText(bComponentEvent.getValue().toString());
            } else if (bComponentEvent.getSlot() == BStationStepRecord.state) {
                if (((BJobState)bComponentEvent.getValue()).isComplete()) {
                    try {
                        this.model.load(((BStationStepRecord)bComponentEvent.getSourceComponent()).readLog().toString());
                        this.refreshLogCommand.setEnabled(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stateLabel.setText(bComponentEvent.getValue().toString());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RefreshLogCommand
    extends Command {
        private BStationStepRecord record;

        public RefreshLogCommand(BStationStepRecord bStationStepRecord) {
            super((BWidget)BStationStepRecordView.this, BStationStepRecordView.this.getLexicon(), "StationStepRecordView.refreshLogCommand");
            this.record = bStationStepRecord;
        }

        public CommandArtifact doInvoke() {
            try {
                BStationStepRecordView.this.model.load(this.record.readLog().toString());
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class GoJobCommand
    extends Command {
        private BProvisioningJob job;

        public GoJobCommand(BProvisioningJob bProvisioningJob) {
            super((BWidget)BStationStepRecordView.this, BStationStepRecordView.this.getLexicon(), "StationStepRecordView.goJobCommand");
            this.job = bProvisioningJob;
        }

        public CommandArtifact doInvoke() {
            try {
                BStationStepRecordView.this.getWbShell().hyperlink(this.job.getNavOrd());
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }
}

