/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BJobStepSummary;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.job.BStationStepLogFile;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.station.BStationProxy;
import com.tridium.provisioning.ui.job.JobTable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.view.BWbComponentView;

public class BStationJobList
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$job$BStationJobList == null ? (class$com$tridium$provisioning$ui$job$BStationJobList = BStationJobList.class$("com.tridium.provisioning.ui.job.BStationJobList")) : class$com$tridium$provisioning$ui$job$BStationJobList));
    private Model model;
    private LogCommand logCommand;
    public static final int COL_STEP_DESC = 0;
    public static final int COL_STEP_START = 1;
    public static final int COL_STEP_END = 2;
    public static final int COL_BUTTONS = 3;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$job$BStationJobList;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BProvisioningJobStep;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BStationStepRecord;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BJobStepSummary;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BProvisioningJob;

    public Type getType() {
        return TYPE;
    }

    public BStationJobList() {
        this.autoRegisterForComponentEvents = false;
        CommandBindings commandBindings = new CommandBindings();
        this.logCommand = new LogCommand();
        commandBindings.addCommand((Command)this.logCommand, BCommandEnablePolicy.singleSelection);
        StepCommand stepCommand = new StepCommand();
        commandBindings.addCommand((Command)stepCommand, BCommandEnablePolicy.singleSelection);
        JobCommand jobCommand = new JobCommand();
        commandBindings.addCommand((Command)jobCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.setDoubleClickCommand((Command)this.logCommand);
        this.model = new Model();
        BCommandBoundTable bCommandBoundTable = JobTable.makeListTable(this.model, commandBindings, 3, stepCommand, null);
        bCommandBoundTable.setMultipleSelection(false);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)new BButtonPane(commandBindings.getCommands()), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bCommandBoundTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BStationProxy bStationProxy = (BStationProxy)bObject;
        if (bStationProxy.getStatus().isFault()) {
            this.setContent((BWidget)new BLabel(this.getLexicon().getText("StationJobList.fault", new Object[]{bStationProxy.getFaultCause()})));
            return;
        }
        this.model.load(bStationProxy);
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BProvisioningService) {
            BProvisioningService bProvisioningService = (BProvisioningService)bComponentEvent.getSourceComponent();
            if (bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BProvisioningService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)bComponentEvent.getValue());
            }
        } else if (bComponentEvent.getId() == 1) {
            if (bComponentEvent.getValue() instanceof BProvisioningJob) {
                SlotCursor slotCursor = ((BProvisioningJob)bComponentEvent.getValue()).getProperties();
                while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? BStationJobList.class$("com.tridium.provisioning.job.BProvisioningJobStep") : class$com$tridium$provisioning$job$BProvisioningJobStep)) {
                    BProvisioningJobStep bProvisioningJobStep = (BProvisioningJobStep)slotCursor.get();
                    SlotCursor slotCursor2 = bProvisioningJobStep.getProperties();
                    while (slotCursor2.next(class$com$tridium$provisioning$job$BStationStepRecord == null ? BStationJobList.class$("com.tridium.provisioning.job.BStationStepRecord") : class$com$tridium$provisioning$job$BStationStepRecord)) {
                        BStationStepRecord bStationStepRecord = (BStationStepRecord)slotCursor2.get();
                        this.model.updateRecord(bStationStepRecord);
                    }
                }
                this.registerForComponentEvents((BComponent)((BProvisioningJob)bComponentEvent.getValue()), Integer.MAX_VALUE);
            } else if (bComponentEvent.getValue() instanceof BProvisioningJobStep) {
                BProvisioningJobStep bProvisioningJobStep = (BProvisioningJobStep)bComponentEvent.getValue();
                SlotCursor slotCursor = bProvisioningJobStep.getProperties();
                while (slotCursor.next(class$com$tridium$provisioning$job$BStationStepRecord == null ? BStationJobList.class$("com.tridium.provisioning.job.BStationStepRecord") : class$com$tridium$provisioning$job$BStationStepRecord)) {
                    BStationStepRecord bStationStepRecord = (BStationStepRecord)slotCursor.get();
                    this.model.updateRecord(bStationStepRecord);
                }
                this.registerForComponentEvents(bProvisioningJobStep, Integer.MAX_VALUE);
            } else if (bComponentEvent.getValue() instanceof BStationStepRecord) {
                BStationStepRecord bStationStepRecord = (BStationStepRecord)bComponentEvent.getValue();
                this.model.updateRecord(bStationStepRecord);
                this.registerForComponentEvents(bStationStepRecord, Integer.MAX_VALUE);
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BStationStepRecord) {
            this.model.updateRecord((BStationStepRecord)bComponentEvent.getSourceComponent());
        }
    }

    protected BStationProxy getStationExt() {
        return (BStationProxy)this.getCurrentValue();
    }

    protected String getStationName() {
        return this.getStationExt().getNiagaraStation().getStationName();
    }

    protected BProvisioningJob getJob(BStationStepRecord bStationStepRecord) {
        BProvisioningJobStep bProvisioningJobStep;
        if (bStationStepRecord.getParent() instanceof BProvisioningJobStep && (bProvisioningJobStep = (BProvisioningJobStep)bStationStepRecord.getParent()).getParent() instanceof BProvisioningJob) {
            return (BProvisioningJob)bProvisioningJobStep.getParent();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Key {
        private String stationName;
        private BAbsTime stepStart;
        private BTypeSpec stepType;

        public Key(BStationStepRecord bStationStepRecord) {
            this(bStationStepRecord.getStationName(), bStationStepRecord.getStartTime(), bStationStepRecord.getStepType());
        }

        public Key(BJobStepSummary bJobStepSummary) {
            this(bJobStepSummary.getStationName(), bJobStepSummary.getStartTime(), bJobStepSummary.getStepType());
        }

        public Key(String string, BAbsTime bAbsTime, BTypeSpec bTypeSpec) {
            this.stationName = string;
            this.stepStart = bAbsTime;
            this.stepType = bTypeSpec;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return key.stationName.equals(this.stationName) && key.stepStart.equals((Object)this.stepStart) && key.stepType.equals((Object)this.stepType);
            }
            return false;
        }

        public String toString() {
            return this.stationName + ":" + this.stepStart + ":" + this.stepType;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BStationJobList.this, BStationJobList.this.getLexicon(), "StationJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BStationStepRecord bStationStepRecord = BStationJobList.this.model.summary(BStationJobList.this.model.getTable().getSelection().getRow()).getStepRecord(BStationJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BStationJobList.this.model.getTable(), bStationStepRecord.readLog().toString());
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class JobCommand
    extends Command {
        public JobCommand() {
            super((BWidget)BStationJobList.this, BStationJobList.this.getLexicon(), "StationJobList.jobCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BJobStepSummary bJobStepSummary = BStationJobList.this.model.summary(BStationJobList.this.model.getTable().getSelection().getRow());
                BProvisioningJob bProvisioningJob = bJobStepSummary.getJob(BStationJobList.this.getCurrentValue());
                if (bProvisioningJob.getParent() instanceof BJobService) {
                    bOrd = bProvisioningJob.getAbsoluteOrd();
                } else {
                    BJobLogFile bJobLogFile = BJobLogFile.find(bProvisioningJob, BStationJobList.this.getCurrentValue());
                    bOrd = bJobLogFile.getAbsoluteOrd();
                }
                if (bProvisioningJob != null) {
                    BStationJobList.this.getWbShell().hyperlink(bOrd);
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class StepCommand
    extends Command {
        public StepCommand() {
            super((BWidget)BStationJobList.this, BStationJobList.this.getLexicon(), "StationJobList.stepCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BJobStepSummary bJobStepSummary = BStationJobList.this.model.summary(BStationJobList.this.model.getTable().getSelection().getRow());
                BStationStepRecord bStationStepRecord = bJobStepSummary.getStepRecord(BStationJobList.this.getCurrentValue());
                if (bStationStepRecord.getParent() instanceof BProvisioningJobStep) {
                    bOrd = BOrd.make((BOrd)BStationJobList.this.getStationExt().getAbsoluteOrd(), (BOrd)bStationStepRecord.getHandleOrd());
                } else {
                    BStationStepLogFile bStationStepLogFile = BStationStepLogFile.find(bJobStepSummary.getStationName(), bJobStepSummary.getStartTime(), bJobStepSummary.getStepType(), (BObject)BStationJobList.this.getStationExt());
                    bOrd = BOrd.make((BOrd)BStationJobList.this.getStationExt().getAbsoluteOrd(), (BOrd)bStationStepLogFile.getOrdInSession());
                }
                BStationJobList.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class Model
    extends TableModel {
        private Array rows = new Array(class$com$tridium$provisioning$job$BJobStepSummary == null ? (class$com$tridium$provisioning$job$BJobStepSummary = BStationJobList.class$("com.tridium.provisioning.job.BJobStepSummary")) : class$com$tridium$provisioning$job$BJobStepSummary);
        private Map summaryByKey = new HashMap();
        private Map summariesByJobStartTime = new HashMap();

        private Model() {
        }

        public synchronized void updateRecord(BStationStepRecord bStationStepRecord) {
            if (bStationStepRecord.getStationName().equals(BStationJobList.this.getStationName())) {
                Key key = new Key(bStationStepRecord);
                BJobStepSummary bJobStepSummary = (BJobStepSummary)((Object)this.summaryByKey.get(key));
                if (bJobStepSummary == null) {
                    BProvisioningJobStep bProvisioningJobStep;
                    BProvisioningJob bProvisioningJob;
                    if (bStationStepRecord.getParent() instanceof BProvisioningJobStep && (bProvisioningJob = (BProvisioningJob)(bProvisioningJobStep = (BProvisioningJobStep)bStationStepRecord.getParent()).getParent()) != null) {
                        bJobStepSummary = new BJobStepSummary(bStationStepRecord, bProvisioningJobStep.getType().getTypeSpec(), bProvisioningJob.getStartTime());
                        Array array = (Array)this.summariesByJobStartTime.get(bProvisioningJob.getStartTime());
                        if (array == null) {
                            array = new Array(class$com$tridium$provisioning$job$BJobStepSummary == null ? (class$com$tridium$provisioning$job$BJobStepSummary = BStationJobList.class$("com.tridium.provisioning.job.BJobStepSummary")) : class$com$tridium$provisioning$job$BJobStepSummary);
                            this.summariesByJobStartTime.put(bProvisioningJob.getStartTime(), array);
                        }
                        array.add((Object)bJobStepSummary);
                        this.rows.add(0, (Object)bJobStepSummary);
                        this.summaryByKey.put(key, bJobStepSummary);
                        this.updateTable(true);
                    }
                } else {
                    bJobStepSummary.update(bStationStepRecord);
                    this.updateTable(true);
                }
            }
        }

        public synchronized void handleJobDisposed(BAbsTime bAbsTime) {
            Array array = (Array)this.summariesByJobStartTime.get(bAbsTime);
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    BJobStepSummary bJobStepSummary = (BJobStepSummary)((Object)array.get(i));
                    this.rows.remove((Object)bJobStepSummary);
                    this.summaryByKey.remove(new Key(bJobStepSummary));
                }
                this.summariesByJobStartTime.remove(bAbsTime);
                this.updateTable(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void load(BStationProxy bStationProxy) throws Exception {
            Array array;
            Object object;
            BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)bStationProxy);
            BProvisioningService bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get((BObject)bStationProxy);
            String string = bStationProxy.getNiagaraStation().getStationName();
            Array array2 = new Array(class$com$tridium$provisioning$job$BJobStepSummary == null ? (class$com$tridium$provisioning$job$BJobStepSummary = BStationJobList.class$("com.tridium.provisioning.job.BJobStepSummary")) : class$com$tridium$provisioning$job$BJobStepSummary);
            HashMap<BAbsTime, Array> hashMap = new HashMap<BAbsTime, Array>();
            HashMap<Key, Object> hashMap2 = new HashMap<Key, Object>();
            SlotCursor slotCursor = bJobService.getProperties();
            while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJob == null ? BStationJobList.class$("com.tridium.provisioning.job.BProvisioningJob") : class$com$tridium$provisioning$job$BProvisioningJob)) {
                object = (BProvisioningJob)slotCursor.get();
                if (object.getJobState().isComplete()) continue;
                array = null;
                SlotCursor slotCursor2 = object.getProperties();
                while (slotCursor2.next(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? BStationJobList.class$("com.tridium.provisioning.job.BProvisioningJobStep") : class$com$tridium$provisioning$job$BProvisioningJobStep)) {
                    BProvisioningJobStep bProvisioningJobStep = (BProvisioningJobStep)slotCursor2.get();
                    SlotCursor slotCursor3 = bProvisioningJobStep.getProperties();
                    while (slotCursor3.next(class$com$tridium$provisioning$job$BStationStepRecord == null ? BStationJobList.class$("com.tridium.provisioning.job.BStationStepRecord") : class$com$tridium$provisioning$job$BStationStepRecord)) {
                        BStationStepRecord bStationStepRecord = (BStationStepRecord)slotCursor3.get();
                        if (!bStationStepRecord.getStationName().equals(string)) continue;
                        BJobStepSummary bJobStepSummary = new BJobStepSummary(bStationStepRecord, bProvisioningJobStep.getType().getTypeSpec(), object.getStartTime());
                        if (array == null) {
                            array = new Array(class$com$tridium$provisioning$job$BJobStepSummary == null ? BStationJobList.class$("com.tridium.provisioning.job.BJobStepSummary") : class$com$tridium$provisioning$job$BJobStepSummary);
                        }
                        array.add((Object)bJobStepSummary);
                        hashMap2.put(new Key(bStationStepRecord), (Object)bJobStepSummary);
                        array2.add((Object)bJobStepSummary);
                    }
                }
                if (array == null) continue;
                hashMap.put(object.getStartTime(), array);
            }
            slotCursor = BJobStepSummary.list(bStationProxy.getNiagaraStation());
            try {
                while (slotCursor.next(class$com$tridium$provisioning$job$BJobStepSummary == null ? BStationJobList.class$("com.tridium.provisioning.job.BJobStepSummary") : class$com$tridium$provisioning$job$BJobStepSummary)) {
                    object = (BJobStepSummary)slotCursor.get();
                    array2.add(object);
                    hashMap2.put(new Key((BJobStepSummary)((Object)object)), object);
                    array = (Array)hashMap.get(((BJobStepSummary)((Object)object)).getJobStartTime());
                    if (array == null) {
                        array = new Array(class$com$tridium$provisioning$job$BJobStepSummary == null ? BStationJobList.class$("com.tridium.provisioning.job.BJobStepSummary") : class$com$tridium$provisioning$job$BJobStepSummary);
                        hashMap.put(((BJobStepSummary)((Object)object)).getJobStartTime(), array);
                    }
                    array.add(object);
                }
            }
            finally {
                slotCursor.close();
            }
            array2 = array2.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    BJobStepSummary bJobStepSummary = (BJobStepSummary)((Object)object);
                    BJobStepSummary bJobStepSummary2 = (BJobStepSummary)((Object)object2);
                    return -1 * bJobStepSummary.getStartTime().compareTo((Object)bJobStepSummary2.getStartTime());
                }
            });
            this.summaryByKey = hashMap2;
            this.rows = array2;
            this.summariesByJobStartTime = hashMap;
            this.updateTable(true);
            BStationJobList.this.registerForComponentEvents((BComponent)bJobService, Integer.MAX_VALUE);
            BStationJobList.this.registerForComponentEvents((BComponent)bProvisioningService, Integer.MAX_VALUE);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BStationJobList.this.getLexicon().getText("StationJobList.col.stepDesc");
                }
                case 1: {
                    return BStationJobList.this.getLexicon().getText("StationJobList.col.stepStart");
                }
                case 2: {
                    return BStationJobList.this.getLexicon().getText("StationJobList.col.stepEnd");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.summary(n).getStepDescription();
                }
                case 1: {
                    return this.summary(n).getStartTime().toString();
                }
                case 2: {
                    return this.summary(n).getEndTime() == null ? "" : this.summary(n).getEndTime().toString();
                }
                case 3: {
                    return this.summary(n).getStepState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BJobStepSummary summary(int n) {
            return (BJobStepSummary)((Object)this.rows.get(n));
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.summary(n).getStepState());
        }
    }
}

