/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobSummary;
import com.tridium.provisioning.ui.job.BProvisioningJobBuilder;
import com.tridium.provisioning.ui.job.JobTable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.workbench.view.BWbComponentView;

public class BProvisioningJobList
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$job$BProvisioningJobList == null ? (class$com$tridium$provisioning$ui$job$BProvisioningJobList = BProvisioningJobList.class$("com.tridium.provisioning.ui.job.BProvisioningJobList")) : class$com$tridium$provisioning$ui$job$BProvisioningJobList));
    private Model model;
    private LogCommand logCommand;
    private DisposeCommand disposeCommand;
    private CancelCommand cancelCommand;
    public static final int COL_JOB_START = 0;
    public static final int COL_JOB_END = 1;
    public static final int COL_JOB_USER = 2;
    public static final int COL_BUTTONS = 3;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$job$BProvisioningJobList;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BProvisioningJobSummary;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BProvisioningJob;

    public Type getType() {
        return TYPE;
    }

    public BProvisioningJobList() {
        this.autoRegisterForComponentEvents = false;
        CommandBindings commandBindings = new CommandBindings();
        commandBindings.setSupport((CommandBindings.Support)this);
        commandBindings.addCommand((Command)new MakeJobCommand(), BCommandEnablePolicy.always);
        this.logCommand = new LogCommand();
        commandBindings.addCommand((Command)this.logCommand, BCommandEnablePolicy.singleSelection);
        OpenCommand openCommand = new OpenCommand();
        commandBindings.addCommand((Command)openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelCommand = new CancelCommand();
        commandBindings.addCommand((Command)this.cancelCommand, BCommandEnablePolicy.anySelection);
        this.disposeCommand = new DisposeCommand();
        commandBindings.addCommand((Command)this.disposeCommand, BCommandEnablePolicy.anySelection);
        commandBindings.setDoubleClickCommand((Command)this.logCommand);
        this.model = new Model();
        BCommandBoundTable bCommandBoundTable = JobTable.makeListTable(this.model, commandBindings, 3, openCommand, this.disposeCommand);
        bCommandBoundTable.setMultipleSelection(true);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)new BButtonPane(commandBindings.getCommands()), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bCommandBoundTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.model.load((BProvisioningService)bObject);
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BProvisioningService) {
            BProvisioningService bProvisioningService = (BProvisioningService)bComponentEvent.getSourceComponent();
            if (bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BProvisioningService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)bComponentEvent.getValue());
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BJobService) {
            BJobService bJobService = (BJobService)bComponentEvent.getSourceComponent();
            if (bComponentEvent.getId() == 1 && bComponentEvent.getValue() instanceof BProvisioningJob) {
                BProvisioningJob bProvisioningJob = (BProvisioningJob)bComponentEvent.getValue();
                this.model.updateJob(bProvisioningJob);
                this.registerForComponentEvents((BComponent)bProvisioningJob, 1);
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BProvisioningJob) {
            this.model.updateJob((BProvisioningJob)bComponentEvent.getSourceComponent());
        }
    }

    public BProvisioningService getProvisioningService() {
        return (BProvisioningService)this.getCurrentValue();
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command == this.disposeCommand) {
            int[] nArray = this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.model.summary(nArray[i]).getJobState().isComplete()) continue;
                command.setEnabled(false);
                return;
            }
        } else if (command == this.cancelCommand) {
            int[] nArray = this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.model.summary(nArray[i]).getJobState() == BJobState.running) continue;
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BProvisioningJobList.this, BProvisioningJobList.this.getLexicon(), "ProvisioningJobList.cancelCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BProvisioningJobList.this.model.getTable(), (String)BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.cancelCommand.dlgTitle"), (Object)BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.cancelCommand.dlgMessage"))) {
                    BProvisioningJobList.this.model.cancel(BProvisioningJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BProvisioningJobList.this, BProvisioningJobList.this.getLexicon(), "ProvisioningJobList.disposeCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BProvisioningJobList.this.model.getTable(), (String)BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.disposeCommand.dlgTitle"), (Object)BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.disposeCommand.dlgMessage"))) {
                    BProvisioningJobList.this.model.dispose(BProvisioningJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BProvisioningJobList.this, BProvisioningJobList.this.getLexicon(), "ProvisioningJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BProvisioningJob bProvisioningJob = BProvisioningJobList.this.model.summary(BProvisioningJobList.this.model.getTable().getSelection().getRow()).getJob(BProvisioningJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BProvisioningJobList.this.model.getTable(), bProvisioningJob);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BProvisioningJobList.this, BProvisioningJobList.this.getLexicon(), "ProvisioningJobList.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BProvisioningJobSummary bProvisioningJobSummary = BProvisioningJobList.this.model.summary(BProvisioningJobList.this.model.getTable().getSelection().getRow());
                BProvisioningJob bProvisioningJob = bProvisioningJobSummary.getJob(BProvisioningJobList.this.getCurrentValue());
                if (bProvisioningJob.getParent() instanceof BJobService) {
                    bOrd = BOrd.make((BOrd)((BProvisioningService)BProvisioningJobList.this.getCurrentValue()).getAbsoluteOrd(), (BOrd)bProvisioningJob.getHandleOrd());
                } else {
                    BJobLogFile bJobLogFile = BJobLogFile.find(bProvisioningJob, BProvisioningJobList.this.getCurrentValue());
                    bOrd = BOrd.make((BOrd)((BProvisioningService)BProvisioningJobList.this.getCurrentValue()).getAbsoluteOrd(), (BOrd)bJobLogFile.getOrdInSession());
                }
                BProvisioningJobList.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class MakeJobCommand
    extends Command {
        public MakeJobCommand() {
            super((BWidget)BProvisioningJobList.this, BProvisioningJobList.this.getLexicon(), "ProvisioningJobList.makeJobCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BProvisioningJobList.this.getWbShell().hyperlink(BOrd.make((BOrd)((BProvisioningService)BProvisioningJobList.this.getCurrentValue()).getAbsoluteOrd(), (OrdQuery)new ViewQuery(BProvisioningJobBuilder.TYPE.toString())));
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class Model
    extends TableModel {
        private Array rows = new Array(class$com$tridium$provisioning$job$BProvisioningJobSummary == null ? (class$com$tridium$provisioning$job$BProvisioningJobSummary = BProvisioningJobList.class$("com.tridium.provisioning.job.BProvisioningJobSummary")) : class$com$tridium$provisioning$job$BProvisioningJobSummary);
        private Map summaryByStartTime = new HashMap();

        private Model() {
        }

        public synchronized void updateJob(BProvisioningJob bProvisioningJob) {
            BProvisioningJobSummary bProvisioningJobSummary = (BProvisioningJobSummary)((Object)this.summaryByStartTime.get(bProvisioningJob.getStartTime()));
            if (bProvisioningJobSummary == null) {
                bProvisioningJobSummary = new BProvisioningJobSummary(bProvisioningJob);
                this.rows.add(0, (Object)bProvisioningJobSummary);
                this.summaryByStartTime.put(bProvisioningJob.getStartTime(), bProvisioningJobSummary);
            } else {
                bProvisioningJobSummary.updateJob(bProvisioningJob);
            }
            this.updateTable(true);
        }

        public synchronized void handleJobDisposed(BAbsTime bAbsTime) {
            BProvisioningJobSummary bProvisioningJobSummary = (BProvisioningJobSummary)((Object)this.summaryByStartTime.get(bAbsTime));
            if (bProvisioningJobSummary != null) {
                this.rows.remove((Object)bProvisioningJobSummary);
                this.summaryByStartTime.remove(bAbsTime);
                this.updateTable(false);
            }
        }

        public synchronized void dispose(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                BProvisioningJobList.this.getProvisioningService().disposeJob(this.summary(nArray[i]).getStartTime());
            }
        }

        public synchronized void cancel(int[] nArray) throws Exception {
            for (int i = 0; i < nArray.length; ++i) {
                this.summary(nArray[i]).getJob(BProvisioningJobList.this.getCurrentValue()).cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void load(BProvisioningService bProvisioningService) throws Exception {
            Object object;
            BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)bProvisioningService);
            bJobService.lease(2);
            Array array = new Array(class$com$tridium$provisioning$job$BProvisioningJobSummary == null ? (class$com$tridium$provisioning$job$BProvisioningJobSummary = BProvisioningJobList.class$("com.tridium.provisioning.job.BProvisioningJobSummary")) : class$com$tridium$provisioning$job$BProvisioningJobSummary);
            HashMap hashMap = new HashMap();
            HashMap<BAbsTime, Object> hashMap2 = new HashMap<BAbsTime, Object>();
            SlotCursor slotCursor = bJobService.getProperties();
            while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJob == null ? BProvisioningJobList.class$("com.tridium.provisioning.job.BProvisioningJob") : class$com$tridium$provisioning$job$BProvisioningJob)) {
                object = (BProvisioningJob)slotCursor.get();
                if (object.getJobState().isComplete()) continue;
                BProvisioningJobSummary bProvisioningJobSummary = new BProvisioningJobSummary((BProvisioningJob)((Object)object));
                array.add((Object)bProvisioningJobSummary);
                hashMap2.put(object.getStartTime(), (Object)bProvisioningJobSummary);
            }
            slotCursor = BProvisioningJobSummary.list((BObject)bProvisioningService);
            try {
                while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJobSummary == null ? BProvisioningJobList.class$("com.tridium.provisioning.job.BProvisioningJobSummary") : class$com$tridium$provisioning$job$BProvisioningJobSummary)) {
                    object = (BProvisioningJobSummary)slotCursor.get();
                    array.add(object);
                    hashMap2.put(((BProvisioningJobSummary)((Object)object)).getStartTime(), object);
                }
            }
            finally {
                slotCursor.close();
            }
            array = array.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    BProvisioningJobSummary bProvisioningJobSummary = (BProvisioningJobSummary)((Object)object);
                    BProvisioningJobSummary bProvisioningJobSummary2 = (BProvisioningJobSummary)((Object)object2);
                    return -1 * bProvisioningJobSummary.getStartTime().compareTo((Object)bProvisioningJobSummary2.getStartTime());
                }
            });
            this.summaryByStartTime = hashMap2;
            this.rows = array;
            this.updateTable(true);
            BProvisioningJobList.this.registerForComponentEvents((BComponent)bJobService, 2);
            BProvisioningJobList.this.registerForComponentEvents((BComponent)bProvisioningService, 1);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.col.jobStart");
                }
                case 1: {
                    return BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.col.jobEnd");
                }
                case 2: {
                    return BProvisioningJobList.this.getLexicon().getText("ProvisioningJobList.col.user");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.summary(n).getStartTime().toString();
                }
                case 1: {
                    return this.summary(n).getEndTime() == null ? "" : this.summary(n).getEndTime().toString();
                }
                case 2: {
                    return this.summary(n).getSubmitUser();
                }
                case 3: {
                    return this.summary(n).getJobState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BProvisioningJobSummary summary(int n) {
            return (BProvisioningJobSummary)((Object)this.rows.get(n));
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.summary(n).getJobState());
        }
    }
}

