/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.job;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.job.BStationStepLogFile;
import java.io.IOException;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.log.Log;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BStationStepRecord
extends BComponent {
    public static final Property stationName = BStationStepRecord.newProperty((int)1, (String)"", null);
    public static final Property stepType = BStationStepRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property stepDescription = BStationStepRecord.newProperty((int)1, (String)"", null);
    public static final Property state = BStationStepRecord.newProperty((int)1, (BValue)BJobState.running, null);
    public static final Property startTime = BStationStepRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property endTime = BStationStepRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action readLog = BStationStepRecord.newAction((int)0, null);
    public static final Action cancel = BStationStepRecord.newAction((int)4, null);
    public static final Action dispose = BStationStepRecord.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$job$BStationStepRecord == null ? (class$com$tridium$provisioning$job$BStationStepRecord = BStationStepRecord.class$("com.tridium.provisioning.job.BStationStepRecord")) : class$com$tridium$provisioning$job$BStationStepRecord));
    private BProvisioningJobStep step = null;
    private JobLog log = null;
    private BStationStepLogFile logFile = null;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BStationStepRecord;

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String string) {
        this.setString(stationName, string, null);
    }

    public BTypeSpec getStepType() {
        return (BTypeSpec)this.get(stepType);
    }

    public void setStepType(BTypeSpec bTypeSpec) {
        this.set(stepType, (BValue)bTypeSpec, null);
    }

    public String getStepDescription() {
        return this.getString(stepDescription);
    }

    public void setStepDescription(String string) {
        this.setString(stepDescription, string, null);
    }

    public BJobState getState() {
        return (BJobState)this.get(state);
    }

    public void setState(BJobState bJobState) {
        this.set(state, (BValue)bJobState, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime bAbsTime) {
        this.set(startTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime bAbsTime) {
        this.set(endTime, (BValue)bAbsTime, null);
    }

    public BString readLog() {
        return (BString)this.invoke(readLog, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void dispose() {
        this.invoke(dispose, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationStepRecord() {
    }

    public BStationStepRecord(BNiagaraStation bNiagaraStation, BProvisioningJobStep bProvisioningJobStep) {
        this.setStation(bNiagaraStation);
        this.setStepType(bProvisioningJobStep.getType().getTypeSpec());
        this.setStartTime(BAbsTime.now());
        this.setStepDescription(bProvisioningJobStep.toString(null));
        this.step = bProvisioningJobStep;
        this.log = new JobLog();
    }

    public void setStation(BNiagaraStation bNiagaraStation) {
        this.setStationName(bNiagaraStation.getStationName());
    }

    public BNiagaraStation getStation() {
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[i];
            if (!bNiagaraStation.getStationName().equals(this.getStationName())) continue;
            return bNiagaraStation;
        }
        return null;
    }

    public BProvisioningJobStep getStep() {
        return this.step;
    }

    public BProvisioningJob getJob() {
        return this.step == null ? null : this.step.getJob();
    }

    public void doCancel() {
        BJobState bJobState = this.getState();
        if (bJobState.isRunning()) {
            this.setState(BJobState.canceling);
            this.getJob().cancelStation(BString.make((String)this.getStationName()));
        } else if (bJobState != BJobState.success && bJobState != BJobState.failed) {
            this.setState(BJobState.canceled);
            this.getJob().cancelStation(BString.make((String)this.getStationName()));
        }
    }

    public void doDispose() {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        try {
            BStationStepLogFile bStationStepLogFile = BStationStepLogFile.find(this, null);
            try {
                Log.getLog((String)"provisioning").trace("Deleting log file " + bStationStepLogFile.getFilePath().getBody());
                bStationStepLogFile.delete();
            }
            catch (IOException iOException) {
                Log.getLog((String)"provisioning").error("Error deleting log file " + bStationStepLogFile.getFilePath().getBody(), (Throwable)iOException);
            }
        }
        catch (UnresolvedException unresolvedException) {
            unresolvedException.printStackTrace();
            Log.getLog((String)"provisioning").trace("Log file not found", (Throwable)unresolvedException);
        }
    }

    public void success() {
        this.success("Step successfully completed for " + this.getStationName());
        this.complete(BJobState.success);
    }

    public void failed(Throwable throwable) {
        this.failed("Step \"" + this.getStepDescription() + "\" failed for " + this.getStationName(), throwable);
        this.complete(BJobState.failed);
    }

    public void canceled() {
        this.complete(BJobState.canceled);
    }

    public void complete(BJobState bJobState) {
        if (!bJobState.isComplete()) {
            throw new IllegalArgumentException("Cannot complete as " + bJobState);
        }
        this.setState(bJobState);
        this.setEndTime(Clock.time());
    }

    public void setLogFile(BStationStepLogFile bStationStepLogFile) {
        this.logFile = bStationStepLogFile;
    }

    public BStationStepLogFile getLogFile() {
        if (this.logFile == null) {
            this.logFile = BStationStepLogFile.find(this, null);
        }
        return this.logFile;
    }

    public void start(String string) {
        this.log.start(string);
        this.getJob().log().start(string);
    }

    public void endSuccess(String string) {
        this.log.endSuccess(string);
        this.getJob().log().endSuccess(string);
    }

    public void endSuccess() {
        this.log.endSuccess();
        this.getJob().log().endSuccess();
    }

    public void endFailed(String string, Throwable throwable) {
        this.log.endFailed(string, throwable);
        this.getJob().log().endFailed(string, throwable);
    }

    public void endFailed(Throwable throwable) {
        this.log.endFailed(throwable);
        this.getJob().log().endFailed(throwable);
    }

    public void endFailed(String string) {
        this.log.endFailed(string);
        this.getJob().log().endFailed(string);
    }

    public void end(int n, String string, Throwable throwable) {
        this.log.end(n, string, throwable);
        this.getJob().log().end(n, string, throwable);
    }

    public void message(String string) {
        this.log.message(string);
        this.getJob().log().message(string);
    }

    public void success(String string) {
        this.log.success(string);
        this.getJob().log().success(string);
    }

    public void failed(String string, Throwable throwable) {
        this.log.failed(string, throwable);
        this.getJob().log().failed(string, throwable);
    }

    public void failed(String string) {
        this.log.failed(string);
        this.getJob().log().failed(string);
    }

    public void add(JobLogItem jobLogItem) {
        this.log.add(jobLogItem);
        this.getJob().log().add(jobLogItem);
    }

    public JobLog log() {
        return this.log;
    }

    public void resetLog() {
        this.log = null;
    }

    public BString doReadLog() {
        if (this.log == null) {
            BStationStepLogFile bStationStepLogFile = this.getLogFile();
            if (bStationStepLogFile == null) {
                return BString.DEFAULT;
            }
            try {
                return bStationStepLogFile.getLogContents();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException();
            }
        }
        return BString.make((String)this.log.encode());
    }

    public String getFailureAlarmMessage() {
        for (int i = this.log.size(); i > 0; --i) {
            JobLogItem jobLogItem = this.log.getItem(i - 1);
            if (jobLogItem.getId() != 4 && jobLogItem.getId() != 2) continue;
            return jobLogItem.toString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

