/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.job;

import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.util.TimeFormat;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.BogDecoder;
import javax.baja.io.BogEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.TextUtil;

public class BStationStepLogFile
extends BAbstractFile {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$job$BStationStepLogFile == null ? (class$com$tridium$provisioning$job$BStationStepLogFile = BStationStepLogFile.class$("com.tridium.provisioning.job.BStationStepLogFile")) : class$com$tridium$provisioning$job$BStationStepLogFile));
    private BStationStepRecord record = null;
    private BAbsTime jobStartTime = null;
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    static /* synthetic */ Class class$com$tridium$provisioning$job$BStationStepLogFile;

    public Type getType() {
        return TYPE;
    }

    public BStationStepLogFile(BIFileStore bIFileStore) {
        super(bIFileStore);
    }

    public BStationStepLogFile() {
    }

    public static BStationStepLogFile[] list(String string) {
        return BStationStepLogFile.list(string, null);
    }

    public static BStationStepLogFile[] list(String string, BTypeSpec bTypeSpec) {
        Array array;
        block5: {
            FilePath filePath = new FilePath("^provisioning/stationData");
            filePath = filePath.merge(string).merge("jobLog");
            array = new Array(class$com$tridium$provisioning$job$BStationStepLogFile == null ? (class$com$tridium$provisioning$job$BStationStepLogFile = BStationStepLogFile.class$("com.tridium.provisioning.job.BStationStepLogFile")) : class$com$tridium$provisioning$job$BStationStepLogFile);
            BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(filePath);
            if (bDirectory == null) break block5;
            if (bTypeSpec == null) {
                BIFile[] bIFileArray = bDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!(bIFileArray[i] instanceof BDirectory)) continue;
                    BIFile[] bIFileArray2 = ((BDirectory)bIFileArray[i]).listFiles();
                    for (int j = 0; j < bIFileArray2.length; ++j) {
                        if (!(bIFileArray2[j] instanceof BStationStepLogFile)) continue;
                        array.add((Object)bIFileArray2[j]);
                    }
                }
            } else {
                bDirectory = (BDirectory)bDirectory.getNavChild(bTypeSpec.getModuleName() + "_" + bTypeSpec.getTypeName());
                BIFile[] bIFileArray = bDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!(bIFileArray[i] instanceof BStationStepLogFile)) continue;
                    array.add((Object)bIFileArray[i]);
                }
            }
        }
        return (BStationStepLogFile[])array.trim();
    }

    public static BStationStepLogFile find(String string, BAbsTime bAbsTime, BTypeSpec bTypeSpec, BObject bObject) {
        return (BStationStepLogFile)BOrd.make((OrdQuery)BStationStepLogFile.path(string, bAbsTime, bTypeSpec)).get(bObject);
    }

    public static BStationStepLogFile find(BStationStepRecord bStationStepRecord, BObject bObject) {
        return BStationStepLogFile.find(bStationStepRecord.getStationName(), bStationStepRecord.getStartTime(), bStationStepRecord.getStepType(), bObject);
    }

    public static BStationStepLogFile findLocal(String string, BAbsTime bAbsTime, BTypeSpec bTypeSpec) {
        return (BStationStepLogFile)BOrd.make((OrdQuery)BStationStepLogFile.path(string, bAbsTime, bTypeSpec)).get();
    }

    public static BStationStepLogFile create(BStationStepRecord bStationStepRecord, BAbsTime bAbsTime) throws Exception {
        BStationStepLogFile bStationStepLogFile = (BStationStepLogFile)BFileSystem.INSTANCE.makeFile(BStationStepLogFile.path(bStationStepRecord.getStationName(), bStationStepRecord.getStartTime(), bStationStepRecord.getStepType()));
        OutputStream outputStream = bStationStepLogFile.getOutputStream();
        BogEncoder bogEncoder = new BogEncoder(outputStream);
        bogEncoder.setEncodeTransients(true);
        BComponent bComponent = new BComponent();
        bComponent.add("stepRecord", bStationStepRecord.newCopy());
        bComponent.add("jobStartTime", (BValue)bAbsTime);
        bComponent.add("logContents", (BValue)BString.make((String)bStationStepRecord.log().encode()));
        bogEncoder.setZipped(true);
        bogEncoder.encodeDocument((BValue)bComponent);
        bogEncoder.close();
        outputStream.close();
        return bStationStepLogFile;
    }

    public BTypeSpec getStepType() {
        String[] stringArray = TextUtil.split((String)this.getFilePath().getParent().getName(), (char)'_');
        return BTypeSpec.make((String)stringArray[0], (String)stringArray[1]);
    }

    public BStationStepRecord getRecord() throws Exception {
        this.parse();
        return this.record;
    }

    public BAbsTime getJobStartTime() throws Exception {
        this.parse();
        return this.jobStartTime;
    }

    public BString getLogContents() throws Exception {
        BComponent bComponent = (BComponent)new BogDecoder((BIFile)this).decodeDocument();
        BString bString = (BString)bComponent.get("logContents");
        if (bString == null) {
            this.record = (BStationStepRecord)bComponent.get("stepRecord");
            bString = (BString)this.record.get("logContents");
        }
        if (bString == null) {
            bString = BString.DEFAULT;
        }
        return bString;
    }

    public BProvisioningJob getJob() throws Exception {
        return this.getJobLogFile().getJob();
    }

    public BJobLogFile getJobLogFile() throws Exception {
        return BJobLogFile.find(this.getJobStartTime(), (BObject)this);
    }

    public void setStore(BIFileStore bIFileStore) {
        super.setStore(bIFileStore);
        this.record = null;
        this.jobStartTime = null;
    }

    public String getMimeType() {
        return "application/niagara-jobstep-log";
    }

    public String getNavDescription(Context context) {
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String string) {
        return null;
    }

    private void parse() throws Exception {
        if (this.record == null) {
            BComponent bComponent = (BComponent)new BogDecoder((BIFile)this).decodeDocument();
            this.record = (BStationStepRecord)bComponent.get("stepRecord");
            this.jobStartTime = (BAbsTime)bComponent.get("jobStartTime");
            this.record.setLogFile(this);
        }
    }

    private static FilePath path(String string, BAbsTime bAbsTime, BTypeSpec bTypeSpec) {
        String string2 = TimeFormat.format((BAbsTime)bAbsTime, (Context)TIMESTAMP_FORMAT) + ".pstp";
        FilePath filePath = new FilePath("^provisioning/stationData");
        filePath = filePath.merge(string).merge("jobLog");
        filePath = filePath.merge(bTypeSpec.getModuleName() + "_" + bTypeSpec.getTypeName());
        return filePath.merge(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

