/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.job;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.job.BStationStepLogFile;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.job.IJobDispatcher;
import java.io.IOException;
import javax.baja.driver.BDevice;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFolder;

public class BProvisioningJob
extends BJob
implements ICancelHint {
    public static final Property alertOnStepFailure = BProvisioningJob.newProperty((int)1, (boolean)true, null);
    public static final Property alertOnJobSuccess = BProvisioningJob.newProperty((int)1, (boolean)false, null);
    public static final Property stationState = BProvisioningJob.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property submitUser = BProvisioningJob.newProperty((int)1, (String)"unknown", null);
    public static final Action cancelStation = BProvisioningJob.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$job$BProvisioningJob == null ? (class$com$tridium$provisioning$job$BProvisioningJob = BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJob")) : class$com$tridium$provisioning$job$BProvisioningJob));
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private BJobLogFile jobFile = null;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BProvisioningJob;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$job$BJobState;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BProvisioningJobStep;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BStationStepRecord;

    public boolean getAlertOnStepFailure() {
        return this.getBoolean(alertOnStepFailure);
    }

    public void setAlertOnStepFailure(boolean bl) {
        this.setBoolean(alertOnStepFailure, bl, null);
    }

    public boolean getAlertOnJobSuccess() {
        return this.getBoolean(alertOnJobSuccess);
    }

    public void setAlertOnJobSuccess(boolean bl) {
        this.setBoolean(alertOnJobSuccess, bl, null);
    }

    public BFolder getStationState() {
        return (BFolder)this.get(stationState);
    }

    public void setStationState(BFolder bFolder) {
        this.set(stationState, (BValue)bFolder, null);
    }

    public String getSubmitUser() {
        return this.getString(submitUser);
    }

    public void setSubmitUser(String string) {
        this.setString(submitUser, string, null);
    }

    public void cancelStation(BString bString) {
        this.invoke(cancelStation, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProvisioningJob() {
    }

    public BProvisioningJob(String string) {
        this.getStationState().add(SlotPath.escape((String)string), (BValue)BJobState.unknown, 1);
    }

    public BProvisioningJob(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.getStationState().add(SlotPath.escape((String)stringArray[i]), (BValue)BJobState.unknown, 1);
        }
    }

    public static BProvisioningJob findMounted(BAbsTime bAbsTime, BObject bObject) {
        BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get(bObject);
        bJobService.lease(2);
        BJob[] bJobArray = bJobService.getJobs();
        for (int i = 0; i < bJobArray.length; ++i) {
            if (!(bJobArray[i] instanceof BProvisioningJob) || !bAbsTime.equals((Object)bJobArray[i].getStartTime())) continue;
            return (BProvisioningJob)bJobArray[i];
        }
        return null;
    }

    public static BProvisioningJob find(BAbsTime bAbsTime, BObject bObject) {
        BProvisioningJob bProvisioningJob = BProvisioningJob.findMounted(bAbsTime, bObject);
        if (bProvisioningJob != null) {
            return bProvisioningJob;
        }
        try {
            BJobLogFile bJobLogFile = BJobLogFile.find(bAbsTime, bObject);
            return bJobLogFile.getJob();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BJobState getStationState(String string) {
        return (BJobState)this.getStationState().get(SlotPath.escape((String)string));
    }

    public void setStationState(String string, BJobState bJobState) {
        this.getStationState().set(SlotPath.escape((String)string), (BValue)bJobState);
    }

    public String[] getStationNames() {
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BProvisioningJob.class$("java.lang.String")) : class$java$lang$String);
        SlotCursor slotCursor = this.getStationState().getProperties();
        while (slotCursor.next(class$javax$baja$job$BJobState == null ? BProvisioningJob.class$("javax.baja.job.BJobState") : class$javax$baja$job$BJobState)) {
            array.add((Object)SlotPath.unescape((String)slotCursor.property().getName()));
        }
        return (String[])array.trim();
    }

    public void addStep(BProvisioningJobStep bProvisioningJobStep) {
        this.add("step?", (BValue)bProvisioningJobStep);
    }

    public BProvisioningJobStep[] getSteps() {
        Array array = new Array(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? (class$com$tridium$provisioning$job$BProvisioningJobStep = BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJobStep")) : class$com$tridium$provisioning$job$BProvisioningJobStep);
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJobStep") : class$com$tridium$provisioning$job$BProvisioningJobStep)) {
            array.add((Object)slotCursor.get());
        }
        return (BProvisioningJobStep[])array.trim();
    }

    protected BProvisioningJobStep[] getCombinedSteps() {
        Array array = new Array(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? (class$com$tridium$provisioning$job$BProvisioningJobStep = BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJobStep")) : class$com$tridium$provisioning$job$BProvisioningJobStep);
        BProvisioningJobStep bProvisioningJobStep = null;
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJobStep") : class$com$tridium$provisioning$job$BProvisioningJobStep)) {
            BProvisioningJobStep bProvisioningJobStep2 = (BProvisioningJobStep)slotCursor.get();
            if (bProvisioningJobStep != null && bProvisioningJobStep.canCombine(bProvisioningJobStep2) && bProvisioningJobStep2.canCombine(bProvisioningJobStep2)) {
                bProvisioningJobStep.combine(bProvisioningJobStep2);
                continue;
            }
            array.add((Object)bProvisioningJobStep2);
            bProvisioningJobStep = bProvisioningJobStep2;
        }
        return (BProvisioningJobStep[])array.trim();
    }

    public IJobDispatcher getDispatcher() {
        BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
        return bProvisioningService.getJobQueue();
    }

    public void prepareJob(BObject bObject) throws Exception {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJobStep") : class$com$tridium$provisioning$job$BProvisioningJobStep)) {
            ((BProvisioningJobStep)slotCursor.get()).prepareStep(bObject);
        }
    }

    public BStationStepRecord[] getStepRecords() {
        Array array = new Array(class$com$tridium$provisioning$job$BStationStepRecord == null ? (class$com$tridium$provisioning$job$BStationStepRecord = BProvisioningJob.class$("com.tridium.provisioning.job.BStationStepRecord")) : class$com$tridium$provisioning$job$BStationStepRecord);
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next(class$com$tridium$provisioning$job$BProvisioningJobStep == null ? BProvisioningJob.class$("com.tridium.provisioning.job.BProvisioningJobStep") : class$com$tridium$provisioning$job$BProvisioningJobStep)) {
            BProvisioningJobStep bProvisioningJobStep = (BProvisioningJobStep)slotCursor.get();
            SlotCursor slotCursor2 = bProvisioningJobStep.getProperties();
            while (slotCursor2.next(class$com$tridium$provisioning$job$BStationStepRecord == null ? BProvisioningJob.class$("com.tridium.provisioning.job.BStationStepRecord") : class$com$tridium$provisioning$job$BStationStepRecord)) {
                array.add((Object)slotCursor2.get());
            }
        }
        return (BStationStepRecord[])array.trim();
    }

    public boolean isCanceled() {
        return this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled;
    }

    public void doSubmit(Context context) {
        if (context != null) {
            this.setSubmitUser(String.valueOf(context.getUser()));
        }
        this.setJobState(BJobState.unknown);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
        this.getDispatcher().dispatch(this, context);
    }

    public final void doCancel(Context context) throws Exception {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        } else if (this.getJobState() != BJobState.success && this.getJobState() != BJobState.failed) {
            this.setJobState(BJobState.canceled);
        }
        this.getDispatcher().cancel(this, context);
    }

    public void doCancelStation(BString bString, Context context) throws Exception {
        if (this.getJobState().isRunning()) {
            BJobState bJobState = this.getStationState(bString.toString());
            if (bJobState.isRunning()) {
                this.setStationState(bString.toString(), BJobState.canceling);
            } else if (bJobState != BJobState.success && bJobState != BJobState.failed) {
                this.setStationState(bString.toString(), BJobState.canceled);
            }
        }
    }

    public void doRun(Context context) {
        int n;
        BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
        BProvisioningJobStep[] bProvisioningJobStepArray = this.getCombinedSteps();
        String[] stringArray = this.getStationNames();
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        int n2 = bProvisioningJobStepArray.length * stringArray.length;
        int n3 = 0;
        this.progress(0);
        boolean bl = false;
        boolean bl2 = false;
        block2: for (n = 0; n < bDeviceArray.length; ++n) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[n];
            for (int i = 0; i < stringArray.length && !this.isCanceled(); ++i) {
                if (!bNiagaraStation.getStationName().equals(stringArray[i])) continue;
                BJobState bJobState = BJobState.running;
                this.getStationState().set(SlotPath.escape((String)bNiagaraStation.getStationName()), (BValue)bJobState);
                this.log().message("Processing station " + bNiagaraStation.getStationName());
                for (int j = 0; j < bProvisioningJobStepArray.length; ++j) {
                    BStationStepRecord bStationStepRecord = bProvisioningJobStepArray[j].run(bProvisioningService, bNiagaraStation, context);
                    bJobState = bStationStepRecord.getState();
                    if (bJobState == BJobState.failed) {
                        this.stepCompleted(bProvisioningService, bStationStepRecord);
                        bl = true;
                        this.progress(100 * (n3 += bProvisioningJobStepArray.length - j) / n2);
                        break;
                    }
                    if (bJobState == BJobState.canceled || bJobState == BJobState.canceling) {
                        if (bJobState == BJobState.canceling) {
                            bJobState = BJobState.canceled;
                            bStationStepRecord.setState(bJobState);
                        }
                        this.stepCompleted(bProvisioningService, bStationStepRecord);
                        bl2 = true;
                        if (this.isCanceled()) break;
                        this.progress(100 * ++n3 / n2);
                        break;
                    }
                    this.stepCompleted(bProvisioningService, bStationStepRecord);
                    this.progress(100 * ++n3 / n2);
                }
                this.getStationState().set(SlotPath.escape((String)bNiagaraStation.getStationName()), (BValue)bJobState);
                continue block2;
            }
        }
        this.progress(100);
        for (n = 0; n < bProvisioningJobStepArray.length; ++n) {
            try {
                bProvisioningJobStepArray[n].jobComplete();
                continue;
            }
            catch (Exception exception) {
                this.log().failed("Could not clean up for step", (Throwable)exception);
            }
        }
        if (bl) {
            this.log().failed("Steps failed for one or more stations");
            this.complete(BJobState.failed);
        } else if (bl2) {
            this.log().failed("Job canceled");
            this.complete(BJobState.canceled);
        } else {
            this.success();
        }
    }

    public void doDispose(Context context) {
        if (this.getJobState().isRunning()) {
            throw new IllegalStateException("Cannot dispose while running");
        }
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
        this.setJobState(BJobState.unknown);
        BStationStepRecord[] bStationStepRecordArray = this.getStepRecords();
        for (int i = 0; i < bStationStepRecordArray.length; ++i) {
            bStationStepRecordArray[i].dispose();
        }
        try {
            BJobLogFile bJobLogFile = BJobLogFile.find(this, null);
            try {
                Log.getLog((String)"provisioning").trace("Deleting log file " + bJobLogFile.getFilePath().getBody());
                bJobLogFile.delete();
            }
            catch (IOException iOException) {
                Log.getLog((String)"provisioning").error("Error deleting log file " + bJobLogFile.getFilePath(), (Throwable)iOException);
            }
        }
        catch (UnresolvedException unresolvedException) {
            Log.getLog((String)"provisioning").trace("Log file not found", (Throwable)unresolvedException);
        }
        if (this.getParent() != null && this.getParent() instanceof BJobService) {
            ((BComponent)this.getParent()).remove((BComplex)this);
        }
        bProvisioningService.notifyDisposed(this);
    }

    protected void stepCompleted(BProvisioningService bProvisioningService, BStationStepRecord bStationStepRecord) {
        try {
            BStationStepLogFile bStationStepLogFile = BStationStepLogFile.create(bStationStepRecord, this.getStartTime());
            if ((bStationStepRecord.getState() == BJobState.failed || bStationStepRecord.getState() == BJobState.canceled) && this.getAlertOnStepFailure()) {
                bProvisioningService.newAlert(bStationStepRecord.getFailureAlarmMessage(), bStationStepLogFile.getOrdInSession());
            }
            bStationStepRecord.resetLog();
        }
        catch (Exception exception) {
            Log.getLog((String)"provisioning").error("error persisting job step", (Throwable)exception);
        }
    }

    public void complete(BJobState bJobState) {
        super.complete(bJobState);
        try {
            this.jobFile = BJobLogFile.create(this);
            this.resetLog();
        }
        catch (Exception exception) {
            Log.getLog((String)"provisioning").error("error persisting job", (Throwable)exception);
        }
        if (this.getJobState() == BJobState.success && this.getAlertOnJobSuccess()) {
            BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
            bProvisioningService.newAlert(this.getLexicon().getText("ProvisioningJob.successAlarmMessage"), this.jobFile.getOrdInSession());
        }
    }

    public BString doReadLog() {
        if (this.getJobState().isComplete()) {
            BJobLogFile bJobLogFile = this.getLogFile();
            if (bJobLogFile == null) {
                return BString.DEFAULT;
            }
            try {
                return bJobLogFile.getLogContents();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return super.doReadLog();
    }

    public void setLogFile(BJobLogFile bJobLogFile) {
        this.jobFile = bJobLogFile;
    }

    public BJobLogFile getLogFile() {
        if (this.jobFile == null) {
            this.jobFile = BJobLogFile.find(this, null);
        }
        return this.jobFile;
    }

    public BIcon getIcon() {
        return icon;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new JobCancelException();
        }
    }

    protected final synchronized void checkCanceled(String string) {
        this.checkCanceled();
        BJobState bJobState = this.getStationState(string);
        if (bJobState == BJobState.canceling || bJobState == BJobState.canceled) {
            throw new JobCancelException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

