/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.job;

import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.util.TimeFormat;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.BogDecoder;
import javax.baja.io.BogEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

public class BJobLogFile
extends BAbstractFile {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$job$BJobLogFile == null ? (class$com$tridium$provisioning$job$BJobLogFile = BJobLogFile.class$("com.tridium.provisioning.job.BJobLogFile")) : class$com$tridium$provisioning$job$BJobLogFile));
    private BProvisioningJob job = null;
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    static /* synthetic */ Class class$com$tridium$provisioning$job$BJobLogFile;

    public Type getType() {
        return TYPE;
    }

    public BJobLogFile(BIFileStore bIFileStore) {
        super(bIFileStore);
    }

    public BJobLogFile() {
    }

    public static BJobLogFile[] list() {
        Array array = new Array(class$com$tridium$provisioning$job$BJobLogFile == null ? (class$com$tridium$provisioning$job$BJobLogFile = BJobLogFile.class$("com.tridium.provisioning.job.BJobLogFile")) : class$com$tridium$provisioning$job$BJobLogFile);
        BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("^provisioning/jobLog"));
        if (bDirectory != null) {
            BIFile[] bIFileArray = bDirectory.listFiles();
            for (int i = 0; i < bIFileArray.length; ++i) {
                if (!(bIFileArray[i] instanceof BJobLogFile)) continue;
                array.add((Object)bIFileArray[i]);
            }
        }
        return (BJobLogFile[])array.trim();
    }

    public static BJobLogFile find(BAbsTime bAbsTime, BObject bObject) {
        if (bAbsTime.isNull()) {
            throw new UnresolvedException();
        }
        return (BJobLogFile)BOrd.make((OrdQuery)BJobLogFile.pathForStartTime(bAbsTime)).get(bObject);
    }

    public static BJobLogFile findLocal(BAbsTime bAbsTime) {
        if (bAbsTime.isNull()) {
            throw new UnresolvedException();
        }
        return (BJobLogFile)BOrd.make((OrdQuery)BJobLogFile.pathForStartTime(bAbsTime)).get();
    }

    public static BJobLogFile find(BProvisioningJob bProvisioningJob, BObject bObject) throws UnresolvedException {
        if (bProvisioningJob.getStartTime().isNull()) {
            throw new UnresolvedException();
        }
        return BJobLogFile.find(bProvisioningJob.getStartTime(), bObject);
    }

    public static BJobLogFile create(BProvisioningJob bProvisioningJob) throws Exception {
        BJobLogFile bJobLogFile = (BJobLogFile)BFileSystem.INSTANCE.makeFile(BJobLogFile.pathForStartTime(bProvisioningJob.getStartTime()));
        OutputStream outputStream = bJobLogFile.getOutputStream();
        BogEncoder bogEncoder = new BogEncoder(outputStream);
        bogEncoder.setEncodeTransients(true);
        bogEncoder.setZipped(true);
        BComponent bComponent = new BComponent();
        bComponent.add("job", bProvisioningJob.newCopy());
        bComponent.add("logContents", (BValue)BString.make((String)bProvisioningJob.log().encode()));
        bogEncoder.encodeDocument((BValue)bComponent);
        bogEncoder.close();
        outputStream.close();
        return bJobLogFile;
    }

    public BProvisioningJob getJob() throws Exception {
        this.parse();
        return this.job;
    }

    public BString getLogContents() throws Exception {
        BString bString;
        BValue bValue = new BogDecoder((BIFile)this).decodeDocument();
        if (bValue instanceof BProvisioningJob) {
            this.job = (BProvisioningJob)bValue;
            bString = (BString)this.job.get("logContents");
            if (bString == null) {
                bString = BString.DEFAULT;
            }
        } else {
            bString = (BString)((BComponent)bValue).get("logContents");
        }
        return bString;
    }

    private void parse() throws Exception {
        if (this.job == null) {
            BValue bValue = new BogDecoder((BIFile)this).decodeDocument();
            if (bValue instanceof BProvisioningJob) {
                this.job = (BProvisioningJob)bValue;
            } else {
                BComponent bComponent = (BComponent)bValue;
                this.job = (BProvisioningJob)bComponent.get("job");
            }
            this.job.setLogFile(this);
        }
    }

    public void setStore(BIFileStore bIFileStore) {
        super.setStore(bIFileStore);
        this.job = null;
    }

    public String getMimeType() {
        return "application/niagara-job-log";
    }

    public String getNavDescription(Context context) {
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String string) {
        return null;
    }

    private static FilePath pathForStartTime(BAbsTime bAbsTime) {
        String string = TimeFormat.format((BAbsTime)bAbsTime, (Context)TIMESTAMP_FORMAT) + ".pjob";
        return new FilePath("^provisioning/jobLog").merge(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

