/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.backup;

import com.tridium.backup.BBackupChannel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioning.BPlatformConnection;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.backup.BBackupStationExt;
import com.tridium.provisioning.backup.BBackupStepRecord;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.job.BStationStepRecord;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.RemoteStation;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BProvisioningBackupStep
extends BProvisioningJobStep
implements BFoxClientConnection.Interest {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$backup$BProvisioningBackupStep == null ? (class$com$tridium$provisioning$backup$BProvisioningBackupStep = BProvisioningBackupStep.class$("com.tridium.provisioning.backup.BProvisioningBackupStep")) : class$com$tridium$provisioning$backup$BProvisioningBackupStep));
    private static final BIcon icon = BIcon.std((String)"backup.png");
    static /* synthetic */ Class class$com$tridium$provisioning$backup$BProvisioningBackupStep;

    public Type getType() {
        return TYPE;
    }

    public static BProvisioningJob makeJob(String string) {
        BProvisioningJob bProvisioningJob = new BProvisioningJob(string);
        bProvisioningJob.add("backup", (BValue)new BProvisioningBackupStep());
        return bProvisioningJob;
    }

    protected BStationStepRecord makeRecord(BNiagaraStation bNiagaraStation) {
        BBackupStepRecord bBackupStepRecord = new BBackupStepRecord(bNiagaraStation, this);
        this.add(SlotPath.escape((String)bNiagaraStation.getStationName()), (BValue)bBackupStepRecord, 4);
        return bBackupStepRecord;
    }

    protected void doRun(BProvisioningService bProvisioningService, BStationStepRecord bStationStepRecord, BNiagaraStation bNiagaraStation, Context context) throws Exception {
        BBackupService bBackupService;
        bStationStepRecord.message("Backing up " + bNiagaraStation.getStationName());
        try {
            bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            bBackupService = new BBackupService();
        }
        BBackupStationExt bBackupStationExt = (BBackupStationExt)bNiagaraStation.getMixIn(BBackupStationExt.TYPE);
        if (bBackupStationExt.isUnoperational()) {
            bStationStepRecord.failed("Backup extension for " + bNiagaraStation.getStationName() + " status is " + bBackupStationExt.getStatus());
            bStationStepRecord.complete(BJobState.failed);
            return;
        }
        OrdQuery[] ordQueryArray = ((BBackupStepRecord)bStationStepRecord).getBackupFileOrd().parse();
        FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
        BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
        this.checkCanceled(bNiagaraStation);
        RemoteStation remoteStation = bPlatformConnection.getPlatformDaemon().getStationManager().getStation(bNiagaraStation.getStationName());
        this.checkCanceled(bNiagaraStation);
        if (remoteStation == null) {
            bStationStepRecord.failed("Backup failed: unrecognized station " + bNiagaraStation.getStationName());
            bStationStepRecord.complete(BJobState.failed);
        } else {
            BIFile bIFile = BFileSystem.INSTANCE.makeFile(filePath);
            if (remoteStation.getStatus() == BStationStatus.running) {
                int n;
                this.checkCanceled(bNiagaraStation);
                bNiagaraStation.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                BBackupChannel bBackupChannel = (BBackupChannel)bNiagaraStation.getClientConnection().getChannels().get("backup", BBackupChannel.TYPE);
                InputStream inputStream = bBackupChannel.backup(false);
                this.checkCanceled(bNiagaraStation);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(bIFile.getOutputStream());
                int n2 = 4096;
                byte[] byArray = new byte[n2];
                while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    this.checkCanceled(bNiagaraStation);
                }
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bNiagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                bStationStepRecord.message(bIFile.getFilePath().getBody() + " written");
            } else {
                bBackupService.zip(bStationStepRecord.log(), BBackupService.makeCanceler((BJob)this.getJob()), bPlatformConnection.getPlatformDaemon(), bIFile.getOutputStream(), true);
                bStationStepRecord.message(bIFile.getFilePath().getBody() + " written");
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

