/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.backup;

import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.backup.BBackupStationExt;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.software.BInstallStep;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBackupStepRecord
extends BStationStepRecord {
    public static final Property backupFileOrd = BBackupStepRecord.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$backup$BBackupStepRecord == null ? (class$com$tridium$provisioning$backup$BBackupStepRecord = BBackupStepRecord.class$("com.tridium.provisioning.backup.BBackupStepRecord")) : class$com$tridium$provisioning$backup$BBackupStepRecord));
    static /* synthetic */ Class class$com$tridium$provisioning$backup$BBackupStepRecord;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$file$BIFile;
    static /* synthetic */ Class class$javax$baja$sys$Context;

    public BOrd getBackupFileOrd() {
        return (BOrd)this.get(backupFileOrd);
    }

    public void setBackupFileOrd(BOrd bOrd) {
        this.set(backupFileOrd, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBackupStepRecord() {
    }

    public BBackupStepRecord(BNiagaraStation bNiagaraStation, BProvisioningJobStep bProvisioningJobStep) {
        super(bNiagaraStation, bProvisioningJobStep);
        try {
            BBackupStationExt bBackupStationExt = (BBackupStationExt)bNiagaraStation.getMixIn(BBackupStationExt.TYPE);
            this.setBackupFileOrd(bBackupStationExt.newBackupFileOrd());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BOrd startRestoreJob(BObject bObject, Context context) throws Exception {
        BProvisioningService bProvisioningService;
        BIFile bIFile = (BIFile)this.getBackupFileOrd().get(bObject);
        try {
            bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get(bObject);
            if (!bProvisioningService.isFatalFault()) {
                BComponentSpace bComponentSpace = (BComponentSpace)bProvisioningService.getSpace();
                bProvisioningService.lease();
                BProvisioningJob bProvisioningJob = new BProvisioningJob(this.getStationName());
                bProvisioningJob.add("restore", (BValue)new BInstallStep(bIFile, false));
                BOrd bOrd = bProvisioningService.submitJob(bProvisioningJob, null);
                bComponentSpace.sync();
                return ((BProvisioningJob)bOrd.get((BObject)bComponentSpace)).getNavOrd();
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        bProvisioningService = (BComponent)BOrd.make((String)"service:batch:BatchService").get(bObject);
        BComponentSpace bComponentSpace = (BComponentSpace)bProvisioningService.getSpace();
        bProvisioningService.lease();
        Class clazz = Sys.getType((String)"provisioningNiagara:NiagaraNetworkJob").getTypeClass();
        Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BBackupStepRecord.class$("java.lang.String")) : class$java$lang$String);
        Object t = constructor.newInstance(this.getStationName());
        Class clazz2 = Sys.getType((String)"provisioningNiagara:InstallStep").getTypeClass();
        Constructor constructor2 = clazz2.getConstructor(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = BBackupStepRecord.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile, Boolean.TYPE);
        Object t2 = constructor2.newInstance(bIFile, Boolean.FALSE);
        Method method = t.getClass().getMethod("addStep", Sys.getType((String)"batch:DeviceJobStep").getTypeClass());
        method.invoke(t, t2);
        Method method2 = ((Object)((Object)bProvisioningService)).getClass().getMethod("submitJob", Sys.getType((String)"batch:BatchJob").getTypeClass(), class$javax$baja$sys$Context == null ? (class$javax$baja$sys$Context = BBackupStepRecord.class$("javax.baja.sys.Context")) : class$javax$baja$sys$Context);
        BOrd bOrd = (BOrd)method2.invoke((Object)bProvisioningService, t, null);
        bComponentSpace.sync();
        return ((BINavNode)bOrd.get((BObject)bComponentSpace)).getNavOrd();
    }

    public void doDispose() {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        if (!this.getBackupFileOrd().isNull()) {
            try {
                BIFile bIFile = (BIFile)this.getBackupFileOrd().get();
                Log.getLog((String)"provisioning").message("Deleting backup file " + bIFile.getFilePath().getBody());
                bIFile.delete();
            }
            catch (UnresolvedException unresolvedException) {
                Log.getLog((String)"provisioning").error("Error deleting backup file " + this.getBackupFileOrd(), (Throwable)unresolvedException);
            }
            catch (IOException iOException) {
                Log.getLog((String)"provisioning").error("Error deleting backup file " + this.getBackupFileOrd(), (Throwable)iOException);
            }
            this.setBackupFileOrd(BOrd.NULL);
        }
        super.doDispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

