/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioning.BPlatformConnection;
import com.tridium.provisioning.BProvisioningChannel;
import com.tridium.provisioning.BProvisioningStationExt;
import com.tridium.provisioning.backup.BBackupStationExt;
import com.tridium.provisioning.backup.BProvisioningBackupStep;
import com.tridium.provisioning.conversion.BConversionJob;
import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BJobTrigger;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BThreadPoolJobQueue;
import com.tridium.provisioning.software.BSoftwareContainer;
import com.tridium.provisioning.software.BSoftwareStationExt;
import com.tridium.provisioning.software.ProvisioningRegistry;
import com.tridium.provisioning.station.BStationPollScheduler;
import com.tridium.provisioning.station.BStationProxy;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.schedule.BTriggerSchedule;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.Array;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;

public class BProvisioningService
extends BAbstractService
implements BIAlarmSource {
    public static final Property backupSchedule = BProvisioningService.newProperty((int)0, (BValue)new BTriggerSchedule(), null);
    public static final Property software = BProvisioningService.newProperty((int)3, (BValue)new BSoftwareContainer(), null);
    public static final Property jobQueue = BProvisioningService.newProperty((int)0, (BValue)new BThreadPoolJobQueue(1), null);
    public static final Property pendingJobs = BProvisioningService.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property pollScheduler = BProvisioningService.newProperty((int)0, (BValue)new BStationPollScheduler(), null);
    public static final Property alarmClass = BProvisioningService.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Action startBackup = BProvisioningService.newAction((int)0, null);
    public static final Action submitJobAction = BProvisioningService.newAction((int)4, (BValue)new BProvisioningJob(), null);
    public static final Action scheduleJobAction = BProvisioningService.newAction((int)4, (BValue)new BJobTrigger(), null);
    public static final Action makeTempFilePath = BProvisioningService.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action disposeJob = BProvisioningService.newAction((int)4, (BValue)BAbsTime.NULL, null);
    public static final Action ackAlarm = BProvisioningService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action startConversion = BProvisioningService.newAction((int)4, null);
    public static final Topic jobDisposed = BProvisioningService.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$BProvisioningService == null ? (class$com$tridium$provisioning$BProvisioningService = BProvisioningService.class$("com.tridium.provisioning.BProvisioningService")) : class$com$tridium$provisioning$BProvisioningService));
    private static final Type[] serviceTypes = new Type[]{TYPE};
    public static final Log log = Log.getLog((String)"provisioning");
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private static final FilePath BASE_DIR = new FilePath("^provisioning");
    private AlarmSupport alarmSupport = null;
    private boolean isProxy = true;
    private ProvisioningRegistry installableRegistry = null;
    private int flags = 0;
    private int oldStatus = -1;
    static /* synthetic */ Class class$com$tridium$provisioning$BProvisioningService;
    static /* synthetic */ Class class$java$lang$String;

    public BTriggerSchedule getBackupSchedule() {
        return (BTriggerSchedule)this.get(backupSchedule);
    }

    public void setBackupSchedule(BTriggerSchedule bTriggerSchedule) {
        this.set(backupSchedule, (BValue)bTriggerSchedule, null);
    }

    public BSoftwareContainer getSoftware() {
        return (BSoftwareContainer)this.get(software);
    }

    public void setSoftware(BSoftwareContainer bSoftwareContainer) {
        this.set(software, (BValue)bSoftwareContainer, null);
    }

    public BThreadPoolJobQueue getJobQueue() {
        return (BThreadPoolJobQueue)this.get(jobQueue);
    }

    public void setJobQueue(BThreadPoolJobQueue bThreadPoolJobQueue) {
        this.set(jobQueue, (BValue)bThreadPoolJobQueue, null);
    }

    public BFolder getPendingJobs() {
        return (BFolder)this.get(pendingJobs);
    }

    public void setPendingJobs(BFolder bFolder) {
        this.set(pendingJobs, (BValue)bFolder, null);
    }

    public BStationPollScheduler getPollScheduler() {
        return (BStationPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BStationPollScheduler bStationPollScheduler) {
        this.set(pollScheduler, (BValue)bStationPollScheduler, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public BOrd startBackup() {
        return (BOrd)this.invoke(startBackup, null, null);
    }

    public BOrd submitJobAction(BProvisioningJob bProvisioningJob) {
        return (BOrd)this.invoke(submitJobAction, (BValue)bProvisioningJob, null);
    }

    public BOrd scheduleJobAction(BJobTrigger bJobTrigger) {
        return (BOrd)this.invoke(scheduleJobAction, (BValue)bJobTrigger, null);
    }

    public BString makeTempFilePath(BString bString) {
        return (BString)this.invoke(makeTempFilePath, (BValue)bString, null);
    }

    public void disposeJob(BAbsTime bAbsTime) {
        this.invoke(disposeJob, (BValue)bAbsTime, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public BOrd startConversion() {
        return (BOrd)this.invoke(startConversion, null, null);
    }

    public void fireJobDisposed(BAbsTime bAbsTime) {
        this.fire(jobDisposed, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIFile makeTempFile(String string) {
        BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)this);
        return bFileSpace.findFile(new FilePath(this.makeTempFilePath(BString.make((String)string)).toString()));
    }

    public void started() throws Exception {
        Slot slot = this.getSlot("backupTrigger");
        if (slot == null) {
            this.linkTo("backupTrigger", (BComponent)this.getBackupSchedule(), (Slot)BTriggerSchedule.trigger, (Slot)startBackup);
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        BComponent bComponent;
        this.isProxy = false;
        try {
            bComponent = Sys.getService((Type)BTypeSpec.make((String)"provisioningNiagara", (String)"ProvisioningNiagaraNetworkExt").getResolvedType());
            if (bComponent != null) {
                this.configFatal("ProvisioningService cannot run on a station that also has a ProvisioningNiagaraNetworkExt");
                return;
            }
        }
        catch (ModuleException moduleException) {
        }
        catch (TypeException typeException) {
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BFoxChannelRegistry.getPrototype().add("provisioning", (BValue)new BProvisioningChannel());
        this.getSoftware().serviceStarted();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        bComponent = this.getComponentSpace();
        bComponent.enableMixIn(BPlatformConnection.TYPE);
        bComponent.enableMixIn(BBackupStationExt.TYPE);
        bComponent.enableMixIn(BSoftwareStationExt.TYPE);
        bComponent.enableMixIn(BStationProxy.TYPE);
        this.updateStatus();
    }

    public void serviceStopped() {
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "provisioning");
    }

    public void updateStatus() {
        int n = this.getStatus().getBits();
        n = !this.getEnabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.isFatalFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            BDeviceExt[] bDeviceExtArray = bDeviceArray[i].getDeviceExts();
            for (int j = 0; j < bDeviceExtArray.length; ++j) {
                if (!(bDeviceExtArray[j] instanceof BPlatformConnection) && !(bDeviceExtArray[j] instanceof BProvisioningStationExt)) continue;
                try {
                    bDeviceExtArray[j].updateStatus();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        this.oldStatus = n;
    }

    public BOrd submitJob(BProvisioningJob bProvisioningJob, Context context) throws Exception {
        if (bProvisioningJob instanceof BProvisioningJob) {
            bProvisioningJob.prepareJob((BObject)this);
        }
        return (BOrd)this.invoke(submitJobAction, (BValue)bProvisioningJob, context);
    }

    public BOrd doSubmitJobAction(BProvisioningJob bProvisioningJob, Context context) throws Exception {
        bProvisioningJob.submit(context);
        return bProvisioningJob.getHandleOrd();
    }

    public BOrd scheduleJob(BProvisioningJob bProvisioningJob, BAbsTime bAbsTime) throws Exception {
        bProvisioningJob.prepareJob((BObject)this);
        return this.scheduleJobAction(new BJobTrigger(bProvisioningJob, bAbsTime));
    }

    public BOrd doScheduleJobAction(BJobTrigger bJobTrigger, Context context) {
        if (context != null && bJobTrigger.getJobPrototype() instanceof BProvisioningJob) {
            bJobTrigger.getJobPrototype().setSubmitUser(String.valueOf(context.getUser()));
        }
        this.getPendingJobs().add("pendingJob?", (BValue)bJobTrigger);
        return bJobTrigger.getHandleOrd();
    }

    public BOrd doStartConversion(Context context) throws Exception {
        return new BConversionJob().submit(context);
    }

    public void doDisposeJob(BAbsTime bAbsTime) throws Exception {
        try {
            BJobLogFile bJobLogFile = BJobLogFile.findLocal(bAbsTime);
            BJobService bJobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
            BJob[] bJobArray = bJobService.getJobs();
            for (int i = 0; i < bJobArray.length; ++i) {
                if (!(bJobArray[i] instanceof BProvisioningJob) || !bAbsTime.equals((Object)bJobArray[i].getStartTime())) continue;
                bJobArray[i].dispose();
                return;
            }
            BProvisioningJob bProvisioningJob = bJobLogFile.getJob();
            bProvisioningJob.dispose();
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
    }

    public void notifyDisposed(BProvisioningJob bProvisioningJob) {
        this.fireJobDisposed(bProvisioningJob.getStartTime());
    }

    public synchronized BString doMakeTempFilePath(BString bString) {
        int n = 0;
        while (true) {
            FilePath filePath;
            BIFile bIFile;
            if ((bIFile = BFileSystem.INSTANCE.findFile(filePath = BASE_DIR.merge("tmp" + n + "." + bString.toString()))) == null) {
                try {
                    BFileSystem.INSTANCE.makeFile(filePath);
                    return BString.make((String)filePath.getBody());
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    throw runtimeException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
            ++n;
        }
    }

    public BOrd doStartBackup(Context context) throws Exception {
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BProvisioningService.class$("java.lang.String")) : class$java$lang$String);
        for (int i = 0; i < bDeviceArray.length; ++i) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[i];
            BBackupStationExt bBackupStationExt = (BBackupStationExt)bNiagaraStation.getMixIn(BBackupStationExt.TYPE);
            if (bBackupStationExt == null || !bBackupStationExt.getEnabled()) continue;
            array.add((Object)bNiagaraStation.getStationName());
        }
        if (array.size() > 0) {
            BProvisioningJob bProvisioningJob = new BProvisioningJob((String[])array.trim());
            bProvisioningJob.add("backup", (BValue)new BProvisioningBackupStep());
            return (BOrd)this.invoke(submitJobAction, (BValue)bProvisioningJob, context);
        }
        return BOrd.NULL;
    }

    public ProvisioningRegistry getInstallableRegistry() {
        if (this.installableRegistry == null) {
            BFoxSession bFoxSession = (BFoxSession)this.getSession();
            BProvisioningChannel bProvisioningChannel = (BProvisioningChannel)bFoxSession.getConnection().getChannels().get("provisioning", BProvisioningChannel.TYPE);
            this.installableRegistry = new ProvisioningRegistry(bProvisioningChannel);
        }
        return this.installableRegistry;
    }

    public void newAlert(String string, BOrd bOrd) {
        if (this.alarmSupport != null) {
            try {
                this.alarmSupport.newAlert(BFacets.make((String[])new String[]{"msgText", "hyperlinkOrd"}, (BIDataValue[])new BString[]{BString.make((String)string), BString.make((String)bOrd.toString())}));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        try {
            if (this.alarmSupport != null) {
                this.alarmSupport.ackAlarm(bAlarmRecord);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BBoolean.TRUE;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

