/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciSpaces;

import com.jci.jciSpaces.BJciEquipmentNode;
import com.jci.jciSpaces.BJciGeographyNode;
import com.jci.jciSupport.ReflectUtils;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciEquipmentRoot
extends BJciEquipmentNode {
    public static final Property geography = BJciEquipmentRoot.newProperty((int)0, (BValue)new BJciGeographyNode(), null);
    public static final Property faultCause = BJciEquipmentRoot.newProperty((int)1, (String)"", null);
    public static final Property trace = BJciEquipmentRoot.newProperty((int)4, (boolean)true, null);
    public static final Action buildEquipmentList = BJciEquipmentRoot.newAction((int)0, null);
    public static final Type TYPE;
    static Lexicon lex;
    private static final BIcon icon;
    BJciEquipmentNode rootNode;
    BJciEquipmentNode centralPlantNode;
    BJciEquipmentNode airHandlersNode;
    BJciEquipmentNode metersNode;
    static /* synthetic */ Class class$com$jci$jciSpaces$BJciEquipmentRoot;
    static /* synthetic */ Class class$javax$baja$driver$BDeviceNetwork;

    public BJciGeographyNode getGeography() {
        return (BJciGeographyNode)this.get(geography);
    }

    public void setGeography(BJciGeographyNode bJciGeographyNode) {
        this.set(geography, (BValue)bJciGeographyNode, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getTrace() {
        return this.getBoolean(trace);
    }

    public void setTrace(boolean bl) {
        this.setBoolean(trace, bl, null);
    }

    public void buildEquipmentList() {
        this.invoke(buildEquipmentList, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void tracemessage(String string) {
        if (this.getTrace()) {
            System.out.println(string);
        }
    }

    public void doBuildEquipmentList() {
        if (Sys.getStation() == null) {
            this.tracemessage("jciEquipmentRoot: doBuildEquipmentList cannot be invoked outside a running station. ");
            return;
        }
        this.tracemessage("jciEquipmentRoot: doBuildEquipmentList at Root: " + this.getName());
        this.rootNode = this;
        int n = 4;
        if (this.metersNode == null) {
            this.metersNode = new BJciEquipmentNode("Meters", "");
            this.rootNode.add(SlotPath.escape((String)"Meters"), (BValue)this.metersNode, n);
        }
        if (this.centralPlantNode == null) {
            this.centralPlantNode = new BJciEquipmentNode("Central Plant", "");
            this.rootNode.add(SlotPath.escape((String)"Central Plant"), (BValue)this.centralPlantNode, n);
        }
        if (this.airHandlersNode == null) {
            this.airHandlersNode = new BJciEquipmentNode("Air Handlers", "");
            this.rootNode.add(SlotPath.escape((String)"Air Handlers"), (BValue)this.airHandlersNode, n);
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        this.tracemessage("   doBuildEquipmentList, Adding Equipment");
        try {
            BDriverContainer bDriverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
            Class clazz = class$javax$baja$driver$BDeviceNetwork;
            if (clazz == null) {
                clazz = class$javax$baja$driver$BDeviceNetwork = BJciEquipmentRoot.class("[Ljavax.baja.driver.BDeviceNetwork;", false);
            }
            Object[] objectArray = bDriverContainer.getChildren(clazz);
            this.tracemessage("   doBuildEquipmentList, Drivers count: " + objectArray.length);
            int n2 = 0;
            while (n2 < objectArray.length) {
                BDeviceNetwork bDeviceNetwork = (BDeviceNetwork)objectArray[n2];
                String string4 = bDeviceNetwork.getName();
                boolean bl = ReflectUtils.isType((BObject)bDeviceNetwork, (String)"NiagaraNetwork");
                this.tracemessage("   doBuildEquipmentList, Drivers type: " + bDeviceNetwork.getType());
                boolean bl2 = ReflectUtils.isType((BObject)bDeviceNetwork, (String)"PanoptixNetwork");
                this.tracemessage("   doBuildEquipmentList, Drivers type: " + bDeviceNetwork.getType());
                if (!bl && !bl2) {
                    BDevice[] bDeviceArray = bDeviceNetwork.getDevices();
                    int n3 = 0;
                    while (n3 < bDeviceArray.length) {
                        BDevice bDevice = bDeviceArray[n3];
                        string = bDevice.getName();
                        string2 = "";
                        string3 = "";
                        string2 = BJciEquipmentRoot.getDeviceSystemType(bDevice);
                        string3 = BJciEquipmentRoot.getPxSystemType(string2);
                        this.tracemessage("   doBuildEquipmentList, Adding for Driver: " + string4 + ", device: " + string);
                        String string5 = string4 + '_' + string;
                        BJciEquipmentNode bJciEquipmentNode = new BJciEquipmentNode(string, string3);
                        bJciEquipmentNode.setEquipmentOrd(bDevice.getSlotPathOrd());
                        bJciEquipmentNode.setDescription(string5);
                        bJciEquipmentNode.setFxEquipmentType(string2);
                        this.addEquipmentNode(string, bJciEquipmentNode);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.tracemessage("doBuildEquipmentList EXCEPTION");
            exception.printStackTrace();
        }
        Sys.getStation().save();
        this.tracemessage("   doBuildEquipmentList, Saving Station");
    }

    public static String getDeviceSystemType(BDevice bDevice) {
        BComponent[] bComponentArray;
        String string = "";
        if (ReflectUtils.hasProperty((BComplex)bDevice, (String)"jciFxDriver_JciDeviceMixIn") && (bComponentArray = bDevice.getChildComponents()).length > 0) {
            int n = 0;
            while (n < bComponentArray.length) {
                if (bComponentArray[n].getName().equalsIgnoreCase("jciFxDriver_JciDeviceMixIn")) {
                    string = ReflectUtils.getPropertyStringValue((BComplex)bComponentArray[n], (String)"systemTypeOverride");
                    string = TextUtil.replace((String)string, (String)" ", (String)"");
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    public void addEquipmentNode(String string, BJciEquipmentNode bJciEquipmentNode) {
        if (bJciEquipmentNode != null) {
            String string2 = bJciEquipmentNode.getEquipmentType();
            if (string2.equalsIgnoreCase("Chiller") || string2.equalsIgnoreCase("Boiler") || string2.equalsIgnoreCase("SimplePlant")) {
                this.addCentralPlantNode(string, bJciEquipmentNode);
            } else if (string2.equalsIgnoreCase("Ahu") || string2.equalsIgnoreCase("FanCoilUnit") || string2.equalsIgnoreCase("HeatPump") || string2.equalsIgnoreCase("RooftopUnit") || string2.equalsIgnoreCase("StatGateway")) {
                this.addAirHandlerNode(string, bJciEquipmentNode);
            } else if (string2.equalsIgnoreCase("ElectricMeter")) {
                this.addMeterNode(string, bJciEquipmentNode);
            } else {
                this.addEquipmentToRoot(string, bJciEquipmentNode);
            }
        }
    }

    public void addMeterNode(String string, BJciEquipmentNode bJciEquipmentNode) {
        if (this.metersNode != null) {
            int n = this.rootNode.getFlags(this.rootNode.getSlot("Meters"));
            this.tracemessage("   doBuildEquipmentList, Meters Flags: " + n);
            this.rootNode.setFlags(this.rootNode.getSlot("Meters"), 0);
        }
        this.metersNode.add(string, (BValue)bJciEquipmentNode);
    }

    public void addAirHandlerNode(String string, BJciEquipmentNode bJciEquipmentNode) {
        if (this.airHandlersNode != null) {
            this.rootNode.setFlags(this.rootNode.getSlot(SlotPath.escape((String)"Air Handlers")), 0);
        }
        this.airHandlersNode.add(string, (BValue)bJciEquipmentNode);
    }

    public void addCentralPlantNode(String string, BJciEquipmentNode bJciEquipmentNode) {
        if (this.centralPlantNode != null) {
            this.rootNode.setFlags(this.rootNode.getSlot(SlotPath.escape((String)"Central Plant")), 0);
        }
        this.centralPlantNode.add(string, (BValue)bJciEquipmentNode);
    }

    public void addEquipmentToRoot(String string, BJciEquipmentNode bJciEquipmentNode) {
        this.rootNode.add(string, (BValue)bJciEquipmentNode);
    }

    public static String getPxSystemType(String string) {
        String string2 = "";
        if (string.length() > 0) {
            String string3 = lex.get(string);
            string2 = string3 != null ? string3 : "";
        }
        return string2;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.rootNode = null;
        this.centralPlantNode = null;
        this.airHandlersNode = null;
        this.metersNode = null;
    }

    public BJciEquipmentRoot() {
        this.this();
    }

    public BJciEquipmentRoot(String string) {
        this.this();
        this.setDescription(string);
    }

    static {
        Class clazz = class$com$jci$jciSpaces$BJciEquipmentRoot;
        if (clazz == null) {
            clazz = class$com$jci$jciSpaces$BJciEquipmentRoot = BJciEquipmentRoot.class("[Lcom.jci.jciSpaces.BJciEquipmentRoot;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$jci$jciSpaces$BJciEquipmentRoot;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciSpaces$BJciEquipmentRoot = BJciEquipmentRoot.class("[Lcom.jci.jciSpaces.BJciEquipmentRoot;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        icon = BIcon.make((String)"module://jciSpaces/com/jci/jciSpaces/gears.png");
    }
}

