/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.puretls;

import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLException;
import COM.claymoresystems.ptls.SSLServerSocket;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class PureTLSSocketFactory
extends ServerSocketFactory {
    static Log logger = LogFactory.getLog(class$org$apache$tomcat$util$net$puretls$PureTLSSocketFactory == null ? (class$org$apache$tomcat$util$net$puretls$PureTLSSocketFactory = PureTLSSocketFactory.class$("org.apache.tomcat.util.net.puretls.PureTLSSocketFactory")) : class$org$apache$tomcat$util$net$puretls$PureTLSSocketFactory);
    static String defaultProtocol = "TLS";
    static boolean defaultClientAuth = false;
    static String defaultKeyStoreFile = "server.pem";
    static String defaultKeyPass = "password";
    static String defaultRootFile = "root.pem";
    static String defaultRandomFile = "random.pem";
    private SSLContext context = null;
    static /* synthetic */ Class class$org$apache$tomcat$util$net$puretls$PureTLSSocketFactory;

    public ServerSocket createSocket(int port) throws IOException {
        this.init();
        return new SSLServerSocket(this.context, port);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        this.init();
        SSLServerSocket tmp = new SSLServerSocket(this.context, port, backlog);
        return tmp;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.init();
        return new SSLServerSocket(this.context, port, backlog, ifAddress);
    }

    private void init() throws IOException {
        if (this.context != null) {
            return;
        }
        boolean clientAuth = defaultClientAuth;
        try {
            SSLContext tmpContext;
            String randomFile;
            String keyPass;
            String keyStoreFile;
            block16: {
                String clientAuthStr;
                String protocol;
                String rootFile;
                keyStoreFile = (String)this.attributes.get("keystore");
                if (keyStoreFile == null) {
                    keyStoreFile = defaultKeyStoreFile;
                }
                if ((keyPass = (String)this.attributes.get("keypass")) == null) {
                    keyPass = defaultKeyPass;
                }
                if ((rootFile = (String)this.attributes.get("rootfile")) == null) {
                    rootFile = defaultRootFile;
                }
                if ((randomFile = (String)this.attributes.get("randomfile")) == null) {
                    randomFile = defaultRandomFile;
                }
                if ((protocol = (String)this.attributes.get("protocol")) == null) {
                    protocol = defaultProtocol;
                }
                if ((clientAuthStr = (String)this.attributes.get("clientauth")) != null) {
                    if (clientAuthStr.equals("true")) {
                        clientAuth = true;
                    } else if (clientAuthStr.equals("false")) {
                        clientAuth = false;
                    } else {
                        throw new IOException("Invalid value '" + clientAuthStr + "' for 'clientauth' parameter:");
                    }
                }
                tmpContext = new SSLContext();
                try {
                    tmpContext.loadRootCertificates(rootFile);
                }
                catch (IOException iex) {
                    if (!logger.isDebugEnabled()) break block16;
                    logger.debug("Error loading Client Root Store: " + rootFile, iex);
                }
            }
            tmpContext.loadEAYKeyFile(keyStoreFile, keyPass);
            tmpContext.useRandomnessFile(randomFile, keyPass);
            SSLPolicyInt policy = new SSLPolicyInt();
            policy.requireClientAuth(clientAuth);
            policy.handshakeOnConnect(false);
            policy.waitOnClose(false);
            short[] enabledCiphers = this.getEnabledCiphers(policy.getCipherSuites());
            if (enabledCiphers != null) {
                policy.setCipherSuites(enabledCiphers);
            }
            tmpContext.setPolicy(policy);
            this.context = tmpContext;
        }
        catch (Exception e) {
            logger.info("Error initializing SocketFactory", e);
            throw new IOException(e.getMessage());
        }
    }

    private short[] getEnabledCiphers(short[] supportedCiphers) {
        short[] enabledCiphers = null;
        String attrValue = (String)this.attributes.get("ciphers");
        if (attrValue != null) {
            Vector<Integer> vec = null;
            int fromIndex = 0;
            int index = attrValue.indexOf(44, fromIndex);
            while (index != -1) {
                String cipher = attrValue.substring(fromIndex, index).trim();
                int cipherValue = SSLPolicyInt.getCipherSuiteNumber((String)cipher);
                if (cipherValue >= 0) {
                    for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                        if (cipherValue != supportedCiphers[i]) continue;
                        if (vec == null) {
                            vec = new Vector<Integer>();
                        }
                        vec.addElement(new Integer(cipherValue));
                        break;
                    }
                }
                fromIndex = index + 1;
                index = attrValue.indexOf(44, fromIndex);
            }
            if (vec != null) {
                int nCipher = vec.size();
                enabledCiphers = new short[nCipher];
                for (int i = 0; i < nCipher; ++i) {
                    Integer value = (Integer)vec.elementAt(i);
                    enabledCiphers[i] = value.shortValue();
                }
            }
        }
        return enabledCiphers;
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        try {
            Socket sock = socket.accept();
            return sock;
        }
        catch (SSLException e) {
            logger.debug("SSL handshake error", e);
            throw new SocketException("SSL handshake error" + e.toString());
        }
    }

    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).handshake();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

