/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ValveBase
implements Contained,
Valve,
MBeanRegistration {
    private static Log log = LogFactory.getLog(ValveBase.class);
    protected Container container = null;
    protected static String info = "org.apache.catalina.core.ValveBase/1.0";
    protected Valve next = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    protected ObjectName controller;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public String getInfo() {
        return info;
    }

    public Valve getNext() {
        return this.next;
    }

    public void setNext(Valve valve) {
        this.next = valve;
    }

    public void backgroundProcess() {
    }

    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void setObjectName(ObjectName oname) {
        this.oname = oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getParentName(ObjectName valveName) {
        return null;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        Container container = this.getContainer();
        if (container == null || !(container instanceof ContainerBase)) {
            return null;
        }
        ContainerBase containerBase = (ContainerBase)container;
        Pipeline pipe = containerBase.getPipeline();
        Valve[] valves = pipe.getValves();
        String parentName = "";
        if (!(container instanceof Engine)) {
            if (container instanceof Host) {
                parentName = ",host=" + container.getName();
            } else if (container instanceof Context) {
                String path = ((Context)container).getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)container.getParent();
                parentName = ",path=" + path + ",host=" + host.getName();
            } else if (container instanceof Wrapper) {
                Context ctx = (Context)container.getParent();
                String path = ctx.getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)ctx.getParent();
                parentName = ",servlet=" + container.getName() + ",path=" + path + ",host=" + host.getName();
            }
        }
        log.debug("valve parent=" + parentName + " " + parent);
        String className = this.getClass().getName();
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        int seq = 0;
        for (int i = 0; i < valves.length && valves[i] != this; ++i) {
            if (valves[i] == null || valves[i].getClass() != this.getClass()) continue;
            log.debug("Duplicate " + valves[i] + " " + this + " " + container);
            ++seq;
        }
        String ext = "";
        if (seq > 0) {
            ext = ",seq=" + seq;
        }
        ObjectName objectName = new ObjectName(domain + ":type=Valve,name=" + className + ext + parentName);
        log.debug("valve objectname = " + objectName);
        return objectName;
    }

    public ObjectName getContainerName() {
        if (this.container == null) {
            return null;
        }
        return ((ContainerBase)this.container).getJmxName();
    }
}

