/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Host;
import org.apache.catalina.util.StringManager;

public class ExpandWar {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war) throws IOException {
        int slash;
        int period;
        String pathname;
        if (host.getLogger().isDebugEnabled()) {
            host.getLogger().debug("expand(" + war.toString() + ")");
        }
        if ((pathname = war.toString().replace('\\', '/')).endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        if (host.getLogger().isDebugEnabled()) {
            host.getLogger().debug("  Proposed directory name: " + pathname);
        }
        return ExpandWar.expand(host, war, pathname);
    }

    /*
     * Loose catch block
     */
    public static String expand(Host host, URL war, String pathname) throws IOException {
        File docBase;
        block20: {
            Throwable t2;
            InputStream input;
            JarFile jarFile;
            block17: {
                File appBase = new File(host.getAppBase());
                if (!appBase.isAbsolute()) {
                    appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
                }
                if (!appBase.exists() || !appBase.isDirectory()) {
                    throw new IOException(sm.getString("hostConfig.appBase", appBase.getAbsolutePath()));
                }
                docBase = new File(appBase, pathname);
                if (docBase.exists()) {
                    return docBase.getAbsolutePath();
                }
                docBase.mkdir();
                JarURLConnection juc = (JarURLConnection)war.openConnection();
                juc.setUseCaches(false);
                jarFile = null;
                input = null;
                jarFile = juc.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String name = jarEntry.getName();
                    int last = name.lastIndexOf(47);
                    if (last >= 0) {
                        File parent = new File(docBase, name.substring(0, last));
                        parent.mkdirs();
                    }
                    if (name.endsWith("/")) continue;
                    input = jarFile.getInputStream(jarEntry);
                    ExpandWar.expand(input, docBase, name);
                    input.close();
                    input = null;
                }
                Object var14_14 = null;
                if (input == null) break block17;
                try {
                    input.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                input = null;
            }
            if (jarFile == null) break block20;
            try {
                jarFile.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            jarFile = null;
            {
                break block20;
                catch (IOException e) {
                    ExpandWar.deleteDir(docBase);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    input = null;
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    jarFile = null;
                }
                throw throwable;
            }
        }
        return docBase.getAbsolutePath();
    }

    public static boolean copy(File src, File dest) {
        return ExpandWar.copyInternal(src, dest, new byte[4096]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copyInternal(File src, File dest, byte[] buf) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            IOException e2222;
            Object var12_12;
            FileOutputStream os;
            FileInputStream is;
            block21: {
                File fileSrc = new File(src, files[i]);
                File fileDest = new File(dest, files[i]);
                if (fileSrc.isDirectory()) {
                    result = ExpandWar.copyInternal(fileSrc, fileDest, buf);
                    continue;
                }
                is = null;
                os = null;
                is = new FileInputStream(fileSrc);
                os = new FileOutputStream(fileDest);
                int len = 0;
                while ((len = is.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
                var12_12 = null;
                if (is == null) break block21;
                try {
                    is.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (os == null) continue;
            try {
                os.close();
            }
            catch (IOException e2222) {}
            continue;
            {
                catch (IOException e3) {
                    e3.printStackTrace();
                    result = false;
                    var12_12 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (os == null) continue;
                    try {
                        os.close();
                    }
                    catch (IOException e2222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_12 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            return ExpandWar.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file);
                continue;
            }
            file.delete();
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        BufferedOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
            Object var8_7 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            output.close();
            return;
        }
        catch (IOException e) {}
    }
}

