/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EngineConfig
implements LifecycleListener {
    private static Log log = LogFactory.getLog(EngineConfig.class);
    private Engine engine = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.engine = (Engine)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error(sm.getString("engineConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void start() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug(sm.getString("engineConfig.start"));
        }
    }

    private void stop() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug(sm.getString("engineConfig.stop"));
        }
    }
}

