/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Constructor;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

final class CreateLoaderRule
extends Rule {
    private String attributeName;
    private String loaderClass;

    public CreateLoaderRule(String loaderClass, String attributeName) {
        this.loaderClass = loaderClass;
        this.attributeName = attributeName;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String value;
        ClassLoader parentClassLoader = null;
        Object ojb = this.digester.peek();
        if (ojb instanceof Container) {
            parentClassLoader = ((Container)ojb).getParentClassLoader();
        }
        String className = this.loaderClass;
        if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
            className = value;
        }
        Class<?> clazz = Class.forName(className);
        Class[] types = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{parentClassLoader};
        Constructor<?> constructor = clazz.getDeclaredConstructor(types);
        Loader loader = (Loader)constructor.newInstance(args);
        this.digester.push(loader);
        if (this.digester.getLogger().isDebugEnabled()) {
            this.digester.getLogger().debug("new " + loader.getClass().getName());
        }
    }

    public void end(String namespace, String name) throws Exception {
        Loader loader = (Loader)this.digester.pop();
        if (this.digester.getLogger().isDebugEnabled()) {
            this.digester.getLogger().debug("pop " + loader.getClass().getName());
        }
    }
}

