/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAASRealm
extends RealmBase {
    private static Log log = LogFactory.getLog(JAASRealm.class);
    protected String appName = null;
    protected static final String info = "org.apache.catalina.realm.JAASRealm/1.0";
    protected static final String name = "JAASRealm";
    protected List roleClasses = new ArrayList();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected List userClasses = new ArrayList();
    protected Map roleMap = new HashMap();
    protected boolean useContextClassLoader = true;
    protected String roleClassNames = null;
    protected String userClassNames = null;

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setUseContextClassLoader(boolean useContext) {
        this.useContextClassLoader = useContext;
        log.info("Setting useContextClassLoader = " + useContext);
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        if (this.appName == null) {
            String name = container.getName();
            this.appName = name = this.makeLegalForJAAS(name);
            log.info("Set JAAS app name " + this.appName);
        }
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String roleClassNames) {
        int comma;
        this.roleClassNames = roleClassNames;
        this.roleClasses.clear();
        String temp = this.roleClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.roleClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.roleClasses.add(temp);
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String userClassNames) {
        int comma;
        this.userClassNames = userClassNames;
        this.userClasses.clear();
        String temp = this.userClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.userClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.userClasses.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(String username, String credentials) {
        try {
            Principal principal;
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.beginLogin", username, this.appName));
            }
            ClassLoader ocl = null;
            if (this.isUseContextClassLoader()) {
                ocl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            try {
                loginContext = new LoginContext(this.appName, new JAASCallbackHandler(this, username, credentials));
            }
            catch (Throwable e) {
                log.error(sm.getString("jaasRealm.unexpectedError"), e);
                Principal principal2 = null;
                return principal2;
            }
            finally {
                if (this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(ocl);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Login context created " + username);
            }
            Subject subject = null;
            try {
                loginContext.login();
                subject = loginContext.getSubject();
                if (subject == null) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug(sm.getString("jaasRealm.failedLogin", username));
                    return null;
                }
            }
            catch (AccountExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug(sm.getString("jaasRealm.accountExpired", username));
                return null;
            }
            catch (CredentialExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug(sm.getString("jaasRealm.credentialExpired", username));
                return null;
            }
            catch (FailedLoginException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug(sm.getString("jaasRealm.failedLogin", username));
                return null;
            }
            catch (LoginException e) {
                log.warn(sm.getString("jaasRealm.loginException", username), e);
                return null;
            }
            catch (Throwable e) {
                log.error(sm.getString("jaasRealm.unexpectedError"), e);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.loginContextCreated", username));
            }
            if ((principal = this.createPrincipal(username, subject)) == null) {
                log.debug(sm.getString("jaasRealm.authenticateFailure", username));
                return null;
            }
            if (!log.isDebugEnabled()) return principal;
            log.debug(sm.getString("jaasRealm.authenticateSuccess", username));
            return principal;
        }
        catch (Throwable t) {
            log.error("error ", t);
            return null;
        }
    }

    public boolean hasRole(Principal principal, String role) {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("jaasRealm.isInRole.start", principal.getName(), role));
        }
        if (principal == null || role == null || this.roleMap.get(principal) == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.isInRole.noPrincipalOrRole"));
            }
            return false;
        }
        List roles = (List)this.roleMap.get(principal);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("jaasRealm.isInRole.principalCached", String.valueOf(roles.size())));
        }
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            Principal possessedRole = (Principal)it.next();
            String possessedRoleName = possessedRole.getName();
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.isInRole.possessesRole", possessedRole.getName()));
            }
            if (!possessedRoleName.equals(role)) continue;
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.isInRole.match"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("jaasRealm.isInRole.noMatch"));
        }
        return false;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Principal createPrincipal(String username, Subject subject) {
        Object password = null;
        ArrayList<Principal> roles = new ArrayList<Principal>();
        Principal userPrincipal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            String principalClass = principal.getClass().getName();
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.checkPrincipal", principal, principalClass));
            }
            if (userPrincipal == null && this.userClasses.contains(principalClass)) {
                userPrincipal = principal;
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("jaasRealm.userPrincipalSuccess", principal.getName()));
                }
            }
            if (!this.roleClasses.contains(principalClass)) continue;
            roles.add(principal);
            if (!log.isDebugEnabled()) continue;
            log.debug(sm.getString("jaasRealm.rolePrincipalAdd", principal.getName()));
        }
        if (userPrincipal == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.userPrincipalFailure"));
                log.debug(sm.getString("jaasRealm.rolePrincipalFailure"));
            }
        } else if (roles.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.rolePrincipalFailure"));
            }
        } else {
            this.roleMap.put(userPrincipal, roles);
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.rolePrincipalSuccess", String.valueOf(roles.size())));
                log.debug(sm.getString("jaasRealm.cachePrincipal", userPrincipal.getName(), String.valueOf(roles.size())));
            }
        }
        return userPrincipal;
    }

    protected String makeLegalForJAAS(String src) {
        String result = src;
        if (result == null) {
            result = "other";
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

