/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.Hashtable;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Group;
import org.apache.catalina.Host;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.mbeans.ServerLifecycleListener;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.tomcat.util.IntrospectionUtils;

public class MBeanUtils {
    private static Log log = LogFactory.getLog(MBeanUtils.class);
    private static String[][] exceptions = new String[][]{{"org.apache.ajp.tomcat4.Ajp13Connector", "Ajp13Connector"}, {"org.apache.coyote.tomcat4.Ajp13Connector", "CoyoteConnector"}, {"org.apache.catalina.users.JDBCGroup", "Group"}, {"org.apache.catalina.users.JDBCRole", "Role"}, {"org.apache.catalina.users.JDBCUser", "User"}, {"org.apache.catalina.users.MemoryGroup", "Group"}, {"org.apache.catalina.users.MemoryRole", "Role"}, {"org.apache.catalina.users.MemoryUser", "User"}};
    private static Registry registry = MBeanUtils.createRegistry();
    private static MBeanServer mserver = MBeanUtils.createServer();
    static Hashtable seq = new Hashtable();

    static String createManagedName(Object component) {
        String className = component.getClass().getName();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!className.equals(exceptions[i][0])) continue;
            return exceptions[i][1];
        }
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className;
    }

    static ModelMBean createMBean(Connector connector) throws Exception {
        String mname = MBeanUtils.createManagedName(connector);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(connector);
        ObjectName oname = MBeanUtils.createObjectName(domain, connector);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Context context) throws Exception {
        String mname = MBeanUtils.createManagedName(context);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(context);
        ObjectName oname = MBeanUtils.createObjectName(domain, context);
        if (mserver.isRegistered(oname)) {
            log.debug("Already registered " + oname);
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(ContextEnvironment environment) throws Exception {
        String mname = MBeanUtils.createManagedName(environment);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(environment);
        ObjectName oname = MBeanUtils.createObjectName(domain, environment);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(ContextResource resource) throws Exception {
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(resource);
        ObjectName oname = MBeanUtils.createObjectName(domain, resource);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(ContextResourceLink resourceLink) throws Exception {
        String mname = MBeanUtils.createManagedName(resourceLink);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(resourceLink);
        ObjectName oname = MBeanUtils.createObjectName(domain, resourceLink);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Engine engine) throws Exception {
        String mname = MBeanUtils.createManagedName(engine);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(engine);
        ObjectName oname = MBeanUtils.createObjectName(domain, engine);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Group group) throws Exception {
        String mname = MBeanUtils.createManagedName(group);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(group);
        ObjectName oname = MBeanUtils.createObjectName(domain, group);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Host host) throws Exception {
        String mname = MBeanUtils.createManagedName(host);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(host);
        ObjectName oname = MBeanUtils.createObjectName(domain, host);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Loader loader) throws Exception {
        String mname = MBeanUtils.createManagedName(loader);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(loader);
        ObjectName oname = MBeanUtils.createObjectName(domain, loader);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Manager manager) throws Exception {
        String mname = MBeanUtils.createManagedName(manager);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(manager);
        ObjectName oname = MBeanUtils.createObjectName(domain, manager);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(MBeanFactory factory) throws Exception {
        String mname = MBeanUtils.createManagedName(factory);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(factory);
        ObjectName oname = MBeanUtils.createObjectName(domain, factory);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(NamingResources resource) throws Exception {
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(resource);
        ObjectName oname = MBeanUtils.createObjectName(domain, resource);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Realm realm) throws Exception {
        String mname = MBeanUtils.createManagedName(realm);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(realm);
        ObjectName oname = MBeanUtils.createObjectName(domain, realm);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Role role) throws Exception {
        String mname = MBeanUtils.createManagedName(role);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(role);
        ObjectName oname = MBeanUtils.createObjectName(domain, role);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Server server) throws Exception {
        String mname = MBeanUtils.createManagedName(server);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(server);
        ObjectName oname = MBeanUtils.createObjectName(domain, server);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Service service) throws Exception {
        String mname = MBeanUtils.createManagedName(service);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(service);
        ObjectName oname = MBeanUtils.createObjectName(domain, service);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(User user) throws Exception {
        String mname = MBeanUtils.createManagedName(user);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(user);
        ObjectName oname = MBeanUtils.createObjectName(domain, user);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(UserDatabase userDatabase) throws Exception {
        String mname = MBeanUtils.createManagedName(userDatabase);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(userDatabase);
        ObjectName oname = MBeanUtils.createObjectName(domain, userDatabase);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Valve valve) throws Exception {
        String mname = MBeanUtils.createManagedName(valve);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(valve);
        ObjectName oname = MBeanUtils.createObjectName(domain, valve);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ObjectName createObjectName(String domain, Connector connector) throws MalformedObjectNameException {
        ObjectName name = null;
        if (connector.getClass().getName().indexOf("CoyoteConnector") >= 0) {
            try {
                String address = (String)IntrospectionUtils.getProperty(connector, "address");
                Integer port = (Integer)IntrospectionUtils.getProperty(connector, "port");
                Service service = connector.getService();
                String serviceName = null;
                if (service != null) {
                    serviceName = service.getName();
                }
                StringBuffer sb = new StringBuffer(domain);
                sb.append(":type=Connector");
                sb.append(",port=" + port);
                if (address != null && address.length() > 0) {
                    sb.append(",address=" + address);
                }
                name = new ObjectName(sb.toString());
                return name;
            }
            catch (Exception e) {
                throw new MalformedObjectNameException("Cannot create object name for " + connector + e);
            }
        }
        throw new MalformedObjectNameException("Cannot create object name for " + connector);
    }

    static ObjectName createObjectName(String domain, Context context) throws MalformedObjectNameException {
        ObjectName name = null;
        Host host = (Host)context.getParent();
        Service service = ((Engine)host.getParent()).getService();
        String path = context.getPath();
        if (path.length() < 1) {
            path = "/";
        }
        name = new ObjectName(domain + ":j2eeType=WebModule,name=//" + host.getName() + path + ",J2EEApplication=none,J2EEServer=none");
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextEnvironment environment) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = environment.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Environment" + ",resourcetype=Global,name=" + environment.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Environment" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + environment.getName());
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResource resource) throws MalformedObjectNameException {
        ObjectName name = null;
        String quotedResourceName = ObjectName.quote(resource.getName());
        Object container = resource.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global,class=" + resource.getType() + ",name=" + quotedResourceName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Resource" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",class=" + resource.getType() + ",name=" + quotedResourceName);
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResourceLink resourceLink) throws MalformedObjectNameException {
        ObjectName name = null;
        String quotedResourceLinkName = ObjectName.quote(resourceLink.getName());
        Object container = resourceLink.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Global" + ",name=" + quotedResourceLinkName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + quotedResourceLinkName);
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Engine engine) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Engine");
        return name;
    }

    static ObjectName createObjectName(String domain, Group group) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Group,groupname=" + ObjectName.quote(group.getGroupname()) + ",database=" + group.getUserDatabase().getId());
        return name;
    }

    static ObjectName createObjectName(String domain, Host host) throws MalformedObjectNameException {
        ObjectName name = null;
        Engine engine = (Engine)host.getParent();
        Service service = engine.getService();
        name = new ObjectName(domain + ":type=Host,host=" + host.getName());
        return name;
    }

    static ObjectName createObjectName(String domain, Loader loader) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = loader.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Loader");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Loader,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Loader,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Manager manager) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = manager.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Manager");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Manager,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Manager,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, NamingResources resources) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = resources.getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Global");
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Context,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, MBeanFactory factory) throws MalformedObjectNameException {
        ObjectName name = new ObjectName(domain + ":type=MBeanFactory");
        return name;
    }

    static ObjectName createObjectName(String domain, Realm realm) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = realm.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Realm");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Realm,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Realm,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Role role) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Role,rolename=" + role.getRolename() + ",database=" + role.getUserDatabase().getId());
        return name;
    }

    static ObjectName createObjectName(String domain, Server server) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Server");
        return name;
    }

    static ObjectName createObjectName(String domain, Service service) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Service,serviceName=" + service.getName());
        return name;
    }

    static ObjectName createObjectName(String domain, User user) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=User,username=" + ObjectName.quote(user.getUsername()) + ",database=" + user.getUserDatabase().getId());
        return name;
    }

    static ObjectName createObjectName(String domain, UserDatabase userDatabase) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=UserDatabase,database=" + userDatabase.getId());
        return name;
    }

    static ObjectName createObjectName(String domain, Valve valve) throws MalformedObjectNameException {
        ObjectName name;
        if (valve instanceof ValveBase && (name = ((ValveBase)valve).getObjectName()) != null) {
            return name;
        }
        name = null;
        Container container = null;
        String className = valve.getClass().getName();
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        if (valve instanceof Contained) {
            container = ((Contained)((Object)valve)).getContainer();
        }
        if (container == null) {
            throw new MalformedObjectNameException("Cannot create mbean for non-contained valve " + valve);
        }
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            String local = "";
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        } else if (container instanceof Host) {
            Service service = ((Engine)container.getParent()).getService();
            String local = ",host=" + container.getName();
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Service service = ((Engine)host.getParent()).getService();
            String local = ",path=" + path + ",host=" + host.getName();
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        }
        return name;
    }

    static int getSeq(String key) {
        int[] i = (int[])seq.get(key);
        if (i == null) {
            i = new int[]{0};
            seq.put(key, i);
        } else {
            i[0] = i[0] + 1;
        }
        return i[0];
    }

    public static synchronized Registry createRegistry() {
        if (registry == null) {
            registry = Registry.getRegistry(null, null);
            ClassLoader cl = ServerLifecycleListener.class.getClassLoader();
            registry.loadDescriptors("org.apache.catalina.mbeans", cl);
            registry.loadDescriptors("org.apache.catalina.authenticator", cl);
            registry.loadDescriptors("org.apache.catalina.core", cl);
            registry.loadDescriptors("org.apache.catalina", cl);
            registry.loadDescriptors("org.apache.catalina.deploy", cl);
            registry.loadDescriptors("org.apache.catalina.loader", cl);
            registry.loadDescriptors("org.apache.catalina.realm", cl);
            registry.loadDescriptors("org.apache.catalina.session", cl);
            registry.loadDescriptors("org.apache.catalina.startup", cl);
            registry.loadDescriptors("org.apache.catalina.users", cl);
            registry.loadDescriptors("org.apache.catalina.cluster", cl);
            registry.loadDescriptors("org.apache.catalina.connector", cl);
            registry.loadDescriptors("org.apache.catalina.valves", cl);
        }
        return registry;
    }

    public static synchronized MBeanServer createServer() {
        if (mserver == null) {
            try {
                mserver = Registry.getRegistry(null, null).getMBeanServer();
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return mserver;
    }

    static void destroyMBean(Connector connector, Service service) throws Exception {
        connector.setService(service);
        String mname = MBeanUtils.createManagedName(connector);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ObjectName oname = MBeanUtils.createObjectName(domain, connector);
        connector.setService(null);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Context context) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(context);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, context))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(ContextEnvironment environment) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(environment);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, environment))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(ContextResource resource) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resource))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(ContextResourceLink resourceLink) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resourceLink);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resourceLink))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Engine engine) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(engine);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, engine))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Group group) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(group);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, group))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Host host) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(host);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, host))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Loader loader) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(loader);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, loader))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Manager manager) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(manager);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, manager))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(NamingResources resources) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resources);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resources))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Realm realm) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(realm);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, realm))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Role role) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(role);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, role))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Server server) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(server);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, server))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Service service) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(service);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, service))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(User user) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(user);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, user))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(UserDatabase userDatabase) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(userDatabase);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, userDatabase))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Valve valve, Container container) throws Exception {
        ((Contained)((Object)valve)).setContainer(container);
        String mname = MBeanUtils.createManagedName(valve);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ObjectName oname = MBeanUtils.createObjectName(domain, valve);
        try {
            ((Contained)((Object)valve)).setContainer(null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
    }
}

