/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;

public class CoyoteAdapter
implements Adapter {
    private static Log log = LogFactory.getLog(CoyoteAdapter.class);
    public static final int ADAPTER_NOTES = 1;
    private Connector connector = null;
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID = ";jsessionid=".toCharArray();
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector");

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(org.apache.coyote.Request req, org.apache.coyote.Response res) throws Exception {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request == null) {
            request = this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, request);
            res.setNote(1, response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        if (this.connector.getXpoweredBy()) {
            response.addHeader("X-Powered-By", "Servlet/2.4");
        }
        try {
            if (this.postParseRequest(req, request, res, response)) {
                this.connector.getContainer().getPipeline().getFirst().invoke(request, response);
            }
            response.finishResponse();
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            log.error(this.sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            request.recycle();
            response.recycle();
        }
    }

    protected boolean postParseRequest(org.apache.coyote.Request req, Request request, org.apache.coyote.Response res, Response response) throws Exception {
        String authtype;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        if (decodedURI.getType() == 2) {
            try {
                req.getURLDecoder().convert(decodedURI, false);
            }
            catch (IOException ioe) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                throw ioe;
            }
            if (!CoyoteAdapter.normalize(req.decodedURI())) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                return false;
            }
            this.convertURI(decodedURI, request);
        } else {
            decodedURI.toChars();
        }
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
        this.parseSessionId(req, request);
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        if (semicolon > 0) {
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
        }
        this.connector.getMapper().map(req.serverName(), decodedURI, request.getMappingData());
        request.setContext((Context)request.getMappingData().context);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            return false;
        }
        MessageBytes redirectPathMB = request.getMappingData().redirectPath;
        if (!redirectPathMB.isNull()) {
            String redirectPath = redirectPathMB.toString();
            String query = request.getQueryString();
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            response.sendRedirect(redirectPath);
            return false;
        }
        this.parseSessionCookiesId(req, request);
        return true;
    }

    protected void parseSessionId(org.apache.coyote.Request req, Request request) {
        CharChunk uriCC = req.decodedURI().getCharChunk();
        int semicolon = uriCC.indexOf(match, 0, match.length(), 0);
        if (semicolon > 0) {
            int start = uriCC.getStart();
            int end = uriCC.getEnd();
            int sessionIdStart = start + semicolon + match.length();
            int semicolon2 = uriCC.indexOf(';', sessionIdStart);
            if (semicolon2 >= 0) {
                request.setRequestedSessionId(new String(uriCC.getBuffer(), sessionIdStart, semicolon2 - semicolon - match.length()));
            } else {
                request.setRequestedSessionId(new String(uriCC.getBuffer(), sessionIdStart, end - sessionIdStart));
            }
            request.setRequestedSessionURL(true);
            ByteChunk uriBC = req.requestURI().getByteChunk();
            start = uriBC.getStart();
            end = uriBC.getEnd();
            semicolon = uriBC.indexOf(match, 0, match.length(), 0);
            if (semicolon > 0) {
                sessionIdStart = start + semicolon;
                semicolon2 = uriCC.indexOf(';', start + semicolon + match.length());
                uriBC.setEnd(start + semicolon);
                byte[] buf = uriBC.getBuffer();
                if (semicolon2 >= 0) {
                    for (int i = 0; i < end - start - semicolon2; ++i) {
                        buf[start + semicolon + i] = buf[start + i + semicolon2];
                    }
                    uriBC.setBytes(buf, start, semicolon + (end - start - semicolon2));
                }
            }
        } else {
            request.setRequestedSessionId(null);
            request.setRequestedSessionURL(false);
        }
    }

    protected void parseSessionCookiesId(org.apache.coyote.Request req, Request request) {
        Cookies serverCookies = req.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals("JSESSIONID")) continue;
            if (!request.isRequestedSessionIdFromCookie()) {
                this.convertMB(scookie.getValue());
                request.setRequestedSessionId(scookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (!log.isDebugEnabled()) continue;
                log.debug(" Requested cookie session id is " + request.getRequestedSessionId());
                continue;
            }
            if (request.isRequestedSessionIdValid()) continue;
            this.convertMB(scookie.getValue());
            request.setRequestedSessionId(scookie.getValue().toString());
        }
    }

    protected void convertURI(MessageBytes uri, Request request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null) {
            B2CConverter conv = request.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    request.setURIConverter(conv);
                } else {
                    conv.recycle();
                }
            }
            catch (IOException e) {
                log.error("Invalid URI encoding; using HTTP default");
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.error("Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                b[pos] = 47;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start >= 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }
}

