/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tomcat;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BWebLogFileFormat;
import javax.baja.web.BWebLogFilePolicy;
import javax.baja.web.BWebService;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;

public class BTomcatWebService
extends BWebService {
    public static final Property logFileEnabled = BTomcatWebService.newProperty((int)4, (boolean)false, null);
    public static final Property logFileFormat = BTomcatWebService.newProperty((int)4, (BValue)BWebLogFileFormat.commonLogFormat, null);
    public static final Property logFileDirectory = BTomcatWebService.newProperty((int)4, (BValue)BOrd.make((String)"file:^tomcat"), null);
    public static final Property logFilePolicy = BTomcatWebService.newProperty((int)4, (BValue)BWebLogFilePolicy.daily, null);
    public static final Property logMaximumSize = BTomcatWebService.newProperty((int)4, (int)100, null);
    public static final Property logFileIndex = BTomcatWebService.newProperty((int)4, (int)1, null);
    public static final Property backlog = BTomcatWebService.newProperty((int)4, (int)0, null);
    public static final Property maxThreads = BTomcatWebService.newProperty((int)4, (int)0, null);
    public static final Property minThreads = BTomcatWebService.newProperty((int)4, (int)0, null);
    public static final Property autoLoginEnabled = BTomcatWebService.newProperty((int)4, (boolean)false, null);
    public static final Property loginTemplate = BTomcatWebService.newProperty((int)4, (BValue)BTypeSpec.NULL, null);
    public static final Property tunnelingEnabled = BTomcatWebService.newProperty((int)4, (boolean)false, null);
    public static final Property proxyAuthenticationWhenTunneling = BTomcatWebService.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$tomcat$BTomcatWebService == null ? (class$com$tridium$tomcat$BTomcatWebService = BTomcatWebService.class$("com.tridium.tomcat.BTomcatWebService")) : class$com$tridium$tomcat$BTomcatWebService));
    static final Log log = Log.getLog((String)"tomcat");
    static boolean unpacked = false;
    Embedded tomcat;
    static /* synthetic */ Class class$com$tridium$tomcat$BTomcatWebService;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public void stationStarted() throws Exception {
        this.startTomcat();
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 9900) {
            return null;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public void stopped() throws Exception {
        this.stopTomcat();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled || property == httpPort || property == httpEnabled || property == httpsPort || property == httpsEnabled) {
            this.restartTomcat();
        }
    }

    private void restartTomcat() {
        try {
            if (!this.isRunning()) {
                return;
            }
            this.stopTomcat();
            this.startTomcat();
        }
        catch (Exception exception) {
            log.error("Cannot restart", (Throwable)exception);
        }
    }

    private void startTomcat() throws Exception {
        Object object;
        log.message("Starting...");
        BTomcatWebService.unpack();
        if (!(this.isOperational() || this.getHttpEnabled() || this.getHttpsEnabled())) {
            return;
        }
        System.setProperty("catalina.home", BTomcatWebService.home().toString());
        this.tomcat = new Embedded();
        Engine engine = this.tomcat.createEngine();
        engine.setDefaultHost("localhost");
        Host host = this.tomcat.createHost("localhost", "webapps");
        engine.addChild(host);
        Context context = this.tomcat.createContext("", "ROOT");
        host.addChild(context);
        Context context2 = this.tomcat.createContext("/manager", "manager");
        context2.setPrivileged(true);
        host.addChild(context2);
        this.tomcat.addEngine(engine);
        if (this.getHttpEnabled()) {
            object = this.tomcat.createConnector((InetAddress)null, this.getHttpPort(), false);
            this.tomcat.addConnector((Connector)object);
        }
        if (this.getHttpsEnabled()) {
            try {
                object = BOrd.make((String)"service:crypto:CryptoService").get();
                if (object != null) {
                    Method method = object.getClass().getMethod("getSsl", new Class[0]);
                    Object object2 = method.invoke(object, new Object[0]);
                    Class<?> clazz = object2.getClass();
                    Method method2 = clazz.getMethod("getFilePath", class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BTomcatWebService.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
                    Method method3 = clazz.getMethod("getKeyStore", new Class[0]);
                    Method method4 = clazz.getMethod("getKeyStorePassword", new Class[0]);
                    Method method5 = clazz.getMethod("getKeyStoreType", new Class[0]);
                    BOrd bOrd = (BOrd)method3.invoke(object2, new Object[0]);
                    String string = (String)method2.invoke(object2, bOrd);
                    BPassword bPassword = (BPassword)method4.invoke(object2, new Object[0]);
                    String string2 = (String)method5.invoke(object2, new Object[0]);
                    Method method6 = clazz.getMethod("getTrustStore", new Class[0]);
                    Method method7 = clazz.getMethod("getTrustStorePassword", new Class[0]);
                    Method method8 = clazz.getMethod("getTrustStoreType", new Class[0]);
                    BOrd bOrd2 = (BOrd)method6.invoke(object2, new Object[0]);
                    String string3 = (String)method2.invoke(object2, bOrd2);
                    BPassword bPassword2 = (BPassword)method7.invoke(object2, new Object[0]);
                    String string4 = (String)method8.invoke(object2, new Object[0]);
                    Connector connector = this.tomcat.createConnector((InetAddress)null, this.getHttpsPort(), true);
                    connector.setScheme("https");
                    connector.setSecure(true);
                    connector.setProtocol("TLS");
                    connector.setProperty("SSLEnabled", "true");
                    connector.setProperty("secure", "true");
                    connector.setProperty("socketFactory", "javax.net.ssl.SSLServerSocketFactory");
                    connector.setProperty("keystoreFile", string);
                    connector.setProperty("keystorePass", bPassword.getString());
                    connector.setProperty("keypass", bPassword.getString());
                    connector.setProperty("keystoreType", string2);
                    connector.setProperty("truststoreFile", string3);
                    connector.setProperty("truststorePass", bPassword2.getString());
                    connector.setProperty("truststorekeypass", bPassword.getString());
                    connector.setProperty("truststoreType", string4);
                    this.tomcat.addConnector(connector);
                }
            }
            catch (Exception exception) {
                log.error("HTTPS connector", (Throwable)exception);
            }
        }
        this.tomcat.start();
        log.message("Started");
    }

    private void stopTomcat() throws Exception {
        log.message("Stopping...");
        if (this.tomcat != null) {
            this.tomcat.stop();
        }
        this.tomcat = null;
        log.message("Stopped");
    }

    public static void unpack() throws Exception {
        if (unpacked) {
            return;
        }
        File file = BTomcatWebService.home();
        file.mkdirs();
        BIDirectory bIDirectory = (BIDirectory)BOrd.make((String)"module://tomcat/unpack").get();
        BTomcatWebService.unpack(bIDirectory, file);
        unpacked = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpack(BIDirectory bIDirectory, File file) throws Exception {
        BIFile[] bIFileArray = bIDirectory.listFiles();
        for (int i = 0; i < bIFileArray.length; ++i) {
            File file2;
            BIFile bIFile = bIFileArray[i];
            String string = bIFile.getFileName();
            if (bIFile.isDirectory()) {
                file2 = new File(file, string);
                file2.mkdirs();
                BTomcatWebService.unpack((BIDirectory)bIFile, file2);
                continue;
            }
            file2 = new File(file, string);
            if (bIFile.getLastModified().getMillis() == file2.lastModified() && bIFile.getSize() == file2.length()) continue;
            log.message("unpack " + file2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(bIFile.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                FileUtil.pipe((InputStream)bufferedInputStream, (long)bIFile.getSize(), (OutputStream)bufferedOutputStream);
            }
            finally {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Exception exception) {}
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {}
            }
            file2.setLastModified(bIFile.getLastModified().getMillis());
        }
    }

    public static File home() {
        return new File(Sys.getStationHome(), "tomcat");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

