/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.sys.Nre;
import javax.baja.chart.BChartPane;
import javax.baja.chart.Series;
import javax.baja.chart.TrendFlags;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

public class TableSeries
extends Series {
    private BITable table;
    private String seriesName;
    private SeriesColumn[] seriesCols;
    private TrendFlagsColumn trendFlags;

    public String getName() {
        return this.seriesName;
    }

    public int getRowCount() {
        return this.table.size();
    }

    public String getColumnName(int n) {
        return this.seriesCols[n].getName();
    }

    public String getColumnDisplayName(int n) {
        return this.seriesCols[n].getDisplayName(null);
    }

    public Type getColumnType(int n) {
        return this.seriesCols[n].getType();
    }

    public BFacets getColumnFacets(int n) {
        return this.seriesCols[n].getFacets();
    }

    public Object getValue(int n, int n2) {
        return this.seriesCols[n2].getValue(this.table, n);
    }

    public int getTrendFlags(int n) {
        if (this.trendFlags == null) {
            return 0;
        }
        return this.trendFlags.getFlags(this.table, n);
    }

    public Object getMin(int n) {
        BAbsTime bAbsTime;
        Object object;
        Type type = this.getColumnType(n);
        if (type == BAbsTime.TYPE && (object = this.table.getTableFacets()) != null && (bAbsTime = (BAbsTime)object.getFacet("startTime")) != null && !bAbsTime.isNull()) {
            return bAbsTime;
        }
        object = this.seriesCols[n].getRange(this.table);
        return object.min;
    }

    public Object getMax(int n) {
        BAbsTime bAbsTime;
        Object object;
        Type type = this.getColumnType(n);
        if (type == BAbsTime.TYPE && (object = this.table.getTableFacets()) != null && (bAbsTime = (BAbsTime)object.getFacet("endTime")) != null && !bAbsTime.isNull()) {
            return bAbsTime;
        }
        object = this.seriesCols[n].getRange(this.table);
        return object.max;
    }

    private final SeriesColumn toSeriesColumn(BITable bITable, BColumnIdentifier bColumnIdentifier) {
        if (bColumnIdentifier.isRowIndex()) {
            return new RowIndexColumn();
        }
        if (bColumnIdentifier.isTableColumn()) {
            ColumnList columnList = bITable.getColumns();
            Column column = columnList.get(bColumnIdentifier.getColumnName());
            if (column == null) {
                throw new IllegalArgumentException("Column does not exist: " + bColumnIdentifier.getColumnName());
            }
            return new TableColumn(column);
        }
        throw new IllegalArgumentException("Unsupported column identifier: " + (Object)((Object)bColumnIdentifier));
    }

    public TableSeries(String string, BITable bITable, String string2, String string3) {
        this(string, bITable, BColumnIdentifier.makeTableColumn(string2), BColumnIdentifier.makeTableColumn(string3));
    }

    public TableSeries(String string, BITable bITable, BColumnIdentifier bColumnIdentifier, BColumnIdentifier bColumnIdentifier2) {
        this.setPen(BPen.make((double)1.0));
        this.setBrush(BChartPane.DEFAULT_COLORS[0].toBrush());
        this.table = bITable;
        BFacets bFacets = bITable.getTableFacets();
        if (string == null) {
            this.seriesName = "";
            if (bFacets != null) {
                this.seriesName = bFacets.gets("tableName", "");
            }
        } else {
            this.seriesName = string;
        }
        this.seriesCols = new SeriesColumn[2];
        this.seriesCols[0] = this.toSeriesColumn(bITable, bColumnIdentifier);
        this.seriesCols[1] = this.toSeriesColumn(bITable, bColumnIdentifier2);
        ColumnList columnList = bITable.getColumns();
        Column column = columnList.get("trendFlags");
        if (column != null) {
            BObject bObject;
            BIDataValue bIDataValue;
            Column column2 = columnList.get("status");
            TrendFlagsColumn trendFlagsColumn = null;
            if (column2 != null) {
                if (column2.getType().is(BStatus.TYPE)) {
                    trendFlagsColumn = new StatusToInt(column2);
                } else if (column2.getType().is(BNumber.TYPE)) {
                    trendFlagsColumn = new NumberToInt(column2, null);
                }
            }
            this.trendFlags = column.getType().is(BNumber.TYPE) ? new NumberToInt(column, trendFlagsColumn) : (bITable.size() != 0 ? ((bIDataValue = (bObject = bITable.get(0, column)).toDataValue()) instanceof BNumber ? new DataValueToInt(column, trendFlagsColumn) : null) : null);
        }
    }

    public TableSeries(String string, BITable bITable, BColumnIdentifier bColumnIdentifier, BColumnIdentifier bColumnIdentifier2, BBrush bBrush, BPen bPen) {
        this(string, bITable, bColumnIdentifier, bColumnIdentifier2);
        this.setBrush(bBrush);
        this.setPen(bPen);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class SeriesColumn {
        private Range range;

        public abstract String getName();

        public abstract Type getType();

        public abstract BFacets getFacets();

        public abstract Object getValue(BITable var1, int var2);

        public String getDisplayName(Context context) {
            return this.getName();
        }

        public Range getRange(BITable bITable) {
            if (this.range == null) {
                this.range = this.computeRange(bITable);
            }
            return this.range;
        }

        public Range computeRange(BITable bITable) {
            Range range = new Range();
            int n = bITable.size();
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                double d;
                Double d2;
                Object object;
                if (!(TrendFlags.isHidden(TableSeries.this.getTrendFlags(n2)) || (object = this.getValue(bITable, n2)) instanceof BINumeric && (d2 = new Double(d = ((BINumeric)object).getNumeric())).isNaN())) {
                    if (bl) {
                        range.min = object;
                        range.max = object;
                        bl = false;
                    } else {
                        if (SortUtil.compare((Object)object, (Object)range.min) < 0) {
                            range.min = object;
                        }
                        if (SortUtil.compare((Object)object, (Object)range.max) > 0) {
                            range.max = object;
                        }
                    }
                }
                ++n2;
            }
            return range;
        }

        private SeriesColumn() {
        }
    }

    private static abstract class TrendFlagsColumn {
        public abstract int getFlags(BITable var1, int var2);

        private TrendFlagsColumn() {
        }
    }

    private static class Range {
        Object min;
        Object max;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RowIndexColumn
    extends SeriesColumn {
        public String getName() {
            return "";
        }

        public String getDisplayName(Context context) {
            return null;
        }

        public Type getType() {
            return BDouble.TYPE;
        }

        public BFacets getFacets() {
            return BFacets.NULL;
        }

        public Object getValue(BITable bITable, int n) {
            return BDouble.make((double)n);
        }

        public Range computeRange(BITable bITable) {
            Range range = new Range();
            range.min = BDouble.make((double)0.0);
            range.max = BDouble.make((double)(bITable.size() - 1));
            return range;
        }

        private RowIndexColumn() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TableColumn
    extends SeriesColumn {
        Column col;
        BFacets colFacets;
        BUnit colFacetUnits;
        BUnit colDesiredUnits;

        public String getDisplayName(Context context) {
            return this.col.getDisplayName(context);
        }

        public String getName() {
            return this.col.getName();
        }

        public Type getType() {
            return this.col.getType();
        }

        public BFacets getFacets() {
            return this.colFacets;
        }

        public Object getValue(BITable bITable, int n) {
            BObject bObject = bITable.get(n, this.col);
            if (bObject instanceof BNumber && this.colDesiredUnits != null && this.colFacetUnits != null && this.colDesiredUnits != this.colFacetUnits) {
                bObject = BDouble.make((double)this.colFacetUnits.convertTo(this.colDesiredUnits, ((BNumber)bObject).getNumeric()));
            }
            return bObject;
        }

        private final /* synthetic */ void this() {
            this.colFacetUnits = null;
            this.colDesiredUnits = null;
        }

        public TableColumn(Column column) {
            this.this();
            this.col = column;
            this.colFacets = column.getFacets();
            if (this.getType().is(BNumber.TYPE) && this.colFacets != null && !this.colFacets.isNull()) {
                this.colFacetUnits = (BUnit)this.colFacets.get("units");
                int n = Nre.unitConversion;
                n = this.colFacets.geti("unitConversion", n);
                if (this.colFacetUnits != null && !this.colFacetUnits.isNull() && n != 0) {
                    BUnitConversion bUnitConversion = BUnitConversion.make((int)n);
                    this.colDesiredUnits = bUnitConversion.getDesiredUnit(this.colFacetUnits);
                    if (this.colDesiredUnits != this.colFacetUnits) {
                        this.colFacets = BFacets.make((BFacets)this.colFacets, (String)"units", (BIDataValue)this.colDesiredUnits);
                    }
                }
            }
        }
    }

    private static class StatusToInt
    extends TrendFlagsColumn {
        Column column;

        public int getFlags(BITable bITable, int n) {
            return ((BStatus)bITable.get(n, this.column)).getBits();
        }

        public StatusToInt(Column column) {
            this.column = column;
        }
    }

    private static class NumberToInt
    extends TrendFlagsColumn {
        Column column;
        TrendFlagsColumn statusCol;

        public int getFlags(BITable bITable, int n) {
            if (this.statusCol != null && (this.statusCol.getFlags(bITable, n) & 0x10) != 0) {
                return ((BNumber)bITable.get(n, this.column)).getInt() | 4;
            }
            return ((BNumber)bITable.get(n, this.column)).getInt();
        }

        public NumberToInt(Column column, TrendFlagsColumn trendFlagsColumn) {
            this.column = column;
            this.statusCol = trendFlagsColumn;
        }
    }

    private static class DataValueToInt
    extends TrendFlagsColumn {
        Column column;
        TrendFlagsColumn statusCol;

        public int getFlags(BITable bITable, int n) {
            if (this.statusCol != null && (this.statusCol.getFlags(bITable, n) & 0x10) != 0) {
                return ((BNumber)bITable.get(n, this.column).toDataValue()).getInt() | 4;
            }
            return ((BNumber)bITable.get(n, this.column).toDataValue()).getInt();
        }

        public DataValueToInt(Column column, TrendFlagsColumn trendFlagsColumn) {
            this.column = column;
            this.statusCol = trendFlagsColumn;
        }
    }
}

