/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.util.ArrayList;
import javax.baja.chart.Series;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;

public class JoinTable {
    private Object[] keys;
    private Object[] columns;
    private Series[] seriesList;
    private Object minRow;
    private Object maxRow;

    public static JoinTable make(Series[] seriesArray, int n) {
        Object object;
        int n2;
        Object[] objectArray;
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Invalid key column for join.");
        }
        int n3 = 0;
        if (n == 0) {
            n3 = 1;
        }
        int n4 = n3;
        int n5 = seriesArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n6 = 0;
        while (n6 < n5) {
            objectArray = seriesArray[n6];
            n2 = objectArray.getRowCount();
            int n7 = 0;
            while (n7 < n2) {
                object = objectArray.getValue(n7, n);
                if (!arrayList.contains(object)) {
                    arrayList.add(object);
                }
                ++n7;
            }
            ++n6;
        }
        Object[] objectArray2 = arrayList.toArray(new Object[arrayList.size()]);
        if (objectArray2.length > 0 && objectArray2[0] instanceof Comparable) {
            SortUtil.sort((Object[])objectArray2);
        }
        objectArray = new Object[n5];
        n2 = 0;
        while (n2 < n5) {
            Object[] objectArray3;
            objectArray[n2] = objectArray3 = new Object[objectArray2.length];
            object = seriesArray[n2];
            int n8 = ((Series)object).getRowCount();
            int n9 = 0;
            while (n9 < n8) {
                Object object2 = ((Series)object).getValue(n9, n);
                Object object3 = ((Series)object).getValue(n9, n4);
                int n10 = 0;
                while (n10 < objectArray2.length) {
                    if (object2.equals(objectArray2[n10])) {
                        objectArray3[n10] = object3;
                        break;
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n2;
        }
        JoinTable joinTable = new JoinTable();
        joinTable.keys = objectArray2;
        joinTable.columns = objectArray;
        joinTable.seriesList = seriesArray;
        return joinTable;
    }

    public int getRowCount() {
        return this.keys.length;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getKey(int n) {
        return this.keys[n];
    }

    public Object getValue(int n, int n2) {
        return ((Object[])this.columns[n2])[n];
    }

    public Series getSeries(int n) {
        return this.seriesList[n];
    }

    public Object getMinRow() {
        if (this.minRow == null) {
            this.computeRowRange();
        }
        return this.minRow;
    }

    public Object getMaxRow() {
        if (this.maxRow == null) {
            this.computeRowRange();
        }
        return this.maxRow;
    }

    private final void computeRowRange() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        int n3 = 0;
        while (n3 < n) {
            double d3 = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                Object object = this.getValue(n3, n4);
                if (object != null) {
                    d3 += ((BINumeric)object).getNumeric();
                }
                ++n4;
            }
            if (n3 == 0) {
                d = d3;
                d2 = d3;
            } else {
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            ++n3;
        }
        if (d == d2) {
            if (d > 0.0) {
                d = 0.0;
            } else {
                d2 = d < 0.0 ? 0.0 : 10.0;
            }
        }
        this.minRow = BDouble.make((double)d);
        this.maxRow = BDouble.make((double)d2);
    }

    private final void dump() {
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        int n3 = 0;
        while (n3 < n) {
            double d = 0.0;
            System.out.print(this.getKey(n3) + ": ");
            int n4 = 0;
            while (n4 < n2) {
                Object object = this.getValue(n3, n4);
                if (n4 != 0) {
                    System.out.print(", ");
                }
                System.out.print(object);
                if (object instanceof BINumeric) {
                    d += ((BINumeric)object).getNumeric();
                }
                ++n4;
            }
            System.out.println("   " + d);
            ++n3;
        }
    }

    private JoinTable() {
    }
}

