/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.gx.GxEnv;
import javax.baja.chart.AxisRenderer;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.Series;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultAxisRenderer
extends AxisRenderer {
    protected static final double SWATCH_WIDTH = 12.0;
    protected static final double SWATCH_HEIGHT = 12.0;
    private static final String SPACER = "      ";
    private static Lexicon lex = Lexicon.make((String)"chart");
    private BFont tickFont;
    private BFont unitFont;
    private BFont titleFont;

    public void paint(Graphics graphics, BAxis bAxis) {
        if (bAxis.getLocation() == BAxisLocation.left) {
            this.paintLeft(graphics, bAxis);
        } else if (bAxis.getLocation() == BAxisLocation.bottom) {
            this.paintBottom(graphics, bAxis);
        } else if (bAxis.getLocation() == BAxisLocation.right) {
            this.paintRight(graphics, bAxis);
        } else if (bAxis.getLocation() == BAxisLocation.top) {
            this.paintTop(graphics, bAxis);
        }
    }

    public double getPreferredAxisWidth(BAxis bAxis) {
        Object object;
        BAxisDimension bAxisDimension = bAxis.getDimension();
        double d = 7.0;
        if (bAxisDimension == BAxisDimension.x) {
            d += this.tickFont.getHeight() + (double)4;
        } else if (bAxisDimension == BAxisDimension.y) {
            if (bAxis instanceof BDiscreteAxis) {
                double d2 = 0.0;
                object = bAxis.getTickValues();
                int n = 0;
                while (n < ((Object[])object).length) {
                    d2 = Math.max(d2, this.tickFont.width(bAxis.valueToString(object[n])));
                    ++n;
                }
                d += d2 + (double)4;
            } else {
                String string = bAxis.valueToString(bAxis.getAxisMax());
                d += this.tickFont.width(string) + (double)4;
            }
        }
        double d3 = 0.0;
        object = this.getAxisLabel(bAxis);
        if (object.length() == 0) {
            object = SPACER;
        }
        d3 = this.titleFont.width((String)object);
        return (d += d3) + (double)5;
    }

    public void paintTop(Graphics graphics, BAxis bAxis) {
        String string;
        double d = bAxis.getWidth();
        double d2 = bAxis.getHeight();
        Object[] objectArray = bAxis.getTickValues();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        int n2 = n;
        graphics.setBrush(BColor.black);
        graphics.setFont(this.tickFont);
        double d3 = bAxis.getMinMargin();
        int n3 = 0;
        while (n3 < n2) {
            double d4 = bAxis.toDisplaySpace(objectArray[n3]);
            String string2 = bAxis.valueToString(objectArray[n3]);
            double d5 = this.tickFont.width(string2);
            double d6 = d4 - d5 / (double)2;
            if (n3 == 0 || d6 > d3 + (double)5) {
                if (n3 == 0) {
                    d6 = 0.0;
                }
                if (!(d6 + d5 >= d) || !((d6 = d - d5) <= d3 + (double)5)) {
                    graphics.strokeLine(d4, d2 - (double)5, d4, d2);
                    graphics.drawString(string2, d6, d2 - 7.0);
                    d3 = d6 + d5;
                }
            }
            ++n3;
        }
        String string3 = bAxis.getTitle();
        if (string3 != null && string3.length() != 0) {
            graphics.setFont(this.titleFont);
            graphics.drawString(string3, (bAxis.getLength() - this.titleFont.width(string3)) / (double)2, d2 - 7.0 - this.tickFont.getHeight() - (double)4);
        }
        if ((string = bAxis.getUnitLabel()) != null && string.length() != 0) {
            graphics.setFont(this.unitFont);
            graphics.drawString(string, bAxis.getLength() - this.unitFont.width(string) - (double)4, this.unitFont.getHeight() + (double)4);
        }
    }

    public void paintBottom(Graphics graphics, BAxis bAxis) {
        String string;
        double d = bAxis.getWidth();
        Object[] objectArray = bAxis.getTickValues();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        int n2 = n;
        graphics.setBrush(BColor.black);
        graphics.setFont(this.tickFont);
        double d2 = bAxis.getMinMargin();
        int n3 = 0;
        while (n3 < n2) {
            double d3 = bAxis.toDisplaySpace(objectArray[n3]);
            String string2 = bAxis.valueToString(objectArray[n3]);
            double d4 = this.tickFont.width(string2);
            double d5 = d3 - d4 / (double)2;
            if (n3 == 0 || d5 > d2 + (double)5) {
                if (n3 == 0) {
                    d5 = 0.0;
                }
                if (!(d5 + d4 >= d) || !((d5 = d - d4) <= d2 + (double)5)) {
                    graphics.strokeLine(d3, 0.0, d3, (double)5);
                    graphics.drawString(string2, d5, (double)5 + this.tickFont.getHeight());
                    d2 = d5 + d4;
                }
            }
            ++n3;
        }
        String string3 = bAxis.getTitle();
        if (string3 != null && string3.length() != 0) {
            graphics.setFont(this.titleFont);
            graphics.drawString(string3, (bAxis.getLength() - this.titleFont.width(string3)) / (double)2, (double)5 + this.tickFont.getHeight() + (double)4 + this.titleFont.getHeight());
        }
        if ((string = bAxis.getUnitLabel()) != null && string.length() != 0) {
            graphics.setFont(this.unitFont);
            graphics.drawString(string, bAxis.getLength() - this.unitFont.width(string) - (double)4, (double)5 + this.tickFont.getHeight() + (double)4 + this.unitFont.getHeight());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintLeft(Graphics graphics, BAxis bAxis) {
        double d = bAxis.getWidth();
        double d2 = bAxis.getHeight();
        Object[] objectArray = bAxis.getTickValues();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        int n2 = n;
        graphics.setBrush(BColor.black);
        graphics.setFont(this.tickFont);
        double d3 = 0.0;
        double d4 = d2;
        int n3 = 0;
        while (n3 < n2) {
            double d5 = bAxis.toDisplaySpace(objectArray[n3]);
            String string = bAxis.valueToString(objectArray[n3]);
            double d6 = this.tickFont.width(string);
            double d7 = d5 + this.tickFont.getAscent() / (double)2 - 1.0;
            if (!(d5 < 0.0) && !(d5 > d2)) {
                d3 = Math.max(d6, d3);
                if (n3 == 0 || n3 == n2 - 1 || d4 == d2 || d7 < d4 - (double)5) {
                    graphics.strokeLine(d - (double)5, d5, d, d5);
                    graphics.drawString(string, d - 7.0 - d6, d7);
                    d4 = d7 - this.tickFont.getAscent();
                } else {
                    graphics.strokeLine(d - (double)2, d5, d, d5);
                }
            }
            ++n3;
        }
        String string = this.getAxisLabel(bAxis);
        if (string.length() == 0) {
            string = SPACER;
        }
        if (!GxEnv.get().isRotationSupported()) return;
        graphics.push();
        try {
            graphics.setFont(this.titleFont);
            double d8 = this.titleFont.width(string);
            double d9 = d2 / (double)2 - d3;
            double d10 = 3;
            graphics.drawString(string, d10, d9);
            if (bAxis.getShowSwatches()) {
                Series[] seriesArray = bAxis.getSeries();
                double d11 = Math.max(0.0, d10 + d8 / (double)2 - 6.0);
                int n4 = 0;
                while (n4 < seriesArray.length) {
                    double d12 = d9 + (double)5;
                    if (n4 > 0) {
                        d12 += (double)n4 * 12.0 + (double)(n4 * 3);
                    }
                    graphics.setBrush(seriesArray[n4].getBrush());
                    graphics.fillRect(d11, d12, 12.0, 12.0);
                    ++n4;
                }
            }
            Object var15_24 = null;
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            graphics.pop();
            throw throwable;
        }
        graphics.pop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintRight(Graphics graphics, BAxis bAxis) {
        double d = bAxis.getWidth();
        double d2 = bAxis.getHeight();
        Object[] objectArray = bAxis.getTickValues();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        int n2 = n;
        graphics.setBrush(BColor.black);
        graphics.setFont(this.tickFont);
        double d3 = 0.0;
        double d4 = d2;
        int n3 = 0;
        while (n3 < n2) {
            double d5 = bAxis.toDisplaySpace(objectArray[n3]);
            String string = bAxis.valueToString(objectArray[n3]);
            double d6 = this.tickFont.width(string);
            d3 = Math.max(d6, d3);
            double d7 = d5 + this.tickFont.getAscent() / (double)2 - 1.0;
            if (!(d5 < 0.0) && !(d5 > d2)) {
                if (n3 == 0 || n3 == n2 - 1 || d4 == d2 || d7 < d4 - (double)5) {
                    graphics.strokeLine(0.0, d5, (double)5, d5);
                    graphics.drawString(string, 8.0, d7);
                    d4 = d7 - this.tickFont.getAscent();
                } else {
                    graphics.strokeLine(0.0, d5, (double)2, d5);
                }
            }
            ++n3;
        }
        String string = this.getAxisLabel(bAxis);
        if (string.length() == 0) {
            string = SPACER;
        }
        if (!GxEnv.get().isRotationSupported()) return;
        graphics.push();
        try {
            graphics.setFont(this.titleFont);
            double d8 = this.titleFont.width(string);
            double d9 = d - d8 - 7.0;
            double d10 = d2 / (double)2 - d3;
            graphics.drawString(string, d9, d10);
            if (bAxis.getShowSwatches()) {
                Series[] seriesArray = bAxis.getSeries();
                double d11 = Math.max(0.0, d9 + d8 / (double)2 - 6.0);
                int n4 = 0;
                while (n4 < seriesArray.length) {
                    double d12 = d10 + (double)5;
                    if (n4 > 0) {
                        d12 += (double)n4 * 12.0 + (double)(n4 * 3);
                    }
                    graphics.setBrush(seriesArray[n4].getBrush());
                    graphics.fillRect(d11, d12, 12.0, 12.0);
                    ++n4;
                }
            }
            Object var15_24 = null;
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            graphics.pop();
            throw throwable;
        }
        graphics.pop();
    }

    private final String getAxisLabel(BAxis bAxis) {
        String string = bAxis.getTitle();
        String string2 = bAxis.getUnitLabel();
        String string3 = "";
        if (string != null && string.length() > 0) {
            string3 = string3 + string;
        }
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + " (" + string2 + ')';
        }
        return string3.trim();
    }

    private final /* synthetic */ void this() {
        this.unitFont = this.tickFont = BFont.make((String)lex.getText("chart.axis.tick.font"));
        this.titleFont = BFont.make((String)lex.getText("chart.axis.title.font"));
    }

    public DefaultAxisRenderer() {
        this.this();
    }
}

