/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.ui.UiEnv;
import com.tridium.workbench.file.BExportDialog;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChartCanvas;
import javax.baja.chart.BChartPane;
import javax.baja.collection.BITable;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChartController {
    private static final int ZOOM_NONE = 0;
    private static final int ZOOM_HORIZONTAL = 1;
    private static final int ZOOM_VERTICAL = 2;
    private static final double ZOOM_TOLERANCE = 3.0;
    private static final BModule module;
    private boolean traceOn;
    private double mx;
    private double my;
    private BChartPane pane;
    private int zoomMode;
    private double zoomX;
    private double zoomY;
    static /* synthetic */ Class class$javax$baja$chart$ChartController;

    void setPane(BChartPane bChartPane) {
        this.pane = bChartPane;
    }

    public BChartPane getPane() {
        return this.pane;
    }

    public BChartCanvas getCanvas() {
        return this.pane.getCanvas();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getWidget() == this.getCanvas() && this.pane.getZoomEnabled()) {
            if (!UiEnv.get().hasMouse()) {
                this.pane.fireShowPanRequested(null);
            }
            this.zoomX = bMouseEvent.getX();
            this.zoomY = bMouseEvent.getY();
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getWidget() == this.getCanvas()) {
            if (bMouseEvent.isPopupTrigger()) {
                BMenu bMenu = new BMenu();
                bMenu.add(null, (Command)new ExportDataCommand(this.pane));
                ExportViewCommand exportViewCommand = new ExportViewCommand(this.pane);
                if (exportViewCommand.isEnabled()) {
                    bMenu.add(null, (Command)exportViewCommand);
                }
                bMenu.open((BWidget)this.getCanvas(), bMouseEvent.getX(), bMouseEvent.getY());
                return;
            }
            if (this.zoomMode != 0 && this.pane.getZoomEnabled()) {
                double d = Math.min(Math.max(bMouseEvent.getX(), 0.0), this.getCanvas().getWidth());
                double d2 = Math.min(Math.max(bMouseEvent.getY(), 0.0), this.getCanvas().getHeight());
                if (this.zoomMode == 1) {
                    if (Math.abs(this.zoomX - d) > (double)3) {
                        if (this.zoomX < d) {
                            this.getPane().zoomIn(BAxisDimension.x, this.zoomX, d);
                        } else {
                            this.getPane().zoomIn(BAxisDimension.x, d, this.zoomX);
                        }
                    }
                } else if (this.zoomMode == 2 && Math.abs(this.zoomY - d2) > (double)3) {
                    if (this.zoomY < d2) {
                        this.getPane().zoomIn(BAxisDimension.y, d2, this.zoomY);
                    } else {
                        this.getPane().zoomIn(BAxisDimension.y, this.zoomY, d2);
                    }
                }
            }
            this.zoomMode = 0;
            this.getCanvas().clearSelection();
            this.getCanvas().repaint();
            this.getPane().repaint();
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.mouseMoved(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.mx = -1.0;
        this.my = -1.0;
        if (this.traceOn) {
            this.pane.repaint();
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.mx = -1.0;
        this.my = -1.0;
        if (this.traceOn) {
            this.pane.repaint();
        }
        this.getCanvas().resetHover();
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        this.mx = bMouseEvent.getX();
        this.my = bMouseEvent.getY();
        if (this.traceOn) {
            this.pane.repaint();
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getWidget() == this.getCanvas() && bMouseEvent.isButton1Down() && this.pane.getZoomEnabled()) {
            double d = bMouseEvent.getX();
            double d2 = bMouseEvent.getY();
            if (this.zoomMode == 0) {
                this.zoomMode = this.getZoomMode(this.zoomX, this.zoomY, d, d2);
            }
            if (this.zoomMode == 1) {
                this.getCanvas().selectHorizontal(this.zoomX, d);
            } else if (this.zoomMode == 2) {
                this.getCanvas().selectVertical(this.zoomY, d2);
            }
        }
    }

    public void mouseWheel(BMouseEvent bMouseEvent) {
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        switch (bKeyEvent.getKeyCode()) {
            case 38: {
                this.pane.panUp();
                break;
            }
            case 37: {
                this.pane.panLeft();
                break;
            }
            case 39: {
                this.pane.panRight();
                break;
            }
            case 40: {
                this.pane.panDown();
                break;
            }
        }
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
    }

    private final int getZoomMode(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = Math.abs(d3 - d);
        if (d6 > (d5 = Math.abs(d4 - d2)) && d6 > (double)3) {
            return 1;
        }
        if (d5 > d6 && d5 > (double)3) {
            return 2;
        }
        return 0;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public double getTraceX() {
        return this.mx;
    }

    public double getTraceY() {
        return this.my;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.traceOn = true;
        this.mx = -1.0;
        this.my = -1.0;
        this.zoomMode = 0;
    }

    public ChartController() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$chart$ChartController;
        if (clazz == null) {
            clazz = class$javax$baja$chart$ChartController = ChartController.class("[Ljavax.baja.chart.ChartController;", false);
        }
        module = Sys.getModuleForClass((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ExportDataCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BITable bITable = ChartController.this.pane.export();
            if (bITable == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)Lexicon.make((String)"chart").getText("chart.nothingToExport"));
                return null;
            }
            return BExportDialog.invoke((BWidget)ChartController.this.pane, (BITable)ChartController.this.pane.export(), (boolean)true);
        }

        ExportDataCommand(BChartPane bChartPane) {
            super((BWidget)bChartPane, module, "commands.export.data");
            this.accelerator = null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ExportViewCommand
    extends Command {
        public synchronized boolean isEnabled() {
            boolean bl = super.isEnabled();
            if (!bl) {
                return bl;
            }
            try {
                BWbView bWbView = this.getParentView((BWidget)ChartController.this.pane);
                if (bWbView != null) {
                    bl = BExportDialog.hasExporters((BWbShell)bWbView.getWbShell(), (boolean)true);
                }
            }
            catch (Exception exception) {}
            return bl;
        }

        public CommandArtifact doInvoke() throws Exception {
            BITable bITable = ChartController.this.pane.export();
            if (bITable == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)Lexicon.make((String)"chart").getText("chart.nothingToExport"));
                return null;
            }
            BWbView bWbView = this.getParentView((BWidget)ChartController.this.pane);
            if (bWbView != null) {
                return BExportDialog.invoke((BWbShell)bWbView.getWbShell(), (boolean)true);
            }
            return null;
        }

        private final BWbView getParentView(BWidget bWidget) {
            if (bWidget == null) {
                return null;
            }
            if (bWidget instanceof BWbView) {
                return (BWbView)bWidget;
            }
            return this.getParentView(bWidget.getParentWidget());
        }

        ExportViewCommand(BChartPane bChartPane) {
            super((BWidget)bChartPane, module, "commands.export.view");
            this.accelerator = null;
        }
    }
}

