/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BChartLegend;
import javax.baja.chart.BChartPane;
import javax.baja.chart.DefaultSwatchRenderer;
import javax.baja.chart.Series;
import javax.baja.chart.SwatchRenderer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDefaultChartLegend
extends BChartLegend {
    public static final Type TYPE;
    private static Lexicon lex;
    private static BFont defFont;
    private static final double MARGIN = 4.0;
    private static final double SPACING = 8.0;
    private SwatchRenderer swatchRenderer;
    private LegendRow rows;
    private RectGeom bounds;
    static /* synthetic */ Class class$javax$baja$chart$BDefaultChartLegend;

    public Type getType() {
        return TYPE;
    }

    public double getPreferredHeight(double d) {
        if (!this.isEnabled() || !this.isVisible()) {
            return 0.0;
        }
        BChartPane bChartPane = this.getPane();
        if (bChartPane == null) {
            return 0.0;
        }
        double d2 = 8.0;
        double d3 = 4;
        int n = 1;
        LegendItem legendItem = this.getItems();
        if (legendItem == null) {
            return 0.0;
        }
        double d4 = legendItem.height;
        int n2 = 0;
        int n3 = 0;
        while (legendItem != null) {
            ++n2;
            if (d2 + legendItem.width > d && n3 > 0) {
                ++n;
                n3 = 0;
                d2 = 8.0;
                d3 += legendItem.height + (double)4;
            }
            d2 += legendItem.width + 8.0;
            ++n3;
            legendItem = legendItem.next;
        }
        if (n2 <= 1) {
            return 0.0;
        }
        return d4 * (double)n + (double)4 * (double)(n + 1);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        Object object;
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        BChartPane bChartPane = this.getPane();
        if (bChartPane == null) {
            return;
        }
        LegendItem legendItem = this.getItems();
        if (legendItem == null) {
            return;
        }
        double d2 = this.getWidth();
        LegendRow legendRow = this.rows = new LegendRow();
        while (legendItem != null) {
            object = legendItem;
            legendItem = legendItem.next;
            d = legendRow.addToEnd((LegendItem)object);
            if (!(d > d2) || legendRow.count <= 1) continue;
            legendRow.removeFromEnd();
            legendRow = legendRow.next = new LegendRow();
            legendRow.addToEnd((LegendItem)object);
        }
        object = this.rows;
        d = 4;
        double d3 = 4;
        double d4 = ((LegendRow)object).first.height;
        double d5 = 0.0;
        while (object != null) {
            d5 = Math.max(d5, ((LegendRow)object).width);
            d = (d2 - ((LegendRow)object).width) / (double)2;
            LegendItem legendItem2 = ((LegendRow)object).first;
            while (legendItem2 != null) {
                legendItem2.setLocation(d, d3);
                d += legendItem2.width + 8.0;
                legendItem2 = legendItem2.next;
            }
            d3 += d4 + (double)4;
            object = ((LegendRow)object).next;
        }
        this.bounds = new RectGeom(Math.max(0.0, (d2 - d5) / (double)2 - (double)4), 0.0, Math.min(d2 - 1.0, d5 + 8.0 - 1.0), this.getHeight() - 1.0);
    }

    private final LegendItem getItems() {
        LegendItem legendItem = null;
        LegendItem legendItem2 = null;
        Series[] seriesArray = this.getPane().getAllSeries();
        int n = 0;
        while (n < seriesArray.length) {
            LegendItem legendItem3 = new LegendItem(seriesArray[n], this.swatchRenderer);
            legendItem3.computeSize();
            if (legendItem == null) {
                legendItem = legendItem2 = legendItem3;
            } else {
                legendItem2.next = legendItem3;
                legendItem2 = legendItem3;
            }
            ++n;
        }
        return legendItem;
    }

    public void paint(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        BChartPane bChartPane = this.getPane();
        LegendItem legendItem = this.getItems();
        if (bChartPane == null || legendItem == null) {
            return;
        }
        graphics.setBrush(this.getBackground());
        graphics.fill((IGeom)this.bounds);
        LegendRow legendRow = this.rows;
        while (legendRow != null) {
            LegendItem legendItem2 = legendRow.first;
            while (legendItem2 != null) {
                graphics.push();
                graphics.translate(legendItem2.x, legendItem2.y);
                legendItem2.paint(graphics);
                graphics.pop();
                legendItem2 = legendItem2.next;
            }
            legendRow = legendRow.next;
        }
        graphics.setBrush(BColor.black.toBrush());
        graphics.stroke((IGeom)this.bounds);
    }

    public void setSwatchRenderer(SwatchRenderer swatchRenderer) {
        if (swatchRenderer == null) {
            throw new NullPointerException("Swatch renderer cannot be null.");
        }
        this.swatchRenderer = swatchRenderer;
    }

    static /* synthetic */ double access$0() {
        return 4;
    }

    static /* synthetic */ double access$1() {
        return 8.0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.swatchRenderer = new DefaultSwatchRenderer();
    }

    public BDefaultChartLegend() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$chart$BDefaultChartLegend;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BDefaultChartLegend = BDefaultChartLegend.class("[Ljavax.baja.chart.BDefaultChartLegend;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"chart");
        defFont = BFont.make((String)lex.getText("chart.legend.font"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LegendItem {
        Series series;
        SwatchRenderer swatch;
        double width;
        double height;
        double x;
        double y;
        LegendItem next;

        public void computeSize() {
            BFont bFont = BDefaultChartLegend.this.getFont();
            if (bFont.isNull()) {
                bFont = defFont;
            }
            this.width = this.swatch.getWidth() + (double)4 + bFont.width(this.series.getName());
            this.height = Math.max(this.swatch.getHeight(), bFont.getHeight());
        }

        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public void paint(Graphics graphics) {
            BFont bFont = BDefaultChartLegend.this.getFont();
            if (bFont.isNull()) {
                bFont = defFont;
            }
            this.swatch.paintSwatch(this.series, graphics, 0.0, (this.height - this.swatch.getHeight()) / (double)2);
            BBrush bBrush = BDefaultChartLegend.this.getFill();
            if (bBrush.isNull()) {
                bBrush = BColor.black.toBrush();
            }
            graphics.setBrush(bBrush);
            graphics.setFont(bFont);
            graphics.drawString(this.series.getName(), this.swatch.getWidth() + (double)4, this.height - (this.height - bFont.getAscent()) / (double)2);
        }

        public String toString() {
            return this.series.getName();
        }

        private final /* synthetic */ void this() {
            this.next = null;
        }

        public LegendItem(Series series, SwatchRenderer swatchRenderer) {
            this.this();
            this.series = series;
            this.swatch = swatchRenderer;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LegendRow {
        LegendItem first;
        LegendItem last;
        int count;
        double width;
        LegendRow next;

        public double addToFront(LegendItem legendItem) {
            legendItem.next = null;
            if (this.first == null) {
                this.first = this.last = legendItem;
            } else {
                legendItem.next = this.first;
                this.first = legendItem;
            }
            ++this.count;
            this.updateWidth();
            return this.width;
        }

        public double addToEnd(LegendItem legendItem) {
            legendItem.next = null;
            if (this.last == null) {
                this.first = this.last = legendItem;
            } else {
                this.last.next = legendItem;
                this.last = legendItem;
            }
            ++this.count;
            this.updateWidth();
            return this.width;
        }

        public LegendItem removeFromFront() {
            if (this.count == 0) {
                return null;
            }
            LegendItem legendItem = null;
            if (this.first == this.last) {
                legendItem = this.first;
                this.last = null;
                this.first = null;
            } else {
                legendItem = this.first;
                this.first = this.first.next;
                legendItem.next = null;
            }
            --this.count;
            this.updateWidth();
            return legendItem;
        }

        public LegendItem removeFromEnd() {
            if (this.count == 0) {
                return null;
            }
            LegendItem legendItem = null;
            if (this.first == this.last) {
                legendItem = this.first;
                this.last = null;
                this.first = null;
            } else {
                LegendItem legendItem2 = this.first;
                while (legendItem2.next != this.last) {
                    legendItem2 = legendItem2.next;
                }
                legendItem = this.last;
                this.last = legendItem2;
                this.last.next = null;
            }
            --this.count;
            this.updateWidth();
            return legendItem;
        }

        private final void updateWidth() {
            this.width = 8.0 + (double)(this.count - 1) * 8.0;
            LegendItem legendItem = this.first;
            while (legendItem != null) {
                this.width += legendItem.width;
                legendItem = legendItem.next;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            LegendItem legendItem = this.first;
            while (legendItem != null) {
                if (legendItem != this.first) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(legendItem.toString());
                legendItem = legendItem.next;
            }
            return stringBuffer.toString();
        }

        private final /* synthetic */ void this() {
            this.count = 0;
            this.next = null;
        }

        private LegendRow() {
            this.this();
        }
    }
}

