/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.chart.ChartUtil;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.BContinuousAxis;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBarChart
extends BChart {
    public static final Property pen = BBarChart.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    public static final Property stroke = BBarChart.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Type TYPE;
    private JoinTable joinTable;
    private double overlap;
    private double clusterWidth;
    private double barWidth;
    private double overlapWidth;
    static /* synthetic */ Class class$javax$baja$chart$BBarChart;

    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    public void setPen(BPen bPen) {
        this.set(pen, (BValue)bPen, null);
    }

    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    public void setStroke(BBrush bBrush) {
        this.set(stroke, (BValue)bBrush, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        ChartModel chartModel;
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.joinTable == null || this.joinTable.getColumnCount() == 0) {
            this.joinTable = JoinTable.make(this.getModel().getAllSeries(), 0);
        }
        if ((chartModel = this.getModel()).getSpecCount() == 0) {
            return;
        }
        BAxis bAxis = chartModel.getSpec(0).getXAxis();
        this.clusterWidth = Double.MAX_VALUE;
        bAxis.setMinMargin(5);
        bAxis.setMaxMargin(5);
        if (bAxis instanceof BDiscreteAxis) {
            Object[] objectArray = bAxis.getTickValues();
            if (objectArray.length == 1) {
                double d3 = bAxis.toDisplaySpace(objectArray[0]);
                this.clusterWidth = d3 * (double)2 * (double)5 / 6.0;
            } else {
                double d4 = bAxis.toDisplaySpace(objectArray[1]) - bAxis.toDisplaySpace(objectArray[0]);
                this.clusterWidth = d4 * (double)2 / (double)3;
            }
        } else {
            int n = 0;
            while (n < this.joinTable.getColumnCount()) {
                double d5 = Double.MAX_VALUE;
                double d6 = Double.NEGATIVE_INFINITY;
                int n2 = 0;
                while (n2 < this.joinTable.getRowCount()) {
                    if (this.joinTable.getValue(n2, n) != null) {
                        double d7 = bAxis.toDisplaySpace(this.joinTable.getKey(n2));
                        if (d7 - d6 < d5) {
                            d5 = d7 - d6;
                        }
                        d6 = d7;
                    }
                    ++n2;
                }
                if (d5 < this.clusterWidth) {
                    this.clusterWidth = d5;
                }
                ++n;
            }
            this.clusterWidth = this.clusterWidth * (double)2 / (double)3;
        }
        int n = this.joinTable.getColumnCount();
        this.overlapWidth = this.overlap * (this.clusterWidth / (double)n);
        this.barWidth = (this.clusterWidth + this.overlapWidth * (double)(n - 1)) / (double)n;
        bAxis.setMinMargin(this.clusterWidth * (double)2 / (double)3);
        bAxis.setMaxMargin(this.clusterWidth * (double)2 / (double)3);
    }

    public void doPaint(Graphics graphics) {
        ChartModel chartModel = this.getModel();
        int n = chartModel.getSpecCount();
        if (n == 0) {
            return;
        }
        BAxis bAxis = chartModel.getSpec(0).getXAxis();
        BContinuousAxis bContinuousAxis = (BContinuousAxis)chartModel.getSpec(0).getYAxis();
        int n2 = this.joinTable.getRowCount();
        int n3 = this.joinTable.getColumnCount();
        double d = bContinuousAxis.toDisplaySpace(bContinuousAxis.getZero());
        int n4 = 0;
        while (n4 < n2) {
            Object object = this.joinTable.getKey(n4);
            double d2 = bAxis.toDisplaySpace(object);
            double d3 = d2 - this.clusterWidth / (double)2;
            int n5 = 0;
            while (n5 < n3) {
                Object object2 = this.joinTable.getValue(n4, n5);
                if (object2 != null) {
                    double d4 = bContinuousAxis.toDisplaySpace(object2);
                    Series series = this.joinTable.getSeries(n5);
                    BPen bPen = series.getPen();
                    graphics.setPen(bPen == null ? BPen.DEFAULT : bPen);
                    if (d4 <= d) {
                        graphics.setBrush(ChartUtil.makeGradient(series.getBrush()));
                        graphics.fillRect(d3, d4, this.barWidth, d - d4);
                        graphics.setBrush(this.getStroke());
                        graphics.strokeRect(d3, d4, this.barWidth, d - d4);
                    } else {
                        graphics.setBrush(ChartUtil.makeGradient(series.getBrush()));
                        graphics.fillRect(d3, d, this.barWidth, d4);
                        graphics.setBrush(this.getStroke());
                        graphics.strokeRect(d3, d, this.barWidth, d4);
                    }
                }
                d3 = d3 + this.barWidth - this.overlapWidth;
                ++n5;
            }
            ++n4;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overlap = 0.2;
    }

    public BBarChart() {
        this.this();
    }

    public BBarChart(ChartModel chartModel) {
        super(chartModel);
        this.this();
    }

    static {
        Class clazz = class$javax$baja$chart$BBarChart;
        if (clazz == null) {
            clazz = class$javax$baja$chart$BBarChart = BBarChart.class("[Ljavax.baja.chart.BBarChart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

