/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart.wb;

import com.tridium.chart.wb.BFlexPane;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.ui.theme.Theme;
import java.text.DecimalFormat;
import javax.baja.chart.AxisRenderer;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChartPane;
import javax.baja.chart.BLineChart;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.BPieChart;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BResourceManager
extends BWbView {
    public static final Type TYPE;
    static final BFont bold;
    static final Lexicon lex;
    static final String lexChartTitle;
    static final String lexSysTitle;
    static final String lexPieTitle;
    static final String lexPropTitle;
    static final String lexPropKey;
    static final String lexPropValue;
    static final String lexUpdate;
    BFoxSession session;
    BSysChannel channel;
    PollThread pollThread;
    Command update;
    String version;
    BChartPane sysChart;
    BChartPane pieChart;
    boolean sysBuilt;
    boolean pieBuilt;
    CpuSeries cpuSeries;
    MemSeries memSeries;
    BPieChart pie;
    BTable table;
    String[] propKeys;
    String[] propValues;
    static /* synthetic */ Class class$com$tridium$chart$wb$BResourceManager;

    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopPoll();
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.session = (BFoxSession)bObject;
        this.channel = this.session.getConnection().getChannels().getSysChannel();
        this.poll();
        this.startPoll();
    }

    public void remoteUpdate() throws Exception {
        this.channel.stationCall("resource.update", null);
    }

    void poll() throws Exception {
        byte[] byArray = this.channel.stationCall("resource.report", null);
        ResourceReport resourceReport = ResourceReport.decode((byte[])byArray);
        this.updateSysChart(resourceReport);
        this.updatePieChart(resourceReport);
        this.updatePropertyTable(resourceReport);
    }

    void updatePropertyTable(ResourceReport resourceReport) {
        Object[] objectArray = resourceReport.props();
        String[] stringArray = new String[objectArray.length];
        SortUtil.sort((Object[])objectArray, (Object[])objectArray);
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = resourceReport.prop((String)objectArray[n]);
            ++n;
        }
        this.propKeys = objectArray;
        this.propValues = stringArray;
        this.table.getModel().updateTable();
    }

    void updateSysChart(ResourceReport resourceReport) {
        if (!this.sysBuilt) {
            BLineChart bLineChart = new BLineChart();
            SimpleChartModel simpleChartModel = new SimpleChartModel();
            this.cpuSeries = new CpuSeries(resourceReport.cpu());
            BNumericAxis bNumericAxis = new BNumericAxis(this.cpuSeries.getMin(0), this.cpuSeries.getMax(0));
            bNumericAxis.setRenderer(new NullAxisRenderer());
            BNumericAxis bNumericAxis2 = new BNumericAxis(this.cpuSeries.getMin(1), this.cpuSeries.getMax(1));
            bNumericAxis2.setDecimalFormat(new DecimalFormat("##0"));
            bNumericAxis2.setTitle(lex.getText("ResourceManager.cpuPercent"));
            simpleChartModel.add(new ChartSpec(this.cpuSeries, bNumericAxis, bNumericAxis2));
            this.memSeries = new MemSeries(resourceReport.mem());
            bNumericAxis2 = new BNumericAxis(this.memSeries.getMin(1), this.memSeries.getMax(1));
            bNumericAxis2.setDecimalFormat(new DecimalFormat("##0"));
            bNumericAxis2.setTitle(lex.getText("ResourceManager.memoryUsage"));
            simpleChartModel.add(new ChartSpec(this.memSeries, bNumericAxis, bNumericAxis2));
            bLineChart.setModel(simpleChartModel);
            this.sysChart.add("cpu", (BValue)bLineChart);
            this.sysBuilt = true;
        }
        this.cpuSeries.setData(resourceReport.cpu());
        this.memSeries.setData(resourceReport.mem());
    }

    void updatePieChart(ResourceReport resourceReport) {
        if (!this.pieBuilt) {
            this.pie = new BPieChart();
            this.pieChart.add("pie", (BValue)this.pie);
            this.pieBuilt = true;
        }
        int n = -1;
        int n2 = resourceReport.ruLimit();
        if (n2 > 0 && n2 >= resourceReport.ruTotal()) {
            n = n2 - resourceReport.ruTotal();
        }
        int n3 = 0;
        if (n > 0) {
            n3 = 1;
        }
        int n4 = n3 + 1;
        String[] stringArray = resourceReport.ruCategories();
        String[] stringArray2 = new String[stringArray.length + n4];
        double[] dArray = new double[stringArray.length + n4];
        int n5 = 0;
        if (n > 0) {
            stringArray2[n5] = "free";
            dArray[n5] = n;
            ++n5;
        }
        stringArray2[n5] = "components";
        dArray[n5] = resourceReport.ruDefault();
        ++n5;
        int n6 = 0;
        while (n6 < stringArray.length) {
            stringArray2[n5] = stringArray[n6];
            dArray[n5] = resourceReport.ru(stringArray[n6]);
            ++n5;
            ++n6;
        }
        this.pie.setModel(stringArray2, dArray);
    }

    void startPoll() {
        this.stopPoll();
        this.pollThread = new PollThread();
        this.pollThread.start();
    }

    void stopPoll() {
        if (this.pollThread != null) {
            this.pollThread.kill();
        }
        this.pollThread = null;
    }

    public BChartPane getSysChart() {
        return this.sysChart;
    }

    public BChartPane getPieChart() {
        return this.pieChart;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.update = new ReflectCommand((BWidget)this, lexUpdate, "remoteUpdate");
        this.version = "";
        this.propKeys = new String[0];
        this.propValues = new String[0];
    }

    public BResourceManager() {
        this.this();
        this.sysChart = new BChartPane();
        this.sysChart.setBorder(BBorder.none);
        this.sysChart.getHeader().setTitle(lexSysTitle);
        this.sysChart.setZoomEnabled(false);
        this.sysChart.getCanvas().setShowHorizontalGridLines(true);
        this.sysChart.getCanvas().setShowVerticalGridLines(true);
        this.pieChart = new BChartPane();
        this.pieChart.setBorder(BBorder.none);
        this.pieChart.getHeader().setTitle(lexPieTitle);
        this.pieChart.setZoomEnabled(false);
        BFlexPane bFlexPane = new BFlexPane((BWidget)this.sysChart, (BWidget)this.pieChart, 70);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bFlexPane, BBorder.solid);
        bBorderPane.setFill(BBrush.make((String)"#eee"));
        BTitlePane bTitlePane = new BTitlePane(lexChartTitle, (BWidget)bBorderPane);
        this.table = new BTable((TableModel)new PropertyModel());
        BTitlePane bTitlePane2 = BTitlePane.makePane((String)lexPropTitle, (BTable)this.table);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton(this.update));
        BSplitPane bSplitPane = new BSplitPane(BOrientation.vertical, 50.0);
        bSplitPane.setWidget1((BWidget)bTitlePane);
        bSplitPane.setWidget2((BWidget)bTitlePane2);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)bSplitPane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setContent((BWidget)bEdgePane);
    }

    static {
        Class clazz = class$com$tridium$chart$wb$BResourceManager;
        if (clazz == null) {
            clazz = class$com$tridium$chart$wb$BResourceManager = BResourceManager.class("[Lcom.tridium.chart.wb.BResourceManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        bold = Theme.widget().getBoldText();
        lex = Lexicon.make((BModule)TYPE.getModule(), null);
        lexChartTitle = lex.getText("resourceManager.chartTitle");
        lexSysTitle = lex.getText("resourceManager.sysTitle");
        lexPieTitle = lex.getText("resourceManager.pieTitle");
        lexPropTitle = lex.getText("resourceManager.propTitle");
        lexPropKey = lex.getText("resourceManager.propKey");
        lexPropValue = lex.getText("resourceManager.propValue");
        lexUpdate = lex.getText("resourceManager.update");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CpuSeries
    extends Series {
        int[] data;
        String seriesName;
        String colName0;
        String colName1;

        public void setData(int[] nArray) {
            this.data = nArray;
            this.modified();
        }

        public String getName() {
            return this.seriesName;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return this.colName0;
            }
            if (n == 1) {
                return this.colName1;
            }
            return "Error-" + n;
        }

        public String getColumnDisplayName(int n) {
            return this.getColumnName(n);
        }

        public Type getColumnType(int n) {
            if (n == 0) {
                return BDouble.TYPE;
            }
            if (n == 1) {
                return BDouble.TYPE;
            }
            throw new IllegalArgumentException();
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValue(int n, int n2) {
            if (n2 == 0) {
                return BDouble.make((double)n);
            }
            return BDouble.make((double)this.data[n]);
        }

        public Object getMin(int n) {
            return BDouble.make((double)0.0);
        }

        public Object getMax(int n) {
            if (n == 0) {
                return BDouble.make((double)(this.getRowCount() - 1));
            }
            if (n == 1) {
                return BDouble.make((double)100.0);
            }
            throw new IllegalArgumentException();
        }

        public CpuSeries(int[] nArray) {
            this.data = nArray;
            this.seriesName = lex.getText("ResourceManager.cpuPercent");
            this.colName0 = lex.getText("ResourceManager.time");
            this.colName1 = lex.getText("ResourceManager.cpu");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NullAxisRenderer
    extends AxisRenderer {
        public void paint(Graphics graphics, BAxis bAxis) {
        }

        public double getPreferredAxisWidth(BAxis bAxis) {
            return 5;
        }

        private NullAxisRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MemSeries
    extends Series {
        double[] data;
        double seriesMax;
        String seriesName;
        String colName0;
        String colName1;

        public void setData(int[] nArray) {
            this.seriesMax = 0.0;
            double d = 0.0;
            this.data = new double[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                this.data[n] = (double)nArray[n] / 1024.0;
                d = Math.max(this.data[n], this.seriesMax);
                ++n;
            }
            this.seriesMax = Math.round(d * 1.2 / (double)5 + 0.5) * (long)5;
            while (d > this.seriesMax) {
                this.seriesMax += 1.0;
            }
            this.modified();
        }

        public String getName() {
            return this.seriesName;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return this.colName0;
            }
            if (n == 1) {
                return this.colName1;
            }
            return "Error-" + n;
        }

        public String getColumnDisplayName(int n) {
            return this.getColumnName(n);
        }

        public Type getColumnType(int n) {
            if (n == 0) {
                return BDouble.TYPE;
            }
            if (n == 1) {
                return BDouble.TYPE;
            }
            throw new IllegalArgumentException();
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValue(int n, int n2) {
            if (n2 == 0) {
                return BDouble.make((double)n);
            }
            return BDouble.make((double)this.data[n]);
        }

        public Object getMin(int n) {
            return BDouble.make((double)0.0);
        }

        public Object getMax(int n) {
            if (n == 0) {
                return BDouble.make((double)(this.getRowCount() - 1));
            }
            if (n == 1) {
                return BDouble.make((double)this.seriesMax);
            }
            throw new IllegalArgumentException();
        }

        public MemSeries(int[] nArray) {
            this.setData(nArray);
            this.seriesName = lex.getText("ResourceManager.memoryUsage");
            this.colName0 = lex.getText("ResourceManager.time");
            this.colName1 = lex.getText("ResourceManager.memory");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PollThread
    extends Thread {
        boolean isAlive;

        public void kill() {
            this.isAlive = false;
            this.interrupt();
        }

        public void run() {
            while (this.isAlive) {
                try {
                    Thread.sleep(1000L);
                    if (!this.isAlive || !BResourceManager.this.session.isConnected()) continue;
                    BResourceManager.this.poll();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private final /* synthetic */ void this() {
            this.isAlive = true;
        }

        PollThread() {
            super("ui:ResourceManagerPoll");
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PropertyModel
    extends TableModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? lexPropKey : lexPropValue;
        }

        public int getRowCount() {
            return BResourceManager.this.propKeys.length;
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? BResourceManager.this.propKeys[n] : BResourceManager.this.propValues[n];
        }

        PropertyModel() {
        }
    }
}

