/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import javax.baja.chart.Series;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.chart.binding.BValueChartBinding;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BoundTimeSeries
extends Series {
    private static final int TIMESTAMP_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final String TIMESTAMP_COLUMN_NAME = Lexicon.make((String)"chart").getText("timestamp");
    private BValueChartBinding binding;
    private BAbsTime minTime;
    private BAbsTime maxTime;
    private Object minValue;
    private Object maxValue;
    private int pageSize;
    private Page[] pages;
    static /* synthetic */ Class class$javax$baja$sys$BFacets;

    public String getName() {
        String string = this.binding.getSeriesName();
        if (string.length() != 0) {
            return string;
        }
        BObject bObject = this.binding.get();
        return bObject.toString();
    }

    public Type getColumnType(int n) {
        if (n == 0) {
            return BAbsTime.TYPE;
        }
        if (!this.binding.isBound()) {
            return null;
        }
        BObject bObject = this.binding.get();
        if (bObject instanceof BStatusValue) {
            return ((BStatusValue)bObject).getValueValue().getType();
        }
        return bObject.getType();
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return TIMESTAMP_COLUMN_NAME;
        }
        return this.getName();
    }

    public String getColumnDisplayName(int n) {
        return this.getColumnName(n);
    }

    public BFacets getColumnFacets(int n) {
        if (n == 0 || this.binding == null || !this.binding.isBound()) {
            return BFacets.NULL;
        }
        BFacets bFacets = this.binding.getTarget().getFacets();
        BObject bObject = this.binding.get();
        if (bObject instanceof BComplex) {
            SlotCursor slotCursor = ((BComplex)bObject).getProperties();
            Class clazz = class$javax$baja$sys$BFacets;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BFacets = BoundTimeSeries.class("[Ljavax.baja.sys.BFacets;", false);
            }
            if (slotCursor.next(clazz)) {
                bFacets = (BFacets)slotCursor.get();
            }
        }
        return bFacets;
    }

    public int getRowCount() {
        return this.getSampleCount();
    }

    public Object getValue(int n, int n2) {
        Sample sample = this.getSample(n);
        if (n2 == 0) {
            return sample == null ? null : sample.timestamp;
        }
        return sample == null ? null : sample.value;
    }

    public Object getMin(int n) {
        if (n == 0) {
            BAxisBound bAxisBound = this.binding.getXAxis().getMin();
            if (bAxisBound.isAuto()) {
                return this.minTime;
            }
            return bAxisBound.getValue();
        }
        BAxisBound bAxisBound = this.binding.getYAxis().getMin();
        if (bAxisBound.isAuto()) {
            return this.minValue;
        }
        return bAxisBound.getValue();
    }

    public Object getMax(int n) {
        if (n == 0) {
            BAxisBound bAxisBound = this.binding.getXAxis().getMax();
            if (bAxisBound.isAuto()) {
                return this.maxTime;
            }
            return bAxisBound.getValue();
        }
        BAxisBound bAxisBound = this.binding.getYAxis().getMax();
        if (bAxisBound.isAuto()) {
            return this.maxValue;
        }
        return bAxisBound.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sample(BValue bValue) {
        Sample sample;
        block8: {
            BAbsTime bAbsTime = Clock.time();
            BoundTimeSeries boundTimeSeries = this;
            synchronized (boundTimeSeries) {
                block7: {
                    if (this.getSampleCount() != 0) break block7;
                    this.addSample(new Sample(bAbsTime, bValue));
                    this.updateRange((BObject)bValue);
                    break block8;
                }
                sample = this.getLastSample();
                if (sample.isChange((BObject)bValue)) {
                    this.addSample(new Sample(bAbsTime, bValue));
                    this.updateRange((BObject)bValue);
                } else {
                    sample.updateTimestamp(bAbsTime);
                    this.updateRange((BObject)bValue);
                }
            }
        }
        sample = this.getFirstSample().timestamp;
        BAbsTime bAbsTime = this.getLastSample().timestamp;
        BRelTime bRelTime = sample.delta(bAbsTime);
        if (bRelTime.compareTo((Object)this.binding.getTimeWindow()) < 0) {
            this.minTime = sample;
            this.maxTime = this.minTime.add(this.binding.getTimeWindow());
        } else {
            this.maxTime = BAbsTime.now();
            this.minTime = this.maxTime.subtract(this.binding.getTimeWindow());
        }
        this.trim(this.minTime);
        this.modified();
    }

    private final void updateRange(BObject bObject) {
        bObject = bObject instanceof BStatusValue ? ((BStatusValue)bObject).getValueValue().newCopy(true) : (bObject instanceof BIStatusValue ? ((BIStatusValue)bObject).getStatusValue().getValueValue().newCopy(true) : ((BValue)bObject).newCopy(true));
        int n = this.getSampleCount();
        if (n == 1) {
            this.minValue = bObject;
            this.maxValue = bObject;
        } else {
            if (SortUtil.compare((Object)bObject, (Object)this.minValue) < 0) {
                this.minValue = bObject;
            }
            if (SortUtil.compare((Object)bObject, (Object)this.maxValue) > 0) {
                this.maxValue = bObject;
            }
        }
    }

    private final int getSampleCount() {
        int n = this.pages.length;
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return this.pages[0].count();
        }
        int n2 = n - 2;
        return this.pages[0].count() + this.pages[n - 1].count() + n2 * this.pageSize;
    }

    private final Sample getSample(int n) {
        int n2 = n + this.pages[0].first;
        int n3 = n2 / this.pageSize;
        return this.pages[n3].samples[n2 - this.pageSize * n3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addSample(Sample sample) {
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            this.getWritePage().addSample(sample);
            return;
        }
    }

    private final Sample getFirstSample() {
        if (this.pages.length == 0) {
            return null;
        }
        return this.pages[0].first();
    }

    private final Sample getLastSample() {
        int n = this.pages.length;
        if (n == 0) {
            return null;
        }
        return this.pages[n - 1].last();
    }

    private final Page addPage() {
        Page page = new Page(this.pageSize);
        Page[] pageArray = new Page[this.pages.length + 1];
        System.arraycopy(this.pages, 0, pageArray, 0, this.pages.length);
        pageArray[pageArray.length - 1] = page;
        this.pages = pageArray;
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Page getWritePage() {
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            int n = this.pages.length;
            if (n != 0 && !this.pages[n - 1].isFull()) {
                return this.pages[n - 1];
            }
            return this.addPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void trim(BAbsTime bAbsTime) {
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            Page[] pageArray;
            int n = 0;
            int n2 = 0;
            while (n < this.pages.length) {
                pageArray = this.pages[n];
                n2 = pageArray.first;
                while (n2 <= pageArray.last && pageArray.samples[n2].timestamp.isBefore(bAbsTime)) {
                    ++n2;
                }
                if (n2 <= pageArray.last) break;
                ++n;
            }
            if (n == this.pages.length) {
                this.pages = new Page[0];
            } else {
                if (n2 != 0) {
                    this.pages[n].first = n2 - 1;
                } else if (n != 0) {
                    pageArray = this.pages[--n];
                    pageArray.first = pageArray.last = pageArray.samples.length - 1;
                }
                if (n != 0) {
                    pageArray = new Page[this.pages.length - n];
                    System.arraycopy(this.pages, n, pageArray, 0, this.pages.length - n);
                    this.pages = pageArray;
                }
            }
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pages = new Page[0];
    }

    public BoundTimeSeries(BValueChartBinding bValueChartBinding) {
        this.this();
        this.pageSize = 256;
        this.binding = bValueChartBinding;
        this.minTime = BAbsTime.now();
        this.maxTime = this.minTime.add(bValueChartBinding.getTimeWindow());
        this.setBrush(bValueChartBinding.getBrush());
        this.setPen(bValueChartBinding.getPen());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Sample {
        public BAbsTime timestamp;
        public BObject value;
        public BStatus status;

        public boolean isChange(BObject bObject) {
            if (bObject instanceof BStatusValue) {
                boolean bl = false;
                if (!((BStatusValue)bObject).getValueValue().equals((Object)this.value) || !((BStatusValue)bObject).getStatus().equals((Object)this.status)) {
                    bl = true;
                }
                return bl;
            }
            return bObject.equals((Object)this.value) ^ true;
        }

        public void updateTimestamp(BAbsTime bAbsTime) {
            this.timestamp = bAbsTime;
        }

        public String toString() {
            return this.timestamp + ": " + this.value;
        }

        public Sample(BAbsTime bAbsTime, BValue bValue) {
            bValue = bValue.newCopy(true);
            this.timestamp = bAbsTime;
            if (bValue instanceof BStatusValue) {
                this.value = ((BStatusValue)bValue).getValueValue();
                this.status = ((BStatusValue)bValue).getStatus();
            } else {
                this.value = bValue;
                this.status = BStatus.ok;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Page {
        Sample[] samples;
        int first;
        int last;

        public int count() {
            if (this.first == -1) {
                return 0;
            }
            return this.last - this.first + 1;
        }

        public void addSample(Sample sample) {
            if (this.count() == 0) {
                this.samples[0] = sample;
                this.last = 0;
                this.first = 0;
            } else {
                if (this.last == this.samples.length - 1) {
                    throw new IllegalStateException("Page full.");
                }
                ++this.last;
                this.samples[this.last] = sample;
            }
        }

        public boolean isFull() {
            boolean bl = false;
            if (this.last == this.samples.length - 1) {
                bl = true;
            }
            return bl;
        }

        public Sample first() {
            return this.samples[this.first];
        }

        public Sample last() {
            return this.samples[this.last];
        }

        public Page(int n) {
            this.samples = new Sample[n];
            this.last = -1;
            this.first = -1;
        }
    }
}

