/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.offnormal;

import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOutOfRangeAlgorithm
extends BOffnormalAlgorithm {
    public static final Property highLimit = BOutOfRangeAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property lowLimit = BOutOfRangeAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property deadband = BOutOfRangeAlgorithm.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Property highLimitText = BOutOfRangeAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lowLimitText = BOutOfRangeAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property limitEnable = BOutOfRangeAlgorithm.newProperty((int)0, (BValue)new BLimitEnable(), null);
    public static final Type TYPE;
    OutOfRangeState current;
    static /* synthetic */ Class class$javax$baja$alarm$ext$offnormal$BOutOfRangeAlgorithm;

    public double getHighLimit() {
        return this.getDouble(highLimit);
    }

    public void setHighLimit(double d) {
        this.setDouble(highLimit, d, null);
    }

    public double getLowLimit() {
        return this.getDouble(lowLimit);
    }

    public void setLowLimit(double d) {
        this.setDouble(lowLimit, d, null);
    }

    public double getDeadband() {
        return this.getDouble(deadband);
    }

    public void setDeadband(double d) {
        this.setDouble(deadband, d, null);
    }

    public BFormat getHighLimitText() {
        return (BFormat)this.get(highLimitText);
    }

    public void setHighLimitText(BFormat bFormat) {
        this.set(highLimitText, (BValue)bFormat, null);
    }

    public BFormat getLowLimitText() {
        return (BFormat)this.get(lowLimitText);
    }

    public void setLowLimitText(BFormat bFormat) {
        this.set(lowLimitText, (BValue)bFormat, null);
    }

    public BLimitEnable getLimitEnable() {
        return (BLimitEnable)this.get(limitEnable);
    }

    public void setLimitEnable(BLimitEnable bLimitEnable) {
        this.set(limitEnable, (BValue)bLimitEnable, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final boolean isHighLimitEnabled() {
        return this.getLimitEnable().isHighLimitEnabled();
    }

    private final boolean isLowLimitEnabled() {
        return this.getLimitEnable().isLowLimitEnabled();
    }

    public void started() {
        BAlarmState bAlarmState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (bAlarmState == BAlarmState.highLimit) {
            this.current = new HighAlarmState();
        }
        if (bAlarmState == BAlarmState.lowLimit) {
            this.current = new LowAlarmState();
        }
    }

    public boolean isGrandparentLegal(BComponent bComponent) {
        return bComponent instanceof BNumericPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == highLimit || slot == lowLimit) {
            return this.getPointFacets();
        }
        if (slot == deadband) {
            BFacets bFacets = this.getPointFacets();
            BUnit bUnit = (BUnit)bFacets.getFacet("units");
            if (bUnit != null) {
                bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)bUnit.getDifferentialUnit());
            }
            return BFacets.make((BFacets)bFacets, (BFacets)super.getSlotFacets((Slot)deadband));
        }
        return super.getSlotFacets(slot);
    }

    public BAlarmState checkAlarms(BStatusValue bStatusValue, long l, long l2) {
        BStatusNumeric bStatusNumeric = (BStatusNumeric)bStatusValue;
        if (bStatusNumeric.getStatus().isNull()) {
            if (this.current instanceof NormalState) {
                return null;
            }
            if (l2 > 0L && this.current instanceof HighAlarmState) {
                this.current = new ValidateReturnFromHighState(l2);
            } else if (l2 > 0L && this.current instanceof LowAlarmState) {
                this.current = new ValidateReturnFromLowState(l2);
            } else {
                this.current = new NormalState();
                return BAlarmState.normal;
            }
            return null;
        }
        return this.evaluate(bStatusNumeric.getValue(), l, l2);
    }

    private final BAlarmState evaluate(double d, long l, long l2) {
        BAlarmState bAlarmState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (!(this.current instanceof ValidationState)) {
            this.current = bAlarmState == BAlarmState.highLimit ? new HighAlarmState() : (bAlarmState == BAlarmState.lowLimit ? new LowAlarmState() : new NormalState());
        }
        return this.current.evaluate(d, l, l2);
    }

    public void writeAlarmData(BStatusValue bStatusValue, Map map) {
        BFacets bFacets = this.getPointFacets();
        map.put("status", BString.make((String)bStatusValue.getStatus().toString(null)));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)bFacets)));
        if (this.current instanceof HighAlarmState) {
            if (!this.getHighLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getHighLimitText().getFormat()));
            }
            map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)bFacets)));
            if (this.isLowLimitEnabled()) {
                map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)bFacets)));
            }
        } else if (this.current instanceof LowAlarmState) {
            if (!this.getLowLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getLowLimitText().getFormat()));
            }
            if (this.isHighLimitEnabled()) {
                map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)bFacets)));
            }
            map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)bFacets)));
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        this.executePoint();
    }

    void transition(OutOfRangeState outOfRangeState) {
        this.current = outOfRangeState;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.current = new NormalState();
    }

    public BOutOfRangeAlgorithm() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$alarm$ext$offnormal$BOutOfRangeAlgorithm;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$ext$offnormal$BOutOfRangeAlgorithm = BOutOfRangeAlgorithm.class("[Ljavax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HighAlarmState
    extends OutOfRangeState {
        public String tag() {
            return "HighAlarmState";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (d >= BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband()) {
                if (!BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            } else if (d < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (l == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromHighState(l));
            } else if (d < BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband()) {
                if (l2 == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromHighState(l2));
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LowAlarmState
    extends OutOfRangeState {
        public String tag() {
            return "LowAlarmState";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (d <= BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband()) {
                if (!BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            } else if (d > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (l2 == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromLowState(l2));
            } else if (d > BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband()) {
                if (l2 == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromLowState(l2));
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NormalState
    extends OutOfRangeState {
        public String tag() {
            return "Normal";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (d < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (l == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.lowLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateLowAlarmState(l));
            } else if ((!(d >= BOutOfRangeAlgorithm.this.getLowLimit()) || !(d <= BOutOfRangeAlgorithm.this.getHighLimit())) && d > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (l == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.highLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateHighAlarmState(l));
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateReturnFromHighState
    extends ValidationState {
        public String tag() {
            return "ValidateReturnFromHighState";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (l2 > 0L && !BOutOfRangeAlgorithm.this.isTimerExpired()) {
                return null;
            }
            if (d > BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
            } else if (d < BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isTimerExpired()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }

        public ValidateReturnFromHighState(long l) {
            BOutOfRangeAlgorithm.this.startTimer(l);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateReturnFromLowState
    extends ValidationState {
        public String tag() {
            return "ValidateReturnFromLowState";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (d <= BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
            } else if (d > BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isTimerExpired()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }

        public ValidateReturnFromLowState(long l) {
            BOutOfRangeAlgorithm.this.startTimer(l);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class ValidationState
    extends OutOfRangeState {
        private ValidationState() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class OutOfRangeState {
        public abstract String tag();

        public abstract BAlarmState evaluate(double var1, long var3, long var5);

        public OutOfRangeState() {
            BOutOfRangeAlgorithm.this.cancelTimer();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateLowAlarmState
    extends ValidationState {
        public String tag() {
            return "ValidateLowAlarmState";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (d < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (BOutOfRangeAlgorithm.this.isTimerExpired()) {
                    BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.lowLimit;
                }
            } else if (d > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (l == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.highLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateHighAlarmState(l));
            } else if (d >= BOutOfRangeAlgorithm.this.getLowLimit()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
            }
            return null;
        }

        public ValidateLowAlarmState(long l) {
            BOutOfRangeAlgorithm.this.startTimer(l);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValidateHighAlarmState
    extends ValidationState {
        public String tag() {
            return "ValidateHighAlarmState";
        }

        public BAlarmState evaluate(double d, long l, long l2) {
            if (d < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (l == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.lowLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateLowAlarmState(l));
            } else if (d > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (BOutOfRangeAlgorithm.this.isTimerExpired()) {
                    BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.highLimit;
                }
            } else if (d <= BOutOfRangeAlgorithm.this.getHighLimit()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
            }
            return null;
        }

        public ValidateHighAlarmState(long l) {
            BOutOfRangeAlgorithm.this.startTimer(l);
        }
    }
}

